<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

JTable::addIncludePath('administrator/components/com_jclassifiedsmanager/tables');

class EmailService{
	function __construct()
	{
		$this->log = Logger::getInstance();
	}

	static function getEmailTemplate($template)
	{
		$db = JFactory::getDBO();
		$query = ' SELECT * FROM #__classifiedsmanager_emails WHERE email_type = "'.$template.'"';
		$db->setQuery( $query );
		$templ= $db->loadObject();
		
		return $templ;
	}
	
	
	public static function sendConfirmationEmail($adData, $sendOnlyToAdmin = false){
	
		$emailTemplate = self::getEmailTemplate(CONFIRMATION_EMAIL,true);
	
		$content = EmailService::prepareClassifiedsEmail($adData,null,null,null,null, $emailTemplate->email_content);
		$from = $adData->appSettings->company_email;
		$fromName = $adData->appSettings->company_name;
		$toEmail =  $adData->adDetails->email;
		$subject = $emailTemplate->email_subject;
		$isHtml = true;
	
		$bcc = array($from);
		
		if($sendOnlyToAdmin){
			$bcc = null;
			$toEmail = $from;
		}
	
		return self::sendEmail($from, $fromName, $from, $toEmail, null, $bcc, $subject, $content, $isHtml);
	}
	
	
	
	public static function sendInvoiceEmail($adData,$sendOnlyToAdmin=false){
		
		$emailTemplate = self::getEmailTemplate(INVOICE_EMAIL,true);

		$content = EmailService::prepareClassifiedsEmail($adData,null,null,null,null, $emailTemplate->email_content);
		$from = $adData->appSettings->company_email;
		$fromName = $adData->appSettings->company_name;
		$toEmail =  $adData->adDetails->email;
		$subject = $emailTemplate->email_subject;
		$isHtml = true;
	
		$bcc = array($from);
		
		if($sendOnlyToAdmin){
			$bcc = null;
			$toEmail = $from;
		}
	
		return self::sendEmail($from, $fromName, $from, $toEmail, null, $bcc, $subject, $content, $isHtml);
	}
	
	public static function sendPromoExpireEmail($adData,$sendOnlyToAdmin=false){
	
		$emailTemplate = self::getEmailTemplate(PROMOTION_EXPIRATION_EMAIL,true);
	
		$content = EmailService::prepareClassifiedsEmail($adData,null,null,null,null, $emailTemplate->email_content);
		$from = $adData->appSettings->company_email;
		$fromName = $adData->appSettings->company_name;
		$toEmail =  $adData->adDetails->email;
		$subject = $emailTemplate->email_subject;
		$isHtml = true;
	
		$bcc = array($from);
	
		if($sendOnlyToAdmin){
			$bcc = null;
			$toEmail = $from;
		}
	
		return self::sendEmail($from, $fromName, $from, $toEmail, null, $bcc, $subject, $content, $isHtml);
	}
	
	public static function sendExpirationEmail($adData,$sendOnlyToAdmin=false){
	
		$emailTemplate = self::getEmailTemplate(EXPIRATION_EMAIL,true);
	
		$content = EmailService::prepareClassifiedsEmail($adData,null,null,null,null, $emailTemplate->email_content);
		$from = $adData->appSettings->company_email;
		$fromName = $adData->appSettings->company_name;
		$toEmail =  $adData->adDetails->email;
		$subject = $emailTemplate->email_subject;
		$isHtml = true;
	
		$bcc = array($from);
	
		if($sendOnlyToAdmin){
			$bcc = null;
			$toEmail = $from;
		}
		return self::sendEmail($from, $fromName, $from, $toEmail, null, $bcc, $subject, $content, $isHtml);
	}
	
	public static function sendAdCreationEmail($adData){
		$emailTemplate = self::getEmailTemplate(ACTIVATION_EMAIL,true);
		$content = EmailService::prepareClassifiedsEmail($adData, null,null,null,null, $emailTemplate->email_content);
		$from = $adData->appSettings->company_email;
		$fromName = $adData->appSettings->company_name;
		$toEmail =  $adData->adDetails->email;
		$subject = $emailTemplate->email_subject;
		$isHtml = true;
	
		$bcc = array($from);
		
		if($sendOnlyToAdmin){
			$bcc = null;
			$toEmail = $from;
		}
	
		return self::sendEmail($from, $fromName, $from, $toEmail, null, $bcc, $subject, $content, $isHtml);
		
		
	}

	public static function sendEmailToFriend($adData,$currentURL, $email, $message ,$sendOnlyToAdmin=false){
	
		$emailTemplate = self::getEmailTemplate(TOFRIEND_EMAIL,true);
		$content = EmailService::prepareClassifiedsEmail($adData, $message, $currentURL,null,null, $emailTemplate->email_content);
		
		$from = $adData->appSettings->company_email;
		$fromName = $adData->appSettings->company_name;
		$toEmail =  $email;
		$subject = $emailTemplate->email_subject;
		$isHtml = true;

	 	$bcc = array($from);

	 	if($sendOnlyToAdmin){
			$bcc = null;
			$toEmail = $from;
		}
 		 return self::sendEmail($from, $fromName, $from, $toEmail, null, $bcc, $subject, $content, $isHtml);

	}

	public static function sendAbuseEmail($adData,$currentURL, $email, $message ,$sendOnlyToAdmin=true){
	
		$emailTemplate = self::getEmailTemplate(ABUSE_EMAIL,true);
		$content = EmailService::prepareClassifiedsEmail($adData, $message, $currentURL,$email,null, $emailTemplate->email_content);
		
		$from = $adData->appSettings->company_email;
		$fromName = $adData->appSettings->company_name;
		$toEmail =  $email;
		$subject = $emailTemplate->email_subject;
		$isHtml = true;

	 	$bcc = array($from);

	 	if($sendOnlyToAdmin){
			$bcc = null;
			$toEmail = $from;
		}

 		 return self::sendEmail($from, $fromName, $from, $toEmail, null, $bcc, $subject, $content, $isHtml);

	}

						
	public static function contactSeller($adData,$currentURL,$email,$name,$message , $sendOnlyToAdmin=false){
	
		$emailTemplate = self::getEmailTemplate(CONTACT_SELLER_EMAIL,true);
		$content = EmailService::prepareClassifiedsEmail($adData, $message, $currentURL,$email,$name , $emailTemplate->email_content);
		
		$from = $adData->appSettings->company_email;
		$fromName = $adData->appSettings->company_name;
		$toEmail =  $adData->adDetails->email;
		$subject = $emailTemplate->email_subject;
		$isHtml = true;

	 	$bcc = array($from);

	 	if($sendOnlyToAdmin){
			$bcc = null;
			$toEmail = $from;
		}

 		 return self::sendEmail($from, $fromName, $from, $toEmail, null, $bcc, $subject, $content, $isHtml);

	}


	static function prepareClassifiedsEmail($adData, $message, $currentURL, $sender_email,$sender_name, $emailTemplate){
	
		$publishDate = $adData->adDetails->creation_date;
		$companyLogo = "";
		if(!empty($adData->appSettings->logo_path)){
			$adData->appSettings->logo_path = str_replace(" ","%20",$adData->appSettings->logo_path);
			$companyLogo = '<img height="auto" src="'.(JURI::root().PATH_PICTURES.$adData->appSettings->logo_path).'"/>';
		}
		$siteurl	= "<a href='".JUri::root()."index.php?option=com_jclassifiedsmanager&controller=useraccount&view=useraccount'>".JText::_("LNG_CLICK_HERE")."</a>";
		$activationUrl	= "<a href='".JUri::root()."index.php?option=com_jclassifiedsmanager&controller=manageads&view=editad&task=activateAd&ad_id=".$adData->adDetails->id."'>".JText::_("LNG_ACTIVATE_AD_LINK")."</a>";
		
		$emailTemplate = str_replace(EMAIL_COMPANY_LOGO, 									$companyLogo,							$emailTemplate);
		$emailTemplate = str_replace(EMAIL_COMPANY_NAME, 									$adData->appSettings->company_name,		$emailTemplate);
		$emailTemplate = str_replace(EMAIL_ADUSERNAME, 					      				$adData->adDetails->userName,			$emailTemplate);
		$emailTemplate = str_replace(EMAIL_PUBLISH_DATE, 									$publishDate,							$emailTemplate);
		$emailTemplate = str_replace(EMAIL_USER_INFORMATION,								'',$emailTemplate);
		$emailTemplate = str_replace(EMAIL_PAYMENT_METHOD,									$adData->paymentInformation,$emailTemplate);
		$emailTemplate = str_replace(EMAIL_AD_DETAILS,										$adData->adDetailsHtml,$emailTemplate);		
		$emailText = "";
		$emailTemplate = str_replace(EMAIL_SITE_URL,										$siteurl, 						$emailTemplate);
		$emailTemplate = str_replace(EMAIL_USER_ADS_URL,									$siteurl, 						$emailTemplate);
		$emailTemplate = str_replace(EMAIL_ACTIVATION_URL_AD,									$activationUrl, 				$emailTemplate);
		$fromName	   = $adData->appSettings->company_name;
		$emailTemplate = str_replace(EMAIL_COMPANY_NAME,									$fromName, 						$emailTemplate);

		if (!empty($message)) {
			$emailTemplate = str_replace(EMAIL_MESSAGE_USER,										$message, 						$emailTemplate);
		}
		if (!empty($currentURL)) {
			$emailTemplate = str_replace(EMAIL_AD_URL,										 $currentURL, 					$emailTemplate);
		}

		if (!empty($sender_email)) {
			$emailTemplate = str_replace(EMAIL_OF_SENDER,									$sender_email, 			$emailTemplate);
		}
		
		if (!empty($sender_name)) {
			$emailTemplate = str_replace(NAME_OF_SENDER,									$sender_name, 			$emailTemplate);
		}

		if (!empty($adData->orderData->order_id)) {

			$emailTemplate = str_replace(EMAIL_INVOICE_DATE, 								$adData->orderData->creation_date,$emailTemplate);
			$emailTemplate = str_replace(EMAIL_INVOICE_NUMBER, 								$adData->orderData->order_id,$emailTemplate);
			$emailTemplate = str_replace(EMAIL_INVOICE_DESCRIPTION,							$adData->orderData->description,$emailTemplate);
			$emailTemplate = str_replace(EMAIL_ORDER_AMOUNT,								$adData->orderData->price." ".$adData->orderData->currency,$emailTemplate);
		 }

		return $emailTemplate;
	}
	
	
	public static function sendEmail($from, $fromName, $replyTo, $toEmail, $cc, $bcc, $subject, $content, $isHtml){


		$mail = JFactory::getMailer();
		$mail->setSender(array($from, $fromName));
		if(isset($replyTo))
		$mail->addReplyTo($replyTo);
		$mail->addRecipient($toEmail);
		if(isset($cc))
		$mail->addCC($cc);
		if(isset($bcc))
		$mail->addBCC($bcc);
		$mail->setSubject($subject);
		$mail->setBody($content);
		$mail->IsHTML($isHtml);

		$ret = $mail->send();

		$log = Logger::getInstance();
		$log->LogDebug("E-mail with subject ".$subject." sent from ".$from." to ".$toEmail." ".serialize($bcc)." result:".$ret);
	
		return $ret;
	}
}


?>