<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

JTable::addIncludePath('administrator/components/com_jclassifiedsmanager/tables');
require_once JPATH_COMPONENT_SITE.'/classes/payment/paymentfactory.php';


class PaymentService{
	
	/**
	 * Create all active payment processors that are displyed on front based on database details
	 * 
	 * @param boolean $onlyFrontEnd
	 */
	public static function getPaymentProcessors($onlyFrontEnd = true){
		$paymentProcessors = array();
		$db = JFactory::getDBO();
		$query = "select * from #__classifiedsmanager_payment_processors where status=1 order by name";
		$db->setQuery($query);
		$paymentProcessorsDetails =  $db->loadObjectList();
		
		foreach($paymentProcessorsDetails as $paymentProcessorsDetail){
			$query = "SELECT * FROM #__classifiedsmanager_payment_processor_extrafields where processor_id=$paymentProcessorsDetail->id order by id asc";
			$db->setQuery($query);
			$fields =  $db->loadObjectList();
			$paymentProcessorsDetail->fields = array();
			foreach($fields as $field){
				$paymentProcessorsDetail->fields[$field->column_name]= $field->column_value;
			}

			$processorFactory = new ProcessorFactory();
			$processor = $processorFactory->getProcessor($paymentProcessorsDetail->code);
			$processor->initialize($paymentProcessorsDetail);
			$paymentProcessors[] = $processor;
		}
		return $paymentProcessors;
	}
	
	/**
	 * Retreive processor details from database
	 * 
	 * @param string $type
	 * @return unknown
	 */
	
	static function getPaymentProcessorDetails($processorCode){
		$db = JFactory::getDBO();
		$query = "select * from #__classifiedsmanager_payment_processors where code='$processorCode'";
		$db->setQuery($query);
		$processor = $db->loadObject();
	
		if(isset($processor)){
			$query = " SELECT * FROM #__classifiedsmanager_payment_processor_extrafields where processor_id=$processor->id order by id asc";
			$db->setQuery( $query );
			$fields = $db->loadObjectList();
			foreach($fields as $field){
				$processor->fields[$field->column_name]= $field->column_value;
			}
			
		}
		return $processor;
	}
	/**
	 * Create payment processor
	 * 
	 * @param string $type
	 */
	public static function createPaymentProcessor($type){
		$processorFactory = new ProcessorFactory();
		$processor = $processorFactory->getProcessor($type);
		
		$initData = self::getPaymentProcessorDetails($type);
		$processor->initialize($initData);
		
		return $processor;
	}
	
	public function getOrder($orderId){
		
		$orderTable = $this->getTable('managerders');
		$orderTable->load($orderId);
	
		return $orderTable;
	}


	/**
	 * Generate payment procesors html
	 * 
	 * @param string $type
	 */
	public static function generatePaymentProcessorHtml(){

		$paymentProcessors = self::getPaymentProcessors();
		foreach($paymentProcessors as $paymentProcessor){ ?>

		 	<div class="processorItem code_<?php echo $paymentProcessor->code; ?>"> 
			 	<div class="processorItem-imageContainer">
			 		<img class="payment-icon" src="<?php echo JURI::base() ."components/com_jclassifiedsmanager/assets/images/payment/". $journalName = str_replace(' ', '', strtolower($paymentProcessor->code)).".gif" ?>"  /> 
			 		<div id="processor_description_<?php echo $paymentProcessor->code?>" style="display:none;" class="procDesc">
						<?php echo $paymentProcessor->getPaymentProcessorHtml();?>
					</div>
			 	</div>
			    <div class="styledRadio">
					<input id="p_method_<?php echo $paymentProcessor->code ?>" onclick="switchMethod('<?php echo $paymentProcessor->code; ?>');" type="radio" name="payment_processor_code" id="payment_processor_code" value="<?php echo $paymentProcessor->code;?>" class="validate[required] radio">
					<label for="p_method_<?php echo $paymentProcessor->code ?>"></label>
					&nbsp; 
				</div>				
				<?php echo $paymentProcessor->name;?> &nbsp;
			</div>
			
	<?php	}

	}

}


?>