<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
require_once( JPATH_COMPONENT_SITE.DS.'views'.DS.'editad'.DS.'view.html.php' );
require_once( JPATH_COMPONENT_SITE.'/models/promotead.php' );


class JClassifiedsManagerControllerEditAd extends JClassifiedsManagerController
{
	function __construct()
	{
		parent::__construct();
		JFactory::getApplication()->input->set('layout','editad');
	}
	function editAd(){
		JFactory::getApplication()->input->set('layout','editad');
        JFactory::getApplication()->input->set("view", "editad");
        parent::display();
	}

	function save($key = null, $urlVar = null)
	{	
		$appSettings = JAdsUtil::getInstance()->getApplicationSettings();
		$model = $this->getModel('editad');
		$post = JFactory::getApplication()->input->post->getArray();
		$adId = JFactory::getApplication()->input->get("ad_id",null);
		$isNew = empty($adId)?true:false;
		$captchaAnswer = !empty($post['recaptcha_response_field'])?$post['recaptcha_response_field']:$post['g-recaptcha-response'];

		if($appSettings->enable_captcha && $isNew){
			$namespace="jclassifiedsmanager.contact";
			$captcha = JCaptcha::getInstance("recaptcha", array('namespace' => $namespace));
			if(!$captcha->checkAnswer($captchaAnswer)){
				$error = $captcha->getError();
				$this->setMessage("Captcha error!", 'warning');
				$this->setRedirect('index.php?option='.getAdComponentName().'&task=editad&view=editad&ad_id='.$model->getAdId());
				return;
			}
		}
		if ($model->saveAd($post)) {
            if($adId!=null){
				$msg = JText::_('LNG_AD_SUCCESSFULLY_UPDATED');
			}else{
				if ($appSettings->enable_paid_classifieds)
					$msg = JText::_('LNG_PAID_AD_SUCCESSFULLY_CREATED');		
				else
					$msg = JText::_('LNG_AD_SUCCESSFULLY_CREATED');
			}

			$link = JRoute::_('index.php?option='.getAdComponentName().'&task=editad&view=manageuserads');
			$msgType = "";
		
			//make payment if selected
			if(isset($post["payment_processor_code"]) && strlen($post["payment_processor_code"])>0){
                $link = JRoute::_('index.php?option='.getAdComponentName().'&task=promotead.promotead&view=promotead&task=promotead.promotead&ad_id='.$model->getAdId().'&payment_plan_id='.$post["payment_plan_id"].'&payment_processor_code='.$post["payment_processor_code"]);
				$this->setRedirect($link,$msg,$msgType);

            }
		} else {
			$msg = JText::_('LNG_ERROR_SAVING_AD');
			$link = JRoute::_('index.php?option='.getAdComponentName().'&task=editad.editad&view=editad&ad_id='.$model->getAdId());
			$msgType = "error";
		}
        $this->setRedirect($link, $msg,$msgType);
	}
	

	function apply()
	{
		$model = $this->getModel('editad');
		$post = JFactory::getApplication()->input->post->getArray();
		$adId = JFactory::getApplication()->input->get("ad_id",null);
		$appSettings = JAdsUtil::getInstance()->getApplicationSettings();

		if ($model->saveAd($post)) {
			if($adId!=null){
				$msg = JText::_('LNG_AD_SUCCESSFULLY_UPDATED');
			}else{
				if ($appSettings->enable_paid_classifieds)
					$msg = JText::_('LNG_PAID_AD_SUCCESSFULLY_CREATED');		
				else
					$msg = JText::_('LNG_AD_SUCCESSFULLY_CREATED');
			}

			$link = 'index.php?option='.getAdComponentName().'&controller=editad&view=editad&ad_id='.$model->getAdId();
			$msgType = "";
		
			//make payment if selected
			if(isset($post["payment_processor_code"]) && strlen($post["payment_processor_code"])>0){
				//$post["ad_id"] = $model->getAdId(); //assign ad_id to data, needed for order
				//$modelPromote =  JModelLegacy::getInstance('promotead','JClassifiedsManagerModel');
				$link = 'index.php?option='.getAdComponentName().'&task=promotead.promotead&view=promotead&task=promotead.promotead&ad_id='.$model->getAdId().'&payment_plan_id='.$post["payment_plan_id"].'&payment_processor_code='.$post["payment_processor_code"];
				$this->setRedirect($link, $msg,$msgType);
		   }	 
		} else {
			$msg = JText::_('LNG_ERROR_SAVING_AD');
			$link = 'index.php?option='.getAdComponentName().'&controller=editad&view=editad&ad_id='.$model->getAdId();
			$msgType = "error";
		}
		$this->setRedirect($link, $msg,$msgType);
	}

	function delete(){
	
	}
	function changeStatus(){

	}

	function back()
	{
		$msg = JText::_('LNG_OPERATION_CANCELLED');
		$this->setRedirect( 'index.php?option='.getAdComponentName(), $msg );
	}
	function getSubCategories(){
		$model = $this->getModel('editad');
		$subcategories = $model->getJSONSubCategories();
		print_r($subcategories);
		exit;
	}
	function getstatecities(){
		$model = $this->getModel('editad');
		$cities = $model->getJSONStateCities();
		print_r($cities);
		exit;
	}
	function uploadFiles(){
		$model = $this->getModel('editad');
		$model->uploadFiles();
		exit;		
	}
	function getAjaxCategoryAttributes(){
		$model = $this->getModel('editad');
		$categoryAttributes = $model->getAjaxCategoryAttributes();
		$adAttributes = $model->getAdAttributes();
		
		$content = $model->renderCategoryAttributes($categoryAttributes,$adAttributes);
		echo $content;
		exit;
	}
	function showAdCreated(){
		JFactory::getApplication()->input->set('layout','adsuccess');
		return $this->display();
	}
	function ordercompletion(){
		JFactory::getApplication()->input->set('layout','ordercompletion');
		return $this->display();
	}
		
}
?>