<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
require_once( JPATH_COMPONENT_SITE.DS.'views'.DS.'editad'.DS.'view.html.php' );
require_once 'components/com_jclassifiedsmanager/models/profile.php';


class JClassifiedsManagerControllerManageUserProfile extends JClassifiedsManagerController
{
	function __construct()
	{
		// JFactory::getApplication()->input->set('layout','displayUserAds');
		parent::__construct();
	}

	
	function back()
	{
		$msg = JText::_('LNG_OPERATION_CANCELLED');
		$this->setRedirect( 'index.php?option='.getAdComponentName(), $msg );
	}
	
	public function saveprofile()
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
	
		// Initialise variables.
		$app	= JFactory::getApplication();
		$model =  &JModelLegacy::getInstance('profile','JClassifiedsManagerModel');
		$user	= JFactory::getUser();
		$userId	= (int) $user->get('id');
	
		// Get the user data.
		$data = JFactory::getApplication()->input->get('jform', array(), 'post', 'array');
	
		// Force the ID to this user.
		$data['id'] = $userId;
	
		// Validate the posted data.
		$form = $model->getForm();
		if (!$form) {
			JFactory::getApplication()->enqueueMessage($model->getError(), 'error');
			return false;
		}
	
		// Validate the posted data.
		$data = $model->validate($form, $data);
	
		// Check for errors.
		if ($data === false) {
			// Get the validation messages.
			$errors	= $model->getErrors();
	
			// Push up to three validation messages out to the user.
			for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
				if ($errors[$i] instanceof Exception) {
					$app->enqueueMessage($errors[$i]->getMessage(), 'warning');
				} else {
					$app->enqueueMessage($errors[$i], 'warning');
				}
			}
	
			// Save the data in the session.
			$app->setUserState('com_users.edit.profile.data', $data);
	
			// Redirect back to the edit screen.
			$userId = (int) $app->getUserState('com_users.edit.profile.id');
			$this->setRedirect(JRoute::_('index.php?option=com_jclassifiedsmanager&view=manageuserprofile&controller=manageuserprofile', false));
			return false;
		}
	
		// Attempt to save the data.
		$return	= $model->save($data);
	
		// Check for errors.
		if ($return === false) {
			// Save the data in the session.
			$app->setUserState('com_users.edit.profile.data', $data);
	
			// Redirect back to the edit screen.
			$userId = (int)$app->getUserState('com_users.edit.profile.id');
			$this->setMessage(JText::sprintf('COM_USERS_PROFILE_SAVE_FAILED', $model->getError()), 'warning');
			$this->setRedirect(JRoute::_('index.php?option=com_jclassifiedsmanager&view=manageuserprofile&controller=manageuserprofile', false));
			return false;
		}
	
		// Redirect the user and adjust session state based on the chosen task.
		switch ($this->getTask()) {
			case 'apply':
				// Check out the profile.
				$app->setUserState('com_users.edit.profile.id', $return);
				$model->checkout($return);
	
				// Redirect back to the edit screen.
				$this->setMessage(JText::_('COM_USERS_PROFILE_SAVE_SUCCESS'));
				$this->setRedirect(JRoute::_('index.php?option=com_jclassifiedsmanager&view=manageuserprofile&controller=manageuserprofile', false));
				break;
	
			default:
				// Check in the profile.
				$userId = (int)$app->getUserState('com_users.edit.profile.id');
			if ($userId) {
				$model->checkin($userId);
			}
	
			// Clear the profile id from the session.
			$app->setUserState('com_users.edit.profile.id', null);
	
			// Redirect to the list screen.
			$this->setMessage(JText::_('COM_USERS_PROFILE_SAVE_SUCCESS'));
			$this->setRedirect(JRoute::_('index.php?option=com_jclassifiedsmanager&view=manageuserprofile&controller=manageuserprofile&id='.$return, false));
			break;
		}
	
		// Flush the data from the session.
		$app->setUserState('com_users.edit.profile.data', null);
	}		
}
?>