<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class JClassifiedsManagerControllerPaymentProcessor extends JClassifiedsManagerController
{
	function __construct()
	{
		parent::__construct();
		$this->log = Logger::getInstance();
	}
	function updateOrder(){
		
		$orderData = new stdClass(); 
		$orderData->$orderId = JFactory::getApplication()->input->get("orderId",null);
		$orderData->orderMessage = JFactory::getApplication()->input->get("orderMessage",null);
		$orderData->orderStatus = JFactory::getApplication()->input->get("orderStatus",null);
		
		$model = $this->getModel('manageorders'); 
		$model->updateOrder($orderData);
		exit;
	}
	
	function processResponse(){
		$this->log->LogDebug("processing payment response");
		$data = JFactory::getApplication()->input->post->getArray();
		$this->log->LogDebug(serialize($data));
	
		$processorType = JFactory::getApplication()->input->get("processor");
		$processor = PaymentService::createPaymentProcessor($processorType);
		$paymentDetails = $processor->processResponse($data);

		if($paymentDetails->status == JCLS_PAYMENT_STATUS_CANCELLED || $paymentDetails->status == JCLS_PAYMENT_ERROR){
			$this->setRedirect(JRoute::_('index.php?option='.getAdComponentName().'&task=promotead.promotead&view=promotead&ad_id='.$model->adId, false),$paymentDetails->msg);
				
		}else{
			if(empty($paymentDetails->ad_id)){
				$orderData = new stdClass();
				$orderData->orderId = $paymentDetails->order_id;
				$orderData->orderMessage = $paymentDetails->msg;
				$orderData->orderStatus = $paymentDetails->status;
				$model = $this->getModel('manageorders');
				$model->updateOrder($orderData);
				$adData= AdService::getAdDetails($paymentDetails->ad_id,$orderData->orderId);
				EmailService::sendInvoiceEmail($adData);
				$this->setRedirect(JRoute::_('index.php?option='.getAdComponentName().'&task=promotead.promotead&view=promotead&task=ordercompletion&orderId='.$orderData->orderId, false),$paymentDetails->orderMessage);
			}
			else 
				$this->setRedirect(JRoute::_('index.php?option='.getAdComponentName().'?&controller=displayads&view=displayads'));
				
		}
	}
	
	function processAutomaticResponse(){
		$this->log->LogDebug("process automatic response");
		$data = JFactory::getApplication()->input->post->getArray();
		$this->log->LogDebug(serialize($data));
	
		$processorType = JFactory::getApplication()->input->get("processor");
		$processor = PaymentService::createPaymentProcessor($processorType);
		$paymentDetails = $processor->processResponse($data);
		$this->log->LogDebug("Payment Details: ".serialize($paymentDetails));
	
		if(empty($paymentDetails->order_id)){
			$this->log->LogDebug("Order id not found. exiting...");
			return;
		}
	
		$intialPaymentDetails = PaymentService::getOrder($paymentDetails->order_id);
		$this->log->LogDebug("Initial payment details: ".serialize($intialPaymentDetails));
	
		if($intialPaymentDetails->payment_status_id==JCLS_PAYMENT_STATUS_PAID){
			return;
		}
	
		//prevent e-mails to be send again to customers
		if($intialPaymentDetails->payment_status_id == $paymentDetails->payment_status){
			http_response_code(200);
			return;
		}
	
		//check if the response is a reponse for a waiting transaction
		$sendMailOnlyToAdmin = $intialPaymentDetails->payment_status_id == PAYMENT_STATUS_WAITING && $paymentDetails->payment_status == JCLS_PAYMENT_STATUS_PAID;
		$this->log->LogDebug("Send only to admin ".serialize($sendMailOnlyToAdmin));
	
	
		$orderData = new stdClass();
		$orderData->$orderId = $paymentDetails->order_id;
		$orderData->orderMessage = $paymentDetails->msg;
		$orderData->orderStatus = $paymentDetails->payment_status;
		
		$model = $this->getModel('manageorders');
		$model->updateOrder($orderData);

		
		if($paymentDetails->status == JCLS_PAYMENT_STATUS_CANCELLED || $paymentDetails->status == JCLS_PAYMENT_ERROR){

		}else{
			$adData= AdService::getAdDetails($this->adId,$paymentDetails->order_id);
			EmailService::sendInvoiceEmail($adData);
		}
	
		http_response_code(200);
	}
	
	function processCancelResponse(){
		$this->log->LogDebug("process cancel response ");
		$data = JFactory::getApplication()->input->post->getArray();
		$this->log->LogDebug(serialize($data));
		$this->setMessage(JText::_('LNG_OPERATION_CANCELED_BY_USER',true));
		$this->setRedirect(JRoute::_('index.php?option=com_jclassifiedsmanager&task=promotead.promotead&view=promotead&ad_id='.$data['itemNumber'], $msg));
	}	
	
	
}