<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
require_once( JPATH_COMPONENT_SITE.DS.'views'.DS.'editad'.DS.'view.html.php' );


class JClassifiedsManagerControllerPromoteAd extends JClassifiedsManagerController
{
	function __construct()
	{
		parent::__construct();
		JFactory::getApplication()->input->set('layout','listPaymentPlans');
	}


	function promotead(){
		$model = $this->getModel('promotead');
		$paymentDetails = $model->promoteAd();
		$adId = JFactory::getApplication()->input->get("ad_id");
		JFactory::getApplication()->input->set("orderId",$paymentDetails->order_id);
		$post = JFactory::getApplication()->input->post->getArray();
		if($paymentDetails->status==JCLS_PAYMENT_REDIRECT){
			$document = JFactory::getDocument();
			$viewType = $document->getType();
			$view = $this->getView("promotead", $viewType, '', array('base_path' => $this->basePath, 'layout' => "redirect"));
			$view->paymentProcessor = $paymentDetails->payment_processor;
			$view->display("redirect");
				
		}else if($paymentDetails->status==JCLS_PAYMENT_STATUS_PAID){
				
			$orderData = new stdClass();
			$orderData->orderId = $paymentDetails->order_id;
			$orderData->orderStatus = JCLS_PAYMENT_STATUS_PAID;
			$orderData->orderMessage = $paymentDetails->orderMessage;
			$model = $this->getModel('manageorders');
			$model->updateOrder($orderData);
		}else if($paymentDetails->status==JCLS_PAYMENT_STATUS_PENDING){
				                                                     
		}else if($paymentDetails->status==JCLS_PAYMENT_ERROR){
			$orderData = new stdClass();
			$orderData->orderId = $paymentDetails->order_id;
			$orderData->orderStatus = JCLS_PAYMENT_ERROR;
			$orderData->orderMessage = $paymentDetails->orderMessage;
			$model = $this->getModel('manageorders');
			$model->updateOrder($orderData);
			$msg = JText::_('LNG_ERROR_SAVING_AD');
			$link = JRoute::_('index.php?option='.getAdComponentName().'&task=editad.editad&view=editad&ad_id='.$model->getAdId());
			$msgType = "error";
			$this->setRedirect($link, $msg,$msgType);
	}
		
		if($paymentDetails->status==JCLS_PAYMENT_STATUS_PAID || $paymentDetails->status==JCLS_PAYMENT_STATUS_PENDING){
			//send ad creation confirmation. 
			$adData= AdService::getAdDetails($adId,$paymentDetails->order_id);
			EmailService::sendConfirmationEmail($adData);
			$this->ordercompletion();
		}
	}
	function ordercompletion(){
		JFactory::getApplication()->input->set('layout','ordercompletion');
		return $this->display();
	}
	
	function renewAd(){
		$model = $this->getModel('promotead');
		if ($model->renewAd()) {
			$msg = JText::_('LNG_AD_SUCCESSFULLY_RENEWED');
			$msgType = "";
		
		} else {
			$msg = JText::_('LNG_ERROR_RENEWING_AD');
			$msgType = "error";
		}
		$link = 'index.php?option='.getAdComponentName().'&controller=useraccount&view=manageuserads';
		$this->setRedirect($link, $msg,$msgType);
	}
}