<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
require_once( JPATH_COMPONENT_SITE.DS.'views'.DS.'editad'.DS.'view.html.php' );
require_once 'components/com_jclassifiedsmanager/models/profile.php';


class JClassifiedsManagerControllerUserAccount extends JClassifiedsManagerController
{
	function __construct()
	{
		
		parent::__construct();
	}

	
	function save($key = null, $urlVar = null)
	{
		$model = $this->getModel('editad');
		$post = JFactory::getApplication()->input->post->getArray();
		if ($model->saveAd($post)) {
			$msg = JText::_('LNG_AD_SUCCESSFULLY_CREATED');
			$link = 'index.php?option='.getAdComponentName().'&controller=editad&view=editad&task=showAdCreated';
			$msgType = "";
				
		} else {
			$msg = JText::_('LNG_ERROR_SAVING_AD');
			$link = 'index.php?option='.getAdComponentName().'&controller=editad&view=editad&ad_id='.$model->getAdId();
			$msgType = "error";
		}
		$this->setRedirect($link, $msg,$msgType);
	}
	function deleteAd(){
		$model = $this->getModel('useraccount');
		$adId = JFactory::getApplication()->input->get("adid",null);
		$message = $model->deleteAd($adId);
		$link = JRoute::_('index.php?option='.getAdComponentName().'&controller=useraccount&view=manageuserads');
		$this->setRedirect($link, $message);
	}

	function back()
	{
		$msg = JText::_('LNG_OPERATION_CANCELLED');
		$this->setRedirect( 'index.php?option='.getAdComponentName(), $msg );
	}



	/**
	 * Method to log out a user.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	public function logout()
	{
		JSession::checkToken('request') or jexit(JText::_('JINVALID_TOKEN'));

		$app = JFactory::getApplication();

		// Perform the log out.
		$error  = $app->logout();
		$input  = $app->input;
		$method = $input->getMethod();

		// Check if the log out succeeded.
		if (!($error instanceof Exception))
		{
			// Get the return url from the request and validate that it is internal.
			$return = $input->$method->get('return', '', 'BASE64');
			$return = base64_decode($return);

			if (!JUri::isInternal($return))
			{
				$return = '';
			}

			// Redirect the user.
			$app->redirect(JRoute::_($return, false));
		}
		else
		{
			$app->redirect(JRoute::_('index.php?option=com_users&view=login', false));
		}
	}

	/**
	 * Add user details and create a Joomla User
	 *
	 * @param $data
	 * @return mixed
	 */
	public function addUser()
	{
		$data = JFactory::getApplication()->input->post->getArray();

		//prepare user object
		$userdata = array(); // place user data in an array for storing.
		$name = explode('@', $data['email']);
		$userdata['name']  = $name[0];

		if (!empty($data["name"])) {
			$userdata['name'] = $data["name"];
		}

		$userdata['email'] = $data["email"];

		$userdata['username'] = $data["username"];
		if (empty($data["username"])) {
			$userdata['username'] = $data["email"];
		}

		//set password
		if (!empty($data["password"])) {
			$userdata['password'] = $data["password"];
		}elseif (!empty($data["password1"])) {
			$userdata['password'] = $data["password1"];
		} else {
			$userdata['password'] = UserService::generatePassword($data["email"], true);
		}

		$userdata['password2'] = $userdata['password'];

		// Get any component's model
		// load some joomla helpers
		JLoader::import('joomla.application.component.model');
		// load the model file
		JLoader::import('registration', JPATH_ROOT . '/components/com_users' . '/models');
		// load the user registration model
		$model = JModelLegacy::getInstance('registration', 'Users' . 'Model');

		JForm::addFormPath(JPATH_ROOT . '/components/com_users' . '/forms');
		JForm::addFormPath(JPATH_ROOT . '/components/com_users' .  '/models/forms');
		JForm::addFieldPath(JPATH_ROOT . '/components/com_users' . '/models/fields');
		JForm::addFormPath(JPATH_ROOT . '/components/com_users' . '/model/form');
		JForm::addFieldPath(JPATH_ROOT . '/components/com_users' . '/model/field');
		// lineup new user data
		$datas = array(
			'username' => $userdata['username'],
			'name' => $userdata['name'],
			'email1' => $userdata['email'],
			'password1' => $userdata['password'], // First password field
			'password2' => $userdata['password2'], // Confirm password field
			'block' => 0
		);

		// register the new user
		$result = $model->register($datas);

		// Redirect url provided only from user module registration
		if(!empty(JFactory::getApplication()->input->get("registration_redirect"))) {
			$this->setRedirect(JRoute::_(base64_decode(JFactory::getApplication()->input->get("registration_redirect")), false));
		}

		$userObj = UserService::getUserByEmail($userdata['email']);
		// if user is created
		if (!empty($userObj->id)) {
			JFactory::getApplication()->enqueueMessage(JText::_('LNG_USER_ACCOUNT_CREATED_VERIFICATION'), 'success');

			return $userObj->id;
		} else {
			JFactory::getApplication()->enqueueMessage($model->getError(), 'warning');
		}

		if (!is_numeric($result)) {
			JFactory::getApplication()->enqueueMessage("Could not create user", 'error');
		} // something went wrong!!

		return $result;
	}
}
?>