<?php
/**
 * @package    JHotelReservation
 * @subpackage  com_jhotelreservation
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * BusinessDirectory component helper.
 *
 * @package    JHotelReservation
 * @subpackage  com_jhotelreservation

 */
class JAdsHelper
{
	/**
	 * Defines the valid request variables for the reverse lookup.
	 */
	protected static $_filter = array('option', 'view', 'layout');

	/**
	 * Configure the Linkbar.
	 *
	 * @param   string	The name of the active view.
	 */
	public static function addSubmenu($vName)
	{
			JSubMenuHelper::addEntry(
				JText::_('LNG_APPLICATION_SETTINGS',true),
				'index.php?option='.getAdComponentName().'&view=applicationsettings',
				$vName == 'applicationsettings'
			);
			JSubMenuHelper::addEntry(
				JText::_('LNG_PAYMENT_PROCESSORS',true),
				'index.php?option='.getAdComponentName().'&task=paymentprocessors.listing',
				$vName == 'paymentprocessors'
			);
			JSubMenuHelper::addEntry(
				JText::_('LNG_PROMOTION_PLANS',true),
				'index.php?option='.getAdComponentName().'&task=promotionplans.listing',
				$vName == 'promotionplans'
			);
			JSubMenuHelper::addEntry(
				JText::_('LNG_MANAGE_EMAIL_TEMPLATES',true),
				'index.php?option='.getAdComponentName().'&view=emailtemplates',
				$vName == 'emailtemplates'
			);
			JSubMenuHelper::addEntry(
				JText::_('LNG_MANAGE_CATEGORIES',true),
				'index.php?option='.getAdComponentName().'&task=categories.listing',
				$vName == 'categories'
			);
			JSubMenuHelper::addEntry(
				JText::_('LNG_MANAGE_CATEGORY_ATTRIBUTES',true),
				'index.php?option='.getAdComponentName().'&task=categoryattributes.listing',
				$vName == 'categoryattributes'
					);

			JSubMenuHelper::addEntry(
				JText::_('LNG_MANAGE_ADS',true),
				'index.php?option='.getAdComponentName().'&task=manageads.listing',
				$vName == 'manageads'
					);
			JSubMenuHelper::addEntry(
				JText::_('LNG_UPDATE',true),
				'index.php?option='.getAdComponentName().'&view=updates',
				$vName == 'updates'
			);
	}
	
	/**
	 * Configure the Linkbar.
	 */
	
	
	public static function getOrderStates(){
			$states = array();
			$state = new stdClass();
			$state->value = 0;
			$state->text = JText::_('LNG_NOT_PAID',true);
			$states[] = $state;
			$state = new stdClass();
			$state->value = 1;
			$state->text = JText::_('LNG_PAID',true);
			$states[] = $state;
			
			return $states;
	}
	
	public static function getStatuses(){
		$states = array();
		$state = new stdClass();
		$state->value = 0;
		$state->text = JText::_('LNG_INACTIVE',true);
		$states[] = $state;
		$state = new stdClass();
		$state->value = 1;
		$state->text = JText::_('LNG_ACTIVE',true);
		$states[] = $state;
	
		return $states;
	}
	
	public static function getModes(){
		$modes = array();
		$state = new stdClass();
		$state->value = "test";
		$state->text = JText::_('LNG_TEST',true);
		$modes[] = $state;
		$state = new stdClass();
		$state->value = "live";
		$state->text = JText::_('LNG_LIVE',true);
		$modes[] = $state;
		
		return $modes;
	}
	public static function getActions()
	{
		// Reverted a change for version 2.5.6
		$user	= JFactory::getUser();
		$result	= new JObject;
	
		$assetName = 'com_jclassifiedsmanager';
	
		$actions = array(
					'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);
	
		foreach ($actions as $action)
		{
			$result->set($action,	$user->authorise($action, $assetName));
		}
		
		return $result;
	}
	


}


