<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/

//defined( '_JEXEC' ) or die( 'Restricted access' );
require_once('defines.php');

function getAdComponentName()
{
	$componentname = JFactory::getApplication()->input->get('option');
	//$componentname = explode("_",$componentname);
	return $componentname;
}

if (!function_exists('dump')) {

	function dump( $text )
	{
		echo "<pre>";
		var_dump($text);
		echo "</pre>";
	}
}

class JAdsUtil{

	var $applicationSettings ;

	private function __construct()
	{
	}

	public static function getInstance()
	{
		static $instance;
		if ($instance === null) {
			$instance = new JAdsUtil();
		}
		return $instance;
	}
	public static function loadAdminLanguage(){

	//languages
		$language 		=  JFactory::getLanguage();
		
		$language_tag 	= isset($language->_lang) ? $language->_lang : $language->getTag();
		JFactory::getApplication()->input->set('_lang',$language_tag);
		
		$x = $language->load(
				'com_installer',
				dirname(JPATH_ADMINISTRATOR.'/language') ,
				$language_tag,
				true
		);
		$x = $language->load(
				'com_jclassifiedsmanager' ,
				dirname(JPATH_COMPONENT_ADMINISTRATOR.'/language') ,
				$language_tag,
				true
				);
	}
	public static function loadSiteLanguage(){

		//languages
		$language 		= JFactory::getLanguage();
		$language_tag = $language->getTag();

		$x = $language->load('com_jclassifiedsmanager',dirname(JPATH_ADMINISTRATOR.'/components/com_jclassifiedsmanager/language') ,$language_tag,true);
		
		$language->load('com_users',dirname( JPATH_SITE.'/language') ,$language_tag,true);
	}
	
	public static function getJoomlaLanguage(){
		$language =  JFactory::getLanguage();
		$language_tag = $language->getTag();
		$tagArray = explode("-",$language_tag);
		return $tagArray[0];
	}
	public static function loadClasses(){
		jimport('joomla.filesystem.file');
		jimport('joomla.filesystem.folder');
	
		//load services
		$classpath = JPATH_COMPONENT_SITE  .DS.'classes'.DS.'services';
		foreach( JFolder::files($classpath) as $file ) {
			JLoader::register(JFile::stripExt($file), $classpath.DS.$file);
		}
	}
	public static function getApplicationSettings(){
		$db		= JFactory::getDBO();
		$query	= "	SELECT * FROM #__classifiedsmanager_application_settings";
	
		//dump($query);
		$db->setQuery( $query );
	
		return  $db->loadObject();
	}
	public static function getDashBoardIcon(){
		return "home";
	}
	
	public static function isJoomla3(){
		$version = new JVersion();
		$versionA =  explode(".", $version->getShortVersion());
		if($versionA[0] =="3"){
			return true;
		}
		return false;
	}

    public static function makePathFile($path)
	{
		$path_tmp = str_replace( '\\', DIRECTORY_SEPARATOR, $path );
		$path_tmp = str_replace( '/', DIRECTORY_SEPARATOR, $path_tmp);
		return $path_tmp;
	}

	static function getDateADFormat($data){
	
		if(!isset($data) || $data=='' || strcmp($data,"0000-00-00")==0)
			return $data;
	
		$data =strtotime($data);
		$currDate = strtotime('now');
		$days = date('d', $currDate) - date('d', $data);
		$months = date('m', $currDate) - date('m', $data);

		//if same day previous month increase days.
		if($months>0)
			$days+=10;

		switch($days){
			case 0:
				$dateS =   JText::_('LNG_TODAY')." ".strtolower(JFactory::getDate($data)->format('H:s'));;
			break;
			case 1:
				$dateS =   JText::_('LNG_YESTERDAY')." ".strtolower(JFactory::getDate($data)->format('H:s'));;
			break;
			default:
				$dateS =  strtolower(JFactory::getDate($data)->format('d M H:s'));
		}
		
		return $dateS;
	}
	static function getDayFormat($data){

		if(!isset($data) || $data=='' || strcmp($data,"0000-00-00")==0)
			return $data;

		$data =strtotime($data);
		$dateS =  JFactory::getDate($data)->format('d M Y');

		return $dateS;
	}
	
	
	static function includeFile($type, $file, $path){
		$version = new JVersion();
		$versionA =  explode(".", $version->getShortVersion());
		if($versionA[0] =="3"){
			JHTML::_($type, $path.$file);
		}else{
			JHTML::_($type, $path.$file);
		}
	}

    public static function truncate($text, $length, $ending = '&hellip;', $considerHtml = true, $exact = false) {
        if ($considerHtml) {
            // if the plain text is shorter than the maximum length, return the whole text
            if (strlen(preg_replace('/<.*?>/', '', $text)) <= $length) {
                return $text;
            }
            // splits all html-tags to scanable lines
            preg_match_all('/(<.+?>)?([^<>]*)/s', $text, $lines, PREG_SET_ORDER);
            $total_length = strlen($ending);
            $open_tags = array();
            $truncate = '';
            foreach ($lines as $line_matchings) {
                // if there is any html-tag in this line, handle it and add it (uncounted) to the output
                if (!empty($line_matchings[1])) {
                    // if it's an "empty element" with or without xhtml-conform closing slash
                    if (preg_match('/^<(\s*.+?\/\s*|\s*(img|br|input|hr|area|base|basefont|col|frame|isindex|link|meta|param)(\s.+?)?)>$/is', $line_matchings[1])) {
                        // do nothing
                        // if tag is a closing tag
                    } elseif (preg_match('/^<\s*\/([^\s]+?)\s*>$/s', $line_matchings[1], $tag_matchings)) {
                        // delete tag from $open_tags list
                        $pos = array_search($tag_matchings[1], $open_tags);
                        if ($pos !== false) {
                            unset($open_tags[$pos]);
                        }
                        // if tag is an opening tag
                    } elseif (preg_match('/^<\s*([^\s>!]+).*?>$/s', $line_matchings[1], $tag_matchings)) {
                        // add tag to the beginning of $open_tags list
                        array_unshift($open_tags, strtolower($tag_matchings[1]));
                    }
                    // add html-tag to $truncate'd text
                    $truncate .= $line_matchings[1];
                }
                // calculate the length of the plain text part of the line; handle entities as one character
                $content_length = strlen(preg_replace('/&[0-9a-z]{2,8};|&#[0-9]{1,7};|[0-9a-f]{1,6};/i', ' ', $line_matchings[2]));
                if ($total_length+$content_length> $length) {
                    // the number of characters which are left
                    $left = $length - $total_length;
                    $entities_length = 0;
                    // search for html entities
                    if (preg_match_all('/&[0-9a-z]{2,8};|&#[0-9]{1,7};|[0-9a-f]{1,6};/i', $line_matchings[2], $entities, PREG_OFFSET_CAPTURE)) {
                        // calculate the real length of all entities in the legal range
                        foreach ($entities[0] as $entity) {
                            if ($entity[1]+1-$entities_length <= $left) {
                                $left--;
                                $entities_length += strlen($entity[0]);
                            } else {
                                // no more characters left
                                break;
                            }
                        }
                    }
                    $truncate .= substr($line_matchings[2], 0, $left+$entities_length);
                    // maximum lenght is reached, so get off the loop
                    break;
                } else {
                    $truncate .= $line_matchings[2];
                    $total_length += $content_length;
                }
                // if the maximum length is reached, get off the loop
                if ($total_length>= $length) {
                    break;
                }
            }
        } else {
            if (strlen($text) <= $length) {
                return $text;
            } else {
                $truncate = substr($text, 0, $length - strlen($ending));
            }
        }
        // if the words shouldn't be cut in the middle...
        if (!$exact) {
            // ...search the last occurance of a space...
            $spacepos = strrpos($truncate, ' ');
            if (isset($spacepos)) {
                // ...and cut the text in this position
                $truncate = substr($truncate, 0, $spacepos);
            }
        }
        // add the defined ending to the text
        $truncate .= $ending;
        if ($considerHtml) {
            // close all unclosed html-tags
            foreach ($open_tags as $tag) {
                $truncate .= '</' . $tag . '>';
            }
        }
        return $truncate;
    }
	
	static function isAdmin(){ 
		$app = JFactory::getApplication();
		return $app->isClient('administrator');
	}
	
	public static function getDateGeneralFormat($data){
	
		if(!isset($data) || $data=='' || strcmp($data,"0000-00-00")==0)
			return $data;
	
		$data =strtotime($data);
		$appSettings= self::getApplicationSettings();
		$language = JFactory::getLanguage();
		$language_tag = $language->getTag();
	
		$language_tag = str_replace("-","_",$language->getTag());
		setlocale(LC_TIME , $language_tag.'.UTF-8');
	
		//	setlocale(LC_TIME , $appSettings->date_language.'.UTF-8');
		if (PHP_OS == "WIN32" || PHP_OS == "WINNT")
			$dateS =  strtolower(strftime("%A %#d %B %Y", $data));
		else
			$dateS =  strtolower(strftime("%A %e %B %Y", $data));;
	
		return $dateS;
	}
	public static function getAllStates(){
		JTable::addIncludePath(JPATH_ROOT.'/administrator/components/com_jclassifiedsmanager/tables');
		$adsTable = JTable::getInstance('ManageAds','Table');
		$states = $adsTable->getAllStates();
		
		return $states;
		
	}
	public static function getAllCities(){
		JTable::addIncludePath(JPATH_ROOT.'/administrator/components/com_jclassifiedsmanager/tables');
		$adsTable = JTable::getInstance('ManageAds','Table');
		$cities = $adsTable->getAllCities();
	
		return $cities;
	
	}
	

	public static function getCoordinates($zipCode){
		$location = null;
		
		$url ="http://maps.googleapis.com/maps/api/geocode/json?sensor=false&address=".urlencode($zipCode);
		$data = file_get_contents($url);
		$search_data = json_decode($data);
		if(!empty($data)){
			$lat =  $search_data->results[0]->geometry->location->lat;
			$lng =  $search_data->results[0]->geometry->location->lng;
	
			$location =  array();
			$location["latitude"] = $lat;
			$location["longitude"] = $lng;
		}
		
		return $location;

	}

	// The ago time function
	public static function convertTimestampToAgo($datetime, $full = false) {
	    $now = new DateTime;
	    $ago = new DateTime($datetime);
	    $diff = $now->diff($ago);

	    $diff->w = floor($diff->d / 7);
	    $diff->d -= $diff->w * 7;
	    $string = array(
	        'y' => JText::_("LNG_YEARS"),
	        'm' => JText::_("LNG_MONTHS"),
	        'w' =>  JText::_("LNG_WEEKS"),
	        'd' => JText::_("LNG_DAYS"),
	        'h' => JText::_("LNG_HOURS"),
	        'i' => JText::_("LNG_MINUTES"),
	        's' => JText::_("LNG_SECONDS"),
	    );
	    foreach ($string as $k => &$v) {
	        if ($diff->$k) {
	            $v = $diff->$k . ' ' . $v;
	        } else {
	            unset($string[$k]);
	        }
	    }

	    if (!$full) $string = array_slice($string, 0, 1);
	    return $string ? implode(', ', $string) . ' '.JText::_("LNG_PUBLISHED_AGO") : JText::_("LNG_PUBLISHED_JUST_NOW");
	}



	static function getAlias($title, $alias){
		if (empty($alias) || trim($alias) == ''){
			$alias = $title;
		}
		
		$alias = JApplicationHelper::stringURLSafe($alias);
		
		if (trim(str_replace('-', '', $alias)) == ''){
			$alias = JFactory::getDate()->format('Y-m-d-H-i-s');
		}
		
		return $alias;
	}




	 /**
	 * getCategoryLink (Builds an url for a cetegory depending on alias and category id)
	 * @param  $categoryAlias (the alias of the category)
	 * @param  $categoryId (the id of the category)
	 * @return $url (string of the url created)
	 * 
	 */

	static function getCategoryLink($categoryId, $categoryAlias, $addIndex=null){
		
		//get application settings 
		$appSettings= self::getApplicationSettings();
		
		$categoryAlias = trim($categoryAlias);
		$categoryAlias = stripslashes(strtolower($categoryAlias));
		$categoryAlias = str_replace(" ", "-", $categoryAlias);
	
		$conf = JFactory::getConfig();
		$index ="";
		if(!JFactory::getConfig()->get("sef_rewrite")){
			$index ="index.php/";
		}
	
		$categoryLink = $categoryId;
		
		//if Seo is not enabled show the default url of the category 
		if(!$appSettings->enable_seo){
			$categoryLink = $categoryId;
			if(JFactory::getConfig()->get("sef")){
				$categoryLink = $categoryId;
			}
			$url = JRoute::_('index.php?option=com_jclassifiedsmanager&view=displayads&categorySearch='.$categoryLink);

		}else{
		//if Seo is enabled than create the url with the given alias
			if($appSettings->enable_id_url == 1){ 
				$categoryLink = $categoryId."-".htmlentities(urlencode($categoryAlias));

			}else{
				$categoryLink = htmlentities(urlencode($categoryAlias));
			}
			$url = JURI::base().$index.CATEGORY_URL_NAMING."/".$categoryLink;
		}
		
		return $url;
	}


	 /**
	 * getAdLink (Builds an url for an ad depending on alias and ad id)
	 * @param  $adAlias (the alias of the ad)
	 * @param  $adId (the id of the ad)
	 * @return $url (string of the url created)
	 * 
	 */

	static function getAdLink($adId, $adAlias, $addIndex=null){
		
		//get application settings 
		$appSettings= self::getApplicationSettings();
		$adAlias = trim($adAlias);
		$adAlias = stripslashes(strtolower($adAlias));
		$adAlias = str_replace(" ", "-", $adAlias);
	
		$conf = JFactory::getConfig();
		$index ="";
		if(!JFactory::getConfig()->get("sef_rewrite")){
			$index ="index.php/";
		}
	
		$adLink = $adId;
		
		//if Seo is not enabled show the default url of the ad 
		if(!$appSettings->enable_seo){
			$adLink = $adId;
			if(JFactory::getConfig()->get("sef")){
				$adLink = $adId;


				
			}
			$url = JRoute::_('index.php?option=com_jclassifiedsmanager&view=displayad&id='.$adLink);

		}else{
		//if Seo is enabled than create the url with the given alias
			if($appSettings->enable_id_url == 1){ 
				$adLink = $adId."-".htmlentities(urlencode($adAlias));
			}else{
				$adLink = htmlentities(urlencode($adAlias));
			}
			$url = JURI::base().$index.AD_URL_NAMING."/".$adLink;
		}		
		return $url;
	}
	
	//format price 
	static function getPriceFormat($amount){
		$dec_point=".";
		$thousands_sep = ",";
	
		//Format price according to separators 
		$amountString = number_format ($amount , 0 , $dec_point,  $thousands_sep);
		
		return $amountString;
	}
	
	//check if user is logged in, redirect to the control panel after login
	static function loginWithRedirect($returnURL){
		if (!JFactory::getUser()->id){
			$app = JFactory::getApplication();
			$msg = JText::_('LNG_LOGIN_IS_REQUIRED');
			$returnURL = base64_encode($returnURL);
			if(empty($returnURL))
				$returnURL = base64_encode('index.php');
			
			$app->redirect(JRoute::_("index.php?option=com_users&view=login&return=".$returnURL, $msg ));
		}
	}

	public static function setExtensionMenuId($appSettings){
		//setting menu item Id
		$session = JFactory::getSession();
		$app = JFactory::getApplication();
		$language = JFactory::getLanguage();
		$language_tag = $language->getTag();
		
		$menu = $app->getMenu();
		$activeMenu = $app->getMenu()->getActive();
		
		if (!empty($activeMenu) && $activeMenu != $menu->getDefault($language_tag)) {
			$menuId = $activeMenu->id;
			$session->set('menuId', $menuId);
		}
		
		$menuId = $session->get('menuId');
		
		if(!empty($appSettings->menu_id) && ($menuId == $menu->getDefault($language_tag)->id || empty($menuId))){
			$menuId = $appSettings->menu_id;
		}
			
		if(!empty($menuId)){
			JFactory::getApplication()->getMenu()->setActive($menuId);
			JFactory::getApplication()->input->set('Itemid',$menuId);
		}
	}


    /**
     * @return array of jclassifieds languages which are  joomlas installed languages
     */
    public static function languageTabs()
    {
        $jclassifiedsLanguagesPath = JLanguageHelper::getLanguagePath(JPATH_COMPONENT_ADMINISTRATOR);
        //Returns an array
        $dirs = JFolder::folders($jclassifiedsLanguagesPath);
        sort($dirs);

        $joomlaLanguagesPath = JLanguageHelper::getLanguagePath(JPATH_ADMINISTRATOR);
        //Returns an array
        $joomlaDirs = JFolder::folders($joomlaLanguagesPath);
        sort($joomlaDirs);

        $language = array();
        foreach($dirs as $jclassifiedsLang){
            if(in_array($jclassifiedsLang,$joomlaDirs)){
                $language[] = $jclassifiedsLang;
            }
        }
        return $language;
    }

	    /**
     * @param $languageTag language tag  like en-GB
     * @return Returns a sting with a name of a languge based on its language tag $languageTag
     */
    public static  function languageNameTabs($languageTag){

        //Active Language type Array
        $activeLanguages = self::languageTabs();

            if(in_array($languageTag,$activeLanguages)) {
                $path = JLanguageHelper::getLanguagePath(JPATH_ROOT);
                $xmlFiles = JFolder::files($path.DS.$languageTag,'^([-_A-Za-z]*)\.xml$');
                $xmlFile = reset($xmlFiles);

                $data = JApplicationHelperHelper::parseXMLLangMetaFile($path.DS.$languageTag.DS.$xmlFile);

                return $data['name'] !=''? $data['name']:$languageTag;
            }
        return $languageTag;
    }

	/**
	 * Retrieve the current editor
	 *
	 * @return \Joomla\CMS\Editor\Editor|string
	 */
	public static function getEditor() {
        if (defined('JVERSION')) {
            $joomlaVersion = (int) JVERSION;
        } else {
            $j = new JVersion();
            $joomlaVersion = (int) $j->getShortVersion();
        }

        if ($joomlaVersion == 3) {
            $editor = JFactory::getEditor();
        } else {
            $editor = self::getSiteConfig()->editor;
            $editor = JEditor::getInstance($editor);
        }

        return $editor;
	}

    public static function getSiteConfig() {
        $config = new JConfig();

        /*  $config->mailfrom ="";
        $config->fromname ="";
        $config->tmp_path = "";
        $config->sitename ="";
         */
        return $config;
    }

	/**
	 * Get the available languages on the CMS
	 *
	 * @return array
	 */
	public static function getLanguages() {
		$languages = JLanguageHelper::getKnownLanguages();
		
		$result = array();
		foreach ($languages as $key=>$language) {
			$name = isset($language["nativeName"])?$language["nativeName"]:$language["name"];
			if (strpos($name, "(")!==false) {
				$name = substr($name, 0, strpos($name, "(")-1);
			}
			if (!isset($result[$name])) {
				$result[$name]=$key;
			} else {
				$name = $language["name"];
				$result[$name]=$key;
			}
		}
		
		asort($result);
		return $result;
	}

	/**
	 * Get Website URL
	 * @return string
	 */
	public static function getWebsiteURL($root = false) {
		$uri = JURI::getInstance();
		$base = $uri->getScheme()."://".$uri->getHost();

		if($root) {
			$baseUrl = $base . JURI::root(true)."/";
		} else {
			$baseUrl = $base;
		}

		return $baseUrl;
	}


	/**
	 * Get the current language code
	 *
	 * @return mixed
	 */
	public static function getCurrentLanguageCode() {
		$lang = JAdsUtil::getLanguageTag();
		$lang = explode("-", $lang);
		return $lang[0];
	}

    /**
     * Get the current language tag
     *
     * @return string
     */
    public static function getLanguageTag() {
        $lang = JFactory::getApplication()->input->get('mobileLanguage');

        if(empty($lang)) {
            $lang = JFactory::getLanguage()->getTag();
        }

        return $lang;
    }
}

?>