<?php

class CRW { // C=crop, R=resize, W=watermark, E=effecfts

    /*+++++++++++++++++ croping images ++++++++++++++++++++++++++++++*/
    public function cropImage($image_folder, $srcImage, $newW, $newH, $new_prefix, $new_name,$destDirectory) {
        
        //$srcExt = strtolower(substr($srcImage, strlen($srcImage) - 4));
        $srcExt = substr($srcImage, strrpos($srcImage, "."));
        $srcExt = strtolower($srcExt);
        list($w_orig, $h_orig) = getimagesize($image_folder . $srcImage);

        $scale_ratio = $w_orig / $h_orig;
        $new_scale_ratio = $newW / $newH;

        if ($new_scale_ratio < $scale_ratio) {
            $resizW = $newH * $scale_ratio;
            $resizH = $newH;
        } else {
            $resizH = $newW / $scale_ratio;
            $resizW = $newW;
        }

        
        $this->resize_for_crop($image_folder . $srcImage, $destDirectory. "resized_" .$srcImage, $resizW, $resizH, $srcExt, $destDirectory);
        $this->crop_resized_image($destDirectory. "resized_" .$srcImage, $destDirectory. $new_prefix . $new_name . $srcExt, $newW, $newH, $srcExt, $destDirectory);
        unlink($destDirectory . "resized_" .  $srcImage);
    }

    private function resize_for_crop($target, $newcopy, $w, $h, $ext,$destDirectory) {
        list($w_orig, $h_orig) = getimagesize($target);
        $scale_ratio = $w_orig / $h_orig;
        if (($w / $h) > $scale_ratio) {
            $w = $h * $scale_ratio;
        } else {
            $h = $w / $scale_ratio;
        }
        $img = "";
        $ext = strtolower($ext);
        
        $tci = imagecreatetruecolor($w, $h);
        
        if ($ext == ".gif") {
            $img = imagecreatefromgif($target);
        } else if ($ext == ".png") {
            imagealphablending($tci, false);
            imagesavealpha($tci,true);
            $transparent = imagecolorallocatealpha($tci, 255, 255, 255, 127);
            imagefilledrectangle($tci, 0, 0, $w, $h, $transparent);
        
            $img = imagecreatefrompng($target);
        } else {
            $img = imagecreatefromjpeg($target);
        }
        
        imagecopyresampled($tci, $img, 0, 0, 0, 0, $w, $h, $w_orig, $h_orig);
        if ($ext == ".gif") {
            imagegif($tci, $newcopy);
        } else if ($ext == ".png") {
            imagepng($tci, $newcopy);
        } else {
            imagejpeg($tci, $newcopy, 100);
        }
    }

    private function crop_resized_image($target, $newcopy, $w, $h, $ext,$destDirectory) {
        list($w_orig, $h_orig) = getimagesize($target);
        $src_x = ($w_orig / 2) - ($w / 2);
        $src_y = ($h_orig / 2) - ($h / 2);
        $ext = strtolower($ext);
        $img = "";
        $tci = imagecreatetruecolor($w, $h);
        if ($ext == ".gif") {
            $img = imagecreatefromgif($target);
        } else if ($ext == ".png") {
             imagealphablending($tci, false);
            imagesavealpha($tci,true);
            $transparent = imagecolorallocatealpha($tci, 255, 255, 255, 127);
            imagefilledrectangle($tci, 0, 0, $w, $h, $transparent);
            $img = imagecreatefrompng($target);
        } else {
            $img = imagecreatefromjpeg($target);
        }
        
        imagecopyresampled($tci, $img, 0, 0, $src_x, $src_y, $w, $h, $w, $h);
        if ($ext == ".gif") {
            imagegif($tci, $newcopy);
        } else if ($ext == ".png") {
            imagepng($tci, $newcopy);
        } else {
            imagejpeg($tci, $newcopy, 100);
        }
    }
    /* +++++++++++++++++ /croping images ++++++++++++++++++++++++++++++ */

    /* +++++++++++++++++ watermarking ++++++++++++++++++++++++++++++ */

    public function watermarkImage($sourcefile, $watermarkfile, $position) {


        //Get the resource ids of the pictures
        $watermarkfile_id = imagecreatefrompng($watermarkfile);

        imageAlphaBlending($watermarkfile_id, false);
        imageSaveAlpha($watermarkfile_id, true);

        $fileType = strtolower(substr($sourcefile, strlen($sourcefile) - 3));

        switch ($fileType) {
            case('gif'):
                $sourcefile_id = imagecreatefromgif($sourcefile);
                break;

            case('png'):
                $sourcefile_id = imagecreatefrompng($sourcefile);
                break;

            default:
                $sourcefile_id = imagecreatefromjpeg($sourcefile);
        }
        $marge_right = 50;
        $marge_bottom = 50;
        
        $sourcefile_width = imageSX($sourcefile_id);
        $sourcefile_height = imageSY($sourcefile_id);
        $watermarkfile_width = imageSX($watermarkfile_id);
        $watermarkfile_height = imageSY($watermarkfile_id);

        if ($position == "BottomRight") {
            $xPos = $sourcefile_width - $watermarkfile_width - $marge_right;
            $yPos = $sourcefile_height - $watermarkfile_height - $marge_bottom;
        } elseif ($position == "TopLeft") {
            $xPos = $marge_right;
            $yPos = $marge_bottom;
        } elseif ($position == "BottomLeft") {
            $xPos = $marge_right;
            $yPos = $sourcefile_height - $watermarkfile_height - $marge_bottom;
        } elseif ($position == "TopRight") {
            $xPos = $sourcefile_width - $watermarkfile_width - $marge_right;
            $yPos = $marge_bottom;
        } elseif ($position == "Center") {
            $xPos = round($sourcefile_width / 2) - $watermarkfile_width / 2;
            $yPos = round($sourcefile_height / 2) - $watermarkfile_height / 2;
        }

        if ($fileType == 'gif') {
            $tempimage = imagecreatetruecolor($sourcefile_width, $sourcefile_height);
            imagecopy($tempimage, $sourcefile_id, 0, 0, 0, 0, $sourcefile_width, $sourcefile_height);
            $sourcefile_id = $tempimage;
        }
        
        if ($fileType == 'png') {
            imagealphablending($sourcefile_id, true);
            imagesavealpha($sourcefile_id, true);
        }
        
       imagecopy($sourcefile_id, $watermarkfile_id, $xPos, $yPos, 0, 0, $watermarkfile_width, $watermarkfile_height);

        if ($fileType == "png") {
            imagepng($sourcefile_id, $sourcefile);
        } else if ($fileType == "gif") {
            imagegif($sourcefile_id, $sourcefile);
        } else {
            imagejpeg($sourcefile_id, $sourcefile, 100);
        }

        imagedestroy($sourcefile_id);
        imagedestroy($watermarkfile_id);
    }
/* +++++++++++++++++ /watermarkng ++++++++++++++++++++++++++++++ */
    

 /*++++++++++++++++ Resize image++++++++++++++++++++*/  
 public function image_resize($image_folder, $image_name, $new_width, $new_prefix,$new_name,$destDirectory) {
    
    $ext = substr($image_name, strrpos($image_name, "."));
    $ext = strtolower($ext);
    
    $filename = $image_folder . $image_name;
    list($width, $height) = getimagesize($filename);

    $newwidth = $new_width;
    $newheight = round(($height / 100) * (100 / $width * $newwidth), 0);
    /*
    $newImg = imagecreatetruecolor($nWidth, $nHeight);
    imagealphablending($newImg, false);
    imagesavealpha($newImg,true);
    $transparent = imagecolorallocatealpha($newImg, 255, 255, 255, 127);
    imagefilledrectangle($newImg, 0, 0, $nWidth, $nHeight, $transparent);
    imagecopyresampled($newImg, $im, 0, 0, 0, 0, $nWidth, $nHeight, $imgInfo[0], $imgInfo[1]);
    */
    $thumb = imagecreatetruecolor($newwidth, $newheight);
    
    $source = "";
    $ext = strtolower($ext);
    if ($ext == ".gif"){ 
    $source = imagecreatefromgif($filename);
    } else if($ext ==".png"){ 
        imagealphablending($thumb, false);
        imagesavealpha($thumb,true);
        $transparent = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
        imagefilledrectangle($thumb, 0, 0, $newwidth, $newheight, $transparent);
       
    $source = imagecreatefrompng($filename);
    } else { 
    $source = imagecreatefromjpeg($filename);
    }
    
    imagecopyresampled($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
    if ($ext == ".gif"){ 
    imagegif($thumb, $destDirectory .$new_prefix . $new_name.$ext);
    } else if($ext ==".png"){ 
    imagepng($thumb, $destDirectory. $new_prefix . $new_name.$ext);
    } else { 
    imagejpeg($thumb, $destDirectory . $new_prefix . $new_name.$ext, 100);
    }
    
 }
 /*++++++++++++++++ /Resize image++++++++++++++++++++*/
 
 /*++++++++++++++++ Effects +++++++++++++++++++++++++*/
    public function imageEffect($imgSource, $imgEffect, $aditionalParam,$prefix, $new_name,$destDirectory)
	{
    

                    $srcExt = substr($imgSource, strrpos($imgSource, "."));
                    $srcExt = strtolower($srcExt);
       
                    if ($srcExt == ".gif"){ 
                    $source = imagecreatefromgif($imgSource);
                    } else if($srcExt ==".png"){ 
                    $source = imagecreatefrompng($imgSource);
                    } else { 
                    $source = imagecreatefromjpeg($imgSource);
                    }
                    
                    //effect
                    switch ($imgEffect)
                        {
                            case'rotate':
                                $source = imagerotate($source, $aditionalParam, 0);
                                break;
                            
                            case'greyscale':
                                 imagefilter($source, IMG_FILTER_GRAYSCALE);
                                break;
                            
                            case'brightness':
                                 imagefilter($source, IMG_FILTER_BRIGHTNESS, $aditionalParam);
                                break;
                            
                            case'negative':
                                 imagefilter($source, IMG_FILTER_NEGATE);
                                break;
                            
                            case'pixelate':
                                 imagefilter($source, IMG_FILTER_PIXELATE, $aditionalParam);
                                break;
                            
                            case'sepia':
                                 imagefilter($source, IMG_FILTER_GRAYSCALE, 25);
                                 imagefilter($source, IMG_FILTER_COLORIZE, 100, 50, 0);
                                break;
                            
                            case'contrast':
                                 imagefilter($source, IMG_FILTER_CONTRAST, $aditionalParam);
                                break;
                            
                            case'colorize':
                                 imagefilter($source, IMG_FILTER_COLORIZE, 0, 100, 0);
                                break;
                            
                            case'edgedetect':
                                 imagefilter($source, IMG_FILTER_EDGEDETECT);
                                break;
                            
                            case'gaussianblur':
                                 imagefilter($source, IMG_FILTER_GAUSSIAN_BLUR);
                                break;
                            
                            case'selectiveblur':
                                 imagefilter($source, IMG_FILTER_SELECTIVE_BLUR);
                                break;
                            
                            case'meanremove':
                                 imagefilter($source, IMG_FILTER_MEAN_REMOVAL);
                                break;
                            
                            case'smooth':
                                 imagefilter($source, IMG_FILTER_SMOOTH, $aditionalParam);
                                break;
                            
                            case'emboss':
                                 imagefilter($source, IMG_FILTER_EMBOSS);
                                break;
                            
                            case'colorize':
                                 imagefilter($source, IMG_FILTER_GRAYSCALE, 25);
                                 imagefilter($source, IMG_FILTER_COLORIZE, 90, 90, 0);
                                break;
                        }
                        
                    
                        if ($srcExt == ".gif")
                        { 
                                imagegif($source, $destDirectory.$prefix.$new_name.$srcExt);
                        } 
                        else if($srcExt ==".png")
                        { 
                                imagepng($source, $destDirectory.$prefix.$new_name.$srcExt);
                        } else { 
                                imagejpeg($source, $destDirectory.$prefix.$new_name.$srcExt, 100);
                        }
    
		}
	
	
/*++++++++++++++++ Effects +++++++++++++++++++++++++*/
 
/*++++++++++++++++Make New Name++++++++++++++++++++*/
    public function new_name() {
    $name = microtime();
    $name = str_replace(".", "", $name);
    $name = str_replace(" ", "", $name);
    $name=  $this->alphanumID($name);
    return $name;
    }
    
    //generate youtube-like name
    private function alphanumID($in, $to_num = false, $pad_up = false, $passKey = null) {
    $index = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-";
    if ($passKey !== null) {

        for ($n = 0; $n < strlen($index); $n++) {
            $i[] = substr($index, $n, 1);
        }

        $passhash = hash('sha256', $passKey);
        $passhash = (strlen($passhash) < strlen($index)) ? hash('sha512', $passKey) : $passhash;

        for ($n = 0; $n < strlen($index); $n++) {
            $p[] = substr($passhash, $n, 1);
        }

        array_multisort($p, SORT_DESC, $i);
        $index = implode($i);
    }

    $base = strlen($index);

    if ($to_num) {
        // Digital number  <<--  alphabet letter code
        $in = strrev($in);
        $out = 0;
        $len = strlen($in) - 1;
        for ($t = 0; $t <= $len; $t++) {
            $bcpow = pow($base, $len - $t);
            $out = $out + strpos($index, substr($in, $t, 1)) * $bcpow;
        }

        if (is_numeric($pad_up)) {
            $pad_up--;
            if ($pad_up > 0) {
                $out -= pow($base, $pad_up);
            }
        }
        $out = sprintf('%F', $out);
        $out = substr($out, 0, strpos($out, '.'));
    } else {
        // Digital number  -->>  alphabet letter code
        if (is_numeric($pad_up)) {
            $pad_up--;
            if ($pad_up > 0) {
                $in += pow($base, $pad_up);
            }
        }

        $out = "";
        for ($t = floor(log($in, $base)); $t >= 0; $t--) {
            $bcp = pow($base, $t);
            $a = floor($in / $bcp) % $base;
            $out = $out . substr($index, $a, 1);
            $in = $in - ($a * $bcp);
        }
        $out = strrev($out); // reverse
    }

    return $out;
}
    
/*++++++++++++++++Make New Name++++++++++++++++++++*/

}




/*
$cropImage=new CRW();
$newName=$cropImage->new_name();
$cropImage->cropImage("uploaded_images/", "orig_1V73A2Jz-q.gif", "1500", "400", "custom_", $newName);
$cropImage->watermarkImage("uploaded_images/custom_".$newName.".gif", "igor_s_transparentq.png", "BottomRight");
$cropImage->image_resize("uploaded_images/", "orig_1V73A2Jz-q.gif", "1500", "custom_", $newName);
 * 
 */
?>
