<?php 

$key= "";
if(!empty($appSettings->google_map_key))
	$key="&key=".$appSettings->google_map_key;

if($appSettings->enable_google_map_clustering) {
?>
  <script src="https://googlemaps.github.io/js-marker-clusterer/examples/data.json"></script>
  <script src="https://google-maps-utility-library-v3.googlecode.com/svn/trunk/markerclusterer/src/markerclusterer.js"></script>
<?php } ?>

<script>
  function initialize() {
    var center = new google.maps.LatLng(37.4419, -122.1419);

    <?php 
      $height = "450px";
      if(isset($mapHeight)) {
        $height = $mapHeight;
      }
      $width = "100%";
      if(isset($mapWidth)) {
        $width = $mapWidth;
      }
    ?>
    var mapdiv = document.getElementById("ads-map");
    mapdiv.style.width =  "<?php echo $width ?>";
    mapdiv.style.height = "<?php echo $height ?>";

    var map = new google.maps.Map(mapdiv, {
      zoom: 3,
      center: center,
      mapTypeId: google.maps.MapTypeId.ROADMAP
    });

    var ads = [
      <?php 
      
      $index = 1;


      foreach($this->filteredAds['adsformap'] as $activeAd ) {
        $description = $activeAd->description;
        $description = substr($description,0,100);
        $description = substr($description,0,strrpos($description," "));
        $db = JFactory::getDBO();
        
       
        $marker = 0;
  

        $contentString = '<div class="info-box">'.
          '<div class="title">'.$db->escape(htmlspecialchars(strip_tags($activeAd->title, ENT_QUOTES))).'</div>'.
          '<div class="info-box-image">'.
          (isset($activeAd->picture_id) && strlen($activeAd->picture_id)>3?'<img src="'. JURI::root()."components/".getAdComponentName()."/imageupload/uploaded_images/thumb_".$activeAd->picture_id.'" alt="'.$activeAd->title.'">':"").
          '</div>'.
          '<div class="info-box-content">'.
          '<div class="price" >'.$activeAd->price.' '.$activeAd->currency.'</div>'.
          '<div class="info-phone"><i class=""></i> '.$db->escape(htmlspecialchars(strip_tags($description), ENT_QUOTES)).'</div>'.
          '<a href="'.JRoute::_( "index.php?option=".getAdComponentName()."&view=displayad&id=". $activeAd->id).'"><i class="dir-icon-external-link"></i> '.JText::_("LNG_MORE_INFO",true).'</a>'.
          '</div></div>';

        if(!empty($activeAd->latitude) && !empty($activeAd->longitude)) {
          echo "['".$activeAd->title."', \"$activeAd->latitude\",\"$activeAd->longitude\", 4,'".$contentString."','".$index."','".$marker."'],"."\n";
        }


        $index++;
      } ?>
    ];

    setMarkers(map, ads);
  }

  function setMarkers(map, locations) {
    // Add markers to the map

    // Marker sizes are expressed as a Size of X,Y
    // where the origin of the image (0,0) is located
    // in the top left of the image.

    // Origins, anchor positions and coordinates of the marker
    // increase in the X direction to the right and in
    // the Y direction down.

    var bounds = new google.maps.LatLngBounds();

    var markers = [];

    for (var i = 0; i < locations.length; i++) {
      var ad = locations[i];

      var pinColor = "0071AF";
      var pinImage = new google.maps.MarkerImage("http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld="+(ad[5])+"|" + pinColor+"|FFFFFF",
        new google.maps.Size(23, 32),
        new google.maps.Point(0,0),
        new google.maps.Point(10, 34));
      var pinShadow = new google.maps.MarkerImage("http://chart.apis.google.com/chart?chst=d_map_pin_shadow",
        new google.maps.Size(40, 37),
        new google.maps.Point(0, 0),
        new google.maps.Point(12, 35));

      var shape = {
        coord: [1, 1, 1, 20, 18, 20, 18 , 1],
        type: 'poly'
      };

      if(ad[6] != '0') {
        pinImage = new google.maps.MarkerImage(ad[6],
        // This marker is 20 pixels wide by 32 pixels tall.
        new google.maps.Size(32, 32),
        // The origin for this image is 0,0.
        new google.maps.Point(0,0),
        // The anchor for this image is the base of the flagpole at 0,32.
        new google.maps.Point(0, 32));
      }

      var myLatLng = new google.maps.LatLng(ad[1], ad[2]);
      var marker = new google.maps.Marker({
        position: myLatLng,
        map: map,
          icon: {
              path: google.maps.SymbolPath.CIRCLE,
              scale: 8,
          },
          shadow: pinShadow,
        shape: shape,
        title: ad[0],
        zIndex: ad[3]
      });

      markers.push(marker);

      var contentBody = ad[4];
      var infowindow = new google.maps.InfoWindow({
        content: contentBody,
        maxWidth: 210
      });

      google.maps.event.addListener(marker, 'click', function(contentBody) {
        return function() {
          infowindow.setContent(contentBody);//set the content
          infowindow.open(map,this);
        }
      } (contentBody));

      bounds.extend(myLatLng);
      }

      <?php if($appSettings->enable_google_map_clustering) { ?>
      var markerCluster = new MarkerClusterer(map, markers);
      <?php } ?>

       <?php 
       $session = JFactory::getSession();  
       $latitude = $session->get("latitude"); 
       $longitude = $session->get("longitude");
       $zipcode = $session->get("zipcode"); 
       $radius = $session->get("geo-loc-radius"); 
       $geolocation = $session->get('geolocation'); 
       ?>

    <?php 
    if(!empty($geolocation) || !empty($zipcode) && !empty($latitude) && !empty($longitude)) { ?>
      var pinImage = new google.maps.MarkerImage("<?php echo JURI::base() ."/components/com_jclassifiedsmanager/assets/images/newmarker.png"?>",
      new google.maps.Size(32, 32),
      new google.maps.Point(0,0),
      new google.maps.Point(10, 34));

      var myLatLng = new google.maps.LatLng(<?php echo $latitude ?>,  <?php echo $longitude ?>);
     
      var marker = new google.maps.Marker({
        position: myLatLng,
        map: map,
        icon: pinImage
      });

     

      <?php if(!empty($radius)) { ?>

        // Add circle overlay and bind to marker
        var circle = new google.maps.Circle({
          map: map,
          radius: <?php echo $radius * 1600;?>,
          strokeColor: "#006CD9",
          strokeOpacity: 0.7,
          strokeWeight: 2,
          fillColor: "#006CD9",
          fillOpacity: 0.15,
        });
        circle.bindTo('center', marker, 'position');
      <?php } ?>
      bounds.extend(myLatLng);
    <?php }?>
    map.fitBounds(bounds);

    var listener = google.maps.event.addListener(map, "idle", function() { 
      if (map.getZoom() > 16) map.setZoom(16);
      google.maps.event.removeListener(listener);
    });
  }

  function loadMapScript() {
    if(!initialized) {
      var script = document.createElement("script");
      script.type = "text/javascript";
      script.src = "https://maps.googleapis.com/maps/api/js?sensor=false&callback=initialize<?php echo $key;?>";
      document.body.appendChild(script);
      initialized = true;
    }
  }
  var initialized = false;
</script>

<div id="ads-map" style="position: relative;"></div>