<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');
jimport('joomla.html.pagination');

class JClassifiedsManagerModelDisplayAd extends JModelList
{
	function __construct()
	{
		parent::__construct();
		$mainframe = JFactory::getApplication();
		
		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = JFactory::getApplication()->input->getInt('limitstart', 0, '', 'int');
		
		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$this->total = 0;
	
	}
	

	
	
	function getParentCategories()
	{
		// Load the data
		$row = $this->getTable('categories');
		$categories = $row->getParentCategoriesWithCount();
		return $categories;
	}
	function getSelectedCategory()
	{
		// Load the data
		$row = $this->getTable('categories');
		$categoryId = JFactory::getApplication()->input->get('categoryId',0);
		$row->load($categoryId);
		return $row->name;
	}
	
	

	function getAdType(){
		// Load the data
		$row = $this->getTable('manageadtypes');
		$adTypeId = JFactory::getApplication()->input->get('adtype',1);
		$adType = $row->getAdType($adTypeId);
		return $adType;
	}
	
	
	function getAllCurrencies(){
		// Load the data
		$row = $this->getTable('currencies');
		$currencies = $row->getAllCurrencies();
		return $currencies;
	}

	function getAllUserTypes(){
		// Load the data
		$row = $this->getTable('manageusertypes');
		$userTypes = $row->getAllUserTypes();
		return $userTypes;
	}

	
	#get category attributes function 
	function getCategoryAttributes(){
		$categoryId = JFactory::getApplication()->input->get('categoryId');
		if(isset($categoryId) && $categoryId!=''){
			$row =$this->getTable('categoryattributes');
			$categoryAttributes = $row->getCategoryAttributes($categoryId);
			$content = $this->renderFilterAttributes($categoryAttributes);
			return $content;
		}
		return "";
	}
	function renderFilterAttributes($categoryAttributes)
	{
		$selectedAttributes = JFactory::getApplication()->input->get('attributeOptions');
		include 'components/com_jclassifiedsmanager/classes/attributeRenderer.php';
		$attributeRenderer= new attributeRenderer();
		$content = $attributeRenderer->renderFilterAttributes($categoryAttributes,$selectedAttributes);
		return $content;
	}
	
	
	function getDefaultCurrency(){
		$currencyTable =$this->getTable('currencies');
		$currency = $currencyTable->getDefaultCurrency();
		return $currency;
	}


	function processSliderAttributes($attributes){
		$processedArray = array();
		if(strlen($attributes)>0){
			$attributesArray = explode(",",$attributes);
			foreach($attributesArray as $key=>$attrib) {
				$processedArray[$key] = explode("|",$attrib);
			}
		}
		return $processedArray;
	}
	
 	function getAdDetails(){
 		$adTable =$this->getTable('manageads');
 		$adId = JFactory::getApplication()->input->getInt("id",0);
 		$adDetails = $adTable->getAdDetailsDetailed($adId);
 		
 		$adDetails->categoryId = $adDetails->category_id;
 		$adDetails->categoryName = $adDetails->category;
 			
 		$adDetails->sub_category_id2 = intVal($adDetails->sub_category_id2);
 		$adDetails->sub_category_id = intVal($adDetails->sub_category_id);
 		 
 		if(!empty($adDetails->sub_category_id2)){
 			$adDetails->categoryId = $adDetails->sub_category_id2;
 			$adDetails->categoryName = $adDetails->sub_category2;
 		}
 		else if(!empty($adDetails->sub_category_id)){
 			$adDetails->categoryId = $adDetails->sub_category_id;
 			$adDetails->categoryName = $adDetails->sub_category;
 		}
 			
 		$adDetails->category_id = !empty($adDetails->sub_category_id2)?$adDetails->sub_category_id2:$adDetails->category_id;
 		$adDetails->category_id = !empty($adDetails->sub_category_id)?$adDetails->sub_category_id:$adDetails->category_id;
 			
 		
 		$adDetails->attributes = $adTable->getAddAttributes($adId);
 		$adTable->increaseViewCount($adId);

 		$videotable = $this->getTable('advideos');
		$adDetails->videos = $videotable->getAdVideos($adId);

 		$userId = JFactory::getUser()->id;
		$adDetails->isBookmarked = false;
		if(!empty($userId)){
			$bookmarkTable = $this->getTable('bookmark');
			// Return the bookmark of the ad 
			$adDetails->bookmark = $bookmarkTable->getBookmark($adId, $userId);
		}

 		return $adDetails;
 	}
 	
 	function sendEmailToFriend(){

 			$applicationSettings = JAdsUtil::getApplicationSettings();
 			$message = JFactory::getApplication()->input->get('message',null);
 			$email = JFactory::getApplication()->input->get('friendEmail',null,'RAW');
 			$currentURL = urldecode(JFactory::getApplication()->input->get('currentURL',null,'RAW'));
 			$adID = JFactory::getApplication()->input->get('adID',null);

 			//Send an email using email templates 
			$adDetails = AdService::getAdDetails($adID);
			$result = EmailService::sendEmailToFriend($adDetails ,$currentURL, $email, $message);

			//Check if the email was sent
 		 	if($result)
 		 		return JText::_("LNG_EMAIL_SENT");
 		 	else
 		 		return JText::_("LNG_ERROR_SENDING_EMAIL");
 	}
 	
 	
 	function sendAbuseEmail(){

 			$applicationSettings = JAdsUtil::getApplicationSettings();
 			$message = JFactory::getApplication()->input->get('abuseMessage',null);
 			$email = JFactory::getApplication()->input->get('reporterEmail',null);
 			$currentURL = urldecode(JFactory::getApplication()->input->get('currentURL',null,'RAW'));
 			$adID = JFactory::getApplication()->input->get('adID',null);
 			
 			//Send an email using email templates 
			$adDetails = AdService::getAdDetails($adID);
 			$result = EmailService::sendAbuseEmail($adDetails ,$currentURL, $email, $message);
			
			//Check if the email was sent
 			if($result)
 				return JText::_("LNG_EMAIL_SENT");
 			else 
 				return JText::_("LNG_ERROR_SENDING_EMAIL");

 	}


 	function contactSeller(){

 			$applicationSettings = JAdsUtil::getApplicationSettings();
 			$message = JFactory::getApplication()->input->get('selleremailMessage',null);
 			$name = JFactory::getApplication()->input->get('name',null);
 			$youremail = JFactory::getApplication()->input->get('youremail',null);
 			$currentURL = urldecode(JFactory::getApplication()->input->get('currentURL',null,'RAW'));
 			$adID = JFactory::getApplication()->input->get('adID',null);
 			
 			//Send an email using email templates 
			$adDetails = AdService::getAdDetails($adID);
 			$result = EmailService::contactSeller($adDetails,$currentURL ,$youremail,$name, $message);
 			
 			//Check if the email was sent							
 			if($result)
 				return JText::_("LNG_EMAIL_SENT");
 			else
 				return JText::_("LNG_ERROR_SENDING_EMAIL");
 	}

 	function getGalleryAds(){
 		$adTable =$this->getTable('manageads');
 		$stateId = JFactory::getApplication()->input->get('stateId',null);
 		$ads = $adTable->getGalleryAds($stateId);
 		return $ads;
 	}
 	
 	function setViewCounter($ads){
 		$adTable =$this->getTable('manageads');
 		$arrayIds = array();
 		foreach($ads as $ad){
 		 array_push($arrayIds, $ad->id);
 		}
 		$adIds = implode(",", $arrayIds);
 		if(strlen($adIds)>0){
 		if(!$adTable->setViewCounter($adIds)) 
 			return false;
 		else 
 			return true;
 		}
 		return false;
 	}
 	



 	function addBookmark($data){
		//get the bookmark table
		$row = $this->getTable("bookmark");
		
		// Bind the form fields to the table
		if (!$row->bind($data))
		{
			$this->setError($row->getError());
			return false;
		}
		// Make sure the record is valid
		if (!$row->check()) {
			$this->setError($row->getError());
			return false;
		}
		// Store to the database
		if (!$row->store()) {
			$this->setError( $row->getError() );
			return false;
		}
		
		return true;
	}
	
	function updateBookmark($data){
		//get the bookmark table
		$row = $this->getTable("bookmark");
	
		// Bind the form fields to the table
		if (!$row->bind($data))
		{
			$this->setError($row->getError());
			return false;
		}
		// Make sure the record is valid
		if (!$row->check()) {
			$this->setError($row->getError());
			return false;
		}
	
		// Store to the database
		if (!$row->store()) {
			$this->setError( $row->getError() );
			return false;
		}
	
		return true;
	}
	
	function removeBookmark($data){
		$row = $this->getTable("bookmark");
		return $row->delete($data["id"]);
	}


}


