<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');

class JClassifiedsManagerModelDisplayAds extends JModelList
{
	function __construct()
	{
		parent::__construct();
		$mainframe = JFactory::getApplication();
		
		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = JFactory::getApplication()->input->getInt('limitstart', 0, '', 'int');
		
		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$this->total = 0;
	
	}
	
	function getPagination()
	{
		// Load the content if it doesn't already exist
		if (empty($this->_pagination)) {
			jimport('joomla.html.pagination');
				
			$this->_pagination = new JPagination($this->total, $this->getState('limitstart'), $this->getState('limit') );
			$this->_pagination->setAdditionalUrlParam('option','com_jclassifiedsmanager');
			$this->_pagination->setAdditionalUrlParam('controller','displayads');
			$this->_pagination->setAdditionalUrlParam('priceLow','');
			$this->_pagination->setAdditionalUrlParam('priceHigh','');
			$this->_pagination->setAdditionalUrlParam('task','displayads.searchAds');
			$this->_pagination->setAdditionalUrlParam('layout',JFactory::getApplication()->input->get('layout','requesting'));
			$this->_pagination->setAdditionalUrlParam('adType',JFactory::getApplication()->input->get('adType',1));
			$this->_pagination->setAdditionalUrlParam('view','displayads');
		}
		return $this->_pagination;
	}
	
	
	function getParentCategories()
	{
		// Load the data
		$row = $this->getTable('categories');
		$categories = $row->getParentCategoriesWithCount();
		return $categories;
	}
	function getSelectedCategory()
	{
		// Load the data
		$row = $this->getTable('categories');
		$categoryId = JFactory::getApplication()->input->get('categoryId',0);
		$row->load($categoryId);
		return $row->name;
	}
	
	
	function getAllAds(){
		$row = $this->getTable('manageads');
		$ads = $row->getAllAds();
		$this->total = count($ads);
		return $ads;
		
	}
	function getAllAdTypes(){
		// Load the data
		$row = $this->getTable('manageadtypes');
		$categories = $row->getAllAdTypes();
		return $categories;
	}
	function getAdType(){
		// Load the data
		$row = $this->getTable('manageadtypes');
		$adTypeId = JFactory::getApplication()->input->get('adtype',1);
		$adType = $row->getAdType($adTypeId);
		return $adType;
	}
	
	
	function getAllCurrencies(){
		// Load the data
		$row = $this->getTable('currencies');
		$currencies = $row->getAllCurrencies();
		return $currencies;
	}

	function getAllUserTypes(){
		// Load the data
		$row = $this->getTable('manageusertypes');
		$userTypes = $row->getAllUserTypes();
		return $userTypes;
	}
	function getJSONSubCategories(){
		$categoryId = JFactory::getApplication()->input->get('category_id');
		if(isset($categoryId)){
			$row = $this->getTable('categories');
			$categories = $row->getSubCategories($categoryId);
			return json_encode($categories);
		}
		return null;
	}
	
	#get category attributes function 
	function getCategoryAttributes(){
		$categoryId = JFactory::getApplication()->input->get('categoryId');
		$categorySearch = JFactory::getApplication()->input->get('categorySearch',null);
		$categoryId = empty($categoryId)?$categorySearch:$categoryId;
		
		if(isset($categoryId) && $categoryId!=''){
			$row =$this->getTable('categoryattributes');
			$categoryAttributes = $row->getCategoryAttributes($categoryId);
			$content = $this->renderFilterAttributes($categoryAttributes);
			return $content;
		}
		return "";
	}
	function renderFilterAttributes($categoryAttributes)
	{
		$selectedAttributes = JFactory::getApplication()->input->get('attributeOptions');
		include 'components/com_jclassifiedsmanager/classes/attributeRenderer.php';
		$attributeRenderer= new attributeRenderer();
		$content = $attributeRenderer->renderFilterAttributes($categoryAttributes,$selectedAttributes);
		return $content;
	}
	function renderFilteredGalleryAds(){
		$stateId = JFactory::getApplication()->input->get('stateId',0);
		$content = "";
		$row =$this->getTable('manageads');
		$ads = $row->getGalleryAds($stateId);
		if(count($ads)>0)
			$content = $this->renderGalleryAdsContent($ads);
		else 
			$content = JText::_("LNG_ADS_NOT_FOUND");
		return $content;
	}
	
	function renderGalleryAdsContent($ads){
	
		$content ='';

		foreach ($ads as $ad){
			if(strlen($ad->picture_id)==0)
				$ad->picture_id = "no_image.jpg";
			$content .= "<div id='classifiedsGallery' class='span3'>";
            $content .= "<div class='promoted-classified'>".JText::_("LNG_PROMOTED")."</div>";
			$content .= "<a href='".JAdsUtil::getAdLink($ad->id, $ad->alias)."' title='".JText::_('LNG_CLICK_TO_VIEW')."'>
					 <div class='photo sample8'><span></span><a href='".JAdsUtil::getAdLink($ad->id, $ad->alias)."' rel='".JURI::root()."components/com_jclassifiedsmanager/imageupload/uploaded_images/med_".$ad->picture_id."' class='zoomple'><img src='".JURI::root()."components/com_jclassifiedsmanager/imageupload/uploaded_images/med_".$ad->picture_id."'></a></div>";
			$content .= "<div id='galleryAdDesc'> ".substr($ad->title,0,100)."</div> <div id='galleryAdPrice'>".JAdsUtil::getPriceFormat($ad->price)." ".$ad->currency."</div>";
			$content .= "</a></div>";
		}
		return $content;
	}
	 
	
	function getDefaultCurrency(){
		$currencyTable =$this->getTable('currencies');
		$currency = $currencyTable->getDefaultCurrency();
		return $currency;
	}
	
	function renderFilteredAds()
	{
		$filterParams =  array();
		$filterParams['attrOptions'] = JFactory::getApplication()->input->get('attributeOptions',0);
		$filterParams['adType'] = JFactory::getApplication()->input->get('adType',0);
		$filterParams['priceLow'] = JFactory::getApplication()->input->get('priceLow',null);
		$filterParams['priceHigh'] = JFactory::getApplication()->input->get('priceHigh',null);
		$filterParams['userDefinedPrices'] = JFactory::getApplication()->input->get('userDefinedPrices',0);
		$filterParams['stateId'] = JFactory::getApplication()->input->get('state',null);
		$filterParams['categoryId']= JFactory::getApplication()->input->get('categoryId',null);
		$filterParams['categorySearch']= $categorySearch = JFactory::getApplication()->input->get('categorySearch',null);
		$filterParams['categoryId']= empty($filterParams['categoryId'])?$categorySearch:$filterParams['categoryId'];
		$filterParams['searchKeyword']= JFactory::getApplication()->input->get('searchKeyword',null);
		$filterParams['limit']= $this->getState('limit');
		$filterParams['limitStart']= intVal($this->getState('limitstart'));
		$filterParams['sortBy']= JFactory::getApplication()->input->getString('sortAdsBy',null);
		$filterParams['sliderAttributes']= $this->processSliderAttributes(JFactory::getApplication()->input->get('sliderAttributes',null));
		$filterParams['userTypeId']= JFactory::getApplication()->input->get('user_type_id',null);
		$filterParams['categoryLevel'] = 1;

		$filterParams['citySearch'] = JFactory::getApplication()->input->get('citySearch',null);
		$filterParams['zipcode'] = JFactory::getApplication()->input->get('zipcode',null);
		$filterParams['geo-loc-radius'] = JFactory::getApplication()->input->get('geo-loc-radius',0);
		$filterParams['regionSearch'] = JFactory::getApplication()->input->get('regionSearch',null);

		//menu item ad types
		$filterParams['adscategories'] = JFactory::getApplication()->input->get('adscategories',null);
		$filterParams['adscities'] = JFactory::getApplication()->input->get('adscities',null);
		$filterParams['adsstates'] = JFactory::getApplication()->input->get('adsstates',null);

		$session = JFactory::getSession();

		if(isset($filterParams['searchKeyword'])){
			$session->set('searchKeyword', $filterParams['searchKeyword']);
		}

		if(isset($filterParams['adType'])){
			$session->set('adType', $filterParams['adType']);
		}

		if(isset($filterParams['categorySearch'])){
			$session->set('categorySearch', $filterParams['categorySearch']);
		}

		if(isset($filterParams['citySearch'])){
			$session->set('citySearch', $filterParams['citySearch']);
		}

		if(isset($filterParams['zipcode'])){
			$session->set('zipcode', $filterParams['zipcode']);
		}

		if(isset($filterParams['geo-loc-radius'])){
			$session->set('geo-loc-radius', $filterParams['geo-loc-radius']);
		}

		if(isset($filterParams['regionSearch'])){
			$session->set('regionSearch', $filterParams['regionSearch']);
		}
		
		$catTable =$this->getTable('categories');
		if(!empty($filterParams['categoryId']))
			$filterParams['categoryLevel'] = $catTable->getCategoryLevel($filterParams['categoryId']);



		$this->location = null;
		if(isset($filterParams['zipcode']) && $filterParams['zipcode']!=""){

			$this->location = JAdsUtil::getCoordinates($filterParams['zipcode']);
			$filterParams["latitude"] = $this->location["latitude"];
			$filterParams["longitude"] = $this->location["longitude"];
			$session->set('latitude', $filterParams['latitude']);
			$session->set('longitude', $filterParams['longitude']);
		}


		//Get the geo location coordinates 
		$geolocation = JFactory::getApplication()->input->get('geolocation',null);
		if(empty($geolocation))
			$session->set("geolocation",$geolocation);
		elseif(isset($geolocation) && $geolocation!=0 ){
			$session->set("geolocation",$geolocation);
			$filterParams['latitude'] = JFactory::getApplication()->input->get('geo-latitude',null);
			$filterParams['longitude'] = JFactory::getApplication()->input->get('geo-longitude',null);
			$session->set('latitude', $filterParams['latitude']);
			$session->set('longitude', $filterParams['longitude']);
		}


		
		$adsTable =$this->getTable('manageads');
		$ads = $adsTable->searchAds($filterParams);
			  
		$content = JText::_("LNG_SEARCH_CRITERIA_NOT_FOUND");
		if(count($ads['records'])>0){
			$content = $this->renderAdsContentDiv($ads['records']);
			if($filterParams['userDefinedPrices']=="1"){//keep user set min,max
				$content['min'] = JFactory::getApplication()->input->get('priceLow',null);
				$content['max'] = JFactory::getApplication()->input->get('priceHigh',null);
			}
			$content['maximumSliderValue'] = $adsTable->getMaxiumPricePerAdType($filterParams);
			$content['total'] =$ads['total'];
			
		}
		else{ 
			$dataEmpty = array();
			$dataEmpty['content'] = JText::_("LNG_SEARCH_CRITERIA_NOT_FOUND");
			$dataEmpty['total'] = 0;
			$dataEmpty['min'] =50;
			$dataEmpty['max'] =1000;
			$dataEmpty['maximumSliderValue'] =1000;
			$content = $dataEmpty;
		}		
		$this->total = $content['total'];
		$content['adsformap']= $ads['records'];

		return $content;
	}



	function getLocation(){
		return $this->location;
	}

	function processSliderAttributes($attributes){
		$processedArray = array();
		if(!empty($attributes) && strlen($attributes)>0){
			$attributesArray = explode(",",$attributes);
			foreach($attributesArray as $key=>$attrib) {
				$processedArray[$key] = explode("|",$attrib);
			}
		}
		return $processedArray;
	}
	
	function renderAdsContent($ads){
		$minimum = $maximum = $ads[0]->price;
		$sortBy = JFactory::getApplication()->input->getString('sortAdsBy',null);
		
		$data = array();
		$content = '<table class="adsTable">';
		$content .= '<tr><td colspan="6" align="right">'.JText::_("LNG_SORT_BY").' <select onChange="sortAds(this.value)" id="sortAdsBy" name="sortAdsBy"><option value="creation_date desc" '. ($sortBy=="creation_date desc"?'selected':'').' >'. JText::_("LNG_NEWEST_ADS").'</option><option value="price asc" '.($sortBy=="price asc"?'selected':'').'>'. JText::_("LNG_CHEAPEST_ADS").'</option><option value="price desc" '.($sortBy=="price desc"?'selected':'').'>'. JText::_("LNG_PRICIER_ADS").'</option><select></td></tr>';
		
		foreach ($ads as $key=>$ad){
			if(count($ad->picture_id)==0)
				$ad->picture_id = "no_image.jpg";
				
			$content .= "<tr>";
			$content .= "<td><a href='".JAdsUtil::getAdLink($ad->id, $ad->alias)."' title='".JText::_('LNG_CLICK_TO_VIEW')."'><div class='photo sample8'><span></span><img width='110px' height='100px' src='".JURI::root()."components/com_jclassifiedsmanager/imageupload/uploaded_images/med_".$ad->picture_id."'></div></a></td>";
			$content .= "<td colspan='2'><a href='".JAdsUtil::getAdLink($ad->id, $ad->alias)."' title='".JText::_('LNG_CLICK_TO_VIEW')."'><B>".$ad->title."</B></a>";
			$content .= " <br/> ".substr($ad->description, 0,75)."... <br/> <br/>".JText::_('LNG_CATEGORY').": <b>".$ad->category."</b>&nbsp;".JText::_('LNG_POSTED').": <b>".JAdsUtil::getDateADFormat($ad->creation_date)."</b></td>"; 
			$content .= "<td><i>".$ad->price." ".$ad->currency."</i></td>";
			$content .= "<td>".$ad->city."</td>";
			$content .= "</tr>";
			 
			if ($minimum > $ad->price) {
				$minimum =  $ad->price;
			}
			if ($maximum < $ad->price) {
				$maximum = $ad->price;
			}
		}
		$content .= "</table>";
		$data['content'] =$content;
		$data['min'] =$minimum;
		$data['max'] =$maximum;

		return $data;
	}
	
	
	function renderAdsContentDiv($ads){
		$minimum = $maximum = $ads[0]->price;
		$sortBy = JFactory::getApplication()->input->get('sortAdsBy',null);
		$content = "";
		$data = array();
	
		$content .= '<div class="ad-ordering"> 	
			<div class="ads-order">'
				.JText::_("LNG_SORT_BY").': <select onChange="sortAds(this.value)" id="sortAdsBy" name="sortAdsBy"><option value="creation_date desc" '. ($sortBy=="creation_date desc"?'selected':'').' >'. JText::_("LNG_NEWEST_ADS").'</option><option value="price asc" '.($sortBy=="price asc"?'selected':'').'>'. JText::_("LNG_CHEAPEST_ADS").'</option><option value="price desc" '.($sortBy=="price desc"?'selected':'').'>'. JText::_("LNG_PRICIER_ADS").'</option><select>
			</div>
			<div class="search-toggles">					
				<p class="view-mode">
					<label>'.JText::_("LNG_VIEW").'</label> <a id="grid-view-link" class="grid" title="Grid" href="javascript:showGrid()"></a>
					<a id="list-view-link" class="list active" title="List" href="javascript:showList()"></a>
					<p class="view-mode"><a id="map-link" class="map" title="Map" href="javascript:showMap(true)">'.JText::_("LNG_SHOW_MAP").'</a></p>
				</p>
			</div>
			
		</div>'
			
		.'<div id ="ads-list-view">
		';
		
		$ad_order = 1;
		foreach ($ads as $key=>$ad){
			
			if(strlen($ad->picture_id)==0){
                $ad->picture_id = "no_image.jpg";
            }

			$title = $ad->title;
			if(empty($title) && !empty($ad->description)){
				$title = substr($ad->description, 0,strpos($ad->description,","));
				if(empty($title))
					$title = substr($ad->description, 0,strpos($ad->description,"."));
				if(empty($title))
					$title = $ad->description;
				if(strlen($title)>55){
					$title = substr($title,0,55);
				}
			}
			$printClass= $ad->paidAd==1?"printed":"";

			if(!file_exists(JPATH_COMPONENT."/imageupload/uploaded_images/med_".$ad->picture_id))
				$ad->picture_id = "no_image.jpg";
			
			$content .= " <div class='classifieds-container $printClass' >";
			$content .= "<div class='ad-photo'><a href='".JAdsUtil::getAdLink($ad->id, $ad->alias)."' title='".JText::_('LNG_CLICK_TO_VIEW')."'><div class='photo sample8'><span></span><img src='".JURI::root()."components/".getAdComponentName()."/imageupload/uploaded_images/med_".$ad->picture_id."'></div></a></div>";
			$content .= "<div class='classified-content'>";
            if($ad->featured==1){
                $content .= "<div class='featured-classified'>".JText::_("LNG_FEATURED_AD")."</div>";
            }else if ($ad->paidAd==1){
                $content .= "<div class='printed-ad'>".JText::_("LNG_PRINTED_AD")."</div>";
            }
			$content .= "<div class='classifieds-title-container'>";
            $content .= "<div class='classifieds-title'><a href='".JAdsUtil::getAdLink($ad->id, $ad->alias)."' title='".JText::_('LNG_CLICK_TO_VIEW')."'><B>".$ad_order.". ".$title."</B></a></div>";
			$content .= "<div class='classifieds-price'>".(!empty($ad->price)?$ad->currency." ".JAdsUtil::getPriceFormat($ad->price):0)."</div>";
			$content .= "</div>";
			$content .= "<div class='classifieds-description-list'>". ( strlen($ad->description)>400?JAdsUtil::truncate($ad->description,400):$ad->description)."</div>";
			$content .= "<div class='classifieds-details'>";
			$content .= "<div class='classifieds-date info-item'><icon class='la la-calendar'></icon> ".JAdsUtil::convertTimestampToAgo($ad->creation_date)."</div>";
			$content .= !empty($ad->view_count)?"<div class='classifieds-adviews info-item'><icon class='la la-eye'></icon> ".$ad->view_count."</div>":"";
			$content .= "<div class='classifieds-category info-item'><icon class='la la-folder-open'></icon> ".$ad->category."</div>";
			$content .= "<div class='classifieds-city info-item'><icon class='fa fa-map-marker'></icon> ".$ad->city."</div>";
			$content .= "</div>";

			$content .= "</div>";
			$content .= "</div>";
				
			if ($minimum > $ad->price) {
				$minimum =  $ad->price;
			}
			if ($maximum < $ad->price) {
				$maximum = $ad->price;
			}

			$ad_order++;
			
		}

		$content .= "</div>";

		$content .="<div id='layout' class='pagewidth  grid4 grid-view-1' style='display: none'>";
		$content .="<div id='grid-content'>";
		$content .="<div id='loops-wrapper' class='loops-wrapper infinite-scrolling AutoWidthElement'> ";

		$ad_order_grid = 1;
		foreach ($ads as $key=>$ad){
			if(strlen($ad->picture_id)==0)
				$ad->picture_id = "no_image.jpg";
	
			$title = $ad->title;
			if(empty($title) && !empty($ad->description)){
				$title = substr($ad->description, 0,strpos($ad->description,","));
				if(empty($title))
					$title = substr($ad->description, 0,strpos($ad->description,"."));
				if(empty($title))
					$title = $ad->description;
				if(strlen($title)>55){
					$title = substr($title,0,55);
				}
			}
			$printClass= $ad->paidAd==1?"printed":"";
			
			
			if(!file_exists(JPATH_COMPONENT."/imageupload/uploaded_images/med_".$ad->picture_id))
				$ad->picture_id = "no_image.jpg";
			
			$content .= "<article id='post-' class='post post type-post status-publish format-standard hentry category-food post clearfix '> <div class='post-inner'>";
			$content .= "<div class='slider'>";
			$content .="<div class='slider-item'>";
			$content .="<div class='slider-content' style=''>";
			$content .="<figure class='post-image'><a href='".JAdsUtil::getAdLink($ad->id, $ad->alias)."' title='".JText::_('LNG_CLICK_TO_VIEW')."'><img src='".JURI::root()."components/".getAdComponentName()."/imageupload/uploaded_images/med_".$ad->picture_id."'></a></figure>";
			$content .="<div class='info' onclick='document.location.href='".JAdsUtil::getAdLink($ad->id, $ad->alias)."''>";
			$content .="<div class='hover_info'>";
			$content .="". ( strlen($ad->description)>300?JAdsUtil::truncate($ad->description,300):$ad->description)."";
			$content .="</div> </div></div></div></div>";
			$content .= "<div class='post-content'>";
			$content .= "<h1 class='post-title'><a href='".JAdsUtil::getAdLink($ad->id, $ad->alias)."' title='".JText::_('LNG_CLICK_TO_VIEW')."'>".$ad_order_grid.". ".$title."</a></h1>";
			
			$content .= "<div class='classifieds-details'>";
			$content .= "<div class='post-category'><icon class='fa fa-folder-open'></icon> ".$ad->category."	</div> ";
			$content .= "<div class='classifieds-date'><icon class='fa fa-calendar'></icon> ".JAdsUtil::getDateADFormat($ad->creation_date)."</div>";
			$content .= "<div class='classifieds-city'><icon class='fa fa-map-marker'> ".$ad->city.", ".$ad->state."</div>";
			$content .= "</div>";
			$adPrice = $ad->currency." ".(!empty($ad->price)?JAdsUtil::getPriceFormat($ad->price):"0");
			$content .= "<hr><div class='classifieds-price'>".$adPrice."</div>";
			
			
			$content .= "</div>";
			$content .= "<div class='clear'></div>";
			if($ad->featured==1){
				$content .= "<div class='featured-classified'>".JText::_("LNG_FEATURED_AD")."</div>";
			}else if ($ad->paidAd==1){
				$content .= "<div class='printed-ad'>".JText::_("LNG_PRINTED_AD")."</div>";
			}
			$content .= "<div class='clear'></div>";
			$content .= "</div></article>";
				
			if ($minimum > $ad->price) {
				$minimum =  $ad->price;
			}
			if ($maximum < $ad->price) {
				$maximum = $ad->price;
			}
			
			$ad_order_grid ++;
		
		}
		
		$content .= "</div></div></div>";
		
		if(count($ads)==0){
			$content = JText::_("LNG_ADS_NOT_FOUND");
		}	
		$data['content'] = $content;
		$data['min'] =$minimum;
		$data['max'] =$maximum;
		
		return $data;
	}
	
	function renderFilteredCategories()
	{
		$filterParams['attrOptions'] = JFactory::getApplication()->input->get('attributeOptions',0);
		$filterParams['adType'] = JFactory::getApplication()->input->get('adType',0);
		$filterParams['priceLow'] = JFactory::getApplication()->input->get('priceLow',null);
		$filterParams['priceHigh'] = JFactory::getApplication()->input->get('priceHigh',null);
		$filterParams['stateId'] = JFactory::getApplication()->input->get('stateId',null);
		$categoryId  = JFactory::getApplication()->input->get('categoryId',null);
		$categorySearch = JFactory::getApplication()->input->get('categorySearch',null);
		$filterParams['categoryId']= empty($categoryId)?$categorySearch:$categoryId;
		$filterParams['searchKeyword']= JFactory::getApplication()->input->get('searchKeyword',null);
		$filterParams['limit']= JFactory::getApplication()->input->get('limit',null);
		$filterParams['limitStart']= JFactory::getApplication()->input->get('limitstart',null);
		$filterParams['citySearch'] = JFactory::getApplication()->input->get('citySearch',null);
		$filterParams['userDefinedPrices']= JFactory::getApplication()->input->get('userDefinedPrices',-1);
				
		$adsTable =$this->getTable('manageads');
		$categories = $adsTable->getSearchCategories($filterParams);
		$content = JText::_("LNG_NO_CATEGORIES_FOUND");
		//print_r($categories);
		if(count($categories)>0)
			$content = $this->renderCategoryContent($categories,$filterParams['categoryId']);
		return $content;
	}




	function renderCategoryContent($categories,$selectedCategory){
	
		$content ='<div class="search-category-box">';
		$content .='<ul id="filterCategoryUl">';
		$prevMainCategory = "";
		$prevSubCategory = "";
		$prevSubCategory2 = "";
		$index = 0; 
		foreach ($categories as $filterCategory){
			$class="";
			$hasLeafs=false;
			$expandContent = "<div class='frontSpacer'></div>";
						
			if($prevMainCategory!=$filterCategory->main_category_id){	
				if($filterCategory->main_category_id == $selectedCategory)
					$class='class="selectedlink"';
				if(isset($categories[$index+1]) && $categories[$index+1]->main_category_id==$filterCategory->main_category_id)
					$hasLeafs=true;
				
				if($hasLeafs==true)
					$expandContent ='<a href="javascript:void(0)" onclick="displaySubCat(\'cat'.$filterCategory->main_category_id.'\',1); "><i id="categoryExpand" class="fa fa-angle-right"></i></a>';
				

				if($filterCategory->countCat!=0){
					$content .='<li id="cat'.$filterCategory->main_category_id.'" onclick="removeSelectedCategory();this.addClass(\'selectedlink\');" '.$class.'>'.$expandContent;
					$content .='<a class="categoryLabel" href="javascript:void(0)" onclick="getCategoryAttributes('.$filterCategory->main_category_id.'); "><div class="catFilterLabel">'.$filterCategory->catname.' ('.$filterCategory->countCat.')</div></a>';
				}
				$content .='<div style="clear:both;"></div>';
				$content .='</li>';
				$prevMainCategory = $filterCategory->main_category_id;
			}
			else if ($prevSubCategory!=$filterCategory->firstSub){
				$class='class="firstSub"';
				if(isset($categories[$index+1]) && $categories[$index+1]->firstSub==$filterCategory->firstSub)
					$hasLeafs=true;
				
				if($hasLeafs==true)
					$expandContent ='<a href="javascript:void(0)" onclick="displaySubCat(\'cat'.$filterCategory->subCategoryId.'\',2); "><i id="categoryExpand" class="fa fa-angle-right"></i></a>';
				
				if($filterCategory->subCategoryId == $selectedCategory)
					$class='class="selectedlink firstSub"';
				if($filterCategory->countCat!=0){
					$content .='<li id="cat'.$filterCategory->main_category_id.'_'.$filterCategory->subCategoryId.'" onclick="removeSelectedCategory();this.addClass(\'selectedlink\');" '.$class.'>'.$expandContent;
					$content .='<a href="javascript:void(0)" onclick="getCategoryAttributes('.$filterCategory->subCategoryId.'); "><div class="catFilterLabel">'.$filterCategory->firstSub.' ('.$filterCategory->countCat.')</div></a>';
				}
				$content .='<div style="clear:both;"></div>';
				$content .='</li>';
				$prevSubCategory = $filterCategory->firstSub;
			}
			else if($prevSubCategory2!=$filterCategory->secondSub){
				$class='class="secondSub"';
				if($filterCategory->secondSubId == $selectedCategory)
					$class='class="selectedlink secondSub"';
				$content .='<li id="cat'.$filterCategory->main_category_id.'_'.$filterCategory->subCategoryId.'_'.$filterCategory->secondSubId.'" onclick="removeSelectedCategory();this.addClass(\'selectedlink\');" '.$class.'>';
				$content .='<a href="javascript:void(0)" onclick="getCategoryAttributes('.$filterCategory->secondSubId.'); "><div class="catFilterLabel">'.$filterCategory->secondSub.' ('.$filterCategory->countCat.')</div></a>';
				$content .='<div style="clear:both;"></div>';
				$content .='</li>';
				$prevSubCategory2 = $filterCategory->secondSub;
			}
			$index++;
		}
		$content .=  '</ul>';
		$content .=  '</div>';
		
		return $content;
	}
  

 	
 	function getAllUserAds(){
 		$adTable =$this->getTable('manageads');
 		$userId = JFactory::getUser()->id;
 		$applicationSettings = JAdsUtil::getApplicationSettings();
 		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;
 		$adDetails = $adTable->getAllUserAds($userId,$validPeriod);
 		return $adDetails;
 	}


 	

 	function getGalleryAds(){
 		$adTable =$this->getTable('manageads');
 		$stateId = JFactory::getApplication()->input->get('stateId',null);
 		$ads = $adTable->getGalleryAds($stateId);
 		return $ads;
 	}
 	
 	function setViewCounter($ads){
 		$adTable =$this->getTable('manageads');
 		$arrayIds = array();
 		foreach($ads as $ad){
 		 array_push($arrayIds, $ad->id);
 		}
 		$adIds = implode(",", $arrayIds);
 		if(strlen($adIds)>0){
 		if(!$adTable->setViewCounter($adIds)) 
 			return false;
 		else 
 			return true;
 		}
 		return false;
 	}
 	
 	function getCategoriesForSelection(){
 		$cats = array();
 		$categoryId  = JFactory::getApplication()->input->get('categoryId',null);
 		$categorySearch = JFactory::getApplication()->input->get('categorySearch',null);
 		$selectedCategory = empty($categoryId)?$categorySearch:$categoryId;
 		if(isset($selectedCategory) && $selectedCategory>0){
	 		$catTable =$this->getTable('categories');
	 		$level = $catTable->getCategoryLevel($selectedCategory);
	 		if($level>1){
	 			$obj = new stdClass();
	 			$parentCategoryId = $catTable->getParentCategory($selectedCategory);
	 			$parentLevel = $catTable->getCategoryLevel($parentCategoryId);
	 			$obj->level = $parentLevel;
	 			$obj->category = $parentCategoryId;
	 			array_push($cats,$obj);
	 			if($parentLevel>1){
	 				$obj = new stdClass();
	 				$rootCategoryId = $catTable->getParentCategory($parentCategoryId);
	 				$parentLevel = $catTable->getCategoryLevel($rootCategoryId);
	 				$obj->level = $parentLevel;
	 				$obj->category = $rootCategoryId;
	 				array_push($cats,$obj);
	 			}
	 		}
 		}
 		return $cats;
 	}


 	function getAllUserBookmarks(){
 		//Get the bookmarks of the logged in user 
 		$bookmarkTable =$this->getTable('bookmark');
 		$userId = JFactory::getUser()->id;
 		$bookmarks = $bookmarkTable->getAllUserBookmarks($userId);
 		return $bookmarks;
 	}


 	function getUserAdsViews()
	{
		//Get the ad views of the logged in user 
 		$adsTable =$this->getTable('manageads');
 		$userId = JFactory::getUser()->id;
 		$adviews = $adsTable->getUserAdsViews($userId);
 		return $adviews;
	}

	function getUserAdsCount()
	{
		//Get total ads number of the logged in user 
 		$adsTable =$this->getTable('manageads');
 		$userId = JFactory::getUser()->id;
 		$adcount = $adsTable->getUserAdsCount($userId);
 		return $adcount;
	}

	function getUserBookmarkCount()
	{
		//Get total ads number of the logged in user 
 		$adsTable =$this->getTable('manageads');
 		$userId = JFactory::getUser()->id;
 		$adcount = $adsTable->getUserBookmarkCount($userId);
 		return $adcount;
	}


 	


}


