<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');
jimport('joomla.application.component.modeladmin');
require_once( JPATH_COMPONENT_SITE.'/models/promotead.php' );
use Joomla\String\StringHelper;

class JClassifiedsManagerModelEditAd extends JModelAdmin
{

		/**
	 * Returns a Table object, always creating it
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  Table	A database object
	*/
	public function getTable($type = 'ManageAds', $prefix = 'Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the menu item form.
	 *
	 * @param   array  $data		Data for the form.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		//exit;
		// The folder and element vars are passed when saving the form.
		if (empty($data))
		{
			$item= $this->getItem();
			// The type should already be set.
		}
		// Get the form.
		$form = $this->loadForm('com_jclassifiedsmanager.managead', 'item', array('control' => 'jform', 'load_data' => $loadData), true);
		if (empty($form))
		{
			return false;
		}
		
		return $form;
	}
	

	function __construct()
	{
		parent::__construct();
		$this->log = Logger::getInstance();
	}
	function getParentCategories()
	{
		// Load the data
		$row = $this->getTable('categories');
		$categories = $row->getParentCategories();

		return $categories;
	}
	function getAllAdTypes(){
		// Load the data
		$row = $this->getTable('manageadtypes');
		$categories = $row->getAllAdTypes();
		return $categories;
	}
	
	
	function getAllCurrencies(){
		// Load the data
		$row = $this->getTable('currencies');
		$currencies = $row->getAllCurrencies();
		return $currencies;
	}
	
	function getAllUserTypes(){
		// Load the data
		$row = $this->getTable('manageusertypes');
		$userTypes = $row->getAllUserTypes();
		return $userTypes;
	}
	function getJSONSubCategories(){
		$categoryId = JFactory::getApplication()->input->get('category_id');
		if(isset($categoryId)){
			$row = $this->getTable('categories');
			$categories = $row->getSubCategories($categoryId);
			return json_encode($categories);
		}
		return null;
	}
	function checkUserAd($userId){
		$adId = JFactory::getApplication()->input->get("ad_id",0);
		$adTable =$this->getTable('manageads');
		$ads =$adTable->checkAdOwner($userId,$adId);
		if(count((array)$ads)>0)
			return true;
		else 
			return false;
	}
	function uploadFiles(){
		
		include("components/com_jclassifiedsmanager/imageupload/includes/settings.php");
		include("components/com_jclassifiedsmanager/imageupload/includes/class_CRW.php");
		
		$uploaddir ="components/com_jclassifiedsmanager/imageupload/".$uploaddir;
		$uploadedFile = $uploaddir . basename($_FILES['uploadfile']['name']);
		$file_name=basename( $_FILES['uploadfile']['name']) ;
		$extension = substr($file_name, strrpos($file_name, "."));
		$extension = strtolower($extension);
		
		$resizer=new CRW();
		$new_name=$resizer->new_name();
		
		if (move_uploaded_file($_FILES['uploadfile']['tmp_name'], $uploadedFile)) {
		
			rename($uploadedFile, $uploaddir.$originalImagePrefix.$new_name.$extension);
			 
		
			foreach($formatsImages as $format)
			{
				$formatSplit=explode(',', $format);
				$prefix=$formatSplit[0];
				$newWidth=$formatSplit[1];
				$newHeight=$formatSplit[2];
				 
				if($action=="crop")
				{
					$resizer->cropImage($uploaddir, $originalImagePrefix.$new_name.$extension, $newWidth, $newHeight, $prefix,$new_name);
				}
				elseif($action=="resize"){
		
					$resizer->image_resize($uploaddir, $originalImagePrefix.$new_name.$extension, $newWidth,  $prefix, $new_name);
					 
				}
		
				/*++++++++++WATERMARK++++++++++++*/
				if ($watermarkIsActive == 1 && $newWidth>$minImageWidthForWatermark) {
					$resizer->watermarkImage($uploaddir .$prefix . $new_name . $extension, $watermarkImage, $watermarkPosition);
					 
				}
				/*+++++++++++WATERMARK++++++++++++++*/
		
		
			}
		
			echo $new_name.$extension;//output new image name
		} else {
			echo "error";
		}
	}
	
	#get category attributes function 
	function getAjaxCategoryAttributes(){
		$categoryId = JFactory::getApplication()->input->get('category_id');
		if(isset($categoryId)){
			$row =$this->getTable('categoryattributes');
			$categoryAttributes = $row->getCategoryAttributes($categoryId);
			return $categoryAttributes;
		}
		return "";
	}
	
	function renderCategoryAttributes($categoryAttributes,$adAttributes)
	{
		include 'components/com_jclassifiedsmanager/classes/attributeRenderer.php';
		$attributeRenderer= new attributeRenderer();
		$content = $attributeRenderer->renderAttributes($categoryAttributes,$adAttributes);
		return $content;
	}
	


	/**
	 * Check for duplicate alias and generate a new alias
	 * @param unknown_type $alias
	 * @param unknown_type $adId
	 */

	function checkAlias($adId, $alias){
	  $adsTable = $this->getTable('manageads');
	  while($adsTable->checkIfAliasExists($adId, $alias)){
	   $alias = StringHelper::increment($alias, 'dash');
	  }
	  return $alias;
	 }


 	function saveAd($data){
 		//print_r($data);
 		$data["ip_address"] = $_SERVER['REMOTE_ADDR'];
		$user= JFactory::getUser();
 		$isAdmin = JAdsUtil::isAdmin($user);
 		$this->_db->insertid();
 		$appSettings = JAdsUtil::getInstance()->getApplicationSettings();
 		$newUser = false;
 		 
 		try{
	 		#save ad data
	 		$adTable =JTable::getInstance('manageads','Table');
	 		//save an existing ad
	 		if(isset($data["ad_id"]) and $data["ad_id"]>0){
	 			$adTable->load($data["ad_id"]);
	 		}
	 		else{
	 			$adTable->status = $isAdmin ? 1: 0; //set ad status to disabled
	 			$date = JFactory::getDate();	 				
	 			$adTable->renewal_date = $date->toSql();
	 		}
	 		
	 		if(!isset($data["sub_category_id2"])){
	 			$data["sub_category_id2"] = 0;
	 		}
	 		if(!isset($data["sub_category_id"])){
	 			$data["sub_category_id"] = 0;
	 		}
	 		
	 		if(isset($data["editions"])){
	 			$data["editions"] = implode(",", $data["editions"]);
	 		}else{
	 			$data["editions"] = "";
	 		}
	 		
	 		//save the alias on ad creation or update	
	 		$adId = $data["ad_id"];
			if(empty($adId)){
				$adId = $this->_db->insertid();
			}

			if(!empty($title) && empty($data["title"]))
				$data["title"] = $title;
			//if autocomplete not used get coordinates by city
			if(empty($data['latitude'])){
				$location = JAdsUtil::getCoordinates($data['city']); 
				if(!empty($location)){
					$data['latitude'] = $location['latitude'];
					$data['longitude'] =  $location['longitude'];
				}
			}

			$data["alias"] = JAdsUtil::getAlias($data["title"],$data["alias"]);
			$data["alias"] = $this->checkAlias($adId, $data["alias"]);
            $data["price"] = empty($data["price"])?0:$data["price"];

	 		$adTable->bind($data);
	 		
	 		if(!$adTable->store(true)){
	 			throw new Exception(JText::_("LNG_ERROR_SAVING_ADD").$adTable->getError());
	 		}
	 		$this->log->LogDebug("saved ad");

	 		$this->ad_id = $adTable->id; 
		
	 		#delete all ad attributes
	 		$adTableAttr =$this->getTable('manageadattributes');
	 		if(!$adTableAttr->deleteAdAttributes($adTable->id))
	 			throw new Exception(JText::_("LNG_ERROR_DELETING_AD_ATTRIBUTES").$adTableAttr->getError());
	 		
	 		#delete all ad pictures
	 		$adTableAttr =$this->getTable('manageadpictures');
	 		if(!$adTableAttr->deleteAdPictures($adTable->id))
	 			throw new Exception(JText::_("LNG_ERROR_DELETING_AD_PICTURES").$adTableAttr->getError());
			$index = 1;//picture index

 			foreach($data as $key=>$value){
	 			#save ad attributes
	 			if(strpos($key,"attribute")===0){
	 				$attributeArr = explode("_", $key);//variable name is attribute and attribute_id
	 				//print_r($attributeArr);
	 				$adTableAttr =$this->getTable('manageadattributes');
	 				$adTableAttr->ad_id= $adTable->id;
	 				$adTableAttr->attribute_id= $attributeArr[1];
	 				
	 				if(is_array($value)){//multiple value attributes 
	 					foreach ($value as $x=>$val){//save each option_id
	 						$adTableAttr->option_id=$val;
	 						if(!$adTableAttr->store())
	 							throw new Exception(JText::_("LNG_ERROR_SAVING_AD_ATTRIBUTES").$adTableAttr->getError());
	 					}
	 				}
	 				
	 				else{//single value attributes
		 				$adTableAttr->option_id= $value;
		 				if(!$adTableAttr->store())
	 						throw new Exception(JText::_("LNG_ERROR_SAVING_AD_ATTRIBUTES").$adTableAttr->getError());
	 					}
	 			}
	 				
	 			
	 			#save ad pictures
	 			if(strpos($key,'imgID')===0){
	 				$picArr = explode("_", $key);
	 				$adTablePic =$this->getTable('manageadpictures');
	 				$adTablePic->ad_id= $adTable->id;
	 				$adTablePic->name= $value; 
	 				$adTablePic->order_num= $index;
	 				if(!$adTablePic->store())
	 					throw new Exception(JText::_("LNG_ERROR_SAVING_AD_PICTURES").$adTablePic->getError());
	 				else
	 					$index++;
	 			}
	 		}
	 		$this->log->LogDebug("saved ad attributes");
	 		$this->log->LogDebug("saved ad pictures");
		
	 		//check and create ad and joomla user
 			$adTableUsers =$this->getTable('manageusers');
 			$adUser = null;
 			
 			if($user->id == 0){
 				$newUser = true;
	 			$this->log->LogDebug("create new user for ad");
	 			$email = $user->id>0?$user->email:$data["email"];
	 			
	 			$adUser = $adTableUsers->getJoomlaUserByEmail($email);
	 			if(empty($adUser->id)){
	 				$userId = $this->createJoomlaUser($data["name"], $data["email"]);
                    $user->load($userId);
                }
	 			else 
	 				$user->load($adUser->id);	
	 		}
	 		if(empty($adTable->user_id)){
		 		$adUser = $adTableUsers->getUserByJoomaUserId($user->id);
				$adTableUsers->bind($data);
				
				$adTableUsers->joomla_user_id = $user->id;
				if(isset($adUser->id) && $adUser->id>0)
					$adTableUsers->id = $adUser->id;  
				if(!$adTableUsers->store())
					throw new Exception(JText::_("LNG_ERROR_SAVING_AD_USER").$adTableUsers->_db->getError());
					
			 	#update user id in the ad table
			 	$adTable->user_id = $adTableUsers->id;
			 	$adTable->store();
	 		}
	 		else{
	 			$adUser = $adTableUsers->load($adTable->user_id);
	 			$adTableUsers->bind($data);
	 			if(!$adTableUsers->store())
	 				throw new Exception(JText::_("LNG_ERROR_SAVING_AD_USER").$adTableUsers->_db->getError());
	 		}
	 		

	 		if ($appSettings->enable_paid_classifieds == 0){
		 		//notify user of ad creation
		 		if(!(isset($data["ad_id"]) and $data["ad_id"]>0) && !$isAdmin){
		 			$adData = AdService::getAdDetails($this->ad_id);
		 			EmailService::sendAdCreationEmail($adData);
		 		}
			}
			
			//logout user so that activation can be made.
			if($newUser){
				$this->log->LogDebug("logout user");
				//UserService::logOutUser();
			}
			
	 		$this->log->LogDebug("ad save - end");

	 		//save ad videos
	 		if(isset($data['videos-included'])) {
				$this->storeVideos($data,$adTable->id );
			}
			
 			//notify ad creation to businesses
						
			$res = JPluginHelper::importPlugin('JBDCLS');
			if($res && $newAd){

				$classifiedURL = JAdsUtil::getAdLink($this->ad_id,$data["alias"]);
				$categoryId = $data["category_id"];

				$categoryTable =JTable::getInstance('Categories','Table');
				$categoryTable->load($categoryId);

				$dispatcher = JEventDispatcher::getInstance();
				$dispatcher->trigger('onNotifyClassifiedCreation', array($categoryTable->name, $categoryTable->alias, $classifiedURL));
			}
			


 		}
 		catch (Exception $e){
             var_dump($e);exit;
 			$application = JFactory::getApplication();
 			$application->enqueueMessage($e->getMessage(), 'error');
 			$this->log->LogDebug("there was an error in adding the ad".$e->getMessage());
 			return false;
 		}
 		 
 
 		return true;
 	}
 
 	function getAdId(){
 		return $this->ad_id;
 	}
 	
 	#get ad details
 	function getAdDetails(){
 		$adTable =$this->getTable('manageads');
 		$adId = JFactory::getApplication()->input->getInt("ad_id",0);
 		$adDetails = $adTable->getAdDetails($adId);
 		
 		$adUser = $this->getAdUser();
 		
 		$user= JFactory::getUser();
 		$isAdmin = JAdsUtil::isAdmin($user);
 		
 		if(empty($adDetails->name) && !empty($adDetails->default_name) && !$isAdmin){
 			$adDetails->name = $adDetails->default_name;
 		}
 	
 		if(isset($adDetails) && empty($adDetails->name) && isset($adUser) && !$isAdmin){
 			$adDetails->name = $adUser->name;
 		}
 		
 		
 		if(empty($adDetails->phone) && !empty($adDetails->default_phone)&& !$isAdmin){
 			//$adDetails->phone = $adDetails->default_phone;
 		}
 		if(empty($adDetails->phone) && isset($adUser) && !$isAdmin){
 			//$adDetails->phone = $adUser->phone;
 		}
 		
 		if(empty($adDetails->email) && !empty($adDetails->default_email)&& !$isAdmin){
 			$adDetails->email = $adDetails->default_email;
 		}
 		if(isset($adDetails) && empty($adDetails->email) && isset($adUser) && !$isAdmin){
 			$adDetails->email = $adUser->email;
 		}
 		if(isset($adDetails)){
 			$adDetails->videos = $this->getAdVideos($adId);
 		}
 		return $adDetails;
 	}

 	function getAdVideos($adId){
		$db =JFactory::getDBO();
		$sql = "select * from #__classifiedsmanager_ad_videos where ad_id=".$adId." order by id";
		$files =  $this->_getList( $sql );
		return $files;

	}

 	#get ad attributes
 	function getAdAttributes(){
 		$adTableAttr =$this->getTable('manageadattributes');
 		$adId = JFactory::getApplication()->input->get("ad_id",0);
 		if(!is_numeric($adId))
 			$adId =0;
 		$adAttributes = $adTableAttr->getAdAttributes($adId);
 		return $adAttributes;
 	}
 	
 	function createJoomlaUser($name,$email){
        $userdata = array(); // place user data in an array for storing.
        $userdata['name'] = $name;
        $userdata['email'] = $email;
        $userdata['username'] = $email;

        //set password
        $userdata['password'] = UserService::generatePassword($email, true);
        $userdata['password2'] = $userdata['password'];

        //create the user
        $userId = UserService::createJoomlaUser($userdata);

        if (!is_numeric($userId)) {
            JFactory::getApplication()->enqueueMessage("", 'warning');
        }

        return $userId;
    }
 	function generatePassword($text, $is_cripted = false)
 	{
 		$password 	=  $text;
 		if( $is_cripted ==false )
 		return $password;
 			
 		$salt 		= JUserHelper::genRandomPassword(32);
 		$crypt 		= JUserHelper::getCryptedPassword($password, $salt);
 		$password 	= $crypt.":".$salt;
 		return $password;
 	}
 	function sendNotificationToAdmins($message){
 		try
 		{
	 		$applicationSettings = getApplicationSettings();
	 		$message= "There was an error in submitting an ad ".$message;
	 		
	 		// Send mail to administrator set in application settings 
			JFactory::getMailer()->sendMail($applicationSettings->company_email, $applicationSettings->company_name,$applicationSettings->company_email, "Error in submitting an add", $message );
	 	}
 		catch (Exception $e){
 			print_r($e);
 			exit;
 		}
 	}
 	function getPaymentProcessors(){
 		$table =$this->getTable('paymentprocessors');
 		$paymentProcessors = $table->getActivePaymentProcessors();
 		return $paymentProcessors;
 	}
 	function getActivePromotionPlans(){
 		$row = $this->getTable('promotionplans');
 		return $row->getActivePromotionPlans();
 	}
 	
 	function getAdUser(){
 		$user= JFactory::getUser();
 		$adUser = null;
 		$adTableUsers =$this->getTable('manageusers');
 		if($user->id > 0 ){
 			$adUser = $adTableUsers->getUserByJoomaUserId($user->id);
 		}
 		
 		return $adUser;
 	}
	
 	function getEditions(){
 		
 		$result = $this->_getList("SHOW TABLES LIKE '%editions%' ");
 		$tableExists = count($result) > 0;
 		$editions = array();
 	
 		if($tableExists){
	 		$query = ' SELECT * from #__editions';
			$editions = $this->_getList( $query );
 		}
 		return $editions;
 	}


 	function storeVideos($data, $adId){
	
		$table = $this->getTable('advideos');
		$table->deleteAllForAd($adId);


		foreach( $data['videos'] as $value ){
			if(empty($value)){
				continue;
			}

			$row = $this->getTable('advideos');

			$video = new stdClass();
			$video->id =0;
			$video->ad_id = $adId;
			$video->url = $value;
				
			if (!$row->bind($video))
			{
				throw( new Exception($row->getError()) );
				$this->setError($row->getError());
			}
			// Make sure the record is valid
			if (!$row->check())
			{
				throw( new Exception($row->getError()) );
				$this->setError($row->getError());
			}
				
			// Store the web link table to the database
			if (!$row->store())
			{
				throw( new Exception($row->getError()) );
				$this->setError($row->getError());
			}
		}
	}




}