<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined('_JEXEC') or die('Restricted access');
require_once JPATH_COMPONENT_SITE.'/models/useraccount.php';
require_once JPATH_COMPONENT_SITE.'/helpers/utils.php';

jimport('joomla.application.component.model');

class JClassifiedsManagerModelManageAds extends JModelLegacy
{
	function __construct()
	{
		parent::__construct();
		$this->log = Logger::getInstance();
	}
	function expireAds(){
		$applicationSettings = JAdsUtil::getApplicationSettings();
		$table = $this->getTable('manageads');
		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;
		$expiredAds = $table->getExpiredAds($validPeriod,0);//get expired ads to the current date
		$epxiredAdsArr = array();
		if(count($expiredAds)>0){
			foreach($expiredAds as $ad){
				$adDetails = AdService::getAdDetails($ad->id);
				EmailService::sendExpirationEmail($adDetails);
			}
	
			$adIds = implode(",", $epxiredAdsArr);
			if($table->unpublish($adIds)){
				$this->log->LogDebug("Ads unpublished successfully");
			} 
			else{
				$this->log->LogDebug("There was an error in expiring ads ".$table->getError());
			}
		}
		$this->log->LogDebug("expired ads:".count($expiredAds));
	}
	 
	function notifyPromoExpiration($nrDays){
		$applicationSettings = JAdsUtil::getApplicationSettings();
		$table = $this->getTable('manageads');
		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;
		$expiredAds = $table->getPromoToExpireAds($nrDays);//get expired ads after 5 days and notigy them
		$epxiredAdsArr = array();
		if(count($expiredAds)>0){
			foreach($expiredAds as $ad){
				$adDetails = AdService::getAdDetails($ad->id,$ad->orderId);
				EmailService::sendPromoExpireEmail($adDetails);
			}
		}
		$this->log->LogDebug("expired ads:".count($expiredAds));
	}
	
	function notifyExpiration($nrDays){
		$applicationSettings =JAdsUtil::getApplicationSettings();
		$table = $this->getTable('manageads');
		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;
		$expiredAds = $table->getExpiredAds($validPeriod,$nrDays);//get expired ads after 5 days and notigy them
		$epxiredAdsArr = array();
		if(count($expiredAds)>0){
			foreach($expiredAds as $ad){
				$adDetails = AdService::getAdDetails($ad->id);
				EmailService::sendExpirationEmail($adDetails);
			}
		}
		$this->log->LogDebug("expired ads:".count($expiredAds));
	}
	
	
	function sendExpirationEmail($userName, $email,$adTitle){
		try
		{
			$applicationSettings = JAdsUtil::getApplicationSettings();
			$siteurl	= "<a href='".JUri::root()."index.php?option=com_jclassifiedsmanager&controller=useraccount&view=useraccount'>".JText::_("LNG_CLICK_HERE")."</a>";
			
			$emailSubject = JText::sprintf('LNG_EXPIRATION_EMAIL_SUBJECT',
											$applicationSettings->company_name
											);			
			$emailBody = JText::sprintf('LNG_AD_EXPIRATION_MESSAGE',
										$userName,
										$adTitle,
										$applicationSettings->company_name,
										$siteurl
										);
			$mode		 = 1 ;//html
	
			// Send mail to user that ad has expired
			$result = JFactory::getMailer()->sendMail($applicationSettings->company_email, $applicationSettings->company_name,$email,$emailSubject, $emailBody,$mode );
		}
		catch (Exception $e){
			$this->log->LogDebug("There was an error in sending expiration emails".$e->getMessage());
			print_r($e);
			exit;
		}
	
	}
	function deleteLongExpiredAds(){
		$applicationSettings = JAdsUtil::getApplicationSettings();
		$table = $this->getTable('manageads');
		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;
		$expiredAds = $table->getExpiredAds($validPeriod,30);//get ads expired for 30 days
		if(count($expiredAds)>0){
			foreach($expiredAds as $ad){
				$model =  &JModelLegacy::getInstance('useraccount','JClassifiedsManagerModel');
				$message = $model->deleteAd($ad->id);
			}
		}
		$this->log->LogDebug("deleted long expired ads:".count($expiredAds));
	}
	function activateAd(){
		$table = $this->getTable('manageads');
		$adId = JFactory::getApplication()->input->get('ad_id');
		if($table->publishItems($adId))
			$this->log->LogDebug("activate ad :".$adId);
		else 
			$this->log->LogDebug("error activating ad :".$adId);
	}
	
	
}