<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined('_JEXEC') or die('Restricted access');

require_once JPATH_COMPONENT_SITE.'/classes/payment/paymentfactory.php';

class JClassifiedsManagerModelManageOrders extends JModelLegacy
{
	function __construct()
	{
		parent::__construct();
		$this->log = Logger::getInstance();
	}
	function updateOrder($orderData){
		try{
			$this->log->LogDebug("updating order ".$orderData->orderId);
				
			$orderTable = $this->getTable("manageorders");
			if($orderTable->updateOrder($orderData->orderId,$orderData->orderMessage,$orderData->orderStatus)){
				$this->log->LogDebug("Order was updated successfully ".$orderData->orderId);
			} 
			else{
				$this->log->LogDebug("There was an error in updating the order $orderData->orderId ".$orderTable->getError());
			}
			$orderTable->load($orderData->orderId);
			$this->adId = $orderTable->ad_id;
				
			if($orderData->orderStatus==JCLS_PAYMENT_STATUS_PAID){
				$adData= AdService::getAdDetails($this->adId);
				EmailService::sendInvoiceEmail($adData,$orderData->orderId);
			}
		}
		catch(Exception $e){
			$this->log->LogDebug("There was an error in updating the order ".$e->getMessage());
		}
	}
	
	function getOrderDetails(){
		$orderId = JFactory::getApplication()->input->get("orderId",null);
		$tableOrders = $this->getTable();
		return $tableOrders->getOrderDetails($orderId);
	}
	
}