<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined('_JEXEC') or die('Restricted access');

$user = JFactory::getUser();
$isAdmin = JAdsUtil::isAdmin();
$appSettings = JAdsUtil::getInstance()->getApplicationSettings();
?>

<style type="text/css">
	label {display: inline;}
</style>

<div id="mangeReservationInfo" class="manage-reservation">
	<form action="<?php echo JRoute::_('index.php?option=com_jclassifiedsmanager&view=editad') ?>" method="post" name="createAd" id="createAd" class="" onSubmit="return formValidate();">
		<div class="classifiedContainer">
			<div class="col-md-8">
				<?php if(isset($this->ad_id) && $isAdmin != 1){ ?>
					<div style="width:100%;text-align:right">
                        <button type="submit" class="ui-classifieds-button">
                            <span class="ui-button-text"><?php echo  isset($this->ad_id)?JText::_('LNG_MODIFY_AD'):JText::_('LNG_SUBMIT_AD'); ?></span>
                        </button>
						<a class="ui-classifieds-button cancel" onclick="cancelEdit()"><span><?php echo JText::_("LNG_CANCEL")?></span></a>

					</div>
				<?php }?>
				<fieldset class="boxed">
					<h2><?php echo JText::_( 'LNG_AD_DETAILS' ); ?> </h2>
					<dl class="defaultAdStyle">
						<dt>
							<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_AD_TITLE');?>"><?php echo JText::_('LNG_AD_TITLE');?></label>										
							<span class="mand">*</span>
						</dt>
						<dd>
							<input class="title" type="text" name='title' id='title' class="validate[required]" autocomplete= 'on' size="50" value="<?php if(isset($this->adDetails->title)) echo $this->adDetails->title?>"/>
							<div id="titleInfo" class="inputInfo"><?php echo JText::_('LNG_AD_TITLE_INFO');?></div>
						</dd>

						<?php if($isAdmin == 1){ ?>
							<dt>
								<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_ALIAS'); ?>"><?php echo JText::_('LNG_ALIAS'); ?></label>										
								<span class="mand">*</span>
							</dt>
							<dd>
								<input type="text" name='alias' id='alias'  size="50" placeholder="<?php echo JText::_('LNG_AUTO_GENERATE_FROM_NAME');?>" value="<?php if(isset($this->adDetails->alias)) echo $this->adDetails->alias?>"/>
							</dd>
						<?php }?>


						<dt>
							<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_AD_TYPES');?>"><?php echo JText::_('LNG_AD_TYPES');?></label>										
							<span class="mand">*</span>
						</dt>
						<dd>
							<select name="ad_type_id" id="ad_type_id" class='validate[required]'>
								<?php 
								foreach($this->adTypes as $adType){
									$checked="";
									if(isset($this->adDetails->ad_type_id) && $this->adDetails->ad_type_id==$adType->id)
										$checked="selected";
										
									$name = JText::_($adType->name);
									echo "<option value='$adType->id' $checked >$name</option>";
								}
								?>
							</select>
						</dd>
						
						<dt id="priceDt">
							<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_PRICE');?>"><?php echo JText::_('LNG_PRICE');?></label>										
							<span class="mand">*</span>
						</dt>
						<dd>
							<input type="text" name='price' id='price' class="validate[required,custom[number]]" size="50" value="<?php if(isset($this->adDetails->price)) echo $this->adDetails->price?>"/>
							<select name="currency_id" id="currency_id" class='currency required'>
							
								<?php 
								foreach($this->currencies as $currency){
									$checked="";
									if(isset($this->adDetails->currency_id) && $this->adDetails->currency_id==$currency->id)
										$checked="selected='true'";
									echo "<option value='$currency->id' $checked>$currency->name</option>";
								}
								?>
							</select>
						</dd>
									
						<dt>
							<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_CATEGORY');?>"><?php echo JText::_('LNG_CATEGORY');?></label>										
							<span class="mand">*</span>
							
						</dt>
						<dd>
						<div id="category">
							<select name="category_id" id="category_id" size="10" class='validate[required]' onChange="getSubcategories(this.value)">
								<?php 
								foreach($this->categories as $category){
									$checked="";
									if(isset($this->adDetails->category_id) && $this->adDetails->category_id==$category->id)
										$checked="selected='true'";
									echo "<option value='$category->id' $checked>$category->name</option>";
								}
								?>
							</select>
						</div>
							<img id="loading-subcat" style="display:none" title="loading. please wait..."  src='<?php echo JURI::root()?>/components/com_jclassifiedsmanager/assets/images/load.gif'>
							<div id="subcategory" style="display:none;">
							
								<select name="sub_category_id" id="sub_category_id" size="10" class='validate[required]'>
								
								</select>
							</div>
							<div id="subcategory2" style="display:none;">
								<select name="sub_category_id2" id="sub_category_id2" size="10" class='validate[required]'>
									
								</select>
							</div>
							<div id="subcat-lbl" style="display:none;float:left;"><?php echo JText::_('LNG_PLEASE_SELECT_SUB_CATEGORY');?></div>										
							<div style="clear:both;"></div>
						</dd>
						
						<div id="attributesDiv">
						</div>
						
						
						<dt>
							<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_DESCRIPTION');?>"><?php echo JText::_('LNG_DESCRIPTION');?></label>										
							<span class="mand">*</span>
						</dt>
						<dd>
							<div><?php echo JText::_('LNG_DESCRIPTION_TEXT');?></div>
						    <?php
                                echo '<div class="d-flex justify-content-between"><div>Remaining Characters: <span id="count"></span></div><span id="count-warning" style="color:red;"></span></div>';
                                echo JAdsUtil::getEditor()->display('description', $this->adDetails->description, '100%', '250', '20', '5', false);
                            ?>
						</dd>

						<dt>
							<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_PICTURES');?>"><?php echo JText::_('LNG_PICTURES');?></label>										
							<span class="mand">*</span>
						</dt>
						<dd>						  
							<div id="loader"><img src="components/com_jclassifiedsmanager/imageupload/web_images/ajax-loader.gif" /></div>
						
								<div id="MainDiv"  style="margin:0 auto;display:inline-block;">
									<div id="errorPics" ></div>
									<div id="success">Succesfully submited! </div>
									<div id="UploadImagesdiv" title="UploadImagesdiv">	
										<input type="hidden" name="ad_pictures" id="ad_pictures"> 
										<input type="button" id="upload" value="<?php echo JText::_('LNG_UPLOAD_PICTURES');?>"  class="adButton"/>
										<span id="status" ></span>
                                    </div>
									<div id="files" class="group"></div>
                                </div>
						</dd>
					</dl>
				</fieldset>
				<?php if ($appSettings->enable_video) {?>
					<fieldset class="boxed">
						<h2><?php echo JText::_( 'LNG_AD_VIDEOS' ); ?> </h2>
						<dl class="defaultAdStyle">
							<!-- videos div start  -->
							<dt class="video-info" >
								<p class="video-information">  <?php echo htmlspecialchars( JText::_('LNG_AD_VIDEO_INFORMATION_TEXT') );?>.</p>
							</dt>
							<dd>
							<input type="hidden" name="videos-included" value="1"/>
							<div class="form-box">
								<div id="video-container">  
									<?php
									if(empty($this->adDetails->videos)){?>
										<div class="detail_box" id="detailBox0">
										
											<label for="video1"><?php echo JText::_('LNG_VIDEO')?></label> 
											<textarea name="videos[]" id="0" class="input_txt" cols="75" rows="2"></textarea>
											<?php if(isset($appSettings->max_videos) && $appSettings->max_videos > 1 ) {  ?>
												<img height="12px" align="left" width="12px" src="<?php echo JURI::root() ."administrator/components/com_jclassifiedsmanager/assets/img/deleteIcon.png"?>" alt="Delete video" onclick="removeRow('detailBox0')" style="cursor: pointer; margin: 3px;">
											<?php } ?>
											<div class="clear"></div>
										</div>
									<?php } ?> 
									
									<?php 
										$index = 0;
										if(!empty($this->adDetails->videos) && count($this->adDetails->videos)>0)
										foreach($this->adDetails->videos as $video){?>
										<div class="detail_box" id="detailBox<?php echo $index ?>">
												<div  class="form-detail req"></div>
											<label for="<?php echo $video->id?>"><?php echo JText::_('LNG_VIDEO')?></label> 
											<textarea name="videos[]" id="<?php echo $video->id?>" class="input_txt" cols="75" rows="2"><?php echo $video->url ?></textarea>
											<?php if(isset($appSettings->max_videos) && $appSettings->max_videos > 1 ) {  ?>	
												<img height="12px" align="left" width="12px" src="<?php echo JURI::root() ."administrator/components/com_jclassifiedsmanager/assets/img/deleteIcon.png"?>" alt="Delete video" onclick="removeRow('detailBox<?php echo $index++; ?>')" style="cursor: pointer; margin: 3px;">	
											<?php } ?>
											<div class="clear"></div>
										</div>
									<?php } ?>
								</div>
								<?php if(isset($appSettings->max_videos) && $appSettings->max_videos > 1 ) {  ?>
									<a id="add-video" href="javascript:void(0);" onclick="addVideo()"><?php echo JText::_('LNG_ADD_VIDEO')?></a>
								<?php } ?>
							</div><!-- videos div end  -->
							</dd>
						</dl>
					</fieldset>
				<?php } ?>
					<fieldset class="boxed">
						<h2><?php echo JText::_( 'LNG_LOCATION' ); ?> </h2>
						<dl class="defaultAdStyle">
							<div class="location">
							<dt>
								<div><label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_AUTOCOMPLETE_ADDRESS');?>"><?php echo JText::_('LNG_AUTOCOMPLETE_ADDRESS');?></label></div>
							</dt>
							<dd>
								<div><input  type="text" id="autocomplete" class="input_txt controls"  placeholder="<?php echo JText::_('LNG_ENTER_ADDRESS')?>" onFocus="" /></div>
							</dd>
							
							<dt> 
								<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_COUNTRY');?>"><?php echo JText::_('LNG_COUNTRY');?></label>										
								<span class="mand">*</span>
							</dt>
							<dd>
								<input type="text" name="country" id="country"  class="validate[required]" value="<?php echo !empty($this->adDetails->country)?$this->adDetails->country:"" ?>"/>
							</dd>
							
							<dt>
								<label type="text" id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_PROVINCE');?>"><?php echo JText::_('LNG_PROVINCE');?></label>
								<span class="mand">*</span>
							</dt>
							<dd>
								<input type="text" name="state" id="administrative_area_level_1"  class="validate[required]" value="<?php echo !empty($this->adDetails->state)?$this->adDetails->state:"" ?>">
							</dd>
							<dt> 
								<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_CITY');?>"><?php echo JText::_('LNG_CITY');?></label>										
								<span class="mand">*</span>
							</dt>
							<dd>
								<input type="text" name="city" id="locality"  class="validate[required]" value="<?php echo !empty($this->adDetails->city)?$this->adDetails->city:"" ?>"/>
							</dd>

							<!-- Latitude and longtitude of the selected location -->
								<input type="hidden" name="latitude" id="lat" value="<?php echo !empty($this->adDetails->latitude)?$this->adDetails->latitude:"" ?>"/>
								<input type="hidden" name="longitude" id="lng" value="<?php echo !empty($this->adDetails->longitude)?$this->adDetails->longitude:"" ?>"/>
						
							</div>
							<!-- location div end  -->
							<div class="map-container">
								<div id="map-canvas"></div>
							</div>
						</dl>
					</fieldset>
							<!-- personal information div start -->
					<fieldset class="boxed">
						<h2><?php echo JText::_( 'LNG_PERSONAL_INFORMATION' ); ?> </h2>
						<dl class="defaultAdStyle">
							<div class="personal-info">
                                <dt>
                                    <label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_USER_TYPE');?>"><?php echo JText::_('LNG_USER_TYPE');?></label>
                                    <span class="mand">*</span>
                                </dt>
                                <dd>
                                    <?php
                                        foreach($this->userTypes as $userType){
                                            $checked="";
                                            if(isset($this->adDetails->user_type_id) && $this->adDetails->user_type_id==$userType->id)
                                                $checked="checked='true'";
                                            echo "<div class=' styledRadio'> <input class='validate[required] radio' type='radio' name='user_type_id' id='user_type_id_$userType->id'  size='50' value='$userType->id' $checked/> 
                                                    <label for='user_type_id_$userType->id'></label>
                                                    
                                                </div>
                                                <label>".JText::_($userType->name)." </label>";
                                        }

                                        ?>
                                    <div class="clear"></div>
                                </dd>
                                <dt>
                                    <label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_NAME');?>"><?php echo JText::_('LNG_NAME');?></label>
                                    <span class="mand"><?php echo !$isAdmin?"*":"" ?></span>
                                </dt>
                                <dd>
                                    <input  name='name' id='name' type="text" class="<?php echo !$isAdmin?"validate[required]":""?> text-input"  size="50" value="<?php if(isset($this->adDetails->name)) echo $this->adDetails->name?>"/>
                                </dd>

                                <dt>
                                    <label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_EMAIL');?>"><?php echo JText::_('LNG_EMAIL');?></label>
                                    <span class="mand"><?php echo !$isAdmin?"*":"" ?></span>
                                </dt>
                                <dd>
                                    <input name='email' id='email' type="text" size="50" class='<?php echo !$isAdmin?"validate[required,custom[email]]":"" ?> text-input' value="<?php if(isset($this->adDetails->email)) echo $this->adDetails->email?>"/>
                                    <div id="emailInfo" class="inputInfo"><?php echo JText::_('LNG_AD_EMAIL_INFO');?></div>
                                </dd>

                                <dt>
                                    <label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_TELEPHONE_NUMBER');?>"><?php echo JText::_('LNG_TELEPHONE_NUMBER');?></label>
                                    <span class="mand"><?php echo !$isAdmin?"*":"" ?></span>
                                </dt>
                                <dd>
                                    <input name='phone' id='phone' type="text" class="<?php echo !$isAdmin?"validate[required,custom[phone]]":""?> text-input" size="50" value="<?php if(isset($this->adDetails->phone)) echo $this->adDetails->phone?>"/>
                                </dd>

							</div>
						</dl>
					</fieldset>
						<?php 
						if(((!isset($this->ad_id) || $this->ad_id==null) && $isAdmin==0)){
						?>

					<?php if ($appSettings->enable_ad_promoting) {?>
					<dl class="defaultAdStyle">
						<dt class="full-width">
							<div class="info_header">
								<?php 	
									if ($appSettings->enable_paid_classifieds) 
										echo JText::_('LNG_LISTING_OPTIONS'); 
									else 
										echo JText::_('LNG_PROMOTING_OPTIONS'); 
								?>
							</div>
						</dt>

						<div class="clear"></div>
						<div id="promoteclassifiedsInfo" <?php if ($appSettings->enable_paid_classifieds)  echo 'style="display:none"';?> >
							<div style="float:left;width:60%" >
								<br><br><br>
								<?php echo JText::_('LNG_SITE_PROMOTE_INFO'); ?>
							</div>
							<!-- <img width="40%" height="40%" src="components/com_jclassifiedsmanager/assets/images/promote.jpg" />-->					    
							<img width="40%" height="40%" src="<?php echo JURI::root();?>components/com_jclassifiedsmanager/assets/images/promote.jpg" />
							<br><br>
							<button type="button" onClick="jQuery('#promoteAdDiv').show();jQuery('#promoteclassifiedsInfo').hide();jQuery('#promoteAdDiv :input').removeAttr('disabled');" class="ui-classifieds-button buttonPromote green"><?php echo JText::_('LNG_PROMOTE');?>
						</div>
						<div id="promoteAdDiv" <?php if ($appSettings->enable_paid_classifieds)  echo 'style="display:block"';  else echo 'style="display:none"';  ?> >
							<dt>
								<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_PAYMENT_PLANS');?>"><?php echo JText::_('LNG_PAYMENT_PLANS');?></label>										
								<span class="mand">*</span>
							</dt>
							<dd style="align:right;">
								<br>
							</dd>
								<div class="paymentPlan">
									<table >
									<?php 
									if(isset($this->promotionPlans))
										foreach($this->promotionPlans as $key=>$paymentPlan){
											if (( $appSettings->enable_paid_classifieds &&$paymentPlan->type == PROMOTION_PLAN_AD_LISTING ) || ( !$appSettings->enable_paid_classifieds && $paymentPlan->type == PROMOTION_PLAN_PROMOTION )) { ?>
												<tr>
													<td width="1%">
														<div class="styledRadio">
															<input id="p_method_<?php echo $paymentPlan->id ?>"  type="radio" name="payment_plan_id"  value="<?php echo $paymentPlan->id?>" class="validate[required] radio">
															<label for="p_method_<?php echo $paymentPlan->id ?>"></label>
														</div>
													</td>
													<td><?php echo $paymentPlan->name ?> </td>
													<td><?php echo $paymentPlan->period." ".JText::_("LNG_PLAN_".strtoupper($paymentPlan->period_unit)); ?>  </td>
													<td><?php echo $paymentPlan->price." ".$paymentPlan->currency; ?>  </td>
												</tr>
											<?php 
											}
										}
									?>
								</table>
								</div>
							<dt class="margin-top-25">
								<label id="details-lbl" for="details" class="hasTip" title="<?php echo JText::_('LNG_PAYMENT_OPTIONS');?>"><?php echo JText::_('LNG_PAYMENT_OPTIONS');?></label>										
								<span class="mand">*</span>
							</dt>
							<dd>
							</dd>
							<div class="paymentProcessors " > 
								<br/>
								<?php echo PaymentService::generatePaymentProcessorHtml() ;?>
							</div>
						<dt></dt>
						<?php if ($appSettings->enable_paid_classifieds == 0)  { ?>
						<dd class="center-div clear">
							<?php echo JText::_('LNG_CANCEL_PROMOTE');?>
							<button onClick="cancelPromotion();return false;" data-icon="" class="ui-classifieds-button buttonPromote cancel"><?php echo JText::_('LNG_CANCEL');?></button>					
							<br>
						</dd>					
						<?php } ?>
						</div>
					</dl>
					<?php } ?>

					<?php if($appSettings->enable_captcha && $isAdmin!=1){?>
						<dl class="defaultAdStyle">
							<div class="form-item">
								<?php 
								$namespace="jclassifiedsmanager.createclassifieds";
								$class="none";
								$captcha = JCaptcha::getInstance("recaptcha", array('namespace' => $namespace));
								if(!empty($captcha)){
									echo $captcha->display("captcha", "captcha-div", $class);
								}
								?>
								<div id="captcha-div-error"> </div>
							</div>
						</dl>
					<?php } ?>

				<?php } ?>

				<div class="info_header">&nbsp;</div>
				<div id="agreement">
					&nbsp; <?php echo JText::_("LNG_READ_AND_ACCEPT",true);?>
					<a href="javascript:void(0);" onclick="showTerms()"><?php echo JText::_("LNG_TERMS_AND_CONDITION",true)?></a>
					<!-- <?php echo " &nbsp;".JText::_("LNG_AND",true)." &nbsp;";?> <a href=""><?php echo JText::_("LNG_USAGE_RULES",true);?></a>  -->
					<?php echo JText::_("LNG_OF_THE_WEBSITE",true);?>
				</div>

		<div class="right">
			<?php if($isAdmin == 0){?>
				<button type="submit" class="ui-classifieds-button">
						<span class="ui-button-text"><?php echo  isset($this->ad_id)?JText::_('LNG_MODIFY_AD'):JText::_('LNG_SUBMIT_AD'); ?></span>
				</button>
				
				<a class="ui-classifieds-button cancel" onclick="cancelEdit()">
					<span class="ui-button-text"><?php echo JText::_("LNG_CANCEL")?></span>
				</a>
				
			<?php } ?>
			<input type="hidden" name="option" value="<?php echo getAdComponentName()?>" />
			<input type="hidden" name="ad_id" value="<?php if(isset($this->adDetails->id)) echo $this->adDetails->id?>" />
			<input type="hidden" name="task" id="task" value="editad.save" />
			<input type="hidden" name="controller" id="controller" value="editad" />
			<input type="hidden" name="view" id="viewname" value="editad" />
			<?php echo JHtml::_('form.token'); ?>
		</div>
		</div>
    </form>
</div>

<div id="terms-and-conditions" style="display:none;overflow-y:scroll;margin-left:auto;margin-right:auto;">
	<div id="dialog-container">
		<div class="titleBar">
			<span class="dialogTitle" id="dialogTitle"></span>
			<span  title="Cancel"  class="dialogCloseButton" onClick="jQuery.unblockUI();">
				<span title="Cancel" class="closeText">x</span>
			</span>
		</div>
		
		<div class="dialogContent">
			<h3 class="title"><?php echo JText::_('LNG_TERMS_AND_CONDITIONS') ?></h3>
		  		<div class="dialogContentBody" id="dialogContentBody">
					<?php echo $this->appSettings->terms_conditions;?>
				</div>
		</div>
	</div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function () {
			
			//function to curCSS error on photo reorder on image uploader
			jQuery.curCSS = function (element, attrib, val) {
    			jQuery(element).css(attrib, val);
			};

			jQuery("#title").focus(function() {
				jQuery("#titleInfo").show();
			});
			jQuery("#title").blur(function() {
				jQuery("#titleInfo").hide();
			});
			jQuery("#email").focus(function() {
				jQuery("#emailInfo").show();
			});
			jQuery("#email").blur(function() {
				jQuery("#emailInfo").hide();
			});

			jQuery("input:radio[name=payment_processor_id]").click(function() {
			  
				jQuery("input:radio[name=payment_processor_id]").each(function() {
				 		processValue = $(this).val();
						jQuery("#processor_description_"+processValue).hide();
			    });
				jQuery("#processor_description_"+ $(this).val()).show();
			});

			if(jQuery("#descriptionCounter").val())
				jQuery("#descriptionCounter").val(parseInt(jQuery("#description").attr('maxlength')) - jQuery("#description").val().length);
			
			
			jQuery("#category_id").attr('selectedIndex', -1);

			var categoryId  ='<?php if(isset($this->adDetails->category_id)) echo $this->adDetails->category_id;?>';
			if(categoryId>0){
				setTimeout(function() {getSubcategories(categoryId);}, 300);
			}			

			var subcategoryId  ='<?php if(isset($this->adDetails->sub_category_id)) echo $this->adDetails->sub_category_id;?>';
			if(subcategoryId>0){
				setTimeout(function() {getSubcategoriesSecondLevel(subcategoryId);}, 600);
			}	

			
			var subcategoryId2  ='<?php if(isset($this->adDetails->sub_category_id2)) echo $this->adDetails->sub_category_id2;?>';
			if(subcategoryId2>0){
				//retrieve attributes
				setTimeout(function() {	getCategoryAttributes(subcategoryId2);}, 700);
				
			}
			<?php 
			if(isset($this->adDetails->picture_ids)){
	            $adPictures = explode(",",$this->adDetails->picture_ids);
	            foreach ($adPictures as $key=>$adPicture){
	            	if(isset($adPicture) && strlen($adPicture)>0 )
	            ?> 
	            	juploadv132.displayImage('<?php echo $adPicture;?>','<?php echo $adPicture;?>');
	            <?php } 
			}   
	          ?>
            lat1 ='<?php if(isset($this->adDetails->latitude)) echo $this->adDetails->latitude?>';
            lng1 ='<?php if(isset($this->adDetails->longitude)) echo $this->adDetails->longitude?>';
            ShowLocationMap();


        <?php if($isAdmin==0){ ?>
            var recaptcha = document.forms["createAd"]["g-recaptcha-response"];
                recaptcha.required = true;
                recaptcha.oninvalid = function(e) {
                    jQuery( "#captcha-div-error" ).html( "<p class='red'> <?php echo JText::_('LNG_COMPLETE_CAPTCHA')?> </p>" );
                    return false;
                }
        <?php }?>

            jQuery("#createAd").validationEngine('attach');
    });

	jQuery("#ad_type_id").change(function() {
		typeId = jQuery(this).val();
		if(typeId==5 || typeId==6){ //donation or search, hide price
			jQuery("#priceDt").hide();
			jQuery("#price").hide();
			jQuery("#currency_id").hide();
		}
		else{
			jQuery("#priceDt").show();
			jQuery("#price").show();
			jQuery("#currency_id").show();
		} 
			
	});
	jQuery.fn.center = function () {
	    this.css("position","absolute");
	    this.css("top", Math.max(0, ((jQuery(window).height() - jQuery(this).outerHeight()) / 2) + jQuery(window).scrollTop()) + "px");
	    this.css("left", Math.max(0, ((jQuery(window).width() - jQuery(this).outerWidth()) / 2) + jQuery(window).scrollLeft()) + "px");
	    return this;
	}

	function showTerms(){
		 jQuery.blockUI({ message: jQuery('#terms-and-conditions'), css: {left:'5%',width: '60%',top: '5%'} });
		 jQuery('.blockUI.blockMsg').center();
		 jQuery(".blockOverlay").click(function(){
			 jQuery.unblockUI();
		});

	}

    initializeCharCount();

    function initializeCharCount() {
        var lng = "";
        var lngUnderscore = ""
        <?php if ($this->appSettings->enable_multilingual == 1) { ?>
        lng = "<?php echo JAdsUtil::getLanguageTag();?>";
        lngUnderscore = lng.replace("-","_");
        <?php } ?>

        var maxchar = <?php echo AD_DESCRIPTIION_MAX_LENGTH ?>;
        var iframe = document.getElementById('description'+ lngUnderscore +'_ifr');
        if(iframe) {
            var innerDoc = (iframe.contentDocument) ? iframe.contentDocument : iframe.contentWindow.document;
            var c = document.getElementById("count" + lng);

            var nrChars = jbdUtils.getEditorStats('description' + lngUnderscore).chars;
            c.innerHTML = maxchar - nrChars;
            checkCount(evt);

            innerDoc.addEventListener("keydown",checkCount);
            innerDoc.addEventListener('paste', handlePaste);

        }
    }
    function checkCount(e) {
        var maxchar = <?php echo AD_DESCRIPTIION_MAX_LENGTH ?>;
        var lng = "";
        var lngUnderscore = "";
        <?php if ($this->appSettings->enable_multilingual == 1) { ?>
        lng = "<?php echo JAdsUtil::getLanguageTag();?>";
        lngUnderscore = lng.replace("-","_");
        <?php } ?>

        var counter = document.getElementById("count" + lng);
        var nrChars = jbdUtils.getEditorStats('description' + lngUnderscore).chars;
        var remaining = maxchar - nrChars;

        if(remaining < 0){
            remaining = 0;
        }
        counter.innerHTML = remaining;

        if (nrChars >= maxchar) {
            jQuery("#count-warning" + lng).text('<?php echo JText::_("LNG_DESCRIPTION_LIMIT_EXCEEDED")?>');
            if (e.keyCode != 8 || e.keyCode == 32) {
                e.preventDefault();
            }
        } else {
            jQuery("#count-warning" + lng).text('')
        }
    }

	function getSubcategories(categoryId) {	
		var fieldName = 'sub_category_id';
		var parentDiv = 'subcategory';
		var changeFunction = 'getSubcategoriesSecondLevel(this.value)';

		jQuery("#loading-subcat").show();
		
		jQuery('#' +parentDiv).hide();
		jQuery('#subcategory2').hide();
		
		
		var siteRoot = '<?php echo JURI::root();?>';
		var compName = '<?php echo getAdComponentName();?>';
		var selectedValue  ='<?php if(isset($this->adDetails->sub_category_id)) echo $this->adDetails->sub_category_id;?>';
		var adId  ='<?php if(isset($this->adDetails->id)) echo $this->adDetails->id;?>';
		
		//retrieve sub-categories
		var url = siteRoot+'index.php?option='+compName+'&controller=editad&task=editad.getSubCategories&category_id='+categoryId;
		getData(fieldName,url,null,parentDiv,changeFunction,selectedValue);
		jQuery("#loading-subcat").hide();
		//retrieve attributes
		getCategoryAttributes(categoryId);

		setTimeout(function() {
			jQuery("#loading-subcat").hide();
			if(jQuery('#sub_category_id option').length>0){
				jQuery('#subcat-lbl').show();
				
			}
			else 
				jQuery('#subcat-lbl').hide();
		}, 600);
	}

	function getSubcategoriesSecondLevel(categoryId) {	
		var fieldName = 'sub_category_id2';
		var parentDiv = 'subcategory2';
		var changeFunction = 'getCategoryAttributes(this.value)';
		
		jQuery('#' +parentDiv).hide();
		var siteRoot = '<?php echo JURI::root();?>';
		var compName = '<?php echo getAdComponentName();?>';
		var selectedValue  ='<?php if(isset($this->adDetails->sub_category_id2)) echo $this->adDetails->sub_category_id2; else echo "";?>';
		var adId  ='<?php if(isset($this->adDetails->id)) echo $this->adDetails->id;?>';		
		var url = siteRoot+'index.php?option='+compName+'&controller=editad&task=editad.getSubCategories&category_id='+categoryId;
		getData(fieldName,url,null,parentDiv,changeFunction,selectedValue);

		//retrieve attributes
		getCategoryAttributes(categoryId);
		jQuery('#subcat-lbl').hide();
	}
	
	function getCategoryAttributes(categoryId){
		fieldName = 'attributesDiv';
		var siteRoot = '<?php echo JURI::root();?>';
		var compName = '<?php echo getAdComponentName();?>';
		var adId  ='<?php if(isset($this->adDetails->id)) echo $this->adDetails->id;?>';
		url = siteRoot+'index.php?option='+compName+'&controller=editad&task=editad.getAjaxCategoryAttributes&category_id='+categoryId+'&ad_id='+adId;
		getAjaxData(fieldName,url,null);
	}

	function calculateLenght(){

		var obj = jQuery("#description");

	    var max = parseInt(obj.attr('maxlength'));
	    if(obj.val().length > max){
	        obj.val(obj.val().substr(0, obj.attr('maxlength')));
	    }
	  
	 	jQuery("#descriptionCounter").val((max - obj.val().length));
	}


	
	function formValidate() {
        jQuery("form[name='createAd']").validationEngine('attach');
        <?php if(isset($appSettings->mandatory_picture)){?>
            if(jQuery('#files').html().length==0){
			   jQuery('#errorPics').html('<?php echo JText::_('LNG_PLEASE_UPLOAD_ONE_PICTURE'); ?>');
			   jQuery('#errorPics').focus();
			   return false;
		   }
		   else{
			   jQuery('#errorPics').html('');
		   }
         <?php }?>
        if(!jQuery("form[name='createAd']").validationEngine('validate')){
            return false;
        }
        return true;
	}

	getData = function(fieldName,url,inputParams,parentDiv,changeFunction,selectedValue) {
		jQuery.getJSON(
		    url,
		    inputParams,
		    function(result) {
		    	try {
		    		jQuery("#loading-subcat").hide();
			    		if(result.length>0)
			    			jQuery('#' +parentDiv).show();
				    		var optionsValues = '<select size="10" id="'+fieldName+'" name="'+fieldName+'" class="validate[required]" onClick="'+changeFunction+'">';				    	jQuery.each(result, function(i,item) {
					    	if(item.id==selectedValue){
					    		if(result.length==1){
					    			jQuery('#' + fieldName).delay(800).trigger('change');
					    		}
					    		optionsValues += '<option value="' + item.id + '" selected="true">' + item.name + '</option>';
					    	}
				    		else{
				    			optionsValues += '<option value="' + item.id + '">' + item.name + '</option>';
				    		}

					    	
				        });
				        
				    	optionsValues += '</select>';
				    	var options = jQuery('#' + fieldName);
				    	options.replaceWith(optionsValues);
				    	return result;
				} catch(err) {
					//alert(err);
				};
		    }
		);
	}
	getJSONData = function(fieldName,url,inputParams,selectedValue) {
		jQuery.getJSON(
		    url,
		    inputParams,
		    function(result) {
		    	try {
		    			jQuery("#loading-subcat").hide();
			    		var selectElement = jQuery('#' + fieldName);
		    			selectElement.empty();
		    			if(result.length>0)
			    			optionsValue = '<option value><?php echo JText::_('LNG_PLEASE_SELECT_A_VALUE'); ?></option>';
			    		else
			    			optionsValue = '<option value><?php echo JText::_('LNG_NO_OPTION_FOUND'); ?></option>';
			    		selectElement.append(optionsValue);
			    		
				    	jQuery.each(result, function(i,item) {
					    	if(item.id==selectedValue)
				    			optionsValue = '<option value="' + item.id + '" selected="true">' + item.name + '</option>';
				    		else
				    			optionsValue = '<option value="' + item.id + '">' + item.name + '</option>';
				    			 
				    		selectElement.append(optionsValue);
				        });				    	
				} catch(err) {
					alert(err);
				};
		    }
		);
	}
	getAjaxData = function(fieldName,url,inputParams) {
		jQuery.ajax({
          type: 'POST',
          url: url,
          data: inputParams,
          dataType: 'html',
          success: function(data){
             	jQuery("#"+fieldName).html(data);
             	
          },
          error: function(xhr, ajaxOptions, thrownError) {
                              // alert("ERROR: " + xhr.statusText +" " + ajaxOptions+" " +thrownError);
             
          }
      });/*ajax post function*/
	} 




    var placeSearch, autocomplete;
    var component_form = {
        'locality': 'long_name',
        'administrative_area_level_1': 'long_name',
        'country': 'long_name',
    };




    function fillInAddress() {

     var place = autocomplete.getPlace();

      for (var component in component_form) {
        console.debug(component);
        document.getElementById(component).value = "";
        document.getElementById(component).disabled = false;
      }

      for (var j = 0; j < place.address_components.length; j++) {
        var att = place.address_components[j].types[0];

        if (component_form[att]) {
          var val = place.address_components[j][component_form[att]];
          // console.debug("#"+att);
          // console.debug(val);
          // console.debug(jQuery(att).val());
          jQuery("#"+att).val(val);
          if(att=='country'){
            jQuery('#country option').filter(function () {
                   return jQuery(this).text() === val;
                }).attr('selected', true);
          }
        }
      }

        var lat = place.geometry.location.lat();
        var lng = place.geometry.location.lng();
        jQuery("#lat").val(lat);
        jQuery("#lng").val(lng);

    }

    function addVideo(){

        var count = jQuery("#video-container").children().length+1;
        id=0;
        var outerDiv = document.createElement('div');
        outerDiv.setAttribute('class',		'detail_box');
        outerDiv.setAttribute('id',		'detailBox'+count);

        var newLabel = document.createElement('label');
        newLabel.setAttribute("for",		id);
        newLabel.innerHTML="<?php echo JText::_('LNG_VIDEO',true)?>";


        var newInput = document.createElement('textarea');
        newInput.setAttribute('name',		'videos[]');
        newInput.setAttribute('id',			id);
        newInput.setAttribute('class',		'input_txt');


        var img_del		 	= document.createElement('img');
        img_del.setAttribute('src', "<?php echo JURI::root() ."administrator/components/com_jclassifiedsmanager/assets/img/deleteIcon.png"?>");
        img_del.setAttribute('alt', 'Delete option');
        img_del.setAttribute('height', '12px');
        img_del.setAttribute('width', '12px');
        img_del.setAttribute('align', 'left');
        img_del.setAttribute('onclick', 'removeRow("detailBox'+count+'")');
        img_del.setAttribute('style', "cursor: pointer; margin:3px;");

        var clearDiv = document.createElement('div');
        clearDiv.setAttribute('class',		'clear');

        outerDiv.appendChild(newLabel);
        outerDiv.appendChild(newInput);
        outerDiv.appendChild(img_del);
        outerDiv.appendChild(clearDiv);

        var facilityContainer =jQuery("#video-container");
        facilityContainer.append(outerDiv);

        checkNumberOfVideos();
    }
    function removeRow(id){
        jQuery('#'+id).remove();

        checkNumberOfVideos();
    }
    function cancelEdit(){
        jQuery("#createAd").validationEngine('detach');
        window.location="<?php echo JURI::root() ."?option=com_jclassifiedsmanager&view=useraccount"?>";

    }

    function apply(){
        document.getElementById("task").value = "apply";
        if (formValidate(this)) {
            document.getElementById('createAd').submit();
        }
    }

    function checkNumberOfVideos(){
        <?php
            if(isset($appSettings->max_videos))
                $max_videos_nr = $appSettings->max_videos;
            else
                $max_videos_nr = 4;
        ?>

        var nrVideos = jQuery('textarea[name*="videos[]"]').length;

        if(nrVideos < <?php echo $max_videos_nr ?>){
            jQuery("#add-video").show();
        }else{
            jQuery("#add-video").hide();
        }
    }
    function cancelPromotion(){
        jQuery('#promoteAdDiv').hide();
        jQuery('#promoteclassifiedsInfo').show();
        jQuery('#promoteAdDiv :input').attr('disabled', true);
    }

</script>