<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view' );
require_once( JPATH_COMPONENT_SITE.'/models/manageorders.php' );
//require_once 'administrator/components/com_jclassifiedsmanager/helpers/utils.php';
$appSettings = JAdsUtil::getApplicationSettings();
$key= !empty($appSettings->google_map_key)?"&key=".$appSettings->google_map_key: "";
JHTML::_('script', 'https://maps.google.com/maps/api/js?sensor=true&libraries=places'.$key);
JHtml::_('jquery.framework',false);


class JClassifiedsManagerViewEditAd extends JViewLegacy
{

	function display($tpl = null)
	{
		$this->checkUserLoginStatus();
        $model = $this->getModel();
        $this->categories = $model->getParentCategories();
        $this->adTypes = $model->getAllAdTypes();
        $currencies = $model->getAllCurrencies();
        $this->currencies = $currencies;

        $states = JAdsUtil::getAllStates();
        $this->states= $states;
        $userTypes = $model->getAllUserTypes();
        $this->userTypes=$userTypes;

        #get ad details
        $this->adDetails = $model->getAdDetails();

        #get payment plans
        $this->promotionPlans = $model->getActivePromotionPlans();
        $this->ad_id = JFactory::getApplication()->input->get("ad_id",null);
        $this->appSettings = JAdsUtil::getApplicationSettings();
        $this->adUser = $model->getAdUser();

        $this->includePictureFunctions();
        $this->includeMapFunctions();
        $this->includePaymentProcesorsFunctions();
		$function = $this->getLayout();
		if(method_exists($this,$function))
			$tpl = $this->$function();
		parent::display($tpl);
	}

	function adsuccess()
	{
		$tpl="adsuccess";
		return $tpl;
	}
	function activateAd(){
		$tpl="adsuccess";
		return $tpl;
	}
	function ordercompletion()
	{
		$tpl="ordercompletion";
		$modelOrders =  JModelLegacy::getInstance('manageorders','JClassifiedsManagerModel');
		$this->order = $modelOrders->getOrderDetails();
		return $tpl;
	}
	
	function includePictureFunctions(){
		$doc = JFactory::getDocument();
		$appSettings = JAdsUtil::getInstance()->getApplicationSettings();

		require_once JPATH_COMPONENT_SITE.'/imageupload/includes/settings.php';
		require_once JPATH_COMPONENT_SITE."/imageupload/includes/functions.php";
		
		JHTML::_('stylesheet', JURI::root().'/components/com_jclassifiedsmanager/imageupload/css/style.css' );
		JHTML::_('stylesheet', JURI::root().'/components/com_jclassifiedsmanager/imageupload/css/jquery.Jcrop.css' );
		JHTML::_('stylesheet', JURI::root().'/components/com_jclassifiedsmanager/imageupload/fancybox/jquery.fancybox-1.3.4.css' );
		JHTML::_('stylesheet', JURI::root().'/components/com_jclassifiedsmanager/assets/css/validation/validationEngine.jquery.css' );
		JHTML::_('stylesheet', JURI::root().'/components/com_jclassifiedsmanager/assets/css/validation/template.css' );

		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/jquery.blockUI.js");
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/imageupload/js/jquery-ui-1.7.3.custom.min.js");
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/imageupload/js/ajaxupload.3.5.js");
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/imageupload/js/jquery.Jcrop.min.js");
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/imageupload/fancybox/jquery.mousewheel-3.0.4.pack.js");
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/imageupload/fancybox/jquery.fancybox-1.3.4.pack.js");
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/imageupload/js/scrollingcarousel.2.0.min.js");
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/galleria/galleria.min.js");
		
		$tag = JAdsUtil::getJoomlaLanguage();
		
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/validation/languages/jquery.validationEngine-".$tag.".js");
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/validation/jquery.validationEngine.js");
		
		JHTML::_('stylesheet', JURI::root()."/components/com_jclassifiedsmanager/imageupload/css/jquery.hoverscroll.css");
		JHTML::_('stylesheet', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1/themes/smoothness/jquery-ui.css' );
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/imageupload/js/jquery.hoverscroll.js");
		
		

		$max_photonr = $appSettings->max_photos;
		$doc->addScriptDeclaration('
		window.onload = function()	{
			jQuery.noConflict();
		};
		var max_photonr="'.($max_photonr).'";
		'
		);


		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/imageupload/js/jUpload.js");
	}


	function includeMapFunctions(){
		$doc = JFactory::getDocument();
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/map_functions.js");
	}

	function includePaymentProcesorsFunctions(){
		$doc = JFactory::getDocument();
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/payment_processors.js");
	}

	function checkUserLoginStatus(){
		$model = $this->getModel();
		$adId = JFactory::getApplication()->input->get("ad_id",null);
		$app = JFactory::getApplication();
        $msg = '';
		
		if (!JFactory::getUser()->id && $adId!=null){
			JFactory::getApplication()->enqueueMessage(JText::_('LNG_LOGIN_IS_REQUIRED'));
			$return = base64_encode('index.php?option=com_jclassifiedsmanager&controller=editad&view=editad&ad_id='.$adId);
			$app->redirect( JRoute::_( "index.php?option=com_users&view=login&return=".$return), false );
		}
		else if($adId!=null){
			if(!$model->checkUserAd(JFactory::getUser()->id)){
				JFactory::getApplication()->enqueueMessage(JText::_('LNG_UNAUTHORIZED_ACCESS'));
				$app->redirect(JRoute::_("index.php?option=com_jclassifiedsmanager&controller=useraccount&view=useraccount", false ));
			}
		}
	}
	
}