<?php
/**
 * @package    JBusinessDirectory
 * @subpackage  com_jclassifieddirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later; 
 */

defined('_JEXEC') or die;

/**
 * The HTML Menus Menu Menus View.
 *
 * @package    JBusinessDirectory
 * @subpackage  com_jclassifieddirectory

 */
require_once JPATH_COMPONENT_SITE.'/views/jclsview.php';
require_once JPATH_COMPONENT_SITE.'/helpers/helper.php';

class JClassifiedsManagerViewManageBookmarks extends JClassifiedsManagerFrontEndView
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{

		$model = JModelLegacy::getInstance('displayads','JClassifiedsManagerModel');	

		$userTypes = $model->getAllUserTypes();
		$this->userTypes=$userTypes;
		
		#get ads 
		$this->bookmarks = $model->getAllUserBookmarks();
		
		$this->appSettings = JAdsUtil::getApplicationSettings();


		//user profile 
		$profileModel =  JModelLegacy::getInstance('profile','JClassifiedsManagerModel');
		// Get the view data.
		$this->data		= $profileModel->getData();
		$this->form		= $profileModel->getForm();
		$this->state	= $profileModel->getState();
		
		// Check for errors.
		if (count($errors = (array)$this->get('Errors'))) {
			JFactory::getApplication()->enqueueMessage(implode("<br />", $errors), 'error');
			return false;
		}
		
		// Check if a user was found.
		if (!$this->data->id) {
			JFactory::getApplication()->enqueueMessage(JText::_('JERROR_USERS_PROFILE_NOT_FOUND'), 'error');
			return false;
		}
		
		// Check for layout override
		$active = JFactory::getApplication()->getMenu()->getActive();
		if (isset($active->query['layout'])) {
			$this->setLayout($active->query['layout']);
		}

		$this->includeLibraries();
		parent::display($tpl);
	}

	function includeLibraries(){
		$doc = JFactory::getDocument();
		JHTML::_('stylesheet', 'components/com_jclassifiedsmanager/imageupload/css/demo.css' );
		JHTML::_('stylesheet', 'components/com_jclassifiedsmanager/assets/css/jquery-ui.css');
		JHTML::_('script', "components/com_jclassifiedsmanager/assets/js/jquery-ui.js");
		
	}	

}
