<?php /*------------------------------------------------------------------------
# JBusinessDirectory
# author CMSJunkie
# copyright Copyright (C) 2012 cmsjunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.cmsjunkie.com
# Technical Support:  Forum - http://www.cmsjunkie.com/forum/j-classifieddirectory/?p=1
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );

require_once JPATH_COMPONENT_SITE.'/views/jclsview.php';

class JClassifiedsManagerViewManageUserAds extends JClassifiedsManagerFrontEndView
{
	function __construct()
	{
		parent::__construct();
	}
	
	function display($tpl = null)
	{
		JAdsUtil::loginWithRedirect('index.php?option=com_jclassifiedsmanager&view=manageuserads');
		
		$model = JModelLegacy::getInstance('displayads','JClassifiedsManagerModel');
		$this->categories = $model->getParentCategories();
		$this->adTypes = $model->getAllAdTypes();
		
		$currencies = $model->getAllCurrencies();
		$this->currencies = $currencies;
		
		$userTypes = $model->getAllUserTypes();
		$this->userTypes=$userTypes;
		
		#get ads 
		$this->ads = $model->getAllUserAds();	
		
		$this->defaultCurrency = $model->getDefaultCurrency();
		$this->appSettings = JAdsUtil::getApplicationSettings();

		//user profile 
		$profileModel =  JModelLegacy::getInstance('profile','JClassifiedsManagerModel');
		// Get the view data.
		$this->data		= $profileModel->getData();
		$this->form		= $profileModel->getForm();
		$this->state	= $profileModel->getState();
		
		// Check for errors.
		if (count($errors = (array)$this->get('Errors'))) {
			JFactory::getApplication()->enqueueMessage(implode("<br />", $errors), 'error');
			return false;
		}
		
		// Check if a user was found.
		if (!$this->data->id) {
			JFactory::getApplication()->enqueueMessage(JText::_('JERROR_USERS_PROFILE_NOT_FOUND'), 'error');
			return false;
		}
		
		// Check for layout override
		$active = JFactory::getApplication()->getMenu()->getActive();
		if (isset($active->query['layout'])) {
			$this->setLayout($active->query['layout']);
		}
		
		
		//$this->prepareDocument();
		
		$this->includeLibraries();

		parent::display($tpl);
	}

	function includeLibraries(){
		$doc = JFactory::getDocument();
		JHTML::_('stylesheet', 'components/com_jclassifiedsmanager/imageupload/css/demo.css' );
		JHTML::_('stylesheet', 'components/com_jclassifiedsmanager/assets/css/jquery-ui.css');
		JHTML::_('stylesheet', 'components/com_jclassifiedsmanager/assets/css/jcls-style.css');
		JHTML::_('script', "components/com_jclassifiedsmanager/assets/js/jquery-ui.js");
		
	}



}
?>
