<?php

/**
 * @package    com_quix
 * @author     ThemeXpert <info@themexpert.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @since      1.0.0
 */

// No direct access

use QuixNxt\Elements\ElementBag;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;

defined('_JEXEC') or die;

/**
 * Class QuixController
 *
 * @since  1.6
 */
class QuixController extends BaseController
{
    /**
     * Method to display a view.
     *
     * @param  boolean  $cachable  If true, the view output will be cached
     * @param  mixed  $urlparams   An array of safe url parameters and their variable types, for valid values see {@link JFilterInput::clean()}.
     *
     * @return \BaseController This object to support chaining.
     *
     * @throws \Exception
     * @since    1.5
     */
    public function display($cachable = false, $urlparams = false): BaseController
    {
        $app  = Factory::getApplication();
        $user = Factory::getUser();
        /**
         * Set the default view name and format from the Request.
         * Note we are using a_id to avoid collisions with the router and the return page.
         * Frontend is a bit messier than the backend.
         */
        $id     = $this->input->getInt('id');
        $vName  = $this->input->getCmd('view', 'page');
        $format = $this->input->getCmd('format', 'html');
        $this->input->set('view', $vName);

        if ($user->get('id') || $this->input->getMethod() === 'POST') {
            $cachable = false;
        } else {
            $cachable = true;
        }

        // Check for edit form.
        if ($vName === 'form' && ! $this->checkEditId('com_quix.edit.'.$this->input->get('type', 'page'), $id)) {
            // Somehow the person just went to the form - we don't allow that.
            // return JError::raiseError(403, \Joomla\CMS\Language\Text::sprintf('COM_QUIX_UNHELD_ID', $id));
            // directly redirect to task edit
            $url = 'index.php?option=com_quix&task='.$this->input->get('type', 'page').'.edit&id='.$id;
            $app->redirect($url);
        }

        if ($format === 'amp') {
            $free = QuixHelper::isFreeQuix();
            if ($free) {
                $uri = JUri::getInstance();
                $uri->delVar('format');
                $app->redirect($uri->toString());
            }
        }
        // JCH fix for amp format
        QuixFrontendHelper::fixJCH();

        // fixing element icon missing issue for j4&j5 as they use icons from media folder
        // old icons are in library folder that its restricted in j5
        if (JVERSION >= 4) {
            // Prepare elements icon for Joomla4
            QuixHelper::elementIconsForJoomla4();
        }

        return parent::display($cachable, $urlparams);
    }

    /**
     * Method to perform ajax call
     *
     * @return void output, like: json or other format
     * url example: index.php?option=com_quix&task=ajax&element=simple-contact&format=json&method=get
     * @throws \Exception
     * @since    1.3
     * @deprecated  5.0  Will be removed with QuixFrontendHelperAjax::doAjax();
     */
    public function ajax(): void
    {
        QuixFrontendHelperAjax::doAjax();
    }

    /**
     * @throws \Exception
     * @since 2.0.0
     */
    public function updateAjax(): void
    {
        QuixFrontendHelperAjax::updateAjax();
    }

    public function live(): void
    {
        try {
            $app = Factory::getApplication();
            // Check if user token is valid.
            if ( ! JSession::checkToken('get')) {
                $exception = new Exception(\Joomla\CMS\Language\Text::_('JINVALID_TOKEN'));
                echo new JResponseJSON($exception);
                $app->close();
            }
            echo new JResponseJson('Quix');
            $app->close();
        } catch (Exception $e) {
            echo new JResponseJson($e);
        }
    }
}
