<?php
/**
 * @package    com_quix
 * @author     ThemeXpert <info@themexpert.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @version    3.0.0
 */

// No direct access
use QuixNxt\Utils\Asset;
use QuixNxt\Utils\Schema;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
//use ;

\Joomla\CMS\HTML\HTMLHelper::_('jquery.framework');
\Joomla\CMS\HTML\HTMLHelper::_('behavior.formvalidator');

$languageFilePath = JPATH_SITE . '/language/en-GB/en-GB.com_quix.builder.ini';

if (file_exists($languageFilePath)) {
  $iniArray = parse_ini_file($languageFilePath);
  foreach ($iniArray as $key => $value) {
     Text::script($key);
  }
} else {
  echo '<script>console.error("Language file not found")</script>';
}

$params = ComponentHelper::getParams('com_quix');
$enable_alternate_page = boolval($params->get('enable_alternate_page', false));

if($enable_alternate_page) {
  $alternate_page_id = $params->get('alternate_page_id', false);
  $this->iframeUrl = $this->iframeUrl . '&Itemid='. $alternate_page_id;
}

$data         = QuixFrontendHelperAssets::processDataForBuilder($this->item->data, $this->item->builder_version);
$qx_elements  = Schema::getAvailableElements();
$dataDebug    = QUIXNXT_DEBUG ? 'true' : 'false';
$root         = JUri::root();
$config       = ComponentHelper::getParams('com_media');
$imagePath    = $config->get('image_path', 'images');
$jmediaPath   = $root.$imagePath;
$version      = QuixAppHelper::getQuixMediaVersion();
$enable_seo   = boolval($params->get('enable_seo', 0));
$session      = Factory::getSession();
$status       = $session->get('guide-quix-builder', 'show');
$title        = JFilterOutput::stringURLSafe($this->item->title);
$actionUrl    = 'index.php?option=com_quix&view=form&layout=edit&builder=frontend&id='.(int) $this->item->id;

$assetManager = new QuixHelperAsset();
$script_assets = [
  'quixnxt.edit' => '/js/edit.js',
  'quixnxt.assets-helper' => '/js/assets-helper.js',
  'quixnxt.builder.vendor' => '/builder/vendor.js',
  'quixnxt.qxfb' => '/js/qxfb.js',
];
$css_assets = [
  'quixnxt.quix-builder' => '/css/quix-builder.css',
  'quixnxt.qxi' => '/css/qxi.css',
  'quixnxt.qxicon' => '/css/qxicon.css',
];
$assetManager->loadAssets($css_assets, $script_assets);
$assetManager->inlineScript("window.QUIX_PAGE = $data");
$assetManager->inlineScript("window.qx_elements = $qx_elements");

QuixHelper::setComponentParams('guide-quix-builder', 'hide');
QuixFrontendHelperAssets::prepareApiScript();
QuixFrontendHelperAssets::loadLiveBuilderAssets();

echo "<script id='qx-theme-script' defer>
      // RUN THIS SCRIPT AS SOON AS THE PAGE LOADS TO SET THE THEME
      (() => {
        const theme = localStorage.getItem('qx-theme');
        if(theme) document.querySelector('html')?.setAttribute('data-theme', theme);
      })()
      </script>";
?>
  <!--load twig template and declare them as script-->
<?php echo $this->loadTemplate('modal'); ?>
  <script id="qx-builder-configs">
      const JVERSION = "<?php echo JVERSION ?>";
      const QuixPageAlias = "<?php echo $title ?>";
      window.QUIXNXT_DEBUG = "<?php echo $dataDebug ?>" === "true";
      window.QUIX_ROOT_URL = "<?php echo $root ?>";
      window.QUIX_IFRAME_URL = "<?php echo $this->iframeUrl ?>";
      window.QUIXNXT_JMEDIA_PATH_URL = "<?php echo $jmediaPath ?>";
      window.QUIX_GDPR_COMPLIANCE = Boolean(<?php echo QUIX_GDPR_COMPLIANCE ?>);
      window.QUIX_SHAPES = <?php echo file_get_contents(JPATH_SITE . '/media/quixnxt/json/shapes.json') ?>;
      window.ENABLE_SEO = Boolean(<?php echo $enable_seo ?>);
      window.addEventListener('load', function() {
        var qxAlerts = qxAlerts ?? [];
        qxAlerts.map(item => qxUIkit.modal.alert(item));
        qxAlerts = [];
      });
  </script>
  <form
          action="<?php echo \Joomla\CMS\Router\Route::_($actionUrl); ?>" method="post" enctype="multipart/form-data"
          name="adminForm" id="adminForm" class="qx-fb form-validate">

    <div class="qx-fb-frame">
        <div id="qx-fb-frame-toolbar">
          <div class="qx-skeleton-toolbar">

            <div>
              <div style="width: 55px; height: 28px" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
              <div style="width: 70px" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
              <div style="width: 70px" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
              <div style="width: 70px" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
              <div style="width: 70px" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
            </div>

            <div>
              <div style="width: 100px; height: 25px;" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
              <div style="width: 50px; height: 25px;" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
              <div style="width: 50px; height: 25px;" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
              <div style="width: 50px; height: 25px;" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
            </div>

            <div>
<!--               TODO: Turn off the seo panel to see if any client complains-->
<!--              <div style="width: 100px" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>-->
              <div style="width: 100px" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
              <div style="width: 100px" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
              <div style="width: 85px; height: 30px" class="qx-skeleton qx-skeleton-toolbar-btn">button</div>
             </div>

          </div>
        </div>

        <div class="qx-fb-frame-body-container">

          <!--LEFT SIDE BAR-->
            <aside id="qx-left-side-bar" class="qx-side-bar qx-side-bar--left">
                <div style="display: flex; justify-content: space-between; padding-inline: 15px;  padding-bottom: 10px" class="qx-skeleton-sidebar-title">
                  <div style="width: 130px; border-radius: 4px; " class="qx-skeleton">Sidebar Title</div>
                  <div style="width: 30px; border-radius: 4px; " class="qx-skeleton">btn</div>
                </div>
                <div class="qx-skeleton-layer">
                  <div class="qx-skeleton-layer-expand-btn">
                    <span class="qx-skeleton">Expand All</span>
                    <span class="qx-skeleton">BTN</span>
                  </div>
                  <div class="qx-skeleton qx-skeleton-layer-item">Layer Item 1</div>
                  <div class="qx-skeleton qx-skeleton-layer-item">Layer Item 2</div>
                  <div class="qx-skeleton qx-skeleton-layer-item">Layer Item 3</div>
                  <div class="qx-skeleton qx-skeleton-layer-item">Layer Item 4</div>
                  <div class="qx-skeleton qx-skeleton-layer-item">Layer Item 4</div>
                  <div class="qx-skeleton qx-skeleton-layer-item">Layer Item 4</div>
                  <div class="qx-skeleton qx-skeleton-layer-item">Layer Item 4</div>
                  <div class="qx-skeleton qx-skeleton-layer-item">Layer Item 4</div>
                </div>
              </aside>

            <!--PREVIEW SECTION-->
              <div style="width: 100%" id="qxui-preview-content" class="qx-fb-frame-preview qx-width-viewport qx-flex qx-margin-auto">
              </div>

              <!--RIGHT SIDE BAR-->
              <aside id="qx-right-side-bar" class="qx-side-bar qx-side-bar--right">
                  <div class="qx-skeleton-sidebar-title"><p class="qx-skeleton">Sidebar Title</p></div>
                  <div class="qx-skeleton-settings-segments">
                    <div class="qx-skeleton">Segment item 1</div>
                    <div class="qx-skeleton">Segment item 2</div>
                    <div class="qx-skeleton">Segment item 3</div>
                  </div>
                  <div class="qx-skeleton-settings">
                    <div class="qx-skeleton-settings-item">
                      <div style="height: 20px; width: 135px;" class="qx-skeleton">Label</div>
                      <div style="height: 20px; width: 35px;" class="qx-skeleton">btn</div>
                    </div>
                    <div class="qx-skeleton-settings-item">
                      <div class="qx-skeleton">Label</div>
                      <div class="qx-skeleton">Field</div>
                    </div>
                    <div class="qx-skeleton-settings-item">
                      <div class="qx-skeleton">Label</div>
                      <div class="qx-skeleton">Field</div>
                    </div>
                    <div class="qx-skeleton-settings-item">
                      <div class="qx-skeleton">Label</div>
                      <div class="qx-skeleton">Field</div>
                    </div>
                    <div class="qx-skeleton-settings-item">
                      <div class="qx-skeleton">Label</div>
                      <div class="qx-skeleton">Field</div>
                    </div>
                    <div class="qx-skeleton-settings-item">
                      <div class="qx-skeleton">Label</div>
                      <div class="qx-skeleton">Field</div>
                    </div>
                  </div>
              </aside>
        </div>

    </div>

    <input type="hidden" name="jform[data]" id="jform_data" value="" />
    <input type="hidden" name="jform[id]" id="jform_id" value="<?php echo (int) $this->item->id; ?>" />
    <input type="hidden" name="jform[title]" id="jform_title_hidden" value="<?php echo $this->item->title; ?>" />
    <input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />
    <input type="hidden" id="jform_Itemid" value="<?php echo $this->Itemid; ?>" />
    <input type="hidden" name="jform[created_by]"
           value="<?php echo $this->item->created_by || Factory::getUser()->id; ?>" />
    <input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />
    <input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />
    <input type="hidden" id="jform_task" name="task" value="" />
    <input type="hidden" id="jform_type" name="type" value="<?php echo $this->type ?>" />
    <input type="hidden" id="return_url" name="return" value="<?php echo $this->return_page; ?>" />

      <?php if (isset($this->item->type)) : ?>
        <input type="hidden" id="jform_template_type" name="jform[type]" value="<?php echo $this->item->type ?>" />
      <?php endif; ?>
    <input type="hidden" id="jform_builder_version" name="jform[builder_version]"
           value="<?php echo $this->item->builder_version ?>" />
    <input type="hidden" id="jform_token" name="<?php echo JSession::getFormToken(); ?>" value="1" />


      <?php echo $this->loadTemplate('options'); ?>
  </form>

  <iframe
          title="q-store"
          data-src="https://getquix.net/media/quixblocks/js/qstore.html" id="q-store" style="display: none;"></iframe>

  <script>
      setTimeout(function() {
          document.getElementById('q-store').src = document.getElementById('q-store').attributes['data-src'].value;
      }, 5000);
  </script>


<style>
    #qx-fb-frame-toolbar .qx-fb-toolbar__logo{
        background: url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/images/quix-logo.png') 7px 7px no-repeat;
    }
@font-face {
    font-family: 'qxi';
    font-display: swap;
    src: url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxi.ttf?cdywht') format('truetype'),
         url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxi.woff?cdywht') format('woff');
    font-weight: normal;
    font-style: normal;
}
@font-face {
    font-family: 'qxuicon';
    font-display: swap;
    src:
        url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxicon.ttf?a4jeee') format('truetype'),
        url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxicon.woff?a4jeee') format('woff'),
        url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxicon.svg?a4jeee#qxicon') format('svg');
    font-weight: normal;
    font-style: normal;
}
@font-face {
    font-family: 'qxuicon';
    font-display: swap;
    src:
        url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxicon.ttf?a4jeee') format('truetype'),
        url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxicon.woff?a4jeee') format('woff'),
        url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxicon.svg?a4jeee#qxicon') format('svg');
    font-weight: normal;
    font-style: normal;
}
@font-face {
    font-family: 'qxuicon';
    font-display: swap;
    src:
        url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxicon.ttf?a4jeee') format('truetype'),
        url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxicon.woff?a4jeee') format('woff'),
        url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxicon.svg?a4jeee#qxicon') format('svg');
    font-weight: normal;
    font-style: normal;
}
</style>
