<?php

/**
 * @package    com_quix
 * @author     ThemeXpert <info@themexpert.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @version    1.8.0
 */

defined('_JEXEC') or die;

use Joomla\CMS\Uri\Uri;

\Joomla\CMS\HTML\HTMLHelper::_('jquery.framework');

$assetManager = new QuixHelperAsset();

$css_assets = [
  'quixnxt.qxi' => '/css/qxi.css',
  'quixnxt.qxicon' => '/css/qxicon.css',
  'quixnxt.quix-elements' => '/css/quix-elements.css',
  'quixnxt.quix-core' => '/css/quix-core.css',
  'quixnxt.quix-builder' => '/css/quix-builder.css',
];
$script_assets = [
  'quixnxt.quix' => '/js/quix.js',
  'quixnxt.iframe' => '/js/iframe.js',
  'quixnxt.qxkit' => '/js/qxkit.js',
];
$assetManager->loadAssets($css_assets, $script_assets);
$assetManager->inlineScript('var quix = ' . json_encode(['url' => QUIXNXT_SITE_URL, 'version' => QUIXNXT_VERSION]) . ';');

?>
<link rel="preconnect" href="https://fonts.gstatic.com">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://ajax.googleapis.com">

<div class="qx-fb-frame">

  <div class="app-mount qx quix">
    <div id="qx-fb-mount"></div>
  </div>
</div>

<!--iframe inside assets fix-->


<?php if (!QUIX_GDPR_COMPLIANCE): ?>
<script src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js" type="text/javascript" defer></script>
<?php endif; ?>

<style>
    @font-face {
        font-family: 'qxi';
        font-display: swap;
        src: url('<?php echo Uri::root();?>media/quixnxt/fonts/qxi.ttf?cdywht') format('truetype'),
        url('<?php echo Uri::root();?>media/quixnxt/fonts/qxi.woff?cdywht') format('woff');
        font-weight: normal;
        font-style: normal;
    }
    @font-face {
        font-family: 'qxuicon';
        font-display: swap;
        src:
            url('<?php echo Uri::root();?>media/quixnxt/fonts/qxicon.ttf?a4jeee') format('truetype'),
            url('<?php echo Uri::root();?>media/quixnxt/fonts/qxicon.woff?a4jeee') format('woff'),
            url('<?php echo Uri::root();?>media/quixnxt/fonts/qxicon.svg?a4jeee#qxicon') format('svg');
        font-weight: normal;
        font-style: normal;
    }
</style>
