<?php 
/**
 * @package		PaidSystem
 * @copyright	Copyright (C) 2010-2014 Juloa.com. All rights reserved.
 *  @license GNU General Public License version 3, or later
 */
class AdsManagerCascadePlugin {

	var $_db;
	
	public function getListDisplay($content,$field)
	{
		return AdsManagerCascadePlugin::getDetailsDisplay($content,$field,$mode="list");
	}

	public function getDetailsDisplay($content,$field,$mode="details")
	{
		$fieldname = $field->name;
		$value = $content->$fieldname;
		
		$options = $field->options;
		$values = array();
		if ($options != null) {
			if ($options->values_storage_type == "internal") {
				if (isset($options->values)) {
					$values = $options->values;
				}
			} else if ($options->values_storage_type == "db") {
				$dbname = $options->db_storage_db_name;
				$name = $options->db_storage_column_name;
				$valuecolumn = $options->db_storage_column_value;
				$sql = "SELECT `$name` as label,`$valuecolumn` as value FROM $dbname WHERE $valuecolumn = ".$this->_db->Quote($value);
				//echo $sql;
				$this->_db->setQuery($sql);
				$values = $this->_db->loadObjectList();
			}
		}
		$vs = array();
		foreach($values as $val) {
			if ($val->value == $value)
				return JText::_($val->label);
		}
		return "";
	}
	
	public function onAjax() 
	{
		$fieldid = JRequest::getInt('fieldid',0);
		if ($fieldid ==0)
			return;
		
		$this->_db->setQuery("SELECT options FROM #__adsmanager_fields WHERE fieldid=".(int)$fieldid);
		$options = $this->_db->loadResult();
		//var_dump($options);
		if ($options != null) {
			$options = json_decode($options);
			if ($options == null)
				return;
			if ($options->parentfield == "")
				return;
			
			$parentvalue = JRequest::getVar($options->parentfield,null);
			if ($parentvalue === null) {
				$parentvalue = JRequest::getVar("f".$options->parentfield,null);
				if ($parentvalue === null) {
					return null;
				}
			}
			$values = array();

			if ($options->values_storage_type == "internal") {
				if (isset($options->values)) {
					foreach($options->values as $v) {
                        if($v->parent == $parentvalue)
                           $values[] = $v;
                    }
				}
			} else if ($options->values_storage_type == "db") {
				$dbname = $options->db_storage_db_name;
				$name = $options->db_storage_column_name;
				$value = $options->db_storage_column_value;
				$parent = $options->db_storage_column_parent_value;
				$sql = "SELECT `$name` as label,`$value` as value,`$parent` as parent FROM $dbname WHERE $parent = ".$this->_db->Quote($parentvalue)." ORDER BY $name ASC";
				//echo $sql;
				$this->_db->setQuery($sql);
				$values = $this->_db->loadObjectList();
				
				/*$list = array();
				foreach($values as $v) {
					$list[] = $v->id;
				}*/
				
				//$sql = "SELECT geoid,name FROM geonames WHERE geoid IN (".implode(',',$list).") AND lang='fr'";
				//echo $sql;
				//$this->_db->setQuery($sql);
				//$trad = $this->_db->loadObjectList("geoid");				

			}
			$results = array();
            $label = JText::_('ADSMANAGER_SELECT_CASCADE');
			$results[] = array("value"=>"","label"=>$label);
			foreach($values as $v) {
				//if (isset($trad[$v->value])) {
				//	$results[$v->value] = $trad[$v->value];
				//} else {
					//$results[$v->value] = $v->label;//JText::_($v->label);
					$results[] = array("value"=>$v->value,"label"=>JText::_($v->label));
				//}
			}
			echo json_encode($results);
		}
	}
	
	private function getValues($options) {
		$values = array();
		if ($options != null) {
			if (@$options->ajax != 1) {
				if (@$options->values_storage_type == "internal") {
					if (isset($options->values)) {
						$values = $options->values;
					}
				} else if (@$options->values_storage_type == "db") {
					$dbname = $options->db_storage_db_name;
					$name = $options->db_storage_column_name;
					$value = $options->db_storage_column_value;
					$parent = $options->db_storage_column_parent_value;
					$sql = "SELECT `$name` as label,`$value` as value,`$parent` as parent FROM $dbname";
					//echo $sql;
					$this->_db->setQuery($sql);
					$values = $this->_db->loadObjectList();
				}
			}
		}
		foreach($values as $key =>  $val) {
			$values[$key]->label = htmlspecialchars(JText::_($val->label));
		}
		return $values;
	}
	
	
	protected function getForm($content,$field,$search=0) {
		$document	= JFactory::getDocument();
		$document->addScript(JURI::root()."components/com_adsmanager/js/jquery.chained.js");
		
		$options = $field->options;
		$values = $this->getValues($options);
		
		$fieldname = $field->name;
		
		$currentval = "";
		if (isset($content->$fieldname) && $fieldname != "") {
			$currentval = $content->$fieldname;
		}
		ob_start();
		
		$unique = $field->name."_".rand();
		if ($search == 0 && $field->required == 1)
			$mosReq = "required";
		else
			$mosReq = "";
		?>
        <select id="f<?php echo $field->name?>" <?php echo $mosReq?> class="form-control <?php echo $unique?>" name="<?php echo $field->name?>">
            <?php if ($search == 1 || $currentval == "") {?>
            <option value="" ><?php echo JText::_('ADSMANAGER_SELECT_CASCADE'); ?></option>
            <?php } ?>
            <?php if (@$options->ajax != 1) {?>
            <?php foreach($values as $val) {
            if ($currentval == $val->value) $selected = 'selected="selected"';else $selected = '';
            $val->parent = str_replace(',',' ',$val->parent);
            ?>
            <option <?php echo $selected;?> value="<?php echo htmlspecialchars($val->value)?>" class="<?php echo htmlspecialchars($val->parent)?>"><?php echo htmlspecialchars($val->label)?></option>
            <?php } ?>
            <?php } ?>
        </select>
        <script type="text/javascript">
        <?php if ($options != null && $options->parentfield != "") { ?>
        jQ(document).ready(function() {
            parentfield = jQ(".<?php echo $unique?>").closest('form').find("#f<?php echo $options->parentfield?>");
            <?php if (@$options->ajax == 1) {?>
            jQ(".<?php echo $unique?>").remoteChained(parentfield,"<?php echo JURI::root()."images/com_adsmanager/plugins/cascade/plug.php?fieldid=".$field->fieldid?>",
                                                                {defaultvalue:<?php echo json_encode($currentval)?>});
            <?php } else {?>
            jQ(".<?php echo $unique?>").chained(parentfield);
            <?php } ?>
        });
        <?php } ?>
        </script>
		<?php 
		$content = ob_get_contents();
		ob_end_clean();
		return $content;
		
	}
	
	
	public function getSearchFormDisplay($content,$field) {
		return $this->getForm($content,$field,1);
	}

	public function getFormDisplay($content,$field,$default=null)
	{
		return $this->getForm($content,$field,0);	
	}

	public function onFormSave($content,$field)
	{
		$value = JRequest::getVar($field->name,"");
		return $value;
	}
	
	public function onDelete($directory,$contentid = -1)
	{
	}
	
	public function getEditFieldJavaScriptDisable()
	{
		$return =  " jQ('#divCascadeOptions').hide();\n";
		//$return .= " jQ('#divCascadeOptions input').attr('mosReq',0);";
		return $return;
	}
	
	public function getEditFieldJavaScriptActive()
	{
       	$return = " disableAll();";
       	$return .= " jQ('#divCascadeOptions').show();\n";
       	//$return .= " jQ('#divCascadeOptions input').attr('mosReq',1);";
		return $return; 
	}

	public function getEditFieldOptions($fieldid)
	{
		$this->_db->setQuery("SELECT options FROM #__adsmanager_fields WHERE fieldid = '$fieldid'");
		$options = $this->_db->loadResult();
		
		$options = json_decode($options);
		if ($options == null)
			$options = new stdClass();
			
		$values = array();
		if (isset($options->values)) {
			$values = $options->values;	
		}	
		
		foreach($values as $val) {
			$val->label = htmlspecialchars(JText::_($val->label));	
		}
		ob_start();
		if (!isset($options->values_storage_type)) {
			$options->values_storage_type="internal";
		}
		if (!isset($options->ajax)) {
			$options->ajax=0;
		}
		?>
		<div id='divCascadeOptions'>
			<?php echo JText::_('ADSMANAGER_PARENT_FIELD_NAME')?> <input type="text" name="options_cascade_parentfield" value="<?php echo @$options->parentfield ?>" /><br/><br/>
			<?php echo JText::_('ADSMANAGER_USE_AJAX')?>
			<input type="radio" name="options_cascade_ajax" value="1" <?php if ($options->ajax == "1") echo "checked='checked'";?> /><?php echo JText::_('ADSMANAGER_YES')?>&nbsp;
			<input type="radio" name="options_cascade_ajax" value="0" <?php if ($options->ajax == "0") echo "checked='checked'";?> /><?php echo JText::_('ADSMANAGER_NO')?><br/><br/>
			<input type="radio" name="options_cascade_values_storage_type" value="internal" <?php if ($options->values_storage_type == "internal") echo "checked='checked'";?> /><?php echo JText::_('ADSMANAGER_VALUES_STORAGE_TYPE_INTERNAL')?>&nbsp;
			<input type="radio" name="options_cascade_values_storage_type" value="db" <?php if ($options->values_storage_type == "db") echo "checked='checked'";?> /><?php echo JText::_('ADSMANAGER_VALUES_STORAGE_TYPE_EXTERNAL')?><br/><br/>
			<div class="cascade_storage_values" id="cascade_storage_values_internal">
			<input type="button" id="addcascadevalue" class="button btn" value="<?php echo JText::_('ADSMANAGER_ADD_FIELD_VALUE')?>" /><br/>
			<ul id="values">
				<li class="ui-state-disabled"> 
					<span id='empty'>&nbsp;</span> 
					<input type="text" name="cascadelabels[]" value="<?php echo JText::_('ADSMANAGER_FIELD_VALUE_NAME');?>"/> 
					<input type="text" name="cascadevalues[]" value="<?php echo JText::_('ADSMANAGER_FIELD_VALUE_VALUE');?>"/> 
					<input type="text" name="cascadeparents[]" value="<?php echo JText::_('ADSMANAGER_FIELD_VALUE_PARENT');?>"/> 
				</li>
			</ul>
			</div>
			<div class="cascade_storage_values" id="cascade_storage_values_db">
			<?php echo JText::_('ADSMANAGER_DB_STORAGE_DB_NAME')?> <input type="text" name="options_cascade_db_storage_db_name" value="<?php echo @$options->db_storage_db_name ?>" /><br/>
			<?php echo JText::_('ADSMANAGER_DB_STORAGE_COLUMN_NAME')?> <input type="text" name="options_cascade_db_storage_column_name" value="<?php echo @$options->db_storage_column_name ?>" /><br/>
			<?php echo JText::_('ADSMANAGER_DB_STORAGE_COLUMN_VALUE')?> <input type="text" name="options_cascade_db_storage_column_value" value="<?php echo @$options->db_storage_column_value ?>" /><br/>
			<?php echo JText::_('ADSMANAGER_DB_STORAGE_COLUMN_PARENT_VALUE')?> <input type="text" name="options_cascade_db_storage_column_parent_value" value="<?php echo @$options->db_storage_column_parent_value ?>" /><br/>
			</div>
		</div>
		<style>
		#divCascadeOptions ul { list-style-type: none; margin: 0; padding: 0; width: 85%; }
		#divCascadeOptions #values li { margin: 0 3px 3px 3px; padding: 0.4em; padding-left: 1.5em; font-size: 1.4em; height: 18px; }
                #divCascadeOptions #values li input { width: 26%; }
		#divCascadeOptions #values li span.ui-icon-arrowthick-2-n-s { position: absolute; margin-left: -1.3em; }
		#divCascadeOptions #values li span.ui-icon-cancel { float:right }
		#divCascadeOptions #empty { position: absolute; margin-left: -1.3em; }
		
		</style>
		<script type="text/javascript">
		function addFieldValue(label,value,parent) {
			data = '<li class="ui-state-default"> \
				<span class="ui-icon ui-icon-arrowthick-2-n-s"></span> \
				<input type="text" name="cascadelabels[]" value="'+label+'"/> \
				<input type="text" name="cascadevalues[]" value="'+value+'"/> \
				<input type="text" name="cascadeparents[]" value="'+parent+'"/> \
				<span class="ui-icon ui-icon-cancel"></span> \
				</li>';
			jQ('#divCascadeOptions  #values').append(data);
		}
		values = <?php echo json_encode($values); ?>;
		for(i=0;i<values.length;i++) {
			addFieldValue(values[i]["label"],values[i]["value"],values[i]["parent"]);
		}
		if (values.length == 0) {
			for(i=0;i<4;i++) {
				addFieldValue("","","");
			}
		}
		jQ(function() {
			jQ( "#divCascadeOptions li.ui-state-disabled input").attr('disabled','disabled');
			jQ( "#divCascadeOptions #values" ).sortable({items: "li:not(.ui-state-disabled)"});
			jQ( "#divCascadeOptions #addcascadevalue" ).click(function() {
				addFieldValue("","","");});
			jQ( "#divCascadeOptions").on("click", ".ui-icon-cancel",function() {
				jQ(this).parent().remove();
			});
			
			jQ('input[name=options_cascade_values_storage_type]:radio').change(function() {
				jQ(".cascade_storage_values").hide();
				val = jQ('input[name=options_cascade_values_storage_type]:radio:checked').val();
				jQ("#cascade_storage_values_"+val).show();
			});
			jQ(".cascade_storage_values").hide();
			jQ("#cascade_storage_values_<?php echo $options->values_storage_type?>").show();
		});
		</script>
		
		<?php
		$return = ob_get_contents();
		ob_end_clean();
		return $return;
	}

	public function saveFieldOptions($field)
	{
		$this->install();
		
		$fieldLabels  = JRequest::getVar('cascadelabels',array());
		$fieldValues = JRequest::getVar('cascadevalues',array());
		$fieldParents = JRequest::getVar('cascadeparents',array());
		
		$values = array();
		foreach($fieldLabels as $key => $label) {
			$value = $fieldValues[$key];
			$parent = $fieldParents[$key];
			if (($label != "")&&($value != "")&&($parent != "")) {
				$values[] = array("label"=>$label,"value"=>$value,"parent"=>$parent);
			}
		}
		
		$options = array();
		$options["values"] = $values;
		return $options;
	}
	
	public function getFieldName()
	{
		return "Cascade";
	}
	
	public function install()
	{
	}
	
	public function uninstall()
	{	
	}
	
	public function __construct()
	{
		$db	= JFactory::getDBO();
		$this->_db = $db;
	}
}
if (!defined('_JEXEC')) {
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: Accept, Authorization, Content-Type');
	header('Access-Control-Allow-Methods: POST, GET');
	
	// respond to preflights
	if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
		exit;
	}

	//Load Framework
	define( '_JEXEC', 1 );
	
	define('JPATH_BASE', dirname(__FILE__).'/../../../../' );
	
	//define('JPATH_BASE','/var/www/joomla25' );
	define( 'DS', DIRECTORY_SEPARATOR );
	require_once ( JPATH_BASE .DS.'includes'.DS.'defines.php' );
	require_once ( JPATH_BASE .DS.'includes'.DS.'framework.php' );
	$mainframe = JFactory::getApplication('site');
	$mainframe->initialise();
	$plugin = new AdsManagerCascadePlugin();
	define('URLBASE',str_replace('images/com_adsmanager/plugins/cascade/','',JURI::base()));
	echo $plugin->onAjax();
} else {
	define('URLBASE',JURI::base());
	require_once(JPATH_ROOT."/components/com_adsmanager/lib/core.php");
	$plugins["cascade"] = new AdsManagerCascadePlugin();
}