<?php
/**
 * @package		AdsManager
 * @copyright	Copyright (C) 2010-2014 Juloa.com. All rights reserved.
 *  @license GNU General Public License version 3, or later
 */

defined('_JEXEC') or die('Restricted access');

class AdsManagerCustomcodePlugin {

	var $_db;
	
	public function getListDisplay($content,$field)
	{
		return AdsManagerCustomcodePlugin::getDetailsDisplay($content,$field,$mode="list");
	}

	public function getDetailsDisplay($content,$field,$mode="details")
	{
		$fieldname = $field->name;
		$options = $field->options;
		
		ob_start();
        ?>
            <?php echo $options->detailsview; ?>
        <?php
        $content = ob_get_contents();
		ob_end_clean();
		return $content;
	}


	function needStorage() {
		return false;
	}

	public function getFormDisplay($content,$field,$default=null)
	{
		$options = $field->options;
	
		$fieldname = $field->name;
		ob_start();
        ?>
            <?php echo $options->editview; ?>
        <?php
        $content = ob_get_contents();
		ob_end_clean();
		return $content;
	}

	public function onFormSave($content,$field)
	{
		return null;
	}
	
	public function onDelete($directory,$contentid = -1)
	{
	}
	
	public function getEditFieldJavaScriptDisable()
	{
		$return = "elem=getObject('divCustomcodeOptions');";
        $return .= "elem.style.visibility = 'hidden';";
		$return .= "elem.style.display = 'none';";
		$return .= "elem=getObject('edit_view_customcode');";
		$return .= "elem.setAttribute('mosReq',0);";
		$return .= "elem=getObject('details_view_customcode');";
		$return .= "elem.setAttribute('mosReq',0);";
		return $return;
	}
	
	public function getEditFieldJavaScriptActive()
	{
       	$return = "disableAll();";
		$return .= "elem=getObject('divCustomcodeOptions');";
        $return .= "elem.style.visibility = 'visible';";
        $return .= "elem.style.display = 'block';";
		$return .= "elem=getObject('edit_view_customcode');";
		$return .= "elem.setAttribute('mosReq',1);";
		$return .= "elem=getObject('details_view_customcode');";
		$return .= "elem.setAttribute('mosReq',1);";
		return $return;
	}

	public function getEditFieldOptions($fieldid)
	{
		$this->install();
		$this->_db->setQuery("SELECT * FROM #__adsmanager_fields WHERE fieldid = '$fieldid'");
		$row = $this->_db->loadObject();
        if($row != null)
            $rowOptions = json_decode($row->options);
       
		$return = "<div id='divCustomcodeOptions'>";
		$return .= "<table class='adminform'>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Edit view custom code</td>";
		$return .= "<td width='20%' align=left><textarea cols='40' rows='10' id='edit_view_customcode' name='customcode_editview' mosReq=1 mosLabel='Edit view custom code' class='inputbox' >".@$rowOptions->editview."</textarea></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Details and List view custom code</td>";
		$return .= "<td width='20%' align=left><textarea cols='40' rows='10' id='details_view_customcode' name='customcode_detailsview' mosReq=1 mosLabel='Details and list view custom code' class='inputbox' >".@$rowOptions->detailsview."</textarea></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "</table>";
		$return .= "</div>";
		return $return;
	}

	public function saveFieldOptions($field)
	{
		$editview = JRequest::getVar('customcode_editview','','string','none',JREQUEST_ALLOWRAW);
        $detailsview = JRequest::getVar('customcode_detailsview','','string','none',JREQUEST_ALLOWRAW);
        
        $options = array();
        $options['editview'] = $editview;
        $options['detailsview'] = $detailsview;
        
        return $options;
	}
	
	public function getFieldName()
	{
		return "Customcode";
	}
	
	public function install()
	{
	}
	
	public function uninstall()
	{	
	}
	
	public function __construct()
	{
		$db	= JFactory::getDBO();
		$this->_db = $db;
	}
}
require_once(JPATH_ROOT."/components/com_adsmanager/lib/core.php");
$plugins["customcode"] = new AdsManagerCustomcodePlugin();