<?php
/**
 * @package		PaidSystem
 * @copyright	Copyright (C) 2010-2014 Juloa.com. All rights reserved.
 *  @license GNU General Public License version 3, or later
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

require_once(JPATH_ROOT."/components/com_adsmanager/lib/core.php");

class AdsManagerGmapPlugin {

	var $_db;
	
	function getListDisplay($content,$field)
	{
		$faddress = $field->name."_address";
		return @$content->$faddress;
	}
	
	function needStorage() {
		return false;
	}

	function getDetailsDisplay($content,$field,$mode="details")
	{
		$flat = $field->name."_lat";
		$flng = $field->name."_lng";
		$fzoom = $field->name."_zoom";
		$fhide = $field->name."_hide";
		$faddress = $field->name."_address";
		
		$contentid = $content->id;

		$fieldid = $field->fieldid;
		if (($content)&&($content->$flat)&&($content->$flng)&&(@$content->$fhide != 1))
		{
			$lat = (float)$content->$flat;
			$lng = (float)$content->$flng;
			$zoom = (int)@$content->$fzoom;
			$address = @$content->$faddress;
			if ($zoom == null) {
				$zoom=8;
			}
			
			
			$this->_db->setQuery("SELECT * FROM #__adsmanager_fieldgmap_conf WHERE fieldid = ".(int)$field->fieldid);
			$conf = $this->_db->loadObject();
			
			if ($mode == "details") {
				$map_width = $conf->map_width;//500;
				$map_height= $conf->map_height;//300;
			} else {
				if ($conf->list_map_width != '') {
					$map_width = $conf->list_map_width;
					$map_height= $conf->list_map_height;
				} else {
					$map_width = $conf->map_width;//500;
					$map_height= $conf->map_height;//300;
				}
			}
			
			$google_key = $conf->google_key;
			ob_start();?>
			<script type="text/javascript"
			    src="https://maps.googleapis.com/maps/api/js?key=<?php echo $google_key;?>&sensor=false">
			</script>
			<script type="text/javascript">
			  var geocoder<?php echo $contentid."_".$fieldid ?>;
		          var map<?php echo $contentid."_".$fieldid ?>;
		          var marker<?php echo $contentid."_".$fieldid ?>;
			  
		         function initializemap<?php echo $contentid."_".$fieldid ?>() {
			    geocoder<?php echo $contentid."_".$fieldid ?> = new google.maps.Geocoder();
			    var latlng = new google.maps.LatLng(<?php echo json_encode($lat) ?>, <?php echo json_encode($lng) ?>);
			    var myOptions = {
			      zoom: <?php echo $zoom ?>,
			      center: latlng,
				  scaleControl: false,
				  draggable: false,
				  scrollwheel: false,
			      mapTypeId: google.maps.MapTypeId.ROADMAP
			    };
			    map<?php echo $contentid."_".$fieldid ?> = new google.maps.Map(document.getElementById("map_canvas<?php echo $contentid."_".$fieldid ?>"),
				myOptions);
		            marker<?php echo $contentid."_".$fieldid ?> = new google.maps.Marker({
				    position: latlng,
				    title: '',
				    map: map<?php echo $contentid."_".$fieldid ?>
				  });
			  }
			  google.maps.event.addDomListener(window, 'load', initializemap<?php echo $contentid."_".$fieldid ?>);
			</script>
			<?php
			$return .= ob_get_contents();
			ob_end_clean();
	        	$return .= '<div class="address">'.htmlspecialchars($address).'</div><div class="gmap" id="map_canvas'.$contentid.'_'.$fieldid.'" style="max-width:100%;width: '.$map_width.'px; height: '.$map_height.'px;"></div>';
			$return .= '<script type="text/javascript">initializemap'.$contentid.'_'.$field->fieldid.'();</script>';
			
			return $return;
		}
	}

	function getFormDisplay($content,$field,$default=null)
	{
		$flat = $field->name."_lat";
		$flng = $field->name."_lng";
		$fzoom = $field->name."_zoom";
		$fhide = $field->name."_hide";
       		$faddress = $field->name."_address";
		
		$fieldid = $field->fieldid; 
		
		$this->_db->setQuery("SELECT * FROM #__adsmanager_fieldgmap_conf WHERE fieldid = $field->fieldid");
		$conf = $this->_db->loadObject();
		
		if (!isset($conf->lat)) {
			echo "ERROR GMAP Field options not set";
			exit();	
		}
		
		if (($content)&&(isset($content->$flat))&&(isset($content->$flng)))
		{
			$newform = 0;
			$lat = (float)$content->$flat;
			$lng = (float)$content->$flng;
			$zoom = (int)@$content->$fzoom;
			$hide = (int)@$content->$fhide;
		}
		else if (($default)&&(isset($default->$flat))&&(isset($default->$flng)))
		{
			$newform = 0;
			$lat = (float)$default->$flat;
			$lng = (float)$default->$flng;
			$zoom = (int)$default->$fzoom;
			$hide = (int)$default->$fhide;
		}
		else
		{
			$newform = 1;
			$lat = (float)$conf->lat;//"37.4419";
			$lng = (float)$conf->lng;//" -122.1419";
			$zoom = (int)$conf->zoom;
			$hide = 0; 
		}
		if ($zoom == null)
			$zoom= 8;
		if ($hide == null)
			$hide=0;
		$map_width = $conf->map_width;//500;
		$map_height= $conf->map_height;//300;
		$google_key = $conf->google_key;//ABQIAAAAbgp4ITpmNUShfIO_dNHv_BR3Tz62YPXwBIaKJWeQ0jDUesttEhTdqyqafAWvPNs2HRK7lWBo2Yemww
		
        $return = '';
        ob_start();
	$document = JFactory::getDocument();
	$document->addScript("https://maps.googleapis.com/maps/api/js?libraries=places&key=".$google_key);
	?>
       <?php /* <script type="text/javascript" 
            src="https://maps.googleapis.com/maps/api/js?key=<?php echo$google_key;?>&libraries=places&amp;sensor=false">
        </script> */?>
	<?php  ?>
		<script type="text/javascript">
	       var geocoder<?php echo $fieldid ?>;
                  var map<?php echo $fieldid ?>;
                  var marker<?php echo $fieldid ?>;

           jQ('input[name=addcat]').click(function () {            
            	google.maps.event.trigger(map<?php echo $fieldid ?>, "resize");
           });

	   var currentaddress;
           		 
           function initializemap<?php echo $fieldid ?>() {
			    geocoder<?php echo $fieldid ?> = new google.maps.Geocoder();
			    var latlng = new google.maps.LatLng(<?php echo json_encode($lat) ?>, <?php echo json_encode($lng) ?>);
			    var myOptions = {
			      zoom: <?php echo $zoom ?>,
			      center: latlng,
			      mapTypeId: google.maps.MapTypeId.ROADMAP
			    };
			    map<?php echo $fieldid ?> = new google.maps.Map(document.getElementById("map_canvas<?php echo $fieldid ?>"),
				myOptions);
                
                var input = document.getElementById('<?php echo 'gmap_address'.$fieldid ?>');
                var autocomplete = new google.maps.places.Autocomplete(input);
		
                
                marker<?php echo $fieldid ?> = new google.maps.Marker({
				    position: latlng,
				    title: '',
				    map: map<?php echo $fieldid ?>,
				    draggable: true
				});

		jQ('#<?php echo 'gmap_address'.$fieldid ?>').keyup(function() {
		    setTimeout(function() {
			    elems = [];
			    jQ(".pac-container .pac-item:first >span").filter(":visible").each(function() {
		            if (jQuery(this).text() != "")
		                      elems.push(jQuery(this).text());
			    });
			    currentaddress = elems.join(', ');
			    console.log("currentaddress",currentaddress);
		    },200);
		});
		
                google.maps.event.addListener(autocomplete, 'place_changed', function() {
		    elems = [];
	            jQ(".pac-container .pac-item:first >span").filter(":visible").each(function() {
                    if (jQuery(this).text() != "")
                              elems.push(jQuery(this).text());
		    });
		    address = elems.join(', ');
		    if (address != "") {
			currentaddress = address;
		    }
		    console.log("currentaddress",currentaddress);
                    marker<?php echo $fieldid ?>.setVisible(false);
                    input.className = '';
                    var place = autocomplete.getPlace();
                    if (!place.geometry) {
                    	marker<?php echo $fieldid ?>.setVisible(true);
                      // Inform the user that the place was not found and return.
                      input.className = 'notfound';
                      return;
                    }

                    updateDataForm(place.address_components);
                    // If the place has a geometry, then present it on a map.
                    if (place.geometry.viewport) {
                      map<?php echo $fieldid ?>.fitBounds(place.geometry.viewport);
                    } else {
                      map<?php echo $fieldid ?>.setCenter(place.geometry.location);
                      map<?php echo $fieldid ?>.setZoom(17);  // Why 17? Because it looks good.
                    }
                    marker<?php echo $fieldid ?>.setPosition(place.geometry.location);
                    marker<?php echo $fieldid ?>.setVisible(true);
                    updateGmapData<?php echo $fieldid ?>();
                    
                });
                
                // Add dragging event listeners.
                google.maps.event.addListener(marker<?php echo $fieldid ?>, 'dragstart', function() {
                    updateMarkerAddress<?php echo $fieldid ?>('Dragging...');
                });
                
			    google.maps.event.addListener(marker<?php echo $fieldid ?>, 'dragend', function() {
                    geocodePosition<?php echo $fieldid ?>(marker<?php echo $fieldid ?>.getPosition());	    	
                    updateGmapData<?php echo $fieldid ?>();
                });

				google.maps.event.addListener(map<?php echo $fieldid ?>, 'zoom_changed', function() {
					  document.getElementById("gmap_zoom<?php echo $fieldid ?>").value = map<?php echo $fieldid ?>.getZoom();
                });

				//Trick with the gmap fields is hidden by default
				 jQ( "#adminForm" ).on( "redraw",function() {
					 google.maps.event.trigger(map<?php echo $fieldid ?>, 'resize');
				 });	
          }
          
          function updateMarkerAddress<?php echo $fieldid ?>(str) {
              document.getElementById('gmap_address<?php echo $fieldid ?>').value = str;
          }
          
          function updateDataForm(address_components) {
              for(var i = 0; i < address_components.length; i++) {
                  if(address_components[i].types[0] === 'locality'){
                      //locality (city)
                      var locality = address_components[i].long_name;
                      if(document.getElementById('fad_city')) {
                          document.getElementById('fad_city').value = locality;
                      }
                  }
                  if(address_components[i].types[0] === 'administrative_area_level_2'){
                      //department
                      var department = address_components[i].long_name;
                      if(document.getElementById('fad_department')) {
                            document.getElementById('fad_department').value = department;
                      }
                  }
                  if(address_components[i].types[0] === 'administrative_area_level_1'){
                      //region
                      var region = address_components[i].long_name;
                      if(document.getElementById('fad_region')) {
                            document.getElementById('fad_region').value = region;
                      }
                  }
                  if(address_components[i].types[0] === 'country'){
                      //country
                      var country = address_components[i].long_name;
                      if(document.getElementById('fad_country')) {
                            document.getElementById('fad_country').value = country;
                      }  
                  }
              }
          }
          
          function updateGmapData<?php echo $fieldid ?>() {
        	  document.getElementById("gmap_lat<?php echo $fieldid ?>").value = marker<?php echo $fieldid ?>.getPosition().lat();
			  document.getElementById("gmap_lng<?php echo $fieldid ?>").value = marker<?php echo $fieldid ?>.getPosition().lng();
			  document.getElementById("gmap_zoom<?php echo $fieldid ?>").value = map<?php echo $fieldid ?>.getZoom();
          }
          
          function geocodePosition<?php echo $fieldid ?>(pos) {
              geocoder<?php echo $fieldid ?>.geocode({
                  latLng: pos
              }, function(responses) {
                if (responses && responses.length > 0) {
                    console.log(responses[0]);
                	updateMarkerAddress<?php echo $fieldid ?>(responses[0].formatted_address);
                    updateDataForm(responses[0].address_components);
                } else {
                    updateMarkerAddress<?php echo $fieldid ?>('Cannot determine address at this location.');
                }
              });
          }
          
		  function codeAddress<?php echo $fieldid ?>() {
		      elems = [];
		      address = currentaddress;
		      console.log("codeAdress=",address);
		      updateMarkerAddress<?php echo $fieldid ?>(address);
		      geocoder<?php echo $fieldid ?>.geocode( { 'address': address}, function(results, status) {
		      if (status == google.maps.GeocoderStatus.OK) {
		    	    updateDataForm(results[0].address_components);
					map<?php echo $fieldid ?>.setCenter(results[0].geometry.location);
					marker<?php echo $fieldid ?>.setPosition(results[0].geometry.location);
					updateGmapData<?php echo $fieldid ?>();	
		      } else {
			//alert("Geocode was not successful for the following reason: " + status);
		      }
		    });
		  }					  

		  google.maps.event.addDomListener(window, 'load', initializemap<?php echo $fieldid ?>);
		</script>
		<style>
		#<?php echo $field->name ?> img {
			max-width: none !important;
		}
		.gmap img {
			max-width: none !important;
		}
		</style>

		<?php
		$return .= ob_get_contents();
		ob_end_clean();
		$return .= '<div id="'.$field->name.'">';
		$return .= '<div class="fieldcontainer">';
       	$return .= '<div class="gmap_address_container"><input onkeyup="if(event.keyCode==13) {codeAddress'.$fieldid.'(); }" type="text" class="form-control gmap_address" size="60" name="gmap_address'.$fieldid.'" id="gmap_address'.$fieldid.'" placeholder="'.JText::_('ADSMANAGER_GMAP_SEARCHFIELD').'" value="'.@htmlspecialchars($content->$faddress).'" /></div>';
		$return .= '<input type="button" class="button btn gmap_address_btn" value="Go!" onClick="codeAddress'.$fieldid.'();" />';
		$return .= "</div>";
		if ($field->required == 0) {
			$return .= '<br/><input type="hidden" name="gmap_hide'.$fieldid.'" value="1"/>';
			if($hide == 0) {
				$return .= '<input type="checkbox" id="gmap_hide'.$fieldid.'" name="gmap_hide'.$fieldid.'" value="0" checked="checked"/>'.JText::_('ADSMANAGER_GMAP_SHOW_MAP');
			} else {
				$return .= '<input type="checkbox" id="gmap_hide'.$fieldid.'" name="gmap_hide'.$fieldid.'" value="0"/>&nbsp;'.JText::_('ADSMANAGER_GMAP_SHOW_MAP');
			}
		} else {
			$return .= '<br/><input type="hidden" name="gmap_hide'.$fieldid.'" value="0"/>';
		}
		$return .= '<div id="map_canvas'.$fieldid.'" style="width:100%;max-width: '.$map_width.'px; height: '.$map_height.'px"></div>';
		if ($newform == 1)
			$return .= '<input type="hidden" mosReq="'.$field->required.'" mosLabel="'.htmlspecialchars($field->title).'" mosElem="'.$field->name.'" id="gmap_lat'.$fieldid.'" name="gmap_lat'.$fieldid.'" value=""/>';
		else 
			$return .= '<input type="hidden" mosReq="'.$field->required.'" mosLabel="'.htmlspecialchars($field->title).'" mosElem="'.$field->name.'" id="gmap_lat'.$fieldid.'" name="gmap_lat'.$fieldid.'" value="'.json_encode($lat).'"/>';
		$return .= '<input type="hidden" id="gmap_lng'.$fieldid.'" name="gmap_lng'.$fieldid.'" value="'.json_encode($lng).'"/>';
		$return .= '<input type="hidden" id="gmap_zoom'.$fieldid.'" name="gmap_zoom'.$fieldid.'" value="'.$zoom.'"/>';
		$return .= JText::_('ADSMANAGER_GMAP_DRAP_AND_DROP');
		$return .= '</div>';

		return $return; 
	}

	function onFormSave(&$content,$field)
	{
		$this->updateAdColumns($field->name);
		
		$lat = JRequest::getFloat("gmap_lat".$field->fieldid,0);
		$lng = JRequest::getFloat("gmap_lng".$field->fieldid,0);
		$zoom = JRequest::getFloat("gmap_zoom".$field->fieldid,0);
		$hide = JRequest::getInt("gmap_hide".$field->fieldid,0);
        	$address = JRequest::getVar("gmap_address".$field->fieldid,'');
		if (!isset($content->data)) {
			$content->data = array();
			$content->data['fields'] = array();
		}
		$content->data['fields'][$field->name.'_lat'] = $lat;
		$content->data['fields'][$field->name.'_lng'] = $lng;
		$content->data['fields'][$field->name.'_zoom'] = $zoom;
		$content->data['fields'][$field->name.'_hide'] = $hide;
       		$content->data['fields'][$field->name.'_address'] = $address;
		return null;
	}
	
	function onDelete($directory,$contentid = -1)
	{
	}
	
	function getEditFieldJavaScriptDisable()
	{
		$return = "elem=getObject('divGMapOptions');";
       	$return .= "elem.style.visibility = 'hidden';";
		$return .= "elem.style.display = 'none';";
		$return .= "elem=getObject('gmap_map_width');";
		$return .= "elem.setAttribute('mosReq',0);";
		$return .= "elem=getObject('gmap_map_height');";
		$return .= "elem.setAttribute('mosReq',0);";
		$return .= "elem=getObject('gmap_list_map_width');";
		$return .= "elem.setAttribute('mosReq',0);";
		$return .= "elem=getObject('gmap_list_map_height');";
		$return .= "elem.setAttribute('mosReq',0);";
		$return .= "elem=getObject('gmap_lat');";
		$return .= "elem.setAttribute('mosReq',0);";
		$return .= "elem=getObject('gmap_zoom');";
		$return .= "elem.setAttribute('mosReq',0);";
		$return .= "elem=getObject('gmap_lng');";
		$return .= "elem.setAttribute('mosReq',0);";
		return $return;
	}
	
	function getEditFieldJavaScriptActive()
	{
       		$return = "disableAll();";
		$return .= "elem=getObject('divGMapOptions');";
		$return .= "elem.style.visibility = 'visible';";
		$return .= "elem.style.display = 'block';";
		$return .= "elem=getObject('gmap_map_width');";
		$return .= "elem.setAttribute('mosReq',1);";
		$return .= "elem=getObject('gmap_map_height');";
		$return .= "elem.setAttribute('mosReq',1);";
		$return .= "elem=getObject('gmap_list_map_width');";
		$return .= "elem.setAttribute('mosReq',1);";
		$return .= "elem=getObject('gmap_list_map_height');";
		$return .= "elem.setAttribute('mosReq',1);";
		$return .= "elem=getObject('gmap_lat');";
		$return .= "elem.setAttribute('mosReq',1);";
		$return .= "elem=getObject('gmap_zoom');";
		$return .= "elem.setAttribute('mosReq',1);";
		$return .= "elem=getObject('gmap_lng');";
		$return .= "elem.setAttribute('mosReq',1);";
		return $return; 
	}

	function getEditFieldOptions($fieldid)
	{
		$this->_db->setQuery("SELECT * FROM #__adsmanager_fieldgmap_conf WHERE fieldid = '$fieldid'");
		$row = $this->_db->loadObject();
		
		$return = "<div id='divGMapOptions'>";
		$return .= "<table class='adminform'>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Map Width (Ad Details)</td>";
		$return .= "<td width='20%' align=left><input type='text' id='gmap_map_width' name='gmap_map_width' mosReq=1 mosLabel='Map Width' class='inputbox' value='".@$row->map_width."' /></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Map Height (Ad Details)</td>";
		$return .= "<td width='20%' align=left><input type='text' id='gmap_map_height' name='gmap_map_height' mosReq=1 mosLabel='Map Height' class='inputbox' value='".@$row->map_height."' /></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Map Width (List)</td>";
		$return .= "<td width='20%' align=left><input type='text' id='gmap_list_map_width' name='gmap_list_map_width' mosReq=1 mosLabel='Map Width (List)' class='inputbox' value='".@$row->list_map_width."' /></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Map Height (List)</td>";
		$return .= "<td width='20%' align=left><input type='text' id='gmap_list_map_height' name='gmap_list_map_height' mosReq=1 mosLabel='Map Height (List)' class='inputbox' value='".@$row->list_map_height."' /></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Default Lat</td>";
		$return .= "<td width='20%' align=left><input type='text' id='gmap_lat' name='gmap_lat' mosReq=1 mosLabel='Default Lat' class='inputbox' value='".@$row->lat."' /></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Default Lng</td>";
		$return .= "<td width='20%' align=left><input type='text' id='gmap_lng' name='gmap_lng' mosReq=1 mosLabel='Default Lng' class='inputbox' value='".@$row->lng."' /></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Default Zoom</td>";
		$return .= "<td width='20%' align=left><input type='text' id='gmap_zoom' name='gmap_zoom' mosReq=1 mosLabel='Default Zoom' class='inputbox' value='".@$row->zoom."' /></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Google Key</td>";
		$return .= "<td width='20%' align=left><input type='text' id='gmap_google_key' name='gmap_google_key' class='inputbox' value='".@$row->google_key."' /></td>";
		$return .= "<td><a target='_blank' href='https://developers.google.com/maps/documentation/javascript/tutorial#api_key'>Google Map API Key v3</a></td>";
		$return .= "</tr>";
		$return .= "</table>";
		$return .= "</div>";
		return $return;
	}
	
	function updateAdColumns($fieldname) {

		$query = "ALTER TABLE `#__adsmanager_ads` ADD `".$fieldname."_lat` FLOAT default NULL;";
		$this->_db->setQuery($query);
		try{
			$this->_db->query();
		}catch(Exception $e){
		
		}
		
		$query = "ALTER TABLE `#__adsmanager_ads` ADD `".$fieldname."_lng` FLOAT default NULL;";
		$this->_db->setQuery($query);
		try{
			$this->_db->query();
		}catch(Exception $e){
		
		}
		
		$query = "ALTER TABLE `#__adsmanager_ads` ADD `".$fieldname."_zoom` int(10) unsigned default 8;";
		$this->_db->setQuery($query);
		try{
			$this->_db->query();
		}catch(Exception $e){
		
		}
		
		$query = "ALTER TABLE `#__adsmanager_ads` ADD `".$fieldname."_hide` int(1) unsigned default 0;";
		$this->_db->setQuery($query);
		try{
			$this->_db->query();
		}catch(Exception $e){
		
		}
		
		$query = "ALTER TABLE `#__adsmanager_ads` ADD `".$fieldname."_address` TEXT default '';";
		$this->_db->setQuery($query);
		try{
			$this->_db->query();
		}catch(Exception $e){
		}
	}

	function saveFieldOptions($field)
	{
		$this->install();
		$gmap_map_width = JRequest::getInt("gmap_map_width",400);
		$gmap_map_height =JRequest::getInt("gmap_map_height",300);
		$gmap_list_map_width = JRequest::getInt("gmap_list_map_width",400);
		$gmap_list_map_height =JRequest::getInt("gmap_list_map_height",300);
		$gmap_lat = JRequest::getFloat("gmap_lat",20);
		$gmap_lng = JRequest::getFloat("gmap_lng",20);
		$gmap_google_key = JRequest::getVar("gmap_google_key",0);
		$gmap_zoom = JRequest::getFloat("gmap_zoom",8);
		
		$this->_db->setQuery("DELETE FROM #__adsmanager_fieldgmap_conf WHERE fieldid = ".(int)$field->fieldid);
		$this->_db->query();
		$this->_db->setQuery("INSERT INTO #__adsmanager_fieldgmap_conf (fieldid,map_width,map_height,list_map_width,list_map_height,lat,lng,google_key,zoom) VALUES ($field->fieldid,$gmap_map_width,$gmap_map_height,$gmap_list_map_width,$gmap_list_map_height,$gmap_lat,$gmap_lng,".$this->_db->Quote($gmap_google_key).",$gmap_zoom)");
		$this->_db->query();
		
		$query = "ALTER TABLE `#__adsmanager_ads` ADD `".$field->name."_lat` FLOAT default NULL;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){
            
        }
		
		$query = "ALTER TABLE `#__adsmanager_ads` ADD `".$field->name."_lng` FLOAT default NULL;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){
            
        }
		
		$query = "ALTER TABLE `#__adsmanager_ads` ADD `".$field->name."_zoom` int(10) unsigned default 8;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){
            
        }
		
		$query = "ALTER TABLE `#__adsmanager_ads` ADD `".$field->name."_hide` int(1) unsigned default 0;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){
            
        }
        
        $query = "ALTER TABLE `#__adsmanager_ads` ADD `".$field->name."_address` TEXT default '';";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){
            
        }
		
		$query = "ALTER TABLE `#__adsmanager_profile` ADD `".$field->name."_lat` FLOAT default NULL;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){
            
        }
		
		$query = "ALTER TABLE `#__adsmanager_profile` ADD `".$field->name."_lng` FLOAT default NULL;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){
            
        }
		
		$query = "ALTER TABLE `#__adsmanager_profile` ADD `".$field->name."_zoom` int(10) unsigned default 9;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){
            
        }
		
		$query = "ALTER TABLE `#__adsmanager_profile` ADD `".$field->name."_hide` int(1) unsigned default 0;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){
            
        }
		
		return;
	}
	
	function getFieldName()
	{
		return "GMap";
	}
	
	function install()
	{		
        if(version_compare(JVERSION, '2.5', '>=') && version_compare(JVERSION, '3.0', '<') ) {
			if (JError::$legacy)
				$tmp_legacy = true;
			else
				$tmp_legacy = false;
		
			JError::$legacy = false;
		}
        
		$query = "CREATE TABLE IF NOT EXISTS `#__adsmanager_fieldgmap_conf` ( ".
			  "`fieldid` int(10) unsigned NOT NULL, ".
			  "`map_width` int(10) unsigned default '500', ".
			  "`map_height` int(10) unsigned default '300', ".
		      "`list_map_width` int(10) unsigned default '200', ".
			  "`list_map_height` int(10) unsigned default '200', ".
			  "`lat` FLOAT default '37.4419', ".
			  "`lng` FLOAT default '-122.1419', ".
			  "`google_key` TEXT default NULL, ".
			  "`zoom` int(10) unsigned default 9, ".
			  "PRIMARY KEY  (`fieldid`) ".
			  "); ";
		$this->_db->setQuery($query);
		$this->_db->query();
        
        $query = "ALTER TABLE `#__adsmanager_fieldgmap_conf` ADD `zoom` int(10) unsigned default 9;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){

        }

		$query = "ALTER TABLE `#__adsmanager_fieldgmap_conf` ADD `list_map_width` int(10) unsigned default 200;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){

        }

		$query = "ALTER TABLE `#__adsmanager_fieldgmap_conf` ADD `list_map_height` int(10) unsigned default 200;";
		$this->_db->setQuery($query);
        try{
            $this->_db->query();
        }catch(Exception $e){

        }

        
        if(version_compare(JVERSION, '2.5', '>=') && version_compare(JVERSION, '3.0', '<') ) {
			JError::$legacy = $tmp_legacy;
		}
	}
	
	function uninstall()
	{	
		$query = "DROP TABLE `#__adsmanager_fieldgmap_conf`";
		$this->_db->setQuery($query);
		$this->_db->query();
	}
	
	function __construct()
	{
		$db	= JFactory::getDBO();
		$this->_db = $db;
	}
}
$plugins["gmap"] = new AdsManagerGmapPlugin();