<?php
/**
 * @package		PaidSystem
 * @copyright	Copyright (C) 2010-2014 Juloa.com. All rights reserved.
 *  @license GNU General Public License version 3, or later
 */

defined('_JEXEC') or die('Restricted access');

// Check to ensure this file is included in Joomla!
class AdsManagerIpPlugin {

	var $_db;
	
	function getListDisplay($content,$field)
	{
		return AdsManagerIpPlugin::getDetailsDisplay($content,$field,$mode="list");
	}

	function getDetailsDisplay($content,$field,$mode="details")
	{
		$fieldname = $field->name;
		return $content->$fieldname;
	}

	function getFormDisplay($content,$field,$default=null)
	{
		$app = JFactory::getApplication();
		
		if ($app->isAdmin() == true) {
			$fieldname = $field->name;
			$value = htmlspecialchars(@$content->$fieldname);
			$return = '<input type="text" size="30" mosReq="'.$field->required.'" mosLabel="'.htmlspecialchars($field->title).'" id="'.$field->name.'" name="'.$field->name.'" value="'.$value.'" />';
		} else {
		 $return = '';
		}
		return $return;
	}

	function onFormSave(&$content,$field)
	{
		$app = JFactory::getApplication();
		
		$fieldname = $field->name;
		if (($app->isAdmin() == false)||($content->id == 0)) {
			$fieldvalue = $_SERVER['REMOTE_ADDR'];
		} else {
			$fieldvalue = JRequest::getVar($fieldname,"");
		}
		return $fieldvalue;
	}
	
	function onDelete($directory,$contentid = -1)
	{
	}
	
	function getEditFieldJavaScriptDisable()
	{
		$return = "";
		return $return;
	}
	
	function getEditFieldJavaScriptActive()
	{
		return ""; 
	}

	function getEditFieldOptions($fieldid)
	{
		$return = "";
		return $return;
	}

	function saveFieldOptions($field)
	{
		return;
	}
	
	function getFieldName()
	{
		return "Ip";
	}
	
	function install()
	{	
	}
	
	function uninstall()
	{
	}
	
	function __construct()
	{
		$db	= JFactory::getDBO();
		$this->_db = $db;
	}
}

require_once(JPATH_ROOT."/components/com_adsmanager/lib/core.php");
$plugins["ip"] = new AdsManagerIpPlugin();