<?php
/**
 * @package		AdsManager
 * @copyright	Copyright (C) 2010-2014 Juloa.com. All rights reserved.
 *  @license GNU General Public License version 3, or later
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

require_once(JPATH_ROOT."/components/com_adsmanager/lib/core.php");

class AdsManagerMultipleSearchPlugin {

	var $_db;
	
	public function getListDisplay($content,$field)
	{
		return null;
	}

	public function getDetailsDisplay($content,$field,$mode="details")
	{
		$fieldname = $field->name;
		$value = @$content->$fieldname;
		return $value;
	}
	
	
	public function getFormDisplay($content,$field,$default=null)
	{
		return null;
	}
	
	public function getSearchFormDisplay($content,$field,$default=null)
	{
		$fieldid = $field->fieldid;
		
		$fieldname = $field->name;
		$value = @$content->$fieldname;
		
       		$return = '<input type="text" size="30" class="form-control" placeholder="'.htmlspecialchars($field->title).'" id="'.htmlspecialchars($fieldname).'" name="'.htmlspecialchars($fieldname).'" value="'.htmlspecialchars($value).'" />';
		return $return;
	}
	
	public function getSqlFilter($field,$filter) {
		$sql = "";
		$sqls =array();
		if ($filter != null) {
			$fieldnames = @$field->options->fieldnames;
			if ($fieldnames != "") {
				$filter = preg_replace('!\s+!', ' ', $filter);
				$filter = str_replace(" "," +",trim($filter))."*";
				$sql = " AND MATCH (".$fieldnames.") AGAINST (".$this->_db->Quote($filter)." IN BOOLEAN MODE) ";
				//echo $sql;
			}
		}
		return $sql;
	}

	public function onFormSave($content,$field)
	{
		return null;
	}
	
	public function onDelete($directory,$contentid = -1)
	{
	}
	
	public function getEditFieldJavaScriptDisable()
	{
		$return =  " jQ('#divMultipleSearchOptions').hide();\n";
		//$return .= " jQ('#divCascadeOptions input').attr('mosReq',0);";
		return $return;
	}
	
	public function getEditFieldJavaScriptActive()
	{
       	$return = " disableAll();";
       	$return .= " jQ('#divMultipleSearchOptions').show();\n";
		return $return; 
	}

	public function getEditFieldOptions($fieldid)
	{
		$this->_db->setQuery("SELECT options FROM #__adsmanager_fields WHERE fieldid = '$fieldid'");
		$options = $this->_db->loadResult();
		
		$options = json_decode($options);
		if ($options == null)
			$options = new stdClass();
			
		ob_start();
		if (!isset($options->fieldnames)) {
			$options->fieldnames="ad_headline,ad_text";
		}
		?>
		<div id='divMultipleSearchOptions'>
			<?php echo JText::_('ADSMANAGER_MULTIPLE_SEARCH_FIELDNAMES')?> <input type="text" name="multiplesearch_fieldnames" value="<?php echo htmlspecialchars($options->fieldnames);?>"/> 
		</div>
		<?php
		$return = ob_get_contents();
		ob_end_clean();
		return $return;
	}

	public function saveFieldOptions($field)
	{
		$this->install();
		
		$fieldnames  = JRequest::getVar('multiplesearch_fieldnames',array());
		
		$options = array();
		$options["fieldnames"] = $fieldnames;
		return $options;
	}
	
	public function getFieldName()
	{
		return "MultipleSearch";
	}
	
	public function install()
	{
	}
	
	public function uninstall()
	{	
	}
	
	public function __construct()
	{
		$db	= JFactory::getDBO();
		$this->_db = $db;
	}
}


$plugins["multiplesearch"] = new AdsManagerMultipleSearchPlugin();
