<?php
/**
 * @package		PaidSystem
 * @copyright	Copyright (C) 2010-2014 Juloa.com. All rights reserved.
 *  @license GNU General Public License version 3, or later
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

require_once(JPATH_ROOT."/components/com_adsmanager/lib/core.php");

// no direct access
defined('_JEXEC') or die('Restricted access');

class AdsManagerReportPlugin {

	var $_db;

	function getListDisplay($content,$field)
	{
		return AdsManagerReportPlugin::getDetailsDisplay($content,$field);
	}

	function getDetailsDisplay($content,$field)
	{
		$fieldid = $field->fieldid;

		$fieldname = $field->name;
		$value = @$content->$fieldname;

		$return ="";

		ob_start();
		?>
		<a href="javascript:void(0);" class="adsmanagerreport-link" data-toggle="modal" data-target="#adsmanagerreport-modal"><?php echo JText::_('ADSMANAGER_REPORT_LINK'); ?></a>
		<!-- The Modal -->
		<div id="adsmanagerreport-modal" class="modal fade" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title"><?php echo JText::_('ADSMANAGER_REPORT_MODAL_TITLE'); ?></h4>
					</div>
					<div class="modal-body">
						<div class="report-form">
							<?php
								$user = JFactory::getUser();
								if($user->id == 0) {
									?>
									<div class="form-group">
										<label for="report_email"><?php echo JText::_('ADSMANAGER_REPORT_MODAL_EMAIL'); ?></label>
										<input type="email" name="report_email" class="form-control" id="report_email">
									</div>
									<p style="color: red;display: none;" id="adsmanagerreport-error-email"></p>
									<?php
								} else {
									?>
									<input type="hidden" name="report_email" id="report_email" value="none" />
									<?php
								}
							 ?>
							 <div class="form-group">
								<label for="report_email"><?php echo JText::_('ADSMANAGER_REPORT_MODAL_TEXT'); ?></label>
								<textarea name="report_text" id="report_text" class="form-control" rows="3"></textarea>
							 </div>
							 <p style="color: red;display: none;" id="adsmanagerreport-error-text"></p>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('ADSMANAGER_REPORT_MODAL_CLOSE'); ?></button>
						<button type="button" id="report_submit" class="btn btn-primary"><?php echo JText::_('ADSMANAGER_REPORT_MODAL_SEND'); ?></button>
					</div>
				</div>
			</div>
		</div>
		<script type="text/javascript">
			jQuery(document).ready(function(){

				jQuery('#report_submit').on('click', function(){
					if(jQuery("#report_email").val() == '') {
						jQuery("#adsmanagerreport-error-email").html('<?php echo JText::_('ADSMANAGER_VALIDATE_FIELD_REQUIRED'); ?>').show();
						return false;
					}

					if(jQuery("#report_text").val() == '') {
						jQuery("#adsmanagerreport-error-text").html('<?php echo JText::_('ADSMANAGER_VALIDATE_FIELD_REQUIRED'); ?>').show();
						return false;
					}
					jQuery.post('index.php?option=com_adsmanager&task=report',{email: jQuery("#report_email").val(), content: jQuery("#report_text").val(), contentid: <?php echo $content->id; ?>}, function(data){
						data = jQuery.parseJSON(data);
						if(data.status == 'error') {
							jQuery('.report-form').html('<p>'+data.message+'</p>');
							jQuery('#report_submit').hide();
						} else {
							jQuery('.report-form').html('<p><?php echo JText::_('ADSMANAGER_REPORT_SUCCESS'); ?></p>');
							jQuery('#report_submit').hide();
						}
					});
				});
			});
		</script>
		<?php
		$return = ob_get_clean();

		return $return;
	}

	function getFormDisplay($content,$field,$default=null)
	{
		return;
	}

	function onFormSave(&$content,$field)
	{
		return;
	}

	function onDelete($directory,$contentid = -1)
	{
	}

	function getEditFieldJavaScriptDisable()
	{
		$return = "";
		return $return;
	}

	function getEditFieldJavaScriptActive()
	{
        $return = "";
		return $return;
	}

	function getEditFieldOptions($fieldid)
	{
		$return = "";
		return $return;
	}

	function saveFieldOptions($field)
	{
		return;
	}

	function getFieldName()
	{
		return "Report";
	}

	function install()
	{
	}

	function uninstall()
	{
	}

	function __construct()
	{
		$db	= JFactory::getDBO();
		$this->_db = $db;
	}
}

$plugins["report"] = new AdsManagerReportPlugin();
?>
