<?php
/**
 * @package		PaidSystem
 * @copyright	Copyright (C) 2010-2014 Juloa.com. All rights reserved.
 *  @license GNU General Public License version 3, or later
 */

defined('_JEXEC') or die('Restricted access');

// Check to ensure this file is included in Joomla!
class AdsManagerTagsPlugin {

	var $_db;
	
	function getListDisplay($content,$field)
	{
		return AdsManagerTagsPlugin::getDetailsDisplay($content,$field,$mode="list");
	}

	function getDetailsDisplay($content,$field,$mode="details")
	{
		$fieldname = $field->name;
		if ((@$content->$fieldname != "")&&(strlen($content->$fieldname) > 2)) {
			$values = explode(",",substr($content->$fieldname,1,strlen($content->$fieldname)-2));
		} else {
			$values = array();
		}
        
        foreach($values as $key => $value) {
			$values[$key] = '<a href="'.JRoute::_('index.php?option=com_adsmanager&view=result&new_search=1&'.$fieldname.'='.$value).'">'.$value.'</a>';
		}
        
		return implode(", ",$values);
	}

	function getFormDisplay($content,$field,$default=null)
	{
		$app = JFactory::getApplication();
		
        $db = JFactory::getDbo();
        
        $query = "CREATE TABLE IF NOT EXISTS `#__adsmanager_tags` (
                    type varchar(50) NOT NULL,
                    value varchar(255) NOT NULL,
                    PRIMARY KEY  (`type`,`value`)
                ) DEFAULT CHARACTER SET utf8;";
        
        $db->setQuery($query);
        $db->execute();
        
		$selector = "#".$field->name;
		
		$document	= JFactory::getDocument();
		$document->addScript(JURI::root()."components/com_adsmanager/js/chosen/chosen.jquery.min.js");
		$document->addScript(JURI::root()."components/com_adsmanager/js/chosen/ajax-chosen.min.js");
		$document->addStyleSheet(JURI::root()."components/com_adsmanager/js/chosen/chosen.css");
		
		JText::script('JGLOBAL_KEEP_TYPING');
		JText::script('JGLOBAL_LOOKING_FOR');
		
		if ($field->size == 0) {
			$field->size = 200;
		}
		
		JFactory::getDocument()->addScriptDeclaration("
				(function($){
					$(document).ready(function () {
				
						$('" . $selector . "').ajaxChosen({
						    type: 'GET',
						    url: '".JRoute::_(JURI::root()."index.php?option=com_adsmanager&task=tags")."',
						    dataType: 'json'
						}, function (data) {
						    var results = [];
						
						    $.each(data, function (i, val) {
						        results.push({ value: val.value, text: val.text });
						    });
						    		console.log(results);
						
						    return results;
						},
						{width: '".$field->size."px'});
						var customTagPrefix = '#new#';

						// Method to add tags pressing enter
						$('" . $selector . "_chzn input').keydown(function(event) {

							// Tag is greater than 3 chars and enter pressed
							if (this.value.length >= 3 && (event.which === 13 || event.which === 188)) {

								// Search an highlighted result
								var highlighted = $('" . $selector . "_chzn').find('li.active-result.highlighted').first();

								// Add the highlighted option
								if (event.which === 13 && highlighted.text() !== '')
								{
									// Extra check. If we have added a custom tag with this text remove it
									var customOptionValue = customTagPrefix + highlighted.text();
									$('" . $selector . " option').filter(function () { return $(this).val() == customOptionValue; }).remove();

									// Select the highlighted result
									var tagOption = $('" . $selector . " option').filter(function () { return $(this).html() == highlighted.text(); });
									tagOption.attr('selected', 'selected');
								}
								// Add the custom tag option
								else
								{
									var customTag = this.value;

									// Extra check. Search if the custom tag already exists (typed faster than AJAX ready)
									var tagOption = $('" . $selector . " option').filter(function () { return $(this).html() == customTag; });
									if (tagOption.text() !== '')
									{
										tagOption.attr('selected', 'selected');
									}
									else
									{
										var option = $('<option>');
										option.text(this.value).val(customTagPrefix + this.value);
										option.attr('selected','selected');

										// Append the option an repopulate the chosen field
										$('" . $selector . "').append(option);
									}
								}

								this.value = '';
								$('" . $selector . "').trigger('liszt:updated');
								event.preventDefault();

							}
						});
					});
				})(jQ);
				");
		
		$fieldname = $field->name;
		if ((@$content->$fieldname != "")&&(strlen($content->$fieldname) > 2)) {
			$values = explode(",",substr($content->$fieldname,1,strlen($content->$fieldname)-2));
		} else {
			$values = array();
		}
		
        $return = '';
		$return .= "<select id='".$field->name."' name='".$field->name."[]' multiple='multiple'>";
		foreach($values as $val) {
			$return .= "<option val=\"".htmlspecialchars($val)."\" selected='selected'>".htmlspecialchars($val)."</option>";
		}
		$return .= "</select>";
		return $return;
	}

	function onFormSave(&$content,$field)
	{
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		
		$fieldname = $field->name;
		
		$fieldvalues = JRequest::getVar($fieldname,array());
		if (!is_array($fieldvalues)) {
			$fieldvalues = array($fieldvalues);
		}
		$list = array();
		//var_dump($fieldvalues);exit();
		foreach($fieldvalues as $val) {
			if (strpos($val,"#new#") !== false) {
				$value = str_replace('#new#',"",$val);
				$db->setQuery("SELECT count(*) FROM #__adsmanager_tags WHERE type='content' AND value=".$db->Quote($value));
				$exist = $db->loadResult();
				//var_dump($exist);exit();
				if ($exist == 0) {
					$data = new stdClass();
					$data->type = 'content';
					$data->value = $value;
					$db->insertObject('#__adsmanager_tags',$data);
				}
				$list[] = $value;
			} else {
				$list[] = $val;
			}
		}
		//exit();
		return ",".implode(',',$list).",";
	}
	
	function onDelete($directory,$contentid = -1)
	{
	}
	
	function getEditFieldJavaScriptDisable()
	{
		$return = "";
		return $return;
	}
	
	function getEditFieldJavaScriptActive()
	{
		return ""; 
	}

	function getEditFieldOptions($fieldid)
	{
		$return = "";
		return $return;
	}

	function saveFieldOptions($field)
	{
		return;
	}
	
	function getFieldName()
	{
		return "Tags";
	}
	
	function install()
	{	
	}
	
	function uninstall()
	{
	}
	
	function __construct()
	{
		$db	= JFactory::getDBO();
		$this->_db = $db;
	}
}

require_once(JPATH_ROOT."/components/com_adsmanager/lib/core.php");
$plugins["tags"] = new AdsManagerTagsPlugin();