<?php
/**
 * @package		AdsManager
 * @copyright	Copyright (C) 2010-2014 Juloa.com. All rights reserved.
 *  @license GNU General Public License version 3, or later
 */

defined('_JEXEC') or die('Restricted access');

class AdsManagerUserfieldPlugin {

	var $_db;

	public function getListDisplay($content,$field)
	{
		return AdsManagerUserfieldPlugin::getDetailsDisplay($content,$field,$mode="list");
	}

	public function getDetailsDisplay($content,$field,$mode="details")
	{
		$fieldname = $field->name;
		$options = $field->options;

        $userField = $options->joomlafield;

        $db = JFactory::getDbo();

        if($userField == 'name' || $userField == 'username' || $userField == 'email') {
            $query = "SELECT ".$userField." as fieldvalue FROM #__users WHERE id = ".(int)$content->userid;
        } else {
            $query = "SELECT profile_value as fieldvalue FROM #__user_profiles WHERE profile_key = 'profile.".$userField."' AND user_id = ".(int)$content->userid;
        }

        $db->setQuery($query);
        $jfieldvalue = $db->loadResult();
        $jfieldvalue = str_replace('"', '', $jfieldvalue);

		ob_start();
        ?>
            <?php echo $jfieldvalue; ?>
        <?php
        $content = ob_get_contents();
		ob_end_clean();
		return $content;
	}


	function needStorage() {
		return false;
	}

	public function getFormDisplay($content,$field,$default=null)
	{
		return '';
	}

	public function onFormSave($content,$field)
	{
		return null;
	}

	public function onDelete($directory,$contentid = -1)
	{
	}

	public function getEditFieldJavaScriptDisable()
	{
		$return = "elem=getObject('divUserfieldOptions');";
        $return .= "elem.style.visibility = 'hidden';";
		$return .= "elem.style.display = 'none';";
		$return .= "elem=getObject('userfield_joomlafield');";
		$return .= "elem.setAttribute('mosReq',0);";
		return $return;
	}

	public function getEditFieldJavaScriptActive()
	{
       	$return = "disableAll();";
		$return .= "elem=getObject('divUserfieldOptions');";
        $return .= "elem.style.visibility = 'visible';";
        $return .= "elem.style.display = 'block';";
		$return .= "elem=getObject('userfield_joomlafield');";
		$return .= "elem.setAttribute('mosReq',1);";
		return $return;
	}

	public function getEditFieldOptions($fieldid)
	{
		$this->install();
		$this->_db->setQuery("SELECT * FROM #__adsmanager_fields WHERE fieldid = '$fieldid'");
		$row = $this->_db->loadObject();
        if($row != null)
            $rowOptions = json_decode($row->options);

        $joomlaFields[] = JHTML::_('select.option', '-1', JText::_('ADSMANAGER_NOT_USED') );

        $joomla_fields = $this->getJoomlaUserPluginFields();

        if (isset($joomla_fields))
		{
			foreach($joomla_fields as $jf)
			{
				$jFields = array();
				if(isset($jf->profile_key)) {
					$jFields = explode('.', $jf->profile_key);
				} else {
					$jFields[0] = $jf;
				}

                if(isset($jFields[1])) {
                    $jFields = $jFields[1];
                } else {
                    $jFields = $jf;
                }
				$joomlaFields[] = JHTML::_('select.option', $jFields, $jFields );
			}
		}
        $lists['joomlafields'] = JHTML::_('select.genericlist', $joomlaFields, 'userfield_joomlafield', 'class="inputbox" size="1"', 'value', 'text', @$rowOptions->joomlafield );

		$return = "<div id='divUserfieldOptions'>";
		$return .= "<table class='adminform'>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Joomla plugin field</td>";
		$return .= "<td width='20%' align=left>".$lists['joomlafields']."</td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "</table>";
		$return .= "</div>";
		return $return;
	}

    function getJoomlaUserPluginFields() {
		$config	= JFactory::getConfig();
		$dbprefix = JOOMLA_J3 ? $config->get('dbprefix') : $config->getValue('config.dbprefix');

		$this->_db->setQuery("SHOW TABLES LIKE '".$dbprefix."user_profiles'"  );
		$tables = $this->_db-> loadObjectList();
		if (count($tables) > 0)
		{
			$this->_db->setQuery("SELECT DISTINCT(profile_key) FROM #__user_profiles WHERE 1"  );
			$fields = $this->_db-> loadObjectList();
            $moreFields = array('name','username','email');
            $fields = array_merge($moreFields, $fields);
			return $fields;
		}
		else
			return array();
	}

	public function saveFieldOptions($field)
	{
		$joomlafield = JRequest::getVar('userfield_joomlafield','-1','string');

        $options = array();
        $options['joomlafield'] = $joomlafield;

        return $options;
	}

	public function getFieldName()
	{
		return "Userfield";
	}

	public function install()
	{
	}

	public function uninstall()
	{
	}

	public function __construct()
	{
		$db	= JFactory::getDBO();
		$this->_db = $db;
	}
}
require_once(JPATH_ROOT."/components/com_adsmanager/lib/core.php");
$plugins["userfield"] = new AdsManagerUserfieldPlugin();
