<?php
/**
 * @package		PaidSystem
 * @copyright	Copyright (C) 2010-2014 Juloa.com. All rights reserved.
 *  @license GNU General Public License version 3, or later
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

require_once(JPATH_ROOT."/components/com_adsmanager/lib/core.php");

// no direct access
defined('_JEXEC') or die('Restricted access');

class AdsManagerYouTubePlugin {

	var $_db;

	function getListDisplay($content,$field)
	{
		return AdsManagerYouTubePlugin::getDetailsDisplay($content,$field);
	}

	function getDetailsDisplay($content,$field)
	{
		$fieldid = $field->fieldid;

		$fieldname = $field->name;
		$value = @$content->$fieldname;

		$return ="";

		if ($value != "")
		{
			preg_match( "/.+v=(.+)$/", $value, $regs );
			if(isset($regs[1])){
                $key = $regs[1];
            } else {
                $key = explode('/',$value);
                $key = $key[count($key) - 1];
            }
			$this->_db->setQuery("SELECT * FROM #__adsmanager_youtube_conf WHERE fieldid = $field->fieldid");
			$conf =$this->_db->loadObject();
			ob_start();
			?>
			<iframe title="YouTube video player" class="youtube-player" type="text/html"
				width="<?php echo $conf->width?>" height="<?php echo $conf->height?>" src="http://www.youtube.com/embed/<?php echo $key ?>"
				frameborder="0" allowFullScreen></iframe>
			<?php
			$return = ob_get_clean();

		}
		return $return;
	}

	function getFormDisplay($content,$field,$default=null)
	{
		$fieldid = $field->fieldid;

		$fieldname = $field->name;
		$value = @$content->$fieldname;

		$return = '<div class="youtube">';
		$return .= '<input type="text" id="f'.$field->name.'" class="form-control" size="30" mosReq="'.$field->required.'" mosLabel="'.htmlspecialchars($field->title).'" name="'.$field->name.'" value="'.$value.'" />';

        $return .= '</div>';
		return $return;
	}

	function onFormSave(&$content,$field)
	{
		$url = JRequest::getVar($field->name,0);
		return $url;
	}

	function onDelete($directory,$contentid = -1)
	{
	}

	function getEditFieldJavaScriptDisable()
	{
		$return = "elem=getObject('divYouTubeOptions');";
        $return .= "elem.style.visibility = 'hidden';";
		$return .= "elem.style.display = 'none';";
		$return .= "elem=getObject('youtube_width');";
		$return .= "elem.setAttribute('mosReq',0);";
		$return .= "elem=getObject('youtube_height');";
		$return .= "elem.setAttribute('mosReq',0);";
		return $return;
	}

	function getEditFieldJavaScriptActive()
	{
        $return = "disableAll();";
		$return .= "elem=getObject('divYouTubeOptions');";
        $return .= "elem.style.visibility = 'visible';";
        $return .= "elem.style.display = 'block';";
		$return .= "elem=getObject('youtube_width');";
		$return .= "elem.setAttribute('mosReq',1);";
		$return .= "elem=getObject('youtube_height');";
		$return .= "elem.setAttribute('mosReq',1);";
		return $return;
	}

	function getEditFieldOptions($fieldid)
	{
		$this->install();
		$this->_db->setQuery("SELECT * FROM #__adsmanager_youtube_conf WHERE fieldid = '$fieldid'");
		$row = $this->_db->loadObject();

		$return = "<div id='divYouTubeOptions'>";
		$return .= "<table class='adminform'>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Player Width</td>";
		$return .= "<td width='20%' align=left><input type='text' id='youtube_width' name='youtube_width' mosReq=1 mosLabel='Player Width' class='inputbox' value='".@$row->width."' /></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "<tr>";
		$return .= "<td width='20%'>Player Height</td>";
		$return .= "<td width='20%' align=left><input type='text' id='youtube_height' name='youtube_height' mosReq=1 mosLabel='Player Height' class='inputbox' value='".@$row->height."' /></td>";
		$return .= "<td>&nbsp;</td>";
		$return .= "</tr>";
		$return .= "</table>";
		$return .= "</div>";
		return $return;
	}

	function saveFieldOptions($field)
	{
		$this->install();
		$width =  JRequest::getInt("youtube_width",0);
		$height = JRequest::getInt("youtube_height",0);
		$this->_db->setQuery("DELETE FROM #__adsmanager_youtube_conf WHERE fieldid = ".(int)$field->fieldid);
		$this->_db->query();
		$this->_db->setQuery("INSERT INTO #__adsmanager_youtube_conf VALUES ($field->fieldid,$width,$height)");
		$this->_db->query();
		return;
	}

	function getFieldName()
	{
		return "YouTube Player";
	}

	function install()
	{
		$query = "CREATE TABLE IF NOT EXISTS `#__adsmanager_youtube_conf` ( ".
			  "`fieldid` int(10) unsigned NOT NULL, ".
			  "`width` int(10) unsigned default '500', ".
			  "`height` int(10) unsigned default '300', ".
			  "PRIMARY KEY  (`fieldid`) ".
			  "); ";
		$this->_db->setQuery($query);
		$this->_db->query();
	}

	function uninstall()
	{
		$query = "DROP TABLE `#__adsmanager_youtube_conf`";
		$this->_db->setQuery($query);
		$this->_db->query();
	}

	function __construct()
	{
		$db	= JFactory::getDBO();
		$this->_db = $db;
	}
}

$plugins["youtube"] = new AdsManagerYouTubePlugin();
?>
