/**
 * Inline development version. Only to be used while developing since it uses document.write to load scripts.
 */

/*jshint smarttabs:true, undef:true, latedef:true, curly:true, bitwise:true, camelcase:true */

(function (exports) {
    "use strict";

    var base = '../../../codemirror5', scripts = [];

    function include(u) {
        scripts.push(base + '/' + u);
    }

    function load() {
        var i, html = '';

        for (i = 0; i < scripts.length; i++) {
            html += '<script type="text/javascript" src="' + scripts[i] + '"></script>\n';
        }
        document.write(html);
    }

    include('lib/codemirror.js');

    // addon
    include('addon/edit/closebrackets.js');
    include('addon/edit/closetag.js');
    include('addon/edit/matchbrackets.js');
    include('addon/selection/active-line.js');
    include('addon/selection/mark-selection.js');
    include('addon/search/match-highlighter.js');
    include('addon/search/search.js');
    include('addon/search/searchcursor.js');
    include('addon/fold/foldcode.js');
    include('addon/fold/foldgutter.js');
    include('addon/fold/brace-fold.js');
    include('addon/fold/xml-fold.js');
    include('addon/fold/indent-fold.js');
    include('addon/fold/markdown-fold.js');
    include('addon/fold/comment-fold.js');

    // mode
    include('mode/clike/clike.js');
    include('mode/css/css.js');
    include('mode/htmlmixed/htmlmixed.js');
    include('mode/javascript/javascript.js');
    include('mode/php/php.js');
    include('mode/xml/xml.js');

    load();
})(this);