<?php
/*------------------------------------------------------------------------
# JBusinessDirectory
# author CMSJunkie
# copyright Copyright (C) 2012 cmsjunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.cmsjunkie.com
# Technical Support:  Forum - http://www.cmsjunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );


abstract class modJAdsLatestHelper
{
	public static function getList(&$params){
				
		// Get the database object.
		$db = JFactory::getDBO();
		
		$whereCatCond = '';
		$categoriesIds = $params->get('categoryIds');
		if(!empty($categoriesIds) && $categoriesIds[0]!="" && $categoriesIds[0]!= 0){
			$categoriesIDs = implode(",",$params->get('categoryIds'));
			$whereCatCond = " and a.category_id in ($categoriesIDs)";	
		}
		
		$onlyFeatured = $params->get('count');
		
		$featuredFilter="";
		$featured  = $params->get('only_featured');
		if($featured){
			$featuredFilter = " having a.featured  = 1";
		}
		
		$city = $params->get('city');
		//dump($city);
		$whereCityCond='';
		if(!empty($city)){
			$whereCityCond=" and a.city = '".$db->escape($city)."' ";
		}
		
		$orderBy = " rand() ";
		$ordering  = $params->get('order');
		if($ordering){
			$orderBy ="a.creation_date desc";
		}
		$nrResults = $params->get('count');

		//Ad availability period
		$applicationSettings = JAdsUtil::getApplicationSettings();
 		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;

		$query = "  
			SELECT a.*,b.picture_id,j.valid,c.code as currency,ifnull(i.name, ifnull(h.name,g.name)) as category, if(LENGTH(a.editions) > 1, 1, 0) as paidAd,j.valid 
					   FROM #__classifiedsmanager_ads a 
			           left join 
						   (   select ad_id, name as picture_id
							   from #__classifiedsmanager_pictures 
							   where order_num=1
							) as b on a.id=b.ad_id
						left join #__classifiedsmanager_category g on a.category_id =g.id
						left join #__classifiedsmanager_category h on a.sub_category_id =h.id
						left join #__classifiedsmanager_category i on a.sub_category_id2 =i.id
						inner join #__classifiedsmanager_currency c on a.currency_id = c.id
						inner join #__classifiedsmanager_users f on a.user_id = f.id
						left join
				                (
				                   select a.ad_id, b.type as type, max(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) - CURDATE() >=0
				                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)- CURDATE() >=0
				                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)- CURDATE() >=0
				                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)- CURDATE() >=0
				                     END ) 
				                     as valid,
				                     max(date(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) 
				                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)
				                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)
				                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)
				                     END )) endDate
				                    from #__classifiedsmanager_orders a 
				                    inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
				                    where a.payment_status_id=1
				                     group by a.ad_id
							      ) j on a.id = j.ad_id 
						
						where 1 
						and 1 
						and a.status=1
		                $whereCatCond
		                $whereCityCond
		                $featuredFilter
		                and  ( j.valid > 0 or ( date_add(date(a.renewal_date),INTERVAL $validPeriod) - CURDATE() >0 ) )
		                and a.softdelete != 1
						order by $orderBy";

		// Set the query and get the result list.
		$db->setQuery($query, 0, $nrResults);
		$items = $db->loadObjectlist();

		return $items;
	}
}
?>
