<?php
/**
 * @package    J-BusinessDirectory
 *
 * @author     CMSJunkie http://www.cmsjunkie.com/
 * @copyright  Copyright (C) 2007 - 2022 CMSJunkie. All rights reserved.
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
?>

<div class="jcls-container offers<?php echo $moduleclass_sfx; ?> jbd-grid-container">
    <?php $index = 0;?>
    <div class="row">
        <?php if(!empty($items)){?>
        <?php foreach ($items as $ad) { ?>
        <?php $index ++;
            $ad->link = JAdsUtil::getAdLink($ad->id,$ad->alias);
        ?>
        <div class="<?php echo $span?> my-3">
            <div class="jitem-card"  style="<?php echo $borderCss?>">
                <div class="jitem-img-wrap">
                    <a href="<?php echo htmlspecialchars($item->link, ENT_QUOTES) ?>"></a>
                    <?php if(empty($ad->picture_id)):?>
                        <img title="No img" alt="No img" src="<?php echo "modules/mod_jads_latest/images/noimg.jpg";?>">
                    <?php else: ?>
                        <img title="<?php echo $ad->title?>" alt="<?php echo $ad->title?>" src="<?php JURI::root()?>components/com_jclassifiedsmanager/imageupload/uploaded_images/med_<?php echo$ad->picture_id;?>">
                    <?php endif ?>
                    <div class="card-hoverable">
                        <a class="hoverable h-100 w-100" href="<?php echo htmlspecialchars($ad->link, ENT_QUOTES) ?>"></a>
                    </div>
                </div>
                <div class="jitem-body">
                    <div class="jitem-body-content">
                        <div class="jitem-title">
                            <a class="item-name" href="<?php echo $ad->link ?>" >
                                <?php echo $ad->title; ?>
                            </a>
                            <div class="mt-2 mb-2 jitem-desc">
                               <a href="<?php echo JRoute::_("index.php?option=com_jclassifiedsmanager&view=displayads&controller=displayads&task=displayads.searchAds&categorySearch=".$ad->category_id."");?>"> <i class="fa fa-folder-o"></i> <?php echo $ad->category;?> </a>
                            </div>
                            <?php
                                if(!empty($ad->description)){
                                    echo "<div class='mt-2 mb-2 jitem-desc'>".( strlen($ad->description)>75?JAdsUtil::truncate($ad->description,75):$ad->description)."</div>";
                                }
                            ?>
                        </div>
                        <div class="jitem-desc">
                            <div class="offer-price">
                                <?php if(!empty($ad->price)){ ?>
                                    <span class="price"><?php echo $ad->currency." ".JAdsUtil::getPriceFormat($ad->price)?></span>
                                <?php } ?>
                                <?php if (empty($ad->price)) { ?>
                                        <span class="price"><?php echo JText::_('LNG_FREE') ?></span>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="jitem-bottom text-center">
                        <div style="<?php echo $backgroundCss?>" class="p-3 w-100">
                            <?php
                            if(!empty($ad->city)) {?>
                                <div class="item-address mb-2">
                                    <i class="fa fa-map-marker"></i> <?php echo $ad->city?>, <span itemprop="county-name"><?php echo $ad->state?>
                                </div>
                            <?php } ?>
                            <a class="btn btn-success" href="<?php echo $ad->link ?>">
                                <?php echo JText::_("LNG_AD_DETAILS")?>
                            </a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <?php if($index%4 == 0 && count($items)>$index){ ?>
    </div>
    <div class="row">
        <?php }?>
        <?php } ?>
        <?php } ?>
    </div>

</div>

<script>
    window.addEventListener('load', function(){
        <?php
        $load = JFactory::getApplication()->input->get("geo-latitude");
        if($params->get('geo_location') && empty($load)){ ?>
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(jbdUtils.addCoordinatesToUrl);
        }
        <?php } ?>
    });
</script>