<?php // no direct access
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/


defined( '_JEXEC' ) or die( 'Restricted access' ); 
?>
<div id="jcls-search" class="jcls-container">
	<div id="jcls-container-<?php echo $token ?>">
		<div id="searchform" class="jcls-search-form">
			<?php $title = $params->get('title'); ?>
			<?php if(!empty($title)){ ?>
				<h1><?php echo $title ?></h1>
			<?php } ?>
			<?php $description = $params->get('description'); ?>
			<?php if(!empty($description)){ ?>
				<p class="search-description"><?php echo $description ?></p>
			<?php } ?>

			<div class="jcls-search-bar">
				<form action="<?php echo JRoute::_('index.php?option=com_jclassifiedsmanager') ?>" method="post" id="keywordSearch" name="keywordSearch">
					<div class="form-container">
						<div class="fields-container">
							<?php if($params->get('showKeyword')){ ?>
								<div class="form-field">
									<div class="searchDiv">
										<?php 
											$searchKeyword = $session->get('searchKeyword');
											$searchKeywordVal = empty($searchKeyword)?"":$searchKeyword;
										?>
										<input type="text" class="search" name="searchKeyword" placeholder="<?php echo JText::_("LNG_SEARCH_FOR") ?>" id="searchbar" value="<?php echo $searchKeywordVal;?>"/>
										<?php if($params->get('fieldLabel')==1){ ?>
											<i class="la la-search"></i>
										<?php }?>
									</div>
									<div class="activeAds"><?php echo JText::_('LNG_ACTIVE_ADS').": ".$activeAds;?></div>
								</div>
							<?php } ?>

							<?php if($params->get('showCategories')){ ?>
								<div class="form-field">
									<select name="categorySearch" id="categorySearch">
										<option value=""><?php echo JText::_("LNG_ALL_CATEGORIES") ?></option>
										<?php foreach($categories as $category){?>
											<option value="<?php echo $category->id?>" <?php echo $session->get('categorySearch')==$category->id?" selected ":"" ?>   ><?php echo $category->name?></option>
										<?php }?>
									</select>
								</div>
							<?php }?>

							<?php if($params->get('showAdType')){ ?>
								<div class="form-field">
									<select name="adType" id="adTypeClassifieds">
										<option value="0"><?php echo JText::_('LNG_ALL_AD_TYPES') ; ?> </option>
										<?php foreach($adtypes as $adtype){?>
											<option value="<?php echo $adtype->id?>" <?php echo $session->get('adType')==$adtype->id?" selected ":"" ?>   ><?php echo JText::_('LNG_'.$adtype->code) ; ?> </option>
										<?php }?>
									</select>
								</div>
							<?php }?>

							<?php if($params->get('showCities')){ ?>
								<div class="form-field">
									<select name="citySearch" id="citySearch">
										<option value="0"><?php echo JText::_("LNG_ALL_CITIES") ?></option>
										<?php foreach($cities as $city){
											if($city->city!=""){?>
											<option value="<?php echo $city->city?>"  <?php echo $session->get('citySearch')==$city->city?" selected ":"" ?>   ><?php echo $city->city?></option>
										<?php }}?>
									</select>
								</div>
							<?php } ?>

							<?php if($params->get('showRegions')){ ?>
								<div class="form-field">
									<select name="regionSearch" id="regionSearch">
										<option value="0"><?php echo JText::_("LNG_ALL_REGIONS") ?></option>
										<?php foreach($regions as $region){?>
											<option value="<?php echo $region->state?>" <?php echo $session->get('regionSearch')==$region->state?" selected ":"" ?> ><?php echo $region->state?></option>
										<?php }?>
										
									</select>
								</div>
							<?php } ?>

							<?php if($params->get('showZipcode')){ ?>
								<div class="form-field zipcode-container" id="zipcode-container" style="display:block;">
									<div class="has-jicon-left" id="search-field-container-<?php echo $token ?>">
										<?php 
											$zipCode= $session->get('zipcode');
											$zipCodeVal = empty($zipCode)?"":$zipCode;
										?>
										<input class="search-field zipcode-<?php echo $token ?>" type="text" value="<?php echo $zipCodeVal; ?>" class="search-field" placeholder="<?php echo JText::_("LNG_ZIPCODE")?>"  name="zipcode" id="zipcode"/>
										<i class="la la-map-marker"></i>
									</div>
									<div class="search-dropdown dir-search-preferences-<?php echo $token ?>" style="display:none">
										<h3 class="title"><?php echo JText::_("LNG_SEARCH_PREFERENCES")?>
										<i class="dir-icon-close" onclick="jQuery('#dir-search-preferences').hide()"></i></h3>
										<div class="geo-radius">
											<div><?php echo JText::_("LNG_RADIUS")?> (<?php echo JText::_("LNG_KM") ?>)</div>
										</div>
										<div>
											<input type="text" id="geo-location-radius" name="geo-loc-radius" value="<?php echo !empty($radius)?$radius: "0" ?>">
											<!-- <input type="hidden" id="geo-loc-radius"   > -->
										</div>
										<div class="geo-location">
											<?php echo JText::_("LNG_GEOLOCATION")?>
											<div id="loading-geo-locaiton" class="ui-autocomplete-loading" style="display:none"></div>
											<a id="enable-geolocation" class="toggle btn-on <?php echo !empty($geoLocation)?"active":""?>" title="Grid" href="javascript:enableGeoLocation()"><?php echo strtoupper(JText::_("LNG_ON")) ?></a>
											<a id="disable-geolocation" class="toggle btn-off <?php echo empty($geoLocation)?"active":""?> " title="List" href="javascript:disableGeoLocation()"><?php echo strtoupper(JText::_("LNG_OFF")) ?></a>
										</div>
									</div>




								</div>
							<?php } ?>
							<div class="form-field">
								<button type="submit" class="btn btn-success ui-ad-button">
									<i class="dir-icon-search"></i>
									<span class="ui-button-text"><?php echo JText::_("LNG_SEARCH")?></span>
								</button>
							</div>
						</div>
					</div>

					<input type="hidden" name="option" value="com_jclassifiedsmanager" >
					<input type="hidden" name="controller" id="controller" value="displayads" />
					<input type="hidden" name="task" value="searchAds">
					<input type="hidden" name="view" id="view" value="displayads">	
					<input type="hidden" name="geo-latitude" id="geo-latitude" value="<?php echo isset($latitude) ?  $latitude : '0' ?>">
					<input type="hidden" name="geo-longitude" id="geo-longitude" value="<?php echo isset($longitude) ?  $longitude : '0' ?>">
					<input type="hidden" name="geolocation" id="geolocation" value="<?php echo isset($geoLocation) ?  $geoLocation : '0' ?>">		
				</form>
			</div>
		</div>		
	</div>
</div>
	 
<script type="text/javascript">
	window.addEventListener('load', function() {

		jQuery("#geo-location-radius").ionRangeSlider({
		grid: true,
		min: 0,
		max: 250,
		from:<?php echo !empty($radius)?$radius: "0" ?>,
		to: 250,
			});

		jQuery(".zipcode-<?php echo $token ?>").focusin(function() {
            jQuery(".dir-search-preferences-<?php echo $token ?>").slideDown(500);
        });

        jQuery(".zipcode-<?php echo $token ?>").focusout(function() {
            jQuery(".dir-search-preferences-<?php echo $token ?>").slideUp(500);
        });

	});


	function checkSearch(){ 

	<?php if($params->get('mandatoryKeyword')){ ?>
		if(document.getElementById('searchkeyword') && jQuery("#searchkeyword").val().length == 0){
			jQuery("#searchkeyword").focus();
			return false;
		}
	<?php } ?>

	<?php if($params->get('mandatoryCategories')){ ?>
		var foo = document.getElementById('categories');
		if (foo)
		{
		   if (foo.selectedIndex == 0)
		   {
			   jQuery("#categories").focus();
			   return false;
		   } 
		}
	<?php } ?>


	<?php if($params->get('mandatoryCities')){ ?>
		var foo = document.getElementById('citySearch');
		if (foo)
		{
		   if (foo.selectedIndex == 0)
		   {
			   jQuery("#citySearch").focus();
			   return false;
		   } 
		}
	<?php } ?>

	<?php if($params->get('mandatoryRegions')){ ?>
		var foo = document.getElementById('regionSearch');
		if (foo)
		{
		   if (foo.selectedIndex == 0)
		   {
			   jQuery("#regionSearch").focus();
				return false;
		   } 
		}
	<?php } ?>



	<?php if($params->get('mandatoryZipCode')){ ?>
		if(document.getElementById('zipcode') && jQuery("#zipcode").val().length == 0){
			jQuery("#zipcode").focus();
			return false;
		}
	<?php } ?>
		
	
		return true;
	}

	function enableGeoLocation(){
		 if (navigator.geolocation) {
	        navigator.geolocation.getCurrentPosition(setGeoLocation);
	        //console.debug("geolocation enabled");
	        jQuery("#loading-geo-locaiton").show();
	    }else{
	    	//console.debug("geolocation not supported");
	    } 
	
		 jQuery("#enable-geolocation").addClass("active");
		 jQuery("#disable-geolocation").removeClass("active");    
		 jQuery("#geolocation").val(1);
	}
	
	function disableGeoLocation(){
		jQuery("#enable-geolocation").removeClass("active");
		jQuery("#disable-geolocation").addClass("active");   
		jQuery("#geolocation").val(0);
		jQuery("#loading-geo-locaiton").hide();
		jQuery("#geo-latitude").val('');
		jQuery("#geo-longitude").val('');
	}
	
	
	function setGeoLocation(position){
		 jQuery("#loading-geo-locaiton").hide();
		//  console.debug("set geolocation");
		 var latitude = position.coords.latitude;
		 var longitude = position.coords.longitude;
		
		 jQuery("#geo-latitude").val(latitude);
		 jQuery("#geo-longitude").val(longitude);
	
	}
</script>