<?php
/**
* @package 		mod_whatsappsupport - Whatsapp Support
* @version		1.0.3
* @created		Aug 2019
* @author		ExtensionCoder.com
* @email		support@extensioncoder.com
* @website		https://www.extensioncoder.com
* @support		https://www.extensioncoder.com/support..html
* @copyright	Copyright (C) 2019 - 2020 https://www.extensioncoder.com. All rights reserved.
* @license		GNU General Public License version 2 and above
*/
	defined('_JEXEC') or die;

		// modules base location
		$site_uri = JUri::base();
		$module_uri = $site_uri.'modules/mod_whatsappsupport/';

		$document = JFactory::getDocument();

		// add module's js file to <head>
		$document->addScript($module_uri.'assets/js/javascript.js');

		// register Helper Class from helper.php 
		JLoader::register('ModWhatsappsupportHelper', __DIR__ . '/helper.php');
		// Assign getData Method of Helper Class to $get_data variable
		$get_data	= ModWhatsappsupportHelper::getData($params);

		// assign parameters to variables 
		$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'), ENT_COMPAT, 'UTF-8');
		// Field : Load jQuery 
		$loadjquery 			= $params->get('loadjquery', '0');
		// Field : Theme 
		$theme 			= $params->get('theme', 'multi');
		$btheme_but			= $params->get('btheme_but', 'flaticon');
		$btheme_ma			= $params->get('btheme_ma', 'flaticon');
		$bimage			= $params->get('bimage', '');
		$bbimage			= $params->get('bbimage', '');
		// Field : Bottom Position 
		$bpos 			= $params->get('bpos', 'right');
		$bbpos 			= $params->get('bbpos', 'right');
		// Field : Show Form After
		$autotriggerenable 			= $params->get('autotriggerenable', '1');
		$showformafter 			= $params->get('showformafter', '2000');
		// Field : Trigger Animation 
		$tanimation 			= $params->get('tanimation', 'fadein');
		// Field : Close Animation 
		$tanimationend 			= $params->get('tanimationend', 'fadeout');
		// Field : Button Background Color 
		$buttonbgcolor 			= $params->get('buttonbgcolor', '#82AA05');
		$buttonbghcolor 			= $params->get('buttonbghcolor', '#a3d20f');
		// Field : Button Text Color 
		$buttontextcolor 			= $params->get('buttontextcolor', '#FFFFFF');
		$buttontexthcolor 			= $params->get('buttontexthcolor', '#FFFFFF');
		// Field : Buttton Text 
		$buttontext 			= $params->get('buttontext', 'Need help? Lets Chat');
		$singlebuttonphone		= $params->get('singlebuttonphone', '1234567890');
		$singlebuttonprechat		= $params->get('singlebuttonprechat', 'I have a question about your product.');
		$opencahatat		= $params->get('opencahatat', 'current');
		$mopencahatat		= $params->get('mopencahatat', 'current');
		// Field : Form Header Background Color 
		$fhbgcolor 			= $params->get('fhbgcolor', '#82AA05');
		// Field : Form Header Text Color 
		$fhtcolor 			= $params->get('fhtcolor', '#FFFFFF');
		// Field : Form Header Text 1 
		$fhtext1 			= $params->get('fhtext1', 'Hi, Need Help?');
		// Field : Form Header Text 2 
		$fhtext2 			= $params->get('fhtext2', 'Is there anything we can help you?');
		// Field : Agents 
		$magents 			= $params->get('magents', 'Some Value');
		// Field : Extra CSS 
		$extracss 			= $params->get('extracss', '/* extra css  */');
		// Field : Extra JS 
		$extrajs 			= $params->get('extrajs', '// extra js');
		// Load Layout
		switch ($theme)
		{
			case 'multi':
			$document->addStyleSheet($module_uri.'assets/css/animate.min.css');
			if($btheme_ma=='flaticon')
			{
				$document->addStyleSheet($module_uri.'assets/css/multiagent_style.css');
				require JModuleHelper::getLayoutPath('mod_whatsappsupport', 'multiagent');
			}
			else if($btheme_ma=='onlyicon')
			{
				$document->addStyleSheet($module_uri.'assets/css/multiagent_circle_style.css');
				require JModuleHelper::getLayoutPath('mod_whatsappsupport', 'multiagentcircle');
			}
			break;
			case 'button':
			// add module's stylesheet to <head>
			if($btheme_but=='flaticon')
			{
				$document->addStyleSheet($module_uri.'assets/css/flaticon_style.css');
				require JModuleHelper::getLayoutPath('mod_whatsappsupport', 'buttonflat');
			}
			else if($btheme_but=='flatimage')
			{
				$document->addStyleSheet($module_uri.'assets/css/flatimage_style.css');
				require JModuleHelper::getLayoutPath('mod_whatsappsupport', 'buttonimage');
			}
			else if($btheme_but=='flaticonbottom')
			{
				$document->addStyleSheet($module_uri.'assets/css/flaticon_bottom_style.css');
				require JModuleHelper::getLayoutPath('mod_whatsappsupport', 'buttonflatbottom');
			}
			else if($btheme_but=='flatimagebottom')
			{
				$document->addStyleSheet($module_uri.'assets/css/flatimage_bottom_style.css');
				require JModuleHelper::getLayoutPath('mod_whatsappsupport', 'buttonflatbottom');
			}				
			break;			
		}
		 
