function YtJLexBackend($, root) {
	// Global varname: ytbackend
	var o=this;labelId=0;
	// allow sorting
	this.resetSort = function(){
		if($('#YtJLexData').find('.YtItem[data-name="playlist"]').length || $('#YtJLexData').find('.YtItem').length>1)
		{
			$('#jform_params_rc_sort').parents('.control-group').show();
		} else {
			$('#jform_params_rc_sort').parents('.control-group').hide();
		}
	};

	this.method = function(name, value) {
		/**
		 * List method that supported: Video ID, User ID, Playlist, Query and ..
		 * ..Youtube service
		 */
		var listMethod={
				video:'Video',
				playlist:'Playlist',
				query:'Query/Channel',
				category:'Category'
			};

		var html = '<div class="YtItem prepare '+(value?'less':'extra')+'" data-name="' + name + '">';
		html +='<span class="YtMethod">'+listMethod[name]+'</span>';
		
		html +='<div class="ItemTool">';
		html +='<span class="YtMove" title="Move"><i class="icon yt-icon-cursor-move"></i></span>';
		html +='<span class="YtInfo" title="Toggle form"><i class="icon yt-icon-expand"></i></span>';
		html +='<span class="YtRemove" title="Remove"><i class="icon yt-icon-trash"></i></span>';
		html +='</div>';
		
		html +='<div class="YtItemData">';
		switch (name) {
			case 'video':
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Videos URL *</label>';
				html += '<textarea name="videoid" id="jlexinput_'+labelId+'" class="jlexinput jlexrequired" ></textarea>';
				labelId++;
				break;
			case 'playlist':
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Playlist ID *</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="playlistid" class="jlexinput jlexrequired" />';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Maximum results *</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="maxResults" class="jlexinput jlexrequired" value="50" />';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Offset (Limit start)</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="startIndex" class="jlexinput jlexrequired" value="0" />';
				labelId++;
				break;

			case 'category':
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Category ID *</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="categoryid" class="jlexinput jlexrequired" />';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Maximum results *</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="maxResults" class="jlexinput jlexrequired" value="50" />';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Region Code</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="regionCode" class="jlexinput" value="" placeholder="Learn more: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2" />';
				labelId++;
				break;

			case 'query':
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Query</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="query" class="jlexinput" />';
				labelId++;
				html += '<label for="jlexinput_'+labelId+'" class="jlexlabel">Channel ID <small>(<a href="javascript:void(0);" onclick="ytbackend.findChannelID('+labelId+');">Find channel ID by Youtube username.</a>)</small></label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="channelId" class="jlexinput" placeholder="UCbPuFpzPkRVaksX3H_F7J4A" />';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Video dimension</label>';
				html += '<select id="jlexinput_'+labelId+'" class="jlexinput" name="dimension">';
				html += '<option value="any" selected>Any</option>';
				html += '<option value="2d">Only 2D</option>';
				html += '<option value="3d">Only 3D</option>';
				html += '</select>';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Video definition</label>';
				html += '<select id="jlexinput_'+labelId+'" class="jlexinput" name="quality">';
				html += '<option value="any" selected>Any</option>';
				html += '<option value="high">High</option>';
				html += '<option value="standard">Standard</option>';
				html += '</select>';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Video caption</label>';
				html += '<select id="jlexinput_'+labelId+'" class="jlexinput" name="caption">';
				html += '<option value="any" selected>Any</option>';
				html += '<option value="closedCaption">Closed Caption</option>';
				html += '<option value="none">None</option>';
				html += '</select>';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Video long</label>';
				html += '<select id="jlexinput_'+labelId+'" class="jlexinput" name="long">';
				html += '<option value="any" selected>Any</option>';
				html += '<option value="short">Short</option>';
				html += '<option value="medium">Medium</option>';
				html += '<option value="long">Long</option>';
				html += '</select>';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Event type</label>';
				html += '<select id="jlexinput_'+labelId+'" class="jlexinput" name="eventType">';
				html += '<option value="any" selected>Any</option>';
				html += '<option value="short">Completed</option>';
				html += '<option value="live">Live</option>';
				html += '<option value="upcoming">Up coming</option>';
				html += '</select>';
				labelId++;
				html += '<label for="jlexinput_'+labelId+'" class="jlexlabel">Sort</label>';
				html += '<select id="jlexinput_'+labelId+'" class="jlexinput" name="orderby">';
				html += '<option value="relevance" selected>Relevance</option>';
				html += '<option value="date">Date</option>';
				html += '<option value="viewCount">View count</option>';
				html += '<option value="title">Title</option>';
				html += '</select>';
				labelId++;
				
				html += '<label for="jlexinput_'+labelId+'" class="jlexlabel">Time</label>';
				html += '<select id="jlexinput_'+labelId+'" class="jlexinput" name="time">';
				html += '<option value="all_time">All time</option>';
				html += '<option value="week">This week</option>';
				html += '<option value="month">This month</option>';
				html += '<option value="year">This year</option>';
				html += '</select>';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Published Before</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="publishedBefore" class="jlexinput" placeholder="YYYY-MM-DD HH:MM:SS" />';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Published After</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="publishedAfter" class="jlexinput" placeholder="YYYY-MM-DD HH:MM:SS" />';
				labelId++;
				
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Maximum results *</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="maxResults" class="jlexinput jlexrequired" value="50" />';
				labelId++;
				html += '<label class="jlexlabel" for="jlexinput_'+labelId+'">Offset (Limit start)</label>';
				html += '<input type="text" id="jlexinput_'+labelId+'" name="startIndex" class="jlexinput jlexrequired" value="0" />';
				labelId++;
				break;
		}
		html +='</div>';
		// Clearfix
		html += '<div class="clearfix"></div>';
		html += '</div>'; // Close element
		var $boxData = $('#YtJLexData');
		if(!$boxData.length) { 
			// Make sure that boxData exist.
			return false;
		}
		$boxData.append(html);
		if (value) {
			$.each(value, function(k, v) {
				$boxData.find('.YtItem:last').find('[name=' + k + ']').val(v);
			});
		}
		$boxData.find('.YtItem:last').removeClass('prepare');
		
		if($.fn.sortable) {
			if (window.YtSortable) {
				window.YtSortable.sortable("refresh");
			} else {
				window.YtSortable=$('#YtJLexData').sortable({
					itemSelector:'div.YtItem',
					group: 'simple_with_animation',
					handle: 'span.YtMove',
					pullPlaceholder: false,
					// set item relative to cursor position
					  onDragStart: function ($item, container, _super) {
					    var offset = $item.offset(),
					    pointer = container.rootGroup.pointer

					    adjustment = {
					      left: pointer.left - offset.left,
					      top: pointer.top - offset.top
					    }

					    _super($item, container)
					  },
					  onDrag: function ($item, position) {
					    $item.css({
					      left: position.left - adjustment.left,
					      top: position.top - adjustment.top
					    })
					  }
				});
			}
		}

		o.resetSort();
	};
	
	// Find channel ID base on Youtube user name
	this.findChannelID = (function(id){
		var u=window.prompt("Please enter Youtube username", "jlexteam");
		if(u!=null && /[A-z0-9\_\-]+/.test(u))
		{
			var k=window.apikey.length?window.apikey[0]:'AIzaSyDi1JyziylFOK2bnK9jFqWpa03BXeXNZjk';
			$('input#jlexinput_'+id).val('Please wait...');
			
			$.ajax('https://www.googleapis.com/youtube/v3/channels?part=id&forUsername='+u+'&key='+k, {
				type: "GET",
				dataType: "json",
				success: function(d){
					if(d.hasOwnProperty('items')){
						$('input#jlexinput_'+id).val(d.items[0].id);
					} else {
						// try another way
						$.get('https://youtube.googleapis.com/youtube/v3/search', {
							q:u,
							type:'channel',
							key:k
						}, function(d1){
							if(d1.hasOwnProperty('items'))
							{
								$('input#jlexinput_'+id).val(d1.items[0].id.channelId);
							} else {
								alert('The ID of this channel could not be found.');
							}
						}, 'json');
					}
		        },
		        error: function(d){
		        	alert(d.responseJSON.error.message);
		        	$('input#jlexinput_'+id).val('');
		        }
			});
		} else {
			alert('Username format incorrect.');
		}
	});

	// This function to save all items of Youtube module.
	this.save = function(){
		var $items = $('#YtJLexData .YtItem'), data=new Array();
		if($items.length<1)
		{
			alert('Value empty.');
			return false;
		}

		// Make sure a
		var empty=false;
		$.each($('#YtJLexData .jlexrequired'),function(){
			if ($.trim( $(this).val() )=='') {
				empty=true;
				$(this).focus();
				return false;
			}
		});
		if (empty) {
			alert('Please fill all input request.');
			return false;
		}
		$.each($items, function() {
			var item = {
				method : $(this).attr('data-name'),
				data : {}
			};
			$.each($(this).find('input[type=text],textarea,select'),
					function() { // Filter all input
						item.data[$(this).attr('name')] = $(this).val();
					});
			data.push(item);
		});
		// Done, export to JSON string
		data = JSON.stringify(data);
		$('textarea#ytjlexdata').val(data);

		// api keys
		var keys=[];
		$('#YtJLexKey .ls .i').each(function(){
			if(!/^\s*$/.test($(this).find('input').val())) keys.push($.trim($(this).find('input').val()));
		});

		if(!keys.length)
		{
			alert('Please add Youtube API key');
			$('[href="#attrib-c_api"]').trigger('click');
			return false;
		}

		$('#YtJLexKey textarea').val(keys.join("\n"));

		return true;
	};

	// This function to parse items.
	this.edit = function(data) {
		window.setTimeout(function(){
			$.each(data,function(k,v){
				o.method(v.method, v.data);
			});
		},1500);
	}
	
	this.init=function(){
		Joomla.submitbutton=(function(task) {
			if (task=='module.apply'||task=='module.save' || task=='module.save2new' || task=='module.save2copy' || task=='translate.save') {
				if (!o.save()) {
					return false;
				}
			}
			Joomla.submitform(task,document.getElementById('module-form'));
		});

		$(document).on('click','.YtInfo',function(){
			var $parent=$(this).parents('.YtItem');
			if ($parent.hasClass('less')) {
				$parent.removeClass('less').addClass('extra');
			} else {
				$parent.removeClass('extra').addClass('less');
			}
		})
		.on('click','.YtRemove',function(){
			var r = confirm("Are you sure?");
			if (r==true) {
				var $parent=$(this).parents('.YtItem');
				$parent.fadeOut('fast',function(){
					$(this).remove();
					o.resetSort();
				});
			}
		});

		/* api */
		if(!$('#YtJLexKey').length) return;
		var $a=$('#YtJLexKey');
			a_n=function(k){
				var $e=$a.find('#md').clone().removeAttr('id');
				if(typeof k!='undefined') $e.find('input').val(k);
				$e.find('button').click(function(){
					$e.fadeOut('fast', function(){
						$e.remove();
					});
				});

				$e.appendTo($a.find('.ls'));
				if(typeof k=='undefined') $e.find('input').focus();
			};

		if($a.find('textarea').val().split("\n").length)
		{
			$.each($a.find('textarea').val().split("\n"), function(k,v){
				if(!/^\s*$/.test(v)){
					window.apikey.push(v);
					a_n(v);
				}
			});
		}

		$a.find('.n').click(function(){
			a_n();
		});

		$a.find('.c').click(function(){
			var total=$a.find('.ls .i').length;
			var cs=function(){
				if(total==0) $a.find('.c').removeAttr('disabled');
			};

			if(total<1)
			{
				alert("PLEASE FILL KEY FIRST");
				return;
			}

			$a.find('.c').attr('disabled', 'disabled');

			$a.find('.ls .i').each(function(){
				var $e=$(this),
					api=$e.find('input').val();

				$e.find('.msg').remove();

				if(/^\s*$/.test(api)){
					$e.remove();
					total-=1; cs();
					return true;
				}

				if(!/^[A-z0-9\-\_]+$/.test(api))
				{
					$e.append('<div class="msg err">API KEY INCORRECT</div>');
					total-=1; cs();
					return true;
				}

				// ajax
				$.post(root+'/index.php', {option:'com_ajax', module:'yt_jlex', method:'checkApi',
					api:api,format:'json'}, function(d){
					if(d.data=="OK"){
						$e.append('<div class="msg success">Ok</div>');
						window.apikey.push(api);
					} else {
						$e.append('<div class="msg err">'+d.data+'</div>');
					}

					total-=1; cs();
				}, 'json');
			});
		});

		/* version */
		if ($("#jtBrand").length)
		{
			$.get(root+'/index.php', {option:"com_ajax", module:"yt_jlex", method:"versions", format:"json"}, function(d){
				if(!d.success || typeof d.data!="object") return;
				$(".jt-c-version .jh-value").text(d.data.version);

				let h="";
				if(d.data.hasOwnProperty("error"))
				{
					h='<span class="text-danger" title="'+d.data.error+'">Error</span>';
				}else if(d.data.hasOwnProperty("update")){
					h='<a class="text-danger" href="http://www.jlexart.com/downloads" target="_blank">'+d.data.latest_version+' - Update now</a>';
				} else {
					h='<span>'+d.data.version+'</span>';
				}
				$(".jt-l-version .jh-value").html(h);
			},"json");
		}
	};
}
