/*
 * Youtube Feed Pro 4.x.x
 * 
 * Copyright 2010-2014, JLexArt.com
 * http://jlexart.com/
 * 
 * Licensed under GPL2 or later
 */
function YTF(s) {
	// Load libs
	{
		/*! 
		 * jquery.event.drag - v 2.2
		 * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
		 * Open Source MIT License - http://threedubmedia.com/code/license
		 */
		// Created: 2008-06-04 
		// Updated: 2012-05-21
		// REQUIRES: jquery 1.7.x

		;(function( $ ){

		// add the jquery instance method
		$.fn.drag = function( str, arg, opts ){
			// figure out the event type
			var type = typeof str == "string" ? str : "",
			// figure out the event handler...
			fn = $.isFunction( str ) ? str : $.isFunction( arg ) ? arg : null;
			// fix the event type
			if ( type.indexOf("drag") !== 0 ) 
				type = "drag"+ type;
			// were options passed
			opts = ( str == fn ? arg : opts ) || {};
			// trigger or bind event handler
			return fn ? this.bind( type, opts, fn ) : this.trigger( type );
		};

		// local refs (increase compression)
		var $event = $.event, 
		$special = $event.special,
		// configure the drag special event 
		drag = $special.drag = {
			
			// these are the default settings
			defaults: {
				which: 1, // mouse button pressed to start drag sequence
				distance: 0, // distance dragged before dragstart
				not: ':input', // selector to suppress dragging on target elements
				handle: null, // selector to match handle target elements
				relative: false, // true to use "position", false to use "offset"
				drop: true, // false to suppress drop events, true or selector to allow
				click: false // false to suppress click events after dragend (no proxy)
			},
			
			// the key name for stored drag data
			datakey: "dragdata",
			
			// prevent bubbling for better performance
			noBubble: true,
			
			// count bound related events
			add: function( obj ){ 
				// read the interaction data
				var data = $.data( this, drag.datakey ),
				// read any passed options 
				opts = obj.data || {};
				// count another realted event
				data.related += 1;
				// extend data options bound with this event
				// don't iterate "opts" in case it is a node 
				$.each( drag.defaults, function( key, def ){
					if ( opts[ key ] !== undefined )
						data[ key ] = opts[ key ];
				});
			},
			
			// forget unbound related events
			remove: function(){
				$.data( this, drag.datakey ).related -= 1;
			},
			
			// configure interaction, capture settings
			setup: function(){
				// check for related events
				if ( $.data( this, drag.datakey ) ) 
					return;
				// initialize the drag data with copied defaults
				var data = $.extend({ related:0 }, drag.defaults );
				// store the interaction data
				$.data( this, drag.datakey, data );
				// bind the mousedown event, which starts drag interactions
				$event.add( this, "touchstart mousedown", drag.init, data );
				// prevent image dragging in IE...
				if ( this.attachEvent ) 
					this.attachEvent("ondragstart", drag.dontstart ); 
			},
			
			// destroy configured interaction
			teardown: function(){
				var data = $.data( this, drag.datakey ) || {};
				// check for related events
				if ( data.related ) 
					return;
				// remove the stored data
				$.removeData( this, drag.datakey );
				// remove the mousedown event
				$event.remove( this, "touchstart mousedown", drag.init );
				// enable text selection
				drag.textselect( true ); 
				// un-prevent image dragging in IE...
				if ( this.detachEvent ) 
					this.detachEvent("ondragstart", drag.dontstart ); 
			},
				
			// initialize the interaction
			init: function( event ){ 
				// sorry, only one touch at a time
				if ( drag.touched ) 
					return;
				// the drag/drop interaction data
				var dd = event.data, results;
				// check the which directive
				if ( event.which != 0 && dd.which > 0 && event.which != dd.which ) 
					return; 
				// check for suppressed selector
				if ( $( event.target ).is( dd.not ) ) 
					return;
				// check for handle selector
				if ( dd.handle && !$( event.target ).closest( dd.handle, event.currentTarget ).length ) 
					return;

				drag.touched = event.type == 'touchstart' ? this : null;
				dd.propagates = 1;
				dd.mousedown = this;
				dd.interactions = [ drag.interaction( this, dd ) ];
				dd.target = event.target;
				dd.pageX = event.pageX;
				dd.pageY = event.pageY;
				dd.dragging = null;
				// handle draginit event... 
				results = drag.hijack( event, "draginit", dd );
				// early cancel
				if ( !dd.propagates )
					return;
				// flatten the result set
				results = drag.flatten( results );
				// insert new interaction elements
				if ( results && results.length ){
					dd.interactions = [];
					$.each( results, function(){
						dd.interactions.push( drag.interaction( this, dd ) );
					});
				}
				// remember how many interactions are propagating
				dd.propagates = dd.interactions.length;
				// locate and init the drop targets
				if ( dd.drop !== false && $special.drop ) 
					$special.drop.handler( event, dd );
				// disable text selection
				drag.textselect( false ); 
				// bind additional events...
				if ( drag.touched )
					$event.add( drag.touched, "touchmove touchend", drag.handler, dd );
				else 
					$event.add( document, "mousemove mouseup", drag.handler, dd );
				// helps prevent text selection or scrolling
				if ( !drag.touched || dd.live )
					return false;
			},	
			
			// returns an interaction object
			interaction: function( elem, dd ){
				var offset = $( elem )[ dd.relative ? "position" : "offset" ]() || { top:0, left:0 };
				return {
					drag: elem, 
					callback: new drag.callback(), 
					droppable: [],
					offset: offset
				};
			},
			
			// handle drag-releatd DOM events
			handler: function( event ){ 
				// read the data before hijacking anything
				var dd = event.data;	
				// handle various events
				switch ( event.type ){
					// mousemove, check distance, start dragging
					case !dd.dragging && 'touchmove': 
						event.preventDefault();
					case !dd.dragging && 'mousemove':
						//  drag tolerance, x² + y² = distance²
						if ( Math.pow(  event.pageX-dd.pageX, 2 ) + Math.pow(  event.pageY-dd.pageY, 2 ) < Math.pow( dd.distance, 2 ) ) 
							break; // distance tolerance not reached
						event.target = dd.target; // force target from "mousedown" event (fix distance issue)
						drag.hijack( event, "dragstart", dd ); // trigger "dragstart"
						if ( dd.propagates ) // "dragstart" not rejected
							dd.dragging = true; // activate interaction
					// mousemove, dragging
					case 'touchmove':
						event.preventDefault();
					case 'mousemove':
						if ( dd.dragging ){
							// trigger "drag"		
							drag.hijack( event, "drag", dd );
							if ( dd.propagates ){
								// manage drop events
								if ( dd.drop !== false && $special.drop )
									$special.drop.handler( event, dd ); // "dropstart", "dropend"							
								break; // "drag" not rejected, stop		
							}
							event.type = "mouseup"; // helps "drop" handler behave
						}
					// mouseup, stop dragging
					case 'touchend': 
					case 'mouseup': 
					default:
						if ( drag.touched )
							$event.remove( drag.touched, "touchmove touchend", drag.handler ); // remove touch events
						else 
							$event.remove( document, "mousemove mouseup", drag.handler ); // remove page events	
						if ( dd.dragging ){
							if ( dd.drop !== false && $special.drop )
								$special.drop.handler( event, dd ); // "drop"
							drag.hijack( event, "dragend", dd ); // trigger "dragend"	
						}
						drag.textselect( true ); // enable text selection
						// if suppressing click events...
						if ( dd.click === false && dd.dragging )
							$.data( dd.mousedown, "suppress.click", new Date().getTime() + 5 );
						dd.dragging = drag.touched = false; // deactivate element	
						break;
				}
			},
				
			// re-use event object for custom events
			hijack: function( event, type, dd, x, elem ){
				// not configured
				if ( !dd ) 
					return;
				// remember the original event and type
				var orig = { event:event.originalEvent, type:event.type },
				// is the event drag related or drog related?
				mode = type.indexOf("drop") ? "drag" : "drop",
				// iteration vars
				result, i = x || 0, ia, $elems, callback,
				len = !isNaN( x ) ? x : dd.interactions.length;
				// modify the event type
				event.type = type;
				// remove the original event
				event.originalEvent = null;
				// initialize the results
				dd.results = [];
				// handle each interacted element
				do if ( ia = dd.interactions[ i ] ){
					// validate the interaction
					if ( type !== "dragend" && ia.cancelled )
						continue;
					// set the dragdrop properties on the event object
					callback = drag.properties( event, dd, ia );
					// prepare for more results
					ia.results = [];
					// handle each element
					$( elem || ia[ mode ] || dd.droppable ).each(function( p, subject ){
						// identify drag or drop targets individually
						callback.target = subject;
						// force propagtion of the custom event
						event.isPropagationStopped = function(){ return false; };
						// handle the event	
						result = subject ? $event.dispatch.call( subject, event, callback ) : null;
						// stop the drag interaction for this element
						if ( result === false ){
							if ( mode == "drag" ){
								ia.cancelled = true;
								dd.propagates -= 1;
							}
							if ( type == "drop" ){
								ia[ mode ][p] = null;
							}
						}
						// assign any dropinit elements
						else if ( type == "dropinit" )
							ia.droppable.push( drag.element( result ) || subject );
						// accept a returned proxy element 
						if ( type == "dragstart" )
							ia.proxy = $( drag.element( result ) || ia.drag )[0];
						// remember this result	
						ia.results.push( result );
						// forget the event result, for recycling
						delete event.result;
						// break on cancelled handler
						if ( type !== "dropinit" )
							return result;
					});	
					// flatten the results	
					dd.results[ i ] = drag.flatten( ia.results );	
					// accept a set of valid drop targets
					if ( type == "dropinit" )
						ia.droppable = drag.flatten( ia.droppable );
					// locate drop targets
					if ( type == "dragstart" && !ia.cancelled )
						callback.update(); 
				}
				while ( ++i < len )
				// restore the original event & type
				event.type = orig.type;
				event.originalEvent = orig.event;
				// return all handler results
				return drag.flatten( dd.results );
			},
				
			// extend the callback object with drag/drop properties...
			properties: function( event, dd, ia ){		
				var obj = ia.callback;
				// elements
				obj.drag = ia.drag;
				obj.proxy = ia.proxy || ia.drag;
				// starting mouse position
				obj.startX = dd.pageX;
				obj.startY = dd.pageY;
				// current distance dragged
				obj.deltaX = event.pageX - dd.pageX;
				obj.deltaY = event.pageY - dd.pageY;
				// original element position
				obj.originalX = ia.offset.left;
				obj.originalY = ia.offset.top;
				// adjusted element position
				obj.offsetX = obj.originalX + obj.deltaX; 
				obj.offsetY = obj.originalY + obj.deltaY;
				// assign the drop targets information
				obj.drop = drag.flatten( ( ia.drop || [] ).slice() );
				obj.available = drag.flatten( ( ia.droppable || [] ).slice() );
				return obj;	
			},
			
			// determine is the argument is an element or jquery instance
			element: function( arg ){
				if ( arg && ( arg.jquery || arg.nodeType == 1 ) )
					return arg;
			},
			
			// flatten nested jquery objects and arrays into a single dimension array
			flatten: function( arr ){
				return $.map( arr, function( member ){
					return member && member.jquery ? $.makeArray( member ) : 
						member && member.length ? drag.flatten( member ) : member;
				});
			},
			
			// toggles text selection attributes ON (true) or OFF (false)
			textselect: function( bool ){ 
				$( document )[ bool ? "unbind" : "bind" ]("selectstart", drag.dontstart )
					.css("MozUserSelect", bool ? "" : "none" );
				// .attr("unselectable", bool ? "off" : "on" )
				document.unselectable = bool ? "off" : "on"; 
			},
			
			// suppress "selectstart" and "ondragstart" events
			dontstart: function(){ 
				return false; 
			},
			
			// a callback instance contructor
			callback: function(){}
			
		};

		// callback methods
		drag.callback.prototype = {
			update: function(){
				if ( $special.drop && this.available.length )
					$.each( this.available, function( i ){
						$special.drop.locate( this, i );
					});
			}
		};

		// patch $.event.$dispatch to allow suppressing clicks
		var $dispatch = $event.dispatch;
		$event.dispatch = function( event ){
			if ( $.data( this, "suppress."+ event.type ) - new Date().getTime() > 0 ){
				$.removeData( this, "suppress."+ event.type );
				return;
			}
			return $dispatch.apply( this, arguments );
		};

		// event fix hooks for touch events...
		var touchHooks = 
		$event.fixHooks.touchstart = 
		$event.fixHooks.touchmove = 
		$event.fixHooks.touchend =
		$event.fixHooks.touchcancel = {
			props: "clientX clientY pageX pageY screenX screenY".split( " " ),
			filter: function( event, orig ) {
				if ( orig ){
					var touched = ( orig.touches && orig.touches[0] )
						|| ( orig.changedTouches && orig.changedTouches[0] )
						|| null; 
					// iOS webkit: touchstart, touchmove, touchend
					if ( touched ) 
						$.each( touchHooks.props, function( i, prop ){
							event[ prop ] = touched[ prop ];
						});
				}
				return event;
			}
		};

		// share the same special event configuration with related events...
		$special.draginit = $special.dragstart = $special.dragend = drag;

		})( jQuery );
	}

	// Youtube module core!
	var $j = jQuery.noConflict();
	var _this=this,
		$p=$j('#ytfPlayer_'+s.moduleid),
		ytdata=[], // static of data
		ytdataid=[],
		vidData=[], // dynamic data
		isReady=false,
		vidCurrent=0,
		player,
		scroll=null,
		bglist=false,
		oldWidth=0,
		limit=s.limit,
		limitstart=limit,
		keyword='';

	_this.data = {
		pending : [],
		process :[],
		completed: [],
		root:[],
		count:0
	};

	_this.player = null;
	_this.playerIndex = 0;

	if(s.style=="background")
	{
		// special variables for background mode
		s.autoplay = 1;
		s.controls = 0;
		s.showinfo = 0;
		s.show_desc = 0;
		s.rel = 0;
		s.show_list = 0;
		s.fs = 0;
		s.annotation = 0;
		s.brand = 0;
		s.intromode = 0;
		s.bgurl = '';
	}

	if(s.style=='slider'){
		s.showlist = 1;
		s.showthumb = 1;
	}

	_this.passKeyword=function(title)
	{
		var preg_quote = function(str, delimiter){
				return (str + '')
		    	.replace(new RegExp('[.\\\\+*?\\[\\^\\]$(){}=!<>|:\\' + (delimiter || '') + '-]', 'g'), '\\$&')
			},
			regex = new RegExp(preg_quote(keyword), "i");

		if(regex.test(title)) return true;
		return false;
	};

	_this.yesReady=function(){
		if(s.popup){
			var wh=$j(window).height();
			if (wh>$p.find('.ytfPopup').height()) {
				$p.find('.ytfPopup').css('top',((wh-$p.find('.ytf-container').height())/2)+'px');
			} else {
				$p.find('.ytfPopup').css({'margin-top':'10px','margin-bottom':'10px'});
			}
		}

		_this.loadThumb();
		$p.find('.ytf-loading').fadeOut('fast');
		$p.find('.ytf-container').addClass('ytf-ready');
		$p.find('.ytf-player,.ytf-sidebar,.ytfOpenlist').addClass('ytf-ready');

		if (s.grid_popup && (s.style=='grid' || s.style=='slider')) $p.find(".ytf-player").hide();
	};

	_this.formatTime=function(duration){
		var parts=duration.match(/([0-9]+H)?([0-9]+M)?([0-9]+S)?$/),
			hours = typeof parts[1]!="undefined" ? parseInt(parts[1]):0,
	    	minutes = typeof parts[2]!="undefined" ? parseInt(parts[2]):0,
	    	seconds = typeof parts[3]!="undefined" ? parseInt(parts[3]):0,
	    	strtime = "";
		if (hours>0)
		{
			strtime+=(hours<10?'0'+hours:hours)+':';
		}

	    strtime+=(minutes<10?'0'+minutes:minutes)+':'+(seconds<10?'0'+seconds:seconds);
		return strtime;
	};

	_this.str2Time=function(timestring,format){
		var n=timestring.match(/[0-9]+/g),r;
		if (format==1) {
			var now=new Date().getTime();
			var vdate=new Date(n[0], parseInt(n[1])-1, n[2], n[3], n[4], n[5],0).getTime();
			$elstime=(now-vdate)/1000;
			if ($elstime<60) {
				r=s.lang.RECENT;
			} else if ($elstime < 3600) {
				r=parseInt($elstime/60) + ' ' + s.lang.MINUTE;
			} else if ($elstime < 24*3600) {
				r=parseInt($elstime/3600) + ' ' + s.lang.HOURS;
			} else if ($elstime < 24*3600*30) {
				r=parseInt($elstime/(3600*24)) + ' '+ s.lang.DAYS;
			} else if ($elstime < 24*3600*30*12) {
				r=parseInt($elstime/(3600*24*30)) + ' '+ s.lang.MONTHS;
			} else {
				r=parseInt($elstime/(3600*24*30*12)) + ' '+ s.lang.YEARS;
			}
			if ($elstime>=60) r=r+' '+s.lang.AGO;
		} else {
			r=n[3]+':'+n[4]+':'+n[5]+' '+n[2]+'/'+n[1]+'/'+n[0];
		}
		return r;
	};

	_this.shortStr=function(str,maxword){
		var t=str.split(" "),nt='',min=Math.min(t.length,maxword);
		if (maxword>min) return str;
		for (i=0;i<min;i++) {
			nt+=t[i]+' ';
		}
		return $j.trim(nt)+'...';
	};

	/**
	 * Apply for touch device when screen small
	 */
	_this.openlist=function(obj) {
		if(s.style=='slider') return;

		if ($j(obj).hasClass('opened')) {
			$p.find('.ytf-sidebar').removeClass('opened');
			$p.removeClass('list-open');
			$j(obj).removeClass('opened').text(s.lang.SHOW_LIST);
		} else {
			$p.find('.ytf-sidebar').addClass('opened');
			$p.addClass('list-open');
			$j(obj).addClass('opened').text(s.lang.HIDE_LIST);
		}
		if (scroll) { scroll.update(); }
	};

	/**
	 * Move list, use for hoz style
	 * Stop this feature at v3.x
	 */
	_this.moveList=function(way){
		return;
	};

	_this.swipeTo=function(index){
		if (scroll) {
			scroll.moveTo(index);
		}
	};

	_this.bindHTML=function(callback){
		/* Bind size */
		var list_center = function(resize)
			{
				if (s.style!='grid' || s.listcenter==0)
				{
					return true;
				}

				if ($p.find('.ytfBlock').length < 2)
				{
					return false;
				}

				if ($p.find('.ytf-container').hasClass("ytf-xs") || $p.find('.ytf-container').hasClass("ytf-sm"))
				{
					$p.find('.swiper-wrapper').removeAttr("style");
					$p.find('.ytfBlock').removeAttr("style");
					return true;
				}

				var wItem = $p.find('.ytfBlock:eq(0)').width(),
					wBox = $p.find('.swiper-container').width(),
					nLine,
					wSpace,
					wWrap;

				nLine = parseInt(wBox/wItem);
				wSpace = parseInt( (wBox-(wItem)*nLine)/(nLine-1) );
				$p.find('.swiper-wrapper').width(nLine*(wSpace+wItem));
				$p.find('.ytfBlock').css('margin-right',wSpace);
			
				return true;
			},

			adjust_tpl = function(resize)
			{
				var w=$p.find('.ytf-container').outerWidth(),
					ww=$j(window).width();

				/*if (ww==oldWidth) {
					return null;
				} else {
					oldWidth=ww;
				}*/

				$p.find('.ytf-container').removeClass('ytf-xs ytf-sm ytf-md ytf-lg');
				$p.find('.ytf-player,.ytf-sidebar').css({height:'',width:''});
				$p.find('a.opened').text(s.lang.SHOW_LIST).removeClass('opened');
				$p.find('div.opened').removeClass('opened');

				var subOfWidth = 0;
				var activeSize = null;

				if (s.show_list) {
					var searchboxHeight = s.searchbox?35:0;
					if (w < s.small_devices) {
						activeSize = 'ytf-xs';
					} else if (w < s.medium_devices && w>= s.small_devices) {
						activeSize = 'ytf-sm';
					} else if (w < s.large_devices && w>= s.medium_devices) {
						activeSize = 'ytf-md';
						if (s.style=='ver')
						{
							subOfWidth = 114;
							$p.find('.ytf-sidebar').height((w-114)*(s.ratio=='4:3'?3/4:9/16)-35-searchboxHeight);
						}	
					} else {
						activeSize = 'ytf-lg';
						if (s.style=='ver') {
							subOfWidth = 300;
							$p.find('.ytf-sidebar').height((w-300)*(s.ratio=='4:3'?3/4:9/16)-searchboxHeight);
						}			
					}
					$p.find('.ytf-container').addClass(activeSize);
				} else {
					$p.find('.ytf-sidebar').remove();
				}

				// size of player
				if ((s.style=="grid"||s.style=="slider") && s.grid_popup=="1")
				{
					var playerWidth  = $p.find(".ytf-player").width(),
						playerHeight = playerWidth*(s.ratio=='4:3'?3/4:9/16),
						topOffset 	 = 0;

					if (playerHeight>=$j(window).height())
					{
						playerHeight = $j(window).height();
						topOffset = 0;
					} else {
						topOffset = ($j(window).height() - playerHeight)/2;
					}

					$p.find('.ytf-player').css({
						'height':playerHeight+'px',
						'top' : topOffset+'px'
					});
				} else {
					if(s.style=="background")
					{
						// height, width, top, left
						var bgSpace = 60,
							bgCtHeight = $p.find('.ytf-bgContent').outerHeight(),
							bgCtWidth = $p.find('.ytf-bgContent').outerWidth(),
							bgHeight=0, bgWidth=0, bgTop=0, bgLeft=0;

						if(bgCtWidth/bgCtHeight>(s.ratio=='4:3'?4/3:16/9)){
							bgWidth=bgCtWidth+bgSpace*2*(s.ratio=='4:3'?4/3:16/9);
							bgHeight=(s.ratio=='4:3'?3/4:9/16)*bgWidth+bgSpace*2;
							bgTop=-1*(bgHeight-bgCtHeight)/2;
							bgLeft=-1*bgSpace*(s.ratio=='4:3'?4/3:16/9);
						} else {
							bgHeight=bgCtHeight+bgSpace*2;
							bgWidth=(s.ratio=='4:3'?4/3:16/9)*bgHeight;
							bgLeft=-1*(bgWidth-bgCtWidth)/2;
							bgTop=-1*bgSpace;
						}

						$p.find('.ytf-player').css({
							top:bgTop+'px',
							left:bgLeft+'px',
							width:bgWidth+'px',
							height:bgHeight+'px'
						});
					} else {
						$p.find('.ytf-player').css({'height':((w-subOfWidth)*(s.ratio=='4:3'?3/4:9/16))+'px','width':(w-subOfWidth-1)+'px'});
					}
				}
				
				
				/* popup */
				if (s.popup) {
					if ($j(window).outerHeight()>$p.find('.ytf-container').outerHeight()) {
						$p.find('.ytfPopup').css('top',(($j(window).outerHeight()-$p.find('.ytf-container').outerHeight())/2)+'px');
					} else {
						$p.find('.ytfPopup').css({'margin-top':'10px','margin-bottom':'10px'});
					}	
				}

				/* for Grid style - Center align */
				var tm = window.setInterval(function(){
					if(list_center(resize)==true)
					{
						window.clearInterval(tm);
					}
				}, 1000);
			};
		
		$j(window).on('resize',function(){
			adjust_tpl(true);
		});

		if (s.popup) {
			$j('body').css('overflow','hidden');
		}

		// background
		if (s.style=="background")
		{
			var html = '<div class="ytf-bgContent">';
					html+= '<div>'+s.introtext+'</div>';
					if (s.background_tool==1)
					{
						html+= '<div class="ytf-api-tools" style="display:none">';
							html+= '<button class="_status _playing"></button>';
							html+= '<button class="_sound _mute"></button>';
						html+= '</div>';
					}
				html+= '</div>';

			$p.find('.ytf-container').prepend(html);
		}

		adjust_tpl(false);
		
		// stop event when list not shown
		if (!s.show_list) {
			if (callback) {
				window.setTimeout(function(){
					callback();
				},200);
			}
			return null;
		}
		
		if (s.style=='ver')
		{
			//open list button
			$j('<a class="ytfOpenlist" onclick="ytf_'+s.moduleid+'.openlist(this)">'+s.lang.SHOW_LIST+'</a>').insertAfter($p.find('.ytf-player'));
		}

		if(s.style=='slider'){
			$p.find('.swiper-container').prepend('<div class="swiper-wrapper"></div>');
		} else {
			$p.find('.swiper-container').html('<div class="swiper-wrapper"></div>');
		}
		
		if (s.style=='hoz')
		{
			var widthOfItem=$p.find('.ytfBlock:eq(0)').width();
			$p.find('.swiper-wrapper').width(widthOfItem*$p.find('.ytfBlock').length);
		}


		switch(s.style){
			case 'slider':
				scroll=new _this.slider();
				break;

			case 'grid':
				$p.on('click','.btn-more',function(){
					$p.find('.ytfBlock.hidden').slice(0,limit).removeClass('hidden');
					if (!$p.find('.ytfBlock.hidden').length) {
						$j(this).removeClass('active');
					}
					limitstart+=limit;
				});
				break;

			default:
				scroll=new _this.scrollbar({
					ob:'#ytfPlayer_'+s.moduleid+' .swiper-container',
					direction:s.style
				});
				break;
		}
		
		if (callback) {
			window.setTimeout(function(){
				callback();
			},200);
		}
	};

	_this.offset_list = 0;
	_this.update_list=function(reset) {
		if(typeof reset=='undefined') reset=true;
		if(!_this.data.process.length) return;
		if(s.style=='grid'&&s.pagination=='list'&&reset==true)
		{
			$p.find('.pages').empty().pagination({
			    dataSource: _this.data.process,
			    pageSize: s.limit,
			    showPrevious: false,
			    showNext: false,
			    className:'pagination',
			    callback: function(data, pagination) {		
					_this.data.completed=data;
					_this.data.process=data;
					_this.offset_list=0;
			        _this.update_list(false);
			    }
			})
			return;
		}

		var currentOffset=_this.offset_list,
			showViewCount=function(v)
			{
				v*=1;
				if (v>Math.pow(10,9)) {
					v=(v/Math.pow(10,9)).toFixed(1)+'B';
				} else if (v>Math.pow(10,6)) {
					v=(v/Math.pow(10,6)).toFixed(1)+'M';
				} else if (v>Math.pow(10,3)) {
					v=(v/Math.pow(10,3)).toFixed(1)+'K';
				}
				return v;
			};

		var html='';
		$j.each(_this.data.process,function(k,v){
			k+=currentOffset;
			_this.offset_list+=1;

			var thumb='https://i1.ytimg.com/vi/'+v.id+'/'+s.thumbsize;
			
			html+='<div class="ytfBlock swiper-slide '+(s.style=='grid' && s.pagination=='more' && k>=limitstart?'hidden':'')+'" data-index="'+k+'" data-id="'+v.id+'">';
			
			if(s.showthumb)
			{
				html+='<div class="ytfThumb"><span class="ytfThumbload" data-src="'+thumb+'" data-class="'+(s.thumbsize!='mqdefault.jpg'?'ytfAlign':'')+'" data-title="'+v.title+'"></span>';
			
				if(s.show_duration) html+='<span class="ytfDuration">'+_this.formatTime(v.length)+'</span>';
					html+='<div class="_border">';
						if (s.style=='grid') html+='<span class="_t">'+s.lang.PLAYING+'</span>';
					html+='</div>';
				html+='</div>';
			}

			html+='<div class="ytfMeta">';
				if(s.title) html+='<a href="javascript:void(0);" class="ytfTitle">'+_this.shortStr(v.title, s.maxword)+'</a>';
				if(s.show_author) html+='<span class="ytfAuthor">'+v.author+'</span>';
				if(s.show_created) html+='<span class="ytfPublished">'+_this.str2Time(v.published,1)+'</span>';
				if(s.show_views_count==1) html+='<span class="ytfViewsCount">'+showViewCount(v.viewCount)+' '+s.lang.VIEWS+'</span>';

				if(s.show_desc&&s.desc_position=='thumb'){
					html+='<div class="ytfDesc">'+v.description.replace(/\r\n|\r|\n/g, '<br/>')+'</div>';
				}
			html+='</div><i class="_clear"></i>';
			if(s.style=='hoz') html+='<div class="ytfDeactive"></div>';
			html+='</div>';

			if(s.style=='grid' && s.pagination=='more'){
				k>=limitstart?$p.find('.btn-more').addClass('active'):$p.find('.btn-more').removeClass('active');
			}
		});

		$p.find('.swiper-wrapper').empty().append(html);

		// update width of container
		if(s.style=='hoz'){
			var wi=$p.find('.ytfBlock:eq(0)').width();
			$p.find('.swiper-wrapper').width(wi*$p.find('.ytfBlock').length);
		}

		// update scrollbar
		if(scroll){scroll.update();}

		// for grid style
		var list_center = function(resize)
			{
				if(s.style!='grid'||s.listcenter==0) return true;
				if($p.find('.ytfBlock').length<2) return false;

				if($p.find('.ytf-container').hasClass("ytf-xs") || $p.find('.ytf-container').hasClass("ytf-sm"))
				{
					$p.find('.swiper-wrapper').removeAttr("style");
					$p.find('.ytfBlock').removeAttr("style");
					return true;
				}

				var wItem = $p.find('.ytfBlock:eq(0)').width(),
					wBox = $p.find('.swiper-container').width(),
					nLine,
					wSpace,
					wWrap;

				nLine = parseInt(wBox/wItem);
				wSpace = parseInt( (wBox-(wItem)*nLine)/(nLine-1) );
				$p.find('.swiper-wrapper').width(nLine*(wSpace+wItem));
				$p.find('.ytfBlock').css('margin-right',wSpace);
			
				return true;
			};

		list_center();
	};

	_this.slider=function(){
		var o = this,
			initSwiper = null,
			delayUpdate = null;

		o.init=function(){
			initSwiper = new Swiper($p.find('.swiper-container'), {
				slidesPerView:5,
				spaceBetween:20,
				autoHeight:true,

				breakpoints: {
					400: {slidesPerView:1,},
					750: {slidesPerView:2,},
					1000: {slidesPerView:3,},
					1200: {slidesPerView:4}
				},

				// Navigation arrows
				navigation: {
					nextEl: $p.find('.swiper-button-next'),
					prevEl: $p.find('.swiper-button-prev'),
				},
			});
		};

		o.moveTo=function(index){

		};

		o.update=function(){
			initSwiper.update();
			window.setInterval(function(){
				initSwiper.updateAutoHeight();
			},500);
		};

		o.init();
	};

	_this.scrollbar=function(params){
		var oc=this,
			$ob=$j(params.ob),
			direction=params.direction?params.direction:'ver',
			xy=direction=='hoz'?
			{
				left:'left',
				outerWidth:'outerWidth',
				width:'width',
				offsetX:'offsetX',
				deltaX:'deltaX',
				scrollLeft:'scrollLeft',
				pageX:'pageX'
			}:
			{
				left:'top',
				outerWidth:'outerHeight',
				width:'height',
				offsetX:'offsetY',
				deltaX:'deltaY',
				scrollLeft:'scrollTop',
				pageX:'pageY'
			};

		this.init=function(){
			if('ontouchstart' in document.documentElement) {
				// Your device support touch event
				return;
			}
			var lengthOfbar=direction=='hoz'?$ob.width()/$ob[0].scrollWidth:$ob.height()/$ob[0].scrollHeight;
			if (lengthOfbar>=1) {
				lengthOfbar=1;
			}
			// Adjust width/height of contain
			if (direction=='ver') {
				$ob.removeAttr('style');
				$ob.width( $ob.width()+oc.getScrollBarWidth() );
			}
			$ob.append('<div class="ytf-scrollbox"><span class="ytf-scrollbar" style="'+(direction=='hoz'?'width':'height')+':'+(lengthOfbar*100)+'%"></span></div>');
			var $div=$ob.find('.ytf-scrollbox');
			var enableScroll=true;
			$ob.find('.ytf-scrollbar').drag("start",function( ev, dd ){
				enableScroll=false;
				dd.limit = $div.position();
	          	dd.limit.dp = dd.limit[xy.left] + $div[xy.outerWidth]() - $j( this )[xy.outerWidth]();
	          	dd.delta = ($ob.find('.swiper-wrapper')[xy.width]()-$ob[xy.width]())/($ob[xy.width]()-$j(this)[xy.width]());
	          	dd[xy.left] = $j(this).position()[xy.left];
			})
			.drag(function( ev, dd ){
				var css={};
				css[xy.left]=Math.min( dd.limit.dp, Math.max( dd.limit[xy.left], dd[xy.offsetX] ) );
				$j( this ).css(css);
				$ob[xy.scrollLeft](dd.delta*(dd[xy.left]+dd[xy.deltaX]));
			},{ relative:true })
			$ob.find('.ytf-scrollbar').drag("end",function( ev, dd ){
				window.setTimeout(function(){
					enableScroll=true;
				},500);
			});
			
			/* Bind scroll event */
			$ob.scroll(function(){
				if (!enableScroll) return;
				var delta=($j(this).find('.swiper-wrapper')[xy.width]()-$j(this)[xy.width]())/($j(this)[xy.width]()-$ob.find('.ytf-scrollbar')[xy.width]());
				var css={};
				css[xy.left]=$j(this)[xy.scrollLeft]()/delta;
				$ob.find('.ytf-scrollbar').css(css);
			});
			$ob.find('.ytf-scrollbox').click(function(e){
				if (!enableScroll) return;
				var delta=($ob.find('.swiper-wrapper')[xy.width]()-$j(this)[xy.width]())/($j(this)[xy.width]()-$ob.find('.ytf-scrollbar')[xy.width]());
				var parentOffset = jQuery(this).parent().offset(); 
				//or $(this).offset(); if you really just want the current element's offset
				var rel = e[xy.pageX] - parentOffset[xy.left];
				$ob[xy.scrollLeft](rel*delta);
			})
			
			$j(window).resize(function(){
				oc.update();
			});
		};
		this.moveTo=function(index){
			if (!$ob.find('.ytfBlock').eq(index).length) return;
			var length=$ob.find('.ytfBlock').eq(index).position()[xy.left];
			$ob[xy.scrollLeft](length);
		};
		this.update=function(){
			var delta=($ob.find('.swiper-wrapper')[xy.width]()-$ob[xy.width]())/($ob[xy.width]()-$ob.find('.ytf-scrollbar')[xy.width]());
			var lengthOfbar=direction=='hoz'?$ob.width()/$ob[0].scrollWidth:$ob.height()/$ob[0].scrollHeight;
			var css={};
			// Adjust width/height of contain
			if (direction=='ver') {
				$ob.removeAttr('style');
				$ob.width( $ob.width()+oc.getScrollBarWidth() );
			}
			//  Adjust width/height of scrollbar (percent unix)
			css[xy.width]=lengthOfbar*100+'%';
			css[xy.left]=$ob[xy.scrollLeft]()/delta;
			$ob.find('.ytf-scrollbar').css(css);
		};
		this.getScrollBarWidth=(function(){
			var inner = document.createElement('p');
			  inner.style.width = "100%";
			  inner.style.height = "200px";

			  var outer = document.createElement('div');
			  outer.style.position = "absolute";
			  outer.style.top = "0px";
			  outer.style.left = "0px";
			  outer.style.visibility = "hidden";
			  outer.style.width = "200px";
			  outer.style.height = "150px";
			  outer.style.overflow = "hidden";
			  outer.appendChild (inner);

			  document.body.appendChild (outer);
			  var w1 = inner.offsetWidth;
			  outer.style.overflow = 'scroll';
			  var w2 = inner.offsetWidth;
			  if (w1 == w2) w2 = outer.clientWidth;

			  document.body.removeChild (outer);

			  return (w1 - w2);
		});
		this.init();
	};

	_this.loadThumb = function()
	{
		var loadThumbList=function(){
			if (!$p.find('.ytfThumb').not('.busy').length) return false;
			$p.find('.ytfThumb').not('.busy').slice(0,10).each(function(){
				var img = new Image(),
				$o=$j(this);
				$o.addClass('busy');
				$j(img).load(function(){
					$o.find('span.ytfThumbload').replaceWith( $j(this) );
					$o.find('img').fadeIn('fast');
				}).attr({
					src: $o.find('span.ytfThumbload').attr('data-src'),
					style: 'display:none',
					title: $o.find('span.ytfThumbload').attr('data-title'),
					class: $o.find('span.ytfThumbload').attr('data-class')
				}).error(function(){
					//do something if image cannot load
				});
			});
		}
		loadThumbList();
		window.setInterval(function(){loadThumbList()},1000);
	};

	_this.getData = function(){
		var items=s.data,
			startIndex=0,
			maxResults=0,
			totalCount=0,
			totalResults=0,
			totalSelected=0;

		// load data
		if(s.videos==null || !s.videos.length)
		{
			$p.find('.ytf-container').empty()
				.append('No video to preview. Check your API key or Feed Resource.');
			return;
		}
		_this.data.root = s.videos;
		_this.data.count = s.videos.length;

		$j.each(s.videos, function(k,v){
			if(_this.passKeyword(v.title))
			{
				_this.data.completed.push(v);
				_this.data.process.push(v);
			}
		});

		if(!_this.loadplayer && _this.data.count>0)
		{
			_this.loadplayer = true;
			_this.ytPlayer();
		}
		

		// create intro if enable
		if (s.intromode)
		{
			var bgurl = !/^http/.test(s.bgurl) ? s.root+s.bgurl : s.bgurl,
				html = '<div class="ytf-bglist" '+(s.bgurl?'style="background-image:url('+bgurl+')"':'')+'>'+(s.introtext?s.introtext:'<span class="ytf-playbutton" onclick="ytf_'+s.moduleid+'.play(this)"></span>')+'</div>';
				$p.find('.ytf-player').prepend(html);
		}

		_this.events();
	};

	_this.showDesc=function(desc){
		if(s.show_desc && s.desc_position=='player')
		{
			$p.find('.ytf-video-desc').remove();

			if(!/^\s*$/.test(desc)){
				$p.find('.ytf-player').after('<div class="ytf-video-desc"><button class="close-btn">X</button><div class="_inn">'+desc.replace(/\r\n|\r|\n/g, '<br/>')+'</div></div>');

				$p.find('.ytf-video-desc .close-btn').click(function(){
					$j(this).parent().remove();
				});
			}
		}
	};

	_this.events=function()
	{
		$p.on("click", ".ytf-overlay", function(){
			$j("html,body").removeClass("scrolldis");
			$p.find(".ytf-overlay").removeClass("active");
			$p.find(".ytf-player").fadeOut("fast");

			// stop video
			_this.player.stopVideo();

			$j(".ytfBlock.active").removeClass("active");
		});

		if((s.style=="grid"||s.style=="slider") && s.grid_popup=="1")
		{
			$j('.ytf-grid-off-btn').click(function(){
				$j('.ytf-overlay').trigger('click');
			});
		}

		$p.on("click", ".ytfBlock", function(e){
			e.preventDefault();
			
			if ($j(this).hasClass("active") || $j(e.target).is("i"))
			{
				return false;
			}

			var id = $j(this).attr('data-index')*1;

			if (typeof _this.data.completed[id]=="undefined")
			{
				return false;
			}
			
			$p.find(".ytfBlock[data-index="+id+"]").addClass("active").siblings().removeClass('active');
			
			if (s.style=="grid" || s.style=="slider")
			{
				if (s.grid_popup=="1")
				{
					$j("html,body").addClass("scrolldis");

					// adjust player size
					$p.find('.ytf-player').removeAttr("style");
					var playerWidth  = $p.find(".ytf-player").width(),
						playerHeight = playerWidth*(s.ratio=='4:3'?3/4:9/16),
						topOffset 	 = 0;

					if (playerHeight>=$j(window).height())
					{
						playerHeight = $j(window).height();
						topOffset = 0;
					} else {
						topOffset = ($j(window).height() - playerHeight)/2;
					}

					$p.find('.ytf-player').css({
						'height':playerHeight+'px',
						'top' : topOffset+'px'
					});

					$p.find(".ytf-overlay").addClass("active");
					$p.find(".ytf-player").fadeIn("fast");
				} else {
					$j(document).scrollTop( $p.find(".ytf-player").offset().top );
				}
			}
			
			_this.player.loadVideoById(_this.data.completed[id].id);
			_this.player.setPlaybackQuality(s.quality);
			_this.player.playVideo();
			vidCurrent=id;

			_this.setHash(_this.data.completed[id].id);
			_this.showDesc(_this.data.completed[id].description);
			
			if (s.intromode&&!bglist)
			{
				$p.find('.ytf-playbutton').addClass('preparePlay');
				window.setTimeout(function(){
					$p.find('.ytf-playbutton').remove();
					$p.find('.ytf-bglist').append('<div class="loading"></div>');
				},700);
				_this.player.addEventListener("onStateChange", function(e){
					if (e.data==1) {
						$p.find('.ytf-bglist').fadeOut('fast');
					}
				});
			};
		});

		/* filter box */
		if ((s.style=="ver" || s.style=="grid") && s.searchbox=="1")
		{
			$j('._yt_filter').keyup(function(e){
				var kw=$j.trim($j(this).val());
				if(kw==keyword) return;

				// update keyword
				keyword = kw;
				$j('._yt_filter').not($j(this)).val($j(this).val());
				$p.find('.swiper-wrapper').empty();

				_this.data.completed=[];
				_this.data.process=[];
				_this.offset_list=0;

				$j.each(_this.data.root, function(k,v){
					if(_this.passKeyword(v.title))
					{
						_this.data.completed.push(v);
						_this.data.process.push(v);
					}
				});

				_this.update_list();
			});
		}
	};

	_this.loadplayer = false;
	_this.lock_process_vid = false;

	_this.play = function()
	{
		if (!_this.player)
		{
			return;
		}

		$p.find('.ytf-playbutton').addClass('preparePlay');
		
		window.setTimeout(function()
		{
			$p.find('.ytf-playbutton').remove();
			$p.find('.ytf-bglist').append('<div class="loading"></div>');
		},700);

		_this.player.setPlaybackQuality(s.quality);
		_this.player.playVideo();
		_this.player.addEventListener("onStateChange", function(e){
			if (e.data==1) { // Play
				$p.find('.ytf-bglist').fadeOut('fast');
				bglist=true;
			}
		});
	};

	_this.ytPlayer = function() {
		_this.bindHTML(function(){
			var __createPlayer = function(id){
				_this.setHash(id);
				let ytConfig = {
					height: '100%',
			        width: '100%',
					videoId:id,
					playerVars : {
						autoplay:s.autoplay?1:0,
						controls:s.controls?1:0,
						showinfo:s.showinfo?1:0,
						rel:s.rel?1:0,
						fs:s.fs?1:0,
						iv_load_policy:s.annotation?1:3,
						modestbranding:s.brand?1:0,
						playsinline:s.autoplay?1:0,
						mute:s.autoplay?1:0,
						cc_load_policy:3
					},
					events : {
						'onReady' : _this.onPlayerReady,
						'onStateChange' : _this.onPlayerStateChange
					}
				};

				if(!s.cookie)
					ytConfig.host='https://www.youtube-nocookie.com';
				
				return new YT.Player('YTF-'+s.moduleid, ytConfig);
			};

			var __hashVid = window.location.hash.replace('#','');

			if(!s.hash || __hashVid=='')
			{
				_this.player=__createPlayer(_this.data.completed[0].id);
				_this.showDesc(_this.data.completed[0].description);
			} else {
				var __findVid = window.setInterval(function(){
					var __el = $p.find('[data-id='+__hashVid+']');
					if(__el.length)
					{
						_this.playerIndex = __el.attr('data-index')*1;
						_this.player = __createPlayer(__hashVid);

						$p.find('.ytfBlock.active').removeClass('active');
						__el.addClass('active');
						_this.showDesc(_this.data.completed[_this.playerIndex].description);

						if(s.style=='grid')
						{
							// to display current video
							var __isVisible = window.setInterval(function(){
								if(__el.is(':visible'))
								{
									window.clearInterval(__isVisible);
								} else {
									$p.find('.btn-more.active').trigger('click');
								}
							},100);
						}

						window.clearInterval(__findVid);
					} else {
						if(_this.data.process.length==0)
						{
							// complete but not found this video, run by default
							_this.player=__createPlayer(_this.data.completed[0].id);
							_this.showDesc(_this.data.completed[0].description);
							window.clearInterval(__findVid);
						}
					}
				},500);
			}

			if(s.style=="background")
			{
				$j("#YTF-"+s.moduleid).attr("webkit-playsinline", true);
			}

			// update list
			_this.update_list();
		});
	};

	_this.bgSupport = function()
	{
		var iOs = /iPhone|iPad|iPod/i.test(navigator.userAgent),
			BlackBerry = /BlackBerry/i.test(navigator.userAgent),
			isWindow = /IEMobile/i.test(navigator.userAgent);

		return (iOs || BlackBerry || isWindow) ? false : true;
	};

	_this.setHash = function(id)
	{
		if(s.hash==1) window.location.hash=id;
	};

	_this.onPlayerReady=function(){
		_this.swipeTo(_this.playerIndex);
		_this.yesReady();
		_this.player.setPlaybackQuality(s.quality);
		
		// add events
		if (s.intromode&&s.bgurl) {
			// Bind event play
			$p.on('click','.ytplay',function(e){
				e.preventDefault();
				_this.play();
			});
		};
		var isMobile = {
		    Android: function() {
		        return /Android/i.test(navigator.userAgent);
		    },
		    BlackBerry: function() {
		        return /BlackBerry/i.test(navigator.userAgent);
		    },
		    iOS: function() {
		        return /iPhone|iPad|iPod/i.test(navigator.userAgent);
		    },
		    Windows: function() {
		        return /IEMobile/i.test(navigator.userAgent);
		    },
		    any: function() {
		        return (isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Windows());
		    }
		};

		if (isMobile.any() && s.autoplay) {
			_this.player.loadVideoById(_this.data.completed[0].id);
			vidCurrent=0;
			_this.player.setPlaybackQuality(s.quality);
		}

		if(s.style=="background")
		{
			$p.find(".ytf-api-tools").removeAttr("style");
			$p.find(".ytf-player").append('<span></span>');

			_this.player.addEventListener("onStateChange", function(e){
				if (e.data==1)
				{
					$p.find(".ytf-api-tools ._status").removeClass("_playing _paused")
							.addClass("_playing");
				} else if (e.data==2) {
					$p.find(".ytf-api-tools ._status").removeClass("_playing _paused")
							.addClass("_paused");
				}
			});

			$p.on("click" ,".ytf-api-tools ._status", function(){
				if ($j(this).hasClass("_playing"))
				{
					_this.player.pauseVideo();
				} else {
					_this.player.playVideo();
				}
			});

			$p.on("click" ,".ytf-api-tools ._sound", function(){
				if ($j(this).hasClass("_mute"))
				{
					_this.player.unMute();
				} else {
					_this.player.mute();
				}
				$j(this).toggleClass("_mute").toggleClass("_unmute");
			});
		}

		if(s.hash==1)
		{
			window.addEventListener("hashchange", function(){
				var __hashVid = window.location.hash;
					__hashVid = __hashVid.replace('#','');

				if(__hashVid!='')
				{
					var __el = $p.find('[data-id='+__hashVid+']');
					if(__el.length) __el.trigger('click');
				}
			});
		}
	};

	_this.onPlayerStateChange=function(e){
		if(e.data==YT.PlayerState.ENDED)
		{
			if(s.loop==1){
				_this.player.playVideo(); 
			} else if(s.autonext){
				if (s.random) {
					vidCurrent=Math.floor(Math.random() * _this.data.completed.length);
					_this.player.loadVideoById(_this.data.completed[vidCurrent].id);
					_this.setHash(_this.data.completed[vidCurrent].id);
				} else {
					if (typeof _this.data.completed[vidCurrent+1] != 'undefined'){
						_this.player.loadVideoById(_this.data.completed[vidCurrent+1].id);
						_this.setHash(_this.data.completed[vidCurrent+1].id);
						vidCurrent+=1;			
					} else {
						vidCurrent=0;
						_this.player.loadVideoById(_this.data.completed[0].id);
						_this.setHash(_this.data.completed[0].id);
					}
				}	
				_this.player.setPlaybackQuality(s.quality);
				$p.find('.ytfBlock[data-index='+vidCurrent+']').addClass('active').siblings().removeClass('active');
				_this.swipeTo(vidCurrent);
			}
		}

		if(s.rel==0 && s.style=='background' && (e.data==YT.PlayerState.PAUSED||e.data==YT.PlayerState.ENDED)){
			$p.find('.ytf-player').addClass('disrel');
		} else {
			window.setTimeout(function(){
				$p.find('.ytf-player').removeClass('disrel');
			}, 500);
		}
	};

	_this.destroy=function(){
		if (!s.popup_trigger) {
			$p.find('.ytf-bg').fadeOut('fast',function(){
				$j('body').css('overflow','');
				$j(this).remove();
			});
			window['ytf_'+s.moduleid]=null;
		} else {
			window['ytf_'+s.moduleid+'_popup']=true;
			$p.find('.ytf-bg').fadeOut('fast');
			_this.player.pauseVideo();
		}
	};

	// The program begin run
	if (s.popup&&s.popup_trigger) {
		$j(document).on('click','.ytplay_'+s.moduleid,function(e){
			e.preventDefault();
			$p.find('.ytf-bg').show();
			if (window['ytf_'+s.moduleid+'_popup'])
			{
				$p.find('.ytf-bg').fadeIn('fast');
			} else {
				_this.getData();
			}
		});
	} else {
		if (! $p.is(':visible')) {
			var _wait=window.setInterval(function(){
				if ($p.is(':visible')) {
					window.clearInterval (_wait);
					_this.getData();
				}
			},500);
			return null;
		}
		_this.getData();
	};

	if (s.popup) {
		$j(document).on('keyup',function(e){
			if (e.keyCode==27) {
				if ($p.is(':visible')) {
					_this.destroy();
				}
			}
		});
	};

	return _this;
}
