<?php
/**
 * @package 	YOUTUBE FEED PRO
 * @version 	5.2.7
 * @copyright 	Copyright [c] JLexArt - All rights reserved.
 * @license 	GNU General Public License version 2 or later
 * @author 		Victor Nguyen (https://jlexart.com)
 */

defined('_JEXEC') or die;
set_time_limit(0);

// Some changed in v5.6.4 ~ Line 64

class YTFGetData
{
	protected 	$params;
	protected 	$keys = array();
	protected 	$dataAll = array(); // video details of all items

	protected 	$data    = array(); // Cid of one item
	protected 	$dataDetails = array(); // Cid details of one item
	protected	$items 	 = null;
	protected 	$sort 	 = '';

	protected 	$errors  = array();

	public function __construct($params, $xml)
	{
		$this->params = $params;

		// parse api key
		$keys = preg_split("/\r\n|\n|\r|\f|\x0b|\x85/", $this->params->get('key', ''));
		if(!is_array($keys) || !count($keys))
		{
			$this->errors[]=jtext::_('YJ_KEY_MISSING');
			return false;
		}

		foreach($keys as $key) if(preg_match('/^[A-z0-9\-\_]{10,}$/', $key)) $this->keys[]=$key;
		$this->keys = array_unique($this->keys);

		if(!count($this->keys))
		{
			$this->errors[]=jtext::_('YJ_KEY_MISSING');
			return false;
		}
		
		foreach($xml as $item)
		{
			// reset
			$this->data = array();
			$this->dataDetails = array();

			if($item['method']=='playlist' || $item['method']=='query' || $item['method']=='category')
			{
				$this->getCidlist($item);

				// record to $this->dataDetails;
				$this->getVideoDetails($this->data);
			} else {
				// list video
				$this->getVideoDetails($item["videos"]);
			}

			if(!empty($this->dataDetails))
				$this->dataAll = array_merge($this->dataAll, $this->dataDetails);
		}

		// sort again
		$orderAll 	= $this->params->get('rc_sort', 'none');
		$sumOffset  = $this->params->get('sum_offset', 0);
		$sumLimit   = $this->params->get('sum_limit', 0);

		$sumOffset  = preg_match('/^[1-9][0-9]*$/', $sumOffset)?intval($sumOffset):0;
		$sumLimit   = preg_match('/^[1-9][0-9]*$/', $sumLimit)?intval($sumLimit):0;
		
		if($orderAll!='none')
		{
			$this->dataAll = $this->sortVideos($this->dataAll, $sumOffset, $sumLimit, $orderAll);
		}
	}

	public function getData()
	{
		return $this->dataAll;
	}

	public function getCidlist($item, $nextPageToken='', $total=0)
	{
		// item setting
		$limit  = isset($item['maxResults']) && preg_match('/^[1-9][0-9]*$/', $item['maxResults'])?intval($item['maxResults']):0;
		$offset = isset($item['startIndex']) && preg_match('/^[1-9][0-9]*$/', $item['startIndex'])?intval($item['startIndex']):0;
		$order  = isset($item['order'])?$item['order']:'relevance';
		
		$request = array();
		if(isset($item['order'])) $request['order'] = $order; // just work for channel type
		if(!empty($nextPageToken)) $request['pageToken']=$nextPageToken;

		if($limit>0 && $offset+$limit<=50)
		{
			$request['maxResults']=($offset+$limit);
		} else {
			$request['maxResults']=50;
		}
		
		$url = $item['url'].'&'.http_build_query($request);

		$response = $this->getUrl($url);
		if(!$response) return;

		if(isset($response->items) && count($response->items))
		{
			foreach($response->items as $video)
			{
				if($total>=$offset)
				{
					$this->data[] = $item["method"]=="playlist"?$video->contentDetails->videoId : $video->id->videoId;
				}
				$total+=1;
			}
		}

		if($limit>0 && count($this->data)>=$limit) return; // don't need find more.

		// sleep :)
		if(preg_match('/^[1-9][0-9]*$/', $this->params->get('sleep', 1)))
		{
			sleep($this->params->get('sleep', 1)*1);
		}

		if(isset($response->nextPageToken))
		{
			// find next page
			$this->getCidlist($item, $response->nextPageToken, $total);
		}
	}

	public function getVideoDetails($cid)
	{
		if(empty($cid)) return;

		$listId = array();
		
		for($i=0; $i<=49; $i++)
		{
			if(isset($cid[0]))
			{
				$listId[]=$cid[0];
				array_splice($cid, 0, 1);
			}
		}

		if(empty($listId) || !count($listId)) return;

		$url = 'https://www.googleapis.com/youtube/v3/videos?part=snippet,contentDetails,statistics&id='.implode(',', $listId);

		$response = $this->getUrl($url);
		if(!$response) return;

		if(isset($response->items) && count($response->items))
		{
			foreach ($response->items as $v)
			{
				$this->dataDetails[] = array(
						'id' => $v->id,
						'title' => $v->snippet->title,
						'length' => @$v->contentDetails->duration,
						'author' => $v->snippet->channelTitle,
						'published' => $v->snippet->publishedAt,
						'description' => $v->snippet->description,
						'viewCount' => @$v->statistics->viewCount,
					);
			}
		}

		// sleep :)
		if(preg_match('/^[1-9][0-9]*$/', $this->params->get('sleep', 1)))
		{
			sleep($this->params->get('sleep', 1)*1);
		}

		$this->getVideoDetails($cid);
	}

	public function sortVideos($videos, $offset=0, $limit=0, $order='relevance')
	{
		if($order!='relevance')
		{
			$this->sort = $order;
			usort($videos, function($a, $b){
				switch ($this->sort) {
					case 'date':
						return strtotime($b["published"])>strtotime($a["published"])?1:-1;

					case 'viewCount':
						return $b["viewCount"]>$a["viewCount"]?1:-1;

					case 'title':
						return strcasecmp($a["title"],$b["title"]);
				}
			});
		}
		
		// offset & limit
		if($offset>0 || $limit>0)
		{
			$newlist = array();
			$i = 0;
			foreach($videos as $k=>$video)
			{
				if($k>=$offset)
				{
					if($limit<=0 || ($limit>0 && $i<$limit)) $newlist[]=$video;
					$i++;
				}
			}

			$videos = $newlist;
		}

		return $videos;
	}

	public function getUrl($url)
	{
		$response=null;
		$i=0;

		$context = stream_context_create(array(
				"http" => array("ignore_errors" => true)
			));
		$logfile = dirname(__FILE__).'/log.php';
		if(!file_exists($logfile))
		{
			file_put_contents($logfile, "<?php die('Forbidden.'); ?>".PHP_EOL);
		}

		while(empty($response) && isset($this->keys[$i]))
		{
			$furl = $url.'&key='.$this->keys[$i];
			$data = @file_get_contents($furl, false, $context);
			$i++;

			if(!empty($data))
			{
				$data=json_decode($data);
				if(!empty($data))
				{
					if(isset($data->error))
					{
						$msg = date("Y-m-d H:i:s").':  '.$this->keys[$i-1].' - '.$data->error->message;

						if(count($this->keys)>1)
						{
							unset($this->keys[$i-1]);
							$this->keys = array_values($this->keys);
							$i = 0;
						}
						
						file_put_contents($logfile, $msg.PHP_EOL , FILE_APPEND | LOCK_EX);
					} else {
						$response=$data;
					}
				}
			}
		}

		return $response;
	}
}