<?php
/**
 * @package 	YOUTUBE FEED PRO
 * @version 	5.2.7
 * @copyright 	Copyright [c] JLexArt - All rights reserved.
 * @license 	GNU General Public License version 2 or later
 * @author 		Victor Nguyen (https://jlexart.com)
 */

defined('_JEXEC') or die;

jimport("joomla.form.formfield");

class JFormFieldAsset extends JFormField
{
	protected $type = 'Asset';

	protected function getVersion()
	{
		$db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select("manifest_cache")
             ->from("#__extensions")
             ->where([
                    $db->quoteName("type")."=".$db->quote("module"),
                    $db->quoteName("element")."=".$db->quote("mod_yt_jlex")
                ]);

        $mf=$db->setQuery($query)->loadResult();
        $mf=json_decode($mf);
        $v=$mf->version;

        return $v;
	}

	protected function getInput()
	{
		$doc = JFactory::getDocument();
		$assets = JURI::root(true)."/modules/mod_yt_jlex/assets";
		
		if($this->element["extension"]=="js")
		{
			if(version_compare(JVERSION, "3.0.0", ">="))
			{
				JHtml::_("jquery.framework");
			} else {
				// require jQuery for Joomla 2.5
				$doc->addScript($assets."/js/jquery.js");
			}

			$doc->addScript($assets."/admin/sortable.min.js");
			$doc->addScript($assets."/admin/script.js?v=5.5.9");

			$js = '
			(function($){
				$(document).ready(function(){
					window.apikey = [];
					window.ytbackend = new YtJLexBackend($, "'.JUri::root(true).'");
					window.ytbackend.init();
				});
			})(jQuery);
			';

			$doc->addScriptDeclaration($js);
		} else {
			// stylesheet
			if(version_compare(JVERSION, "4.0.0-alpha", ">="))
			{
				$doc->addStyleSheet($assets."/admin/j4.css");
			}
			$doc->addStyleSheet($assets."/admin/style.css?v=5.5.9");

			// ls
			return;
			$f = dirname(__FILE__)."/../assets/admin/ls.json";
			$n = true;
			$k = null;
			$v = null;
			$h = $_SERVER['SERVER_NAME'];

			if(is_file($f))
			{
			  $dt=file_get_contents($f);
			  $dt=json_decode($dt);

			  if(!empty($dt))
			  {
			      $dt = $dt->c;
			      $dt = base64_decode(substr($dt, 6, 4).substr($dt, 0, 4).substr($dt, 13));

			      if($dt!==false)
			      {
			          $dt = explode(",", $dt);
			          if(count($dt)==2)
			          {
			              $k=$dt[0];
			              $v=$this->getVersion();

			              if($v==$dt[1]) $n=false;
			          }
			      }
			  }
			}

			if(!$n) return;
			if(!$v) $v=$this->getVersion();

			$s = ["id"=>3, "k"=>$k, "v"=>$v, "h"=>$h, "t"=>time()];
			$p = ["b"=>JUri::root(true) , "h"=>str_replace('{root}', JUri::root(true), file_get_contents(dirname(__FILE__)."/../assets/i.html"))];

			$js="
			(function($){
			  $(document).ready(function($){
			      var s=".json_encode($s).";
			      var r=".json_encode($p).";
			      var m=function(msg, t){
			          t=typeof t=='undefined'?'':t;
			          $('#license .msg').remove();
			          $('#license form').prepend('<div class=\"msg '+t+'\">'+msg+'</div>');
			      };
			      var f=function(msg, t){
			          var h='<div id=\"license\">';
			              h+='<form class=\"i\">';
			              	h+=r.h;
			                  h+='<input type\"text\" placeholder=\"XXXXXX\" required>';
			                  h+='<button>active</button>';
			                  h+='<a href=\"'+r.b+'/administrator/index.php?option=com_modules\" style=\"text-decoration:none\" draggable=\"false\">&larr; Back</a>';
			                  h+='<div class=\"o\"></div>';
			              h+='</form>';
			          h+='</div>';
			          $('body').empty().append(h);
			          $('form input').focus();
			          if(typeof msg!='undefined') m(msg, t);
			          $('form').submit(function(e){
			              e.preventDefault();
			              s.k=$(this).find('input').val();
			              
			              $(this).find('.o').addClass('active');
			              c(function(d){
			                  if(d.status==400){
			                      $('form .o').removeClass('active');
			                      m(d.error, 'error');
			                  }

			                  if(d.status==200){
			                      $.post(r.b+'/modules/mod_yt_jlex/ajax.php', {type:'ls', en:d.code, format:'json'}, function(dt){
			                          $('form .o').removeClass('active');
			                          m('Activated Successfully!', 'success');
			                          setTimeout(function(){
			                              window.location.reload();
			                          }, 1000);
			                      }, 'json');
			                  }
			              });
			          });
			      };
			      var c=function(cb){
			          $.ajax({
			              url: 'https://www.jlexart.com/component/topic?task=order.check_ls',
			              data: s,
			              dataType: 'json',
			              success: function(d){
			                  if(typeof cb=='function') cb(d);
			              },
			              error: function(d){
			                  $('form .o').removeClass('active');
			                  m('Could not connect to server JLexArt!', 'error');
			              }
			          });
			      };

			      if(s.k==null)
			      {
			          f('You need an activation to use this extension. Please follow the steps below &darr;'); return;
			      }

			      c(function(d){
			          if(d.status==400){
			              f(d.error, 'error');
			          }
			      });
			  });
			})(jQuery);
			";

			$css="#license{background:#f5deb3;position:fixed;top:0;left:0;right:0;bottom:0;z-index:1;user-select:none;}form.i{background:#fff;margin:50px auto;max-width:550px;padding:20px;border-radius:4px;box-shadow:1px 1px 5px rgba(0,0,0,0.2);overflow:hidden;text-align:center;position:relative}#license img{max-width:100%}#license input{background:#e1e1e1;border:none;width:100%;height:50px;border-radius:4px;margin:10px 0;padding:0 15px;font-size:20px;outline:none;box-sizing:border-box;}#license input:active,#license input:focus{background:#ddd}#license button{background:#333;color:#fff;border:none;border-radius:4px;height:40px;width:100%;text-transform:uppercase;margin-bottom:40px}.msg{background:#259abd;color:#fff;padding:5px 10px;border-radius:4px;margin-bottom:10px;text-align:left;font-size:14px}.msg.error{background:#d95450}.msg.success{background:#5db75d}.o{background-color:rgba(0,0,0,0.65);background-image:url(https://i.imgur.com/XC2otTV.gif);background-position:center;background-repeat:no-repeat;position:absolute;top:0;left:0;right:0;bottom:0;z-index:1;display:none}.o.active{display:block}";

			$doc->addStyleDeclaration($css);
			$doc->addScriptDeclaration($js);
		}
	}
}