<?php
/**
 * @package 	YOUTUBE FEED PRO
 * @version 	5.2.7
 * @copyright 	Copyright [c] JLexArt - All rights reserved.
 * @license 	GNU General Public License version 2 or later
 * @author 		Victor Nguyen (https://jlexart.com)
 */

defined('_JEXEC') or die;

jimport ( 'joomla.form.formfield' );
class JFormFieldJNote extends JFormField
{
	protected $type = 'JNote';

	protected function getInput()
	{
		$html = '';
		switch ($this->element['cmd']) {
			case 'heading':
				$html.= '<div class="m-heading">'. JText::_($this->element['caption']).'</div>';
				break;

			case 'ytkey':
				$html.= 'How to create a Youtube API key? <a href="https://www.jlexart.com/articles/youtube-module-documentation-39ps" target="_blank"><strong>Learn More</strong></a>';
				break;

			case 'warning_quota':
				$html.= '<div class="alert alert-warning">These options need more quotas so should use for small channel/playlist or if you have a premium API key.</div>';
				break;

			case 'schedule':
				$app = JFactory::getApplication();
				$id  = $app->input->getInt('id', 0);

				if($id>0)
				{
					$command = "wget -O - -q -t 1 '".JUri::root()."index.php?option=com_ajax&module=yt_jlex&id=".$id."&format=json' >/dev/null 2>&1";

					$html.= '<input type="text" class="form-control" value="'.$command.'" readonly onclick="this.select();" style="background:white;border:1px solid #8b0300">';
					$html.= '<div style="margin-top:7px; font-size:12px"><a href="https://bit.ly/setup-cronjob" target="_blank">&#187; Learn more here</a></div>';
				} else {
					$html.= '<span style="color:#ce211f">You must save module first to see content.</span>';
				}
				break;

			case 'lowtime':
				$html.= '<div class="alert alert-info">'.jtext::_('YJ_NOTICE_LOWTIME_FIRST').'</div>';
				break;
		}

		return $html;
	}
}