<?php
/**
 * @package 	YOUTUBE FEED PRO
 * @version 	5.2.7
 * @copyright 	Copyright [c] JLexArt - All rights reserved.
 * @license 	GNU General Public License version 2 or later
 * @author 		Victor Nguyen (https://jlexart.com)
 */

defined('_JEXEC') or die;

class modYtJlexHelper
{
	public static function getAjax()
	{
		// Get module parameters
		$app  = JFactory::getApplication();
		$conf = JFactory::getConfig();
		$id  = $app->input->getInt('id', 0);

		if($id<1) return null;

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select('*')
			  ->from('#__modules')
			  ->where(array(
			  		'id='.$db->quote($id),
			  		'published=1',
			  		'module='.$db->quote('mod_yt_jlex')
			  	));

		$module = $db->setQuery($query)->loadObject();

		if(!$module) return null;

		$params = new JRegistry();
		$params->loadString($module->params);

		$data = $params->get('ytjlexdata');
		$parse = self::parse($data);
		
		if(!empty($parse->list) && $parse->canCache)
		{
			$cache = JFactory::getCache('mod_yt_jlex','');
			$cache->setCaching(true);
			$cache->setLifeTime( $params->get('cache_time', $conf->get('cachetime') * 60) / 60 );
			$cacheid = md5(json_encode($parse->list));

			require_once dirname ( __FILE__ ) . '/data.php';
			$ytData = new YTFGetData($params, $parse->list);

			$output = $ytData->getData();

			if(!empty($output))
			{
				// save it, finally =)).
				$cache->store(json_encode($output), $cacheid);
			}
		}
	}

	public static function lsAjax()
	{
		$app = JFactory::getApplication();
		$en  = $app->input->post->getString("en", "");

		file_put_contents(dirname(__FILE__)."/assets/admin/ls.json", json_encode(["status"=>200, "c"=>$en]));

		return "OK";
	}

	public static function checkApiAjax()
	{
		$api = JFactory::getApplication()->input->post->getString("api", "");
		$err = null;

		if(!function_exists("ini_get")){
			$err = "We don't know your server is support opening remote URL. Please make sure it enabled by checking its status: <strong>System &gt; System Information &gt; PHP Information &gt; allow_url_fopen</strong>";
		} elseif(!ini_get("allow_url_fopen")) {
			$err = "Opening remote URL is disabling in your server. Please turn on it, check its status at here: <strong>System &gt; System Information &gt; PHP Information &gt; allow_url_fopen</strong>";
		} else {
			$url = "https://www.googleapis.com/youtube/v3/channels?part=id&forUsername=apple&key=".$api;

			$data = @json_decode(file_get_contents($url));

			if(empty($data) || !is_object($data))
			{
				$err = "API key not valid";
			} elseif(isset($data->error)) {
				$err = strip_tags($data->error->message);
				// https://developers.google.com/youtube/v3/docs/errors
			}
		}

		if(!is_null($err)) return $err;

		return "OK";
	}

	public static function parse($data)
	{
		$data = json_decode($data);

		$ytHelper = new YTFHelper();

		$result = new stdClass();
		$result->canCache = true;
		$result->list = array();
		$result->canHash  = true;

		if(!is_array($data) || !count($data)) return $result;
		
		foreach($data as $item)
		{
			switch($item->method)
			{
				case 'playlist':
					$playlist = $item->data->playlistid;
					if (trim($playlist)!='') {
						$result->list[] = array (
							'method' => $item->method,
							'url' => 'https://www.googleapis.com/youtube/v3/playlistItems?part=snippet,contentDetails&playlistId='.$playlist,
							'maxResults' => $item->data->maxResults*1,
							'startIndex' => $item->data->startIndex*1
						);
					}
					break;

				case 'category':
					$catId = $item->data->categoryid;
					if(preg_match('/^[1-9][0-9]*$/', $catId))
					{
						$regionCode = $item->data->regionCode;
						if(!preg_match('/^[A-z]{2}$/', $regionCode)) $regionCode = '';

						$result->list[] = [
							'method' => $item->method,
							'url' => 'https://www.googleapis.com/youtube/v3/search?part=id&type=video&videoCategoryId='.$catId.($regionCode!=''?('&regionCode='.$regionCode):''),
							'maxResults' => $item->data->maxResults*1
						];
					}
					break;

				case 'query':
					if(preg_match('/^\s*$/', $item->data->query) && preg_match('/^\s*$/', $item->data->channelId))
					{
						continue 2;
					}

					if(preg_match('/^\s*$/', $item->data->channelId)) $result->canCache=false;

					$xml = 'https://www.googleapis.com/youtube/v3/search?part=snippet';

					if(trim($item->data->query)!= '')
					{
						$q = http_build_query ( array (
							'q' => $item->data->query 
						), '', '&amp;' );
						$xml.='&'.$q;

						$result->canHash = false;
					}
					
					$xml .= '&type=video'; // set video type
					in_array( $item->data->caption, array('closedCaption','none') ) ? $xml.= '&videoCaption='.$item->data->caption : null; // [any,closedCaption,none]

					in_array( $item->data->long, array('long','medium','short') ) ? $xml.= '&videoDuration='.$item->data->long : null; // [any,long,medium,short]

					in_array( $item->data->dimension, array('2d','3d') ) ? $xml.='&videoDimension='.$item->data->dimension : null; // [any,2d,3d]

					in_array( $item->data->orderby, array('date','relevance','viewCount','title') ) ? $xml.='&order='.$item->data->orderby : null;

					in_array( $item->data->eventType, array('completed','live','upcoming') ) ? $xml.='&eventType='.$item->data->eventType : null; // [completed,live,upcoming]

					in_array( $item->data->quality, array('high','standard') ) ? $xml.='&videoDefinition='.$item->data->quality : null; // [any,high,standard]
					
					// Channel ID
					if ($item->data->channelId!='') {
						$xml.='&channelId='.$item->data->channelId;
					}
					
					if ($item->data->time != 'all_time')
					{
						switch ($item->data->time) {
							case 'month':
							case 'year':
							case 'week':
								$item->data->publishedBefore = '';
								$item->data->publishedAfter = date('Y-m-d H:i:s', strtotime("-1 ".$item->data->time));
								break;
						}
					}

					if ($item->data->publishedBefore!='') {
						$xml.='&publishedBefore='. $ytHelper->dateSql2Rfc3339 ($item->data->publishedBefore);
					}
					if($item->data->publishedAfter!='') {
						$xml.='&publishedAfter='. $ytHelper->dateSql2Rfc3339 ($item->data->publishedAfter);
					}
					
					
					$result->list[] = array (
							'method' => $item->method,
							'url' => $xml,
							'maxResults' => $item->data->maxResults*1,
							'startIndex' => $item->data->startIndex*1,
							'order' => $item->data->orderby,
					);
					break;
				case 'video' : // List special
					$vids = preg_split ( "/\r\n|\n|\r|\f|\x0b|\x85/", $item->data->videoid );
					if (is_array ( $vids ) && count ( $vids ) > 0) {
						$vid_correct = array ();
						$pattern = '#^(?:https?://)?(?:www\.|m\.)?(?:youtu\.be/|youtube\.com(?:/embed/|/v/|/watch\?v=|/watch\?.+&v=))([\w-]{11})(?:.+)?$#x';
						foreach ( $vids as $vid ) {
							if (preg_match ( $pattern, $vid, $matches )) {
								$vid_correct [] = $matches [1];
							}
							continue;
						}
						if (count ( $vid_correct ) > 0) {
							$result->list[] = array (
									'method' => 'video',
									'videos' => $vid_correct 
							);
						}
					}
					break;
			}
		}

		return $result;
	}

	public static function versionsAjax()
	{
		$app = JFactory::getApplication();
        $db  = JFactory::getDbo();
        $session = JFactory::getSession();
        $versions = $session->get("yt_versions", null);

        if($versions)
        	return $versions;

        // get current version
        $query = $db->getQuery(true);
        $query->select("manifest_cache")
              ->from("#__extensions")
              ->where([
              		$db->quoteName("type").'='.$db->quote("module"),
                	$db->quoteName("element").'='.$db->quote("mod_yt_jlex")
              ]);

        $manifest = $db->setQuery($query)->loadResult();
        $manifest = json_decode($manifest);

        $versions["version"] = $manifest->version;

        // get latest version from JLexArt.com
        $url = "http://www.jlexart.com/fn/connect/check?id=3";

        $required = ini_get("allow_url_fopen") && function_exists("file_get_contents");
        
        if(!$required)
        {
            $versions["latest_version"] = $versions["local"];
            $versions["error"] = "Couldn't connect to JLexArt.com | <b>allow_url_fopen</b> in your hosting is disabled.";
        } else {
            $data = @file_get_contents($url);
            $data = json_decode($data);

            if(!$data)
            {
                $versions["latest_version"] = $versions["local"];
                $versions["error"] = "Couldn't connect to JLexArt.com";
            } else {
                $versions["latest_version"]= $data->version;
                if(version_compare($versions["latest_version"], $versions["version"], ">"))
                {
                    $versions["update"] = true;
                }
            }
        }

        // store this variable to session
        $session->set("yt_versions", $versions);

        return $versions;
	}
}

class YTFHelper
{
	public function periodToRFC3339 ($period) {
		$subDate=null;
		switch ($period) {
			case 'week':
			$subDate=new DateInterval('P7D');
			break;
			case 'month':
			$subDate=new DateInterval('P1M');
			default:
			$subDate=new DateInterval('P1Y');
			break;
		}
		$time = JFactory::getDate()->sub( $subDate )->format( "Y-m-d\TH:i:sP" );
		$time = str_replace('+00:00', '.000Z',$time);
		return $time;
	}

	public function dateSql2Rfc3339 ($time)
	{
		$time = JFactory::getDate($time)->format( "Y-m-d\TH:i:sP" );
		$time = str_replace('+00:00', '.000Z',$time);
		return $time;
	}

	public function formatDuring($time)
	{
		$time = ( int ) $time;
		if ($time < 60) {
			return gmdate ( "s", $time );
		} elseif ($time < 3600) {
			return gmdate ( "i:s", $time );
		} else {
			return gmdate ( "H:i:s", $time );
		}
	}

	public function subword($string, $maxword = 7)
	{
		$words = explode ( ' ', $string );
		if (count ( $words ) <= $maxword)
			return $string;
		$newString = '';
		for($i = 0; $i < $maxword; $i ++) {
			$newString .= $words [$i] . ' ';
		}
		return count ( $words ) > $maxword ? $newString . ' ...' : $newString;
	}
}