<?php
/**
 * @package 	YOUTUBE FEED PRO
 * @version 	5.2.7
 * @copyright 	Copyright [c] JLexArt - All rights reserved.
 * @license 	GNU General Public License version 2 or later
 * @author 		Victor Nguyen (https://jlexart.com)
 */

defined('_JEXEC') or die;

require_once dirname ( __FILE__ ) . '/helper.php';
$ytHelper = new YTFHelper();
$setting = new stdClass ();

$app = JFactory::getApplication();

// Bug params
$params = isset($params)?$params:false;
if(!$params) return;

// document class
$doc = JFactory::getDocument();
$urlAsset = JUri::base(true)."/modules/mod_yt_jlex/assets";

$doc->addStyleSheet($urlAsset."/css/style.min.css?v=5.2.7");
$doc->addScript("https://www.youtube.com/iframe_api");

// jQuery lib
if(version_compare(JVERSION, "3.0.0", ">="))
{
	JHtml::_('jquery.framework');
	if($params->get("jquery3", 0) || version_compare(JVERSION, "4.0.0-alpha", ">="))
		$doc->addScript($urlAsset."/js/jquery-migrate.min.js");
} else {
	$doc->addScript($urlAsset."/js/jquery.js");
}

// swiper for slider template
if($params->get('ui','hoz')=='slider'){
	$doc->addScript($urlAsset."/swiper/swiper.min.js");
	$doc->addStyleSheet($urlAsset."/swiper/swiper.min.css");
}

if($params->get('ui','hoz')=='grid' && $params->get('pagination','more')=='list'){
	$doc->addScript($urlAsset."/js/pagination.min.js");
}

$doc->addScript($urlAsset."/js/script.js?v=5.4.1");

// Css stylesheet
$css = $params->get("advanced_css", "");
if(!empty($css)) $doc->addStyleDeclaration($css);

// parse data
$xml = null;
$xml_list = array();
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
$hash = $params->get('hash',0)==1?true:false;

// new version
$data = $params->get('ytjlexdata');

if($data)
{
	$conf = JFactory::getConfig();
	$parse = modYtJlexHelper::parse($data);
	$xml_list = $parse->list;

	if(!count($xml_list)) return;

	if(!$parse->canHash) $hash=false;

	if($parse->canCache)
	{
		$cache = JFactory::getCache('mod_yt_jlex','');
		$cache->setCaching(true);
		$cache->setLifeTime($params->get('cache_time', $conf->get('cachetime') * 60) / 60);
		$cacheid = md5(json_encode($xml_list));

		// use it if the API key is error or out quora
		$cacheOg = JFactory::getCache('mod_yt_life','');
		$cacheOg->setCaching(true);
		$cacheOg->setLifeTime($params->get('cache_time', 86400*7)); // a week

		$output = $cache->get($cacheid);
		if(empty($output)){
			require_once dirname ( __FILE__ ) . '/data.php';
			$ytData = new YTFGetData($params, $xml_list);

			$output = $ytData->getData();

			if(!empty($output))
			{
				$cache->store(json_encode($output), $cacheid);
				$cacheOg->store(json_encode($output), $cacheid);
				
				$setting->videos = $output;
			} else {
				// get from cache life
				$setting->videos = json_decode($cacheOg->get($cacheid));
			}
		} else {
			$setting->videos = json_decode($output);
		}
	}
}

// Setting
$sizes = array (
		0 => 'default.jpg',
		1 => 'mqdefault.jpg',
		2 => 'hqdefault.jpg' 
);
// language
$language = array();
$language['RECENT'] = JText::_('YJ_RECENT' );
$language['MINUTE'] = JText::_('YJ_MINUTE' );
$language['HOURS'] = JText::_('YJ_HOURS' );
$language['DAYS'] = JText::_('YJ_DAYS' );
$language['MONTHS'] = JText::_('YJ_MONTHS' );
$language['YEARS'] = JText::_('YJ_YEARS' );
$language['AGO'] = JText::_('YJ_AGO' );
$language['BY'] = JText::_('YJ_BY' );
$language['SHOW_LIST'] = JText::_('YJ_SHOW_LIST' );
$language['HIDE_LIST'] = JText::_('YJ_HIDE_LIST' );
$language['PLAYING'] = JText::_('YJ_PLAYING_STATUS' );
$language['SEE_DESC'] = JText::_('YJ_SEE_DESCRIPTION' );
$language['VIEWS'] = JText::_('YJ_VIEWS' );

// setting module
//$setting->key = trim($params->get('key',''));
$setting->lang = $language;
$setting->data = $xml_list;
$setting->style = $params->get( 'ui', 'hoz' );
$setting->moduleid = $module->id;
$setting->autoplay = $params->get( 'auto_play', 0 ) ? true : false;
$setting->autonext = $params->get( 'auto_next', 1 ) ? true : false;
$setting->controls = $params->get( 'controls', 1 ) ? true : false;
$setting->showinfo = $params->get( 'showinfo', 1 ) ? true : false;
$setting->theme = strtolower($params->get( 'theme', 'dark' ) );
$setting->rel = $params->get('rel',0) ? true : false;
$setting->quality = $params->get( 'quality', 'default' );
$setting->autonext = $params->get( 'auto_next', 1 ) ? true : false;
$setting->random = $params->get('random', 0) ? true : false;
$setting->title = $params->get('vid_title', 1) ? true:false;
$setting->maxword = intval($params->get('maxword', 10));
$setting->thumbsize = $sizes[intval($params->get('thumb_size', 1 ) )];
$setting->show_duration = $params->get( 'show_duration', 1 ) ? true : false;
$setting->show_author = $params->get( 'show_author', 1 ) ? true : false;
$setting->show_created = $params->get( 'show_created', 1 ) ? true : false;
$setting->ratio = $params->get( 'ratio', 1 ) ? '16:9' : '4:3';
$setting->show_list = $params->get ( 'showlist', 1 ) ? true : false;
$setting->fs = $params->get( 'fs', 1 ) ? true : false;
$setting->pagination = $params->get( 'pagination', 'more');

// setting - v3
$setting->small_devices = intval($params->get( 'small_devices', 320 ) );
$setting->medium_devices = intval($params->get( 'medium_devices', 540 ) );
$setting->large_devices = intval($params->get( 'large_devices', 750 ) );
$setting->annotation = $params->get ( 'annotation', 1 ) ? true : false;
$setting->loop = $params->get ( 'loop', 0 ) ? true : false;
$setting->brand = $params->get ( 'brand', 0 ) ? true : false;
$setting->popup = $params->get ( 'popup', 0 ) ? true : false;
$setting->popup_trigger = $params->get ( 'popup_trigger', 0 ) ? true : false;
$setting->limit = $params->def('limit',20)*1;
$setting->listcenter = $params->def ( 'listcenter', 1 ) > 0 ? true : false;
$setting->show_desc = $params->get ( 'show_desc', 1 ) ? true : false;

$setting->desc_position = 'player';
if($params->get('ui', 'ver')=='grid')
	$setting->desc_position=$params->get('desc_position','player');
if($params->get('ui', 'ver')=='slider' && $params->get('gridlightbox',0)==1)
	$setting->desc_position='thumb';

// extra field - v4
$setting->root = JUri::base ();
$setting->intromode = $params->get ( 'intromode', 0 ) ? true : false;
$setting->bgurl = $params->get ( 'bgurl', '' ) ? $params->get ( 'bgurl' ) : false;
$setting->introtext = $params->get('introtext', '');

// v4.3
$setting->background_tool = $params->get("bgtool", 1)==1 ? true : false;
$setting->grid_popup = $params->get("gridlightbox", 0)==1 ? true : false;
$setting->showthumb = $params->get("showthumb", 1)==1 ? true : false;

// v4.3.7
$setting->searchbox = $params->get("searchbox", 0)==1 ? true : false;

// v4.3.9
$setting->rc_sort = $params->get("rc_sort", "none");

// v4.4.5
$setting->show_views_count = $params->get('show_views_count',0);
$setting->hash 	= $hash;

// v5.4.1
$setting->cookie = $params->get('cookie',1)==1;

$setting = json_encode($setting);

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

require JModuleHelper::getLayoutPath('mod_yt_jlex', ($params->get('ui','hoz')=='slider'?'slider':'default'));