<?php
/**
 * @package 	YOUTUBE FEED PRO
 * @version 	5.2.7
 * @copyright 	Copyright [c] JLexArt - All rights reserved.
 * @license 	GNU General Public License version 2 or later
 * @author 		Victor Nguyen (https://jlexart.com)
 */

defined('_JEXEC') or die;

class mod_Yt_JLexInstallerScript
{
	public function preflight($type, $parent)
	{
		if($type=="update")
		{
			$release = $parent->getManifest()->version;
			$version = $this->getManifest("version");
			
			if(version_compare($version, "4", "<"))
			{
				Jerror::raiseWarning(null, "This upgrade applies to Youtube Feed Pro v4 and above versions only. Cannot upgrade module from ".$version);
				return false;
			}
		}
	}

	public function postflight($type, $parent)
	{
		if(version_compare(JVERSION, "4.0.0-alpha", ">="))
		{
			$xml = JPATH_ROOT."/modules/mod_yt_jlex/mod_yt_jlex.xml";
			if(is_file($xml))
			{
				$ct  = file_get_contents($xml);
				$ct = str_replace('class="btn-group"', 'layout="joomla.form.field.radio.switcher"', $ct);
				file_put_contents($xml, $ct);
			}
		}
	}

	public function getManifest($param)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select("manifest_cache")
			  ->from("#__extensions")
			  ->where("element=".$db->quote("mod_yt_jlex"));

		$return = $db->setQuery($query)->loadResult();
		$data 	= json_decode($return, true);
		
		return @$data[$param];
	}
}