<?php
/**
 * @package J2Store
 * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * @license GNU GPL v3 or later
 */

// No direct access
defined('_JEXEC') or die;

if(!empty($this->product->addtocart_text)) {
	$cart_text = JText::_($this->product->addtocart_text);
} else {
	$cart_text = JText::_('J2STORE_ADD_TO_CART');
}

$show = J2Store::product ()->validateVariableProduct($this->product);
?>
	<?php echo J2Store::plugin()->eventWithHtml('BeforeAddToCartButton', array($this->product, J2Store::utilities()->getContext('default_cart'))); ?>
	<?php if($show): ?>
		<div class="cart-action-complete" style="display:none;">
				<p class="text-success">
					<?php echo JText::_('J2STORE_ITEM_ADDED_TO_CART');?>
					<a href="<?php echo $this->product->checkout_link; ?>" class="j2store-checkout-link">
						<?php echo JText::_('J2STORE_CHECKOUT'); ?>
					</a>
				</p>
		</div>


		<div id="add-to-cart-<?php echo $this->product->j2store_product_id; ?>" class="j2store-add-to-cart">

		<?php echo J2Store::product()->displayQuantity('com_j2store.productlist.bootstrap3', $this->product, $this->params, array( 'class'=>'input-mini form-control ' ) ); ?>

			<input type="hidden" name="product_id" value="<?php echo $this->product->j2store_product_id; ?>" />


			<span class="tx-cart-btn">
				<i class="cart-icon-img">
					 <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 64 64" enable-background="new 0 0 64 64" xml:space="preserve" width="21px" height="21px">
						 <g id="Cart">
							 <path d="M62.534359,20.2339001c-0.4531021-0.6221008-1.180584-0.9937-1.9462013-0.9937H23.5138588c-0.5527,0-1,0.4477997-1,1   c0,0.5522995,0.4473,1,1,1h37.0742989c0.1298027,0,0.25,0.0620003,0.3300018,0.1709003   c0.0800972,0.1103992,0.1035004,0.2544003,0.0625,0.3876991l-5.5615005,18.0000019   C55.1965599,40.517601,54.5509605,41,53.8126602,41H21.6662598c-0.8213005,0-1.5293007-0.5684013-1.7227001-1.3809013   L12.6056595,8.6968002C12.3703594,7.6978002,11.4924593,7,10.4709597,7H2.0002599C1.4474601,7,1.00026,7.4478002,1.00026,8   s0.4472001,1,0.9999999,1h8.4706993c0.0879002,0,0.1669998,0.0654001,0.1884003,0.1571999l7.3389006,30.9229012   C18.4054604,41.7998009,19.914259,43,21.6662598,43h32.1464005c1.6211967,0,3.0341988-1.0488014,3.5166969-2.6104012   l5.5615005-17.9994984C63.1183586,21.6581993,62.9845581,20.8516006,62.534359,20.2339001z"/>
							 <path d="M29.5793591,33c-0.5527992,0-1,0.4473-1,1s0.4472008,1,1,1h20.8417988c0.5527,0,1-0.4473,1-1s-0.4473-1-1-1H29.5793591z"/>
							 <path d="M53.5050583,28c0-0.5522003-0.4472008-1-1-1H27.4953594c-0.5527992,0-1,0.4477997-1,1s0.4472008,1,1,1h25.0096989   C53.0578575,29,53.5050583,28.5522003,53.5050583,28z"/>
							 <path d="M30.0002594,47c-2.7569008,0-5,2.2431984-5,5s2.2430992,5,5,5c2.7568016,0,5-2.2431984,5-5S32.757061,47,30.0002594,47z    M30.0002594,55c-1.6543007,0-3-1.3456993-3-3s1.3456993-3,3-3s3,1.3456993,3,3S31.6545601,55,30.0002594,55z"/>
							 <path d="M46.0002594,47c-2.7569008,0-5,2.2431984-5,5s2.2430992,5,5,5c2.7567978,0,5-2.2431984,5-5S48.7570572,47,46.0002594,47z    M46.0002594,55c-1.6543007,0-3-1.3456993-3-3s1.3456993-3,3-3s3,1.3456993,3,3S47.6545601,55,46.0002594,55z"/>
						 </g>
					 </svg>
				</i>

					<input
						data-cart-action-always="<?php echo JText::_('J2STORE_ADDING_TO_CART'); ?>"
						data-cart-action-done="<?php echo $cart_text; ?>"
						data-cart-action-timeout="1000"
					   value="<?php echo $cart_text; ?>"
					   type="submit"
					   class="j2store-cart-button <?php echo $this->params->get('addtocart_button_class', 'btn btn-primary');?>" />
			</span>

	   </div>
	<?php else: ?>
			<input value="<?php echo JText::_('J2STORE_OUT_OF_STOCK'); ?>" type="button" class="j2store_button_no_stock btn btn-warning" />
	<?php endif; ?>

	<?php //echo J2Store::plugin()->eventWithHtml('AfterAddToCartButton', array($this->product, J2Store::utilities()->getContext('default_cart'))); ?>

	<input type="hidden" name="option" value="com_j2store" />
	<input type="hidden" name="view" value="carts" />
	<input type="hidden" name="task" value="addItem" />
	<input type="hidden" name="ajax" value="0" />
	<?php echo JHTML::_( 'form.token' ); ?>
	<input type="hidden" name="return" value="<?php echo base64_encode( JUri::getInstance()->toString() ); ?>" />
	<div class="j2store-notifications"></div>
