<?php
/**
 * @package 		J2Store
 * @copyright 	Copyright (c)2016-19 Sasi varna kumar / J2Store.org
 * @license 		GNU GPL v3 or later
 */
defined('_JEXEC') or die;

//$forced_singleItem = ($params->get('force_single_column') == 1) ? 'true' : 'false';
$total_cols = $params->get('number_of_coloums', 3);
$total_colsDesktop = $params->get('number_of_coloums_Desktop', 3);
$total_colsDesktopSmall = $params->get('number_of_coloums_DesktopSmall', 3);
$total_colsTablet = $params->get('number_of_coloums_Tablet', 3);
$total_colsTabletSmall = $params->get('number_of_coloums_TabletSmall', 2);
$total_colsMobile = $params->get('number_of_coloums_Mobile', 1);
$total_count = count($list); $counter = 0;
$slider_autoplay="true";
//$show_pagination = $params->get('show_pagination', 1) ? "true":"false";
$show_navigation = $params->get('show_navigation', 1) ? "true":"false";
$slider_id = 'jowl-slider-'.$module_id;

$document =JFactory::getDocument();
$document->addStyleSheet(JURI::root(true).'/media/j2store/css/font-awesome.min.css');
$document->addStyleSheet(JURI::root(true).'/modules/mod_j2products/tmpl/Carousel/assets/owl.carousel.min.css');
$document->addScript(JURI::root(true).'/modules/mod_j2products/tmpl/Carousel/assets/owl.carousel.min.js');

?>
<script>
	if(typeof(j2store) == 'undefined') {
		var j2store = {};
	}
	if(typeof(j2store.jQuery) == 'undefined') {
		j2store.jQuery = jQuery.noConflict();
	}

	if(typeof(j2storeURL) == 'undefined') {
		var j2storeURL = '';
	}
	(function($) {
		window.onresize = setcarousel<?php echo $module_id;?>;
		$(document).ready(function() {
			setcarousel<?php echo $module_id;?>();
		});

	})(j2store.jQuery);
	function setcarousel<?php echo $module_id;?>(){
		var screenWidth = window.screen.width;
		//var screenHeight = window.screen.height;
		var pro_items = 0;
		if(screenWidth >= 1200){
			pro_items = '<?php echo $total_colsDesktop;?>';
		}else if(screenWidth >= 992){
			pro_items = '<?php echo $total_colsDesktopSmall;?>';
		}else if(screenWidth >= 768){
			pro_items = '<?php echo $total_colsTablet;?>';
		}else if(screenWidth >= 480){
			pro_items = '<?php echo $total_colsTabletSmall;?>';
		}else if(screenWidth >= 320){
			pro_items = '<?php echo $total_colsMobile;?>';
		}
		if(pro_items <= 0){
			pro_items =  '<?php echo $total_cols;?>';
		}
		(function ($) {
			console.log(pro_items);
			var syncedSecondary = true;
			$("#<?php echo $slider_id;?>").owlCarousel('destroy');
			$("#<?php echo $slider_id;?>").owlCarousel({
				items : pro_items,
				slideSpeed : 2000,
				margin: 30,
				nav: <?php echo $show_navigation;?>,
				autoplay: <?php echo $slider_autoplay?>,
				dots: true,
				loop: false,
				responsiveRefreshRate : 200,
				navText: ["<i class='fa fa-caret-left icon-chevron-left icon-white'></i>",
					"<i class='fa fa-caret-right icon-chevron-right icon-white'></i>"]
				//navText: ['<svg width="100%" height="100%" viewBox="0 0 11 20"><path style="fill:none;stroke-width: 1px;stroke: #000;" d="M9.554,1.001l-8.607,8.607l8.607,8.606"/></svg>','<svg width="100%" height="100%" viewBox="0 0 11 20" version="1.1"><path style="fill:none;stroke-width: 1px;stroke: #000;" d="M1.054,18.214l8.606,-8.606l-8.606,-8.607"/></svg>'],
			}).on('changed.owl.carousel', syncPosition);
		})(j2store.jQuery);
	}
	function syncPosition(el) {
		(function ($) {
			//if you set loop to false, you have to restore this next line
			//var current = el.item.index;

			//if you disable loop you have to comment this block
			var count = el.item.count-1;
			var current = Math.round(el.item.index - (el.item.count/2) - .5);

			if(current < 0) {
				current = count;
			}
			if(current > count) {
				current = 0;
			}
			//console.log(current);
			//$("#<?php echo $slider_id;?>").data('owl.carousel').to(number, 300, true);
		})(j2store.jQuery);
	}



</script>
<div class="jowl-module-product-slide-<?php echo $module_id;?>"> <!-- owl slider container -->
	<div itemscope itemtype="http://schema.org/BreadCrumbList"
		 id="<?php echo $slider_id;?>"
		 class="j2store-product-module j2store-product-module-list owl-carousel">
		<?php if( count($list) > 0 ):?>
			<?php foreach ($list as $product_id => $product) : ?>
				<?php  $rowcount = ((int) $counter % (int) $total_cols) + 1; ?>
				<!-- single product -->
				<div itemprop="itemListElement" itemscope="" itemtype="http://schema.org/Product" class="j2store product-<?php echo $product->j2store_product_id; ?> j2store-module-product tx-sx-single-product ">


					<div class="image-block">
					   <div class="j2store-product-images ">
					      <div class="j2store-thumbnail-image">
					         <?php require( __DIR__.'/default_image.php' );?>
					      </div>
					   </div>

					   <div class="item-sidebar">
					      <?php echo J2Store::plugin()->eventWithHtml('AfterAddToCartButton', array($product, J2Store::utilities()->getContext('default_cart'))); ?>
					   </div>
					</div>



					<div class="content-block text-center">
						   <h2 itemprop="name" class="product-title">
								 <?php if( $product->link_title ): ?>
										<a itemprop="url"
										   href="<?php echo JRoute::_( $product->module_display_link ); ?>"
										   title="<?php echo $product->product_name; ?>" >
											<?php endif; ?>

											<?php echo $product->product_name; ?>
											<?php if($product->link_title ): ?>
										</a>
									<?php endif; ?>
						   </h2>

							 <!-- Product price block-->
							<?php echo J2Store::plugin()->eventWithHtml('BeforeRenderingProductPrice', array($product)); ?>

							<div itemprop="offers" itemscope itemtype="http://schema.org/Offer" class="product-price-container">
								<?php if($product->show_price && $product->show_special_price):?>
									<?php if($product->pricing->base_price != $product->pricing->price):?>
										<?php $class='';?>
										<?php if(isset($product->pricing->is_discount_pricing_available)) $class='strike'; ?>
										<span class="base-price <?php echo $class?>">
											<?php echo J2Store::product()->displayPrice($product->pricing->base_price, $product, $j2params);?>
										</span>
									<?php endif; ?>
									<span class="sale-price">
										<?php echo J2Store::product()->displayPrice($product->pricing->price, $product, $j2params);?>
									</span>
								<?php elseif ($product->show_price && !$product->show_special_price):?>
									<?php if($product->pricing->base_price != $product->pricing->price):?>
										<?php $class='';?>
										<?php if(isset($product->pricing->is_discount_pricing_available)) $class=''; ?>
										<span class="base-price <?php echo $class?>">
											<?php echo J2Store::product()->displayPrice($product->pricing->base_price, $product, $j2params);?>
										</span>
									<?php else:?>
										<span class="sale-price">
											<?php echo J2Store::product()->displayPrice($product->pricing->price, $product, $j2params);?>
										</span>
									<?php endif; ?>
								<?php elseif (!$product->show_price && $product->show_special_price):?>
									<?php if($product->pricing->base_price != $product->pricing->price):?>
										<?php $class='';?>
										<?php if(isset($product->pricing->is_discount_pricing_available)) $class=''; ?>
										<span class="base-price <?php echo $class?>">
											<?php echo J2Store::product()->displayPrice($product->pricing->price, $product, $j2params);?>
										</span>
									<?php endif; ?>
								<?php endif;?>

								<?php if( $product->show_price_taxinfo ): ?>
									<span class="tax-text">
										<?php echo J2Store::product()->get_tax_text(); ?>
									</span>
								<?php endif; ?>

								<meta itemprop="price" content="<?php echo $product->pricing->price; ?>" />
								<meta itemprop="priceCurrency" content="<?php echo $j2currency->getCode(); ?>" />
								<link itemprop="availability" href="http://schema.org/<?php echo $product->variant->availability ? 'InStock':'OutOfStock'; ?>" />
							</div>
							<?php //endif; ?>

							<?php echo J2Store::plugin()->eventWithHtml('AfterRenderingProductPrice', array($product)); ?>

							<?php if( $product->show_offers && isset($product->pricing->is_discount_pricing_available) && $product->pricing->base_price > 0): ?>
								<?php $discount =(1 - ($product->pricing->price / $product->pricing->base_price) ) * 100; ?>
								<?php if($discount > 0): ?>
									<span class="discount-percentage">
										<?php  echo round($discount).' % '.JText::_('J2STORE_PRODUCT_OFFER');?>
									</span>
								<?php endif; ?>
							<?php endif; ?>
							<!-- end Product price block-->



							<?php if($j2params->get('catalog_mode', 0) == 0 ): ?>
									<form action="<?php echo $product->cart_form_action; ?>"
										  method="post" class="j2store-addtocart-form tx-sx-addtocart"
										  id="j2store-addtocart-form-<?php echo $product->j2store_product_id; ?>"
										  name="j2store-addtocart-form-<?php echo $product->j2store_product_id; ?>"
										  data-product_id="<?php echo $product->j2store_product_id; ?>"
										  data-product_type="<?php echo $product->product_type; ?>"
										<?php if(isset($product->variant_json)): ?>
											data-product_variants="<?php echo htmlspecialchars($product->variant_json);?>"
										<?php endif; ?>
										  enctype="multipart/form-data">

										<?php $cart_type = $product->list_show_cart;//$this->params->get('list_show_cart', 1);
										$product->display_cart_block = true;
										?>

										<?php

										if ($product->product_type=='configurable') {
											$cart_type = 2	;
										}

										if($cart_type == 1) : ?>
											<?php if ( $product->product_type=='simple' || $product->product_type=='downloadable' ):
												require( __DIR__.'/default_options.php' );
											elseif ($product->product_type=='variable'):
												require( __DIR__.'/default_variableoptions.php' );
											elseif ($product->product_type=='configurable'):
												$product->display_cart_block = false;
											endif;
											?>
										<?php elseif( $product->product_type=='configurable' || ($cart_type == 2 && isset($product->options) && count($product->options)) || ($cart_type == 3) ):?>
											<!-- we have options so we just redirect -->
											<a href="<?php echo $product->module_display_link; ?>" class="<?php echo $params->get('choosebtn_class', 'btn btn-success'); ?>"><?php echo JText::_('J2STORE_VIEW_PRODUCT_DETAILS'); ?></a>
											<?php $product->display_cart_block = false; ?>
										<?php endif; ?>

										<?php echo J2Store::plugin()->eventWithHtml('BeforeAddToCartButton', array($product, J2Store::utilities()->getContext('default_cart'))); ?>

										<?php if ($product->display_cart_block): ?>
											<!-- cart block -->
											<div class="cart-action-complete" style="display:none;">
												<p class="text-success">
													<?php echo JText::_('J2STORE_ITEM_ADDED_TO_CART');?>
													<a href="<?php echo $product->checkout_link; ?>" class="j2store-checkout-link">
														<?php echo JText::_('J2STORE_CHECKOUT'); ?>
													</a>
												</p>
											</div>

											<div id="add-to-cart-<?php echo $product->j2store_product_id; ?>" class="j2store-add-to-cart">

												<?php if($params->get('show_qty_field', 1)): ?>
													<div class="product-qty">
														<input type="number" name="product_qty" value="<?php echo (int) $product->quantity; ?>" class="input-mini form-control" min="<?php echo (int) $product->quantity; ?>" step='1' />
													</div>
												<?php else: ?>
													<input type="hidden" name="product_qty" value="<?php echo (int) $product->quantity; ?>" />
												<?php endif; ?>

												<input type="hidden" name="product_id" value="<?php echo $product->j2store_product_id; ?>" />

												<span class="tx-cart-btn">


												<i class="cart-icon-img">
						 						 	<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 64 64" enable-background="new 0 0 64 64" xml:space="preserve" width="21px" height="21px">
						 							 	<g id="Cart">
						 							 		<path d="M62.534359,20.2339001c-0.4531021-0.6221008-1.180584-0.9937-1.9462013-0.9937H23.5138588c-0.5527,0-1,0.4477997-1,1   c0,0.5522995,0.4473,1,1,1h37.0742989c0.1298027,0,0.25,0.0620003,0.3300018,0.1709003   c0.0800972,0.1103992,0.1035004,0.2544003,0.0625,0.3876991l-5.5615005,18.0000019   C55.1965599,40.517601,54.5509605,41,53.8126602,41H21.6662598c-0.8213005,0-1.5293007-0.5684013-1.7227001-1.3809013   L12.6056595,8.6968002C12.3703594,7.6978002,11.4924593,7,10.4709597,7H2.0002599C1.4474601,7,1.00026,7.4478002,1.00026,8   s0.4472001,1,0.9999999,1h8.4706993c0.0879002,0,0.1669998,0.0654001,0.1884003,0.1571999l7.3389006,30.9229012   C18.4054604,41.7998009,19.914259,43,21.6662598,43h32.1464005c1.6211967,0,3.0341988-1.0488014,3.5166969-2.6104012   l5.5615005-17.9994984C63.1183586,21.6581993,62.9845581,20.8516006,62.534359,20.2339001z"/>
						 							 		<path d="M29.5793591,33c-0.5527992,0-1,0.4473-1,1s0.4472008,1,1,1h20.8417988c0.5527,0,1-0.4473,1-1s-0.4473-1-1-1H29.5793591z"/>
						 							 		<path d="M53.5050583,28c0-0.5522003-0.4472008-1-1-1H27.4953594c-0.5527992,0-1,0.4477997-1,1s0.4472008,1,1,1h25.0096989   C53.0578575,29,53.5050583,28.5522003,53.5050583,28z"/>
						 							 		<path d="M30.0002594,47c-2.7569008,0-5,2.2431984-5,5s2.2430992,5,5,5c2.7568016,0,5-2.2431984,5-5S32.757061,47,30.0002594,47z    M30.0002594,55c-1.6543007,0-3-1.3456993-3-3s1.3456993-3,3-3s3,1.3456993,3,3S31.6545601,55,30.0002594,55z"/>
						 							 		<path d="M46.0002594,47c-2.7569008,0-5,2.2431984-5,5s2.2430992,5,5,5c2.7567978,0,5-2.2431984,5-5S48.7570572,47,46.0002594,47z    M46.0002594,55c-1.6543007,0-3-1.3456993-3-3s1.3456993-3,3-3s3,1.3456993,3,3S47.6545601,55,46.0002594,55z"/>
						 							 	</g>
						 						 	</svg>
						 					 </i>

											 <input
												 data-cart-action-always="<?php echo JText::_('J2STORE_ADDING_TO_CART'); ?>"
												 data-cart-action-done="<?php echo $product->cart_button_text; ?>"
												 data-cart-action-timeout="1000"
												 value="<?php echo $product->cart_button_text; ?>"
												 type="submit"
												 class="j2store-cart-button <?php echo $params->get('addtocart_button_class', 'btn btn-link');?>"
											 />

						 				 </span>

											</div>
										<?php elseif( !$product->variant->availability ): ?>
											<input value="<?php echo JText::_('J2STORE_OUT_OF_STOCK'); ?>" type="button" class="j2store_button_no_stock btn btn-warning" />
											<!-- end cart block -->
										<?php endif; ?>



										<input type="hidden" name="option" value="com_j2store" />
										<input type="hidden" name="view" value="carts" />
										<input type="hidden" name="task" value="addItem" />
										<input type="hidden" name="ajax" value="0" />
										<?php echo JHTML::_( 'form.token' ); ?>
										<input type="hidden" name="return" value="<?php echo base64_encode( JUri::getInstance()->toString() ); ?>" />
										<div class="j2store-notifications"></div>
										<?php if ($product->product_type == 'variable'): ?>
											<input type="hidden" name="variant_id" value="<?php echo $product->variant->j2store_variant_id; ?>" />
										<?php endif ?>
									</form>
								<?php endif;?>




						</div>






				</div>
				<!-- end single product -->
			<?php endforeach; ?>
		<?php endif; ?>
	</div>
</div>
