<?php

if( ! class_exists('QuixJoomlArticleElementClass') )
{
  include_once ( __DIR__ . '/helper.php' );
}

$info = new QuixJoomlArticleElementClass();
$cats = array_reduce( $info->getInput(), function ( $carry, $module ) {
  $carry[$module->value] = $module->text;
  return $carry;
}, [ ] );


return [
  'slug' => 'j2store-gallery',
  'name' => 'J2Store Gallery',
  'groups' => ['j2store', 'content'],
  'form' => [
    'general' => [
      [ 'name' => 'category',
        'type' => 'select',
        'multiple' => true,
        'label' => 'Select Category',
        'options' => $cats
      ],

      [ 'name' => 'list_show_short_desc',
        'type' => 'switch',
        'label' => 'Show Short Description'
      ],

      [ 'name' => 'list_show_long_desc',
        'type' => 'switch',
        'label' => 'Show Long Description'
      ],

      [ 'name' => 'list_filter_selected_categories',
        'type' => 'switch',
        'label' => 'Category Filter'
      ],
      [ 'name' => 'limit_product',
        'type' => 'text',
        'value' => 6,
        'label' => 'No of product Display'
      ],


    ],
  ]
];
