<?php
/**
 * --------------------------------------------------------------------------------
 *	Module - Related Items
 * --------------------------------------------------------------------------------
 * @package     Joomla 3.x
 * @subpackage  J2Store
 * @author      Alagesan
 * @copyright   Copyright (c) 2017 j2store.org . All rights reserved.
 * @license     GNU/GPL license: http://www.gnu.org/licenses/gpl-2.0.html
 * --------------------------------------------------------------------------------
 *
 * */
defined('_JEXEC') or die;
require_once JPATH_SITE . '/components/com_content/helpers/route.php';
abstract class ModJ2StoreRelatedProductsHelper {

	public static function getAllProducts($limit, $elementparams) {
		/**
		 * get the cart items
		 * get the catgories of the cart items
		 * get the products list of the categories
		 * assign the title, intro text, and show price and cart block
		 * display preview doc / product image based on the params in module
		 * show make a doc button
		 * */

		$app = JFactory::getApplication();
		$session = JFactory::getSession();
		$model = F0FModel::getTmpInstance('Products', 'J2StoreModel')->runMyBehaviorFlag(true);

		$manufacturer_ids = $app->input->get('manufacturer_ids', array(), 'ARRAY');
		$vendor_ids = $app->input->get('vendor_ids', array(), 'ARRAY');
		$productfilter_ids = $app->input->get('productfilter_ids', array(), 'ARRAY');

		$product_types  = $model->getProductTypes();
		array_unshift($product_types, JText::_('J2STORE_SELECT_OPTION'));
		$params = F0FModel::getTmpInstance('Products', 'J2StoreModel')->getMergedParams();
        $params->merge($elementparams);

        $states = ModJ2StoreRelatedProductsHelper::getFilterStates();

		if($params->get('list_show_vote', 0)) {
			$params->set('show_vote', 1);
		}

		if(!empty($manufacturer_ids)){
			$session->set('manufacturer_ids', $manufacturer_ids, 'j2store');
			$states['manufacturer_id'] = implode(',',$utility->cleanIntArray($manufacturer_ids, $db));
		}else{
			$session->clear('manufacturer_ids', 'j2store');
			$states['manufacturer_id'] = '';
		}
		if(!empty($vendor_ids)){
			$session->set('vendor_ids', $vendor_ids, 'j2store');
			$states['vendor_id']= implode(',',$utility->cleanIntArray($vendor_ids, $db));
			//$model->setState('vendor_id' ,implode(',',$vendor_ids));
		}else{
			$session->clear('vendor_ids', 'j2store');
			$states['vendor_id']= '';
		}
		if(!empty($productfilter_ids)){
			$session->set('productfilter_ids', $productfilter_ids, 'j2store');
			//set filter search condition
			$session->set('list_product_filter_search_logic_rel', $params->get('list_product_filter_search_logic_rel', 'OR'), 'j2store');
			$states['productfilter_id'] = implode(',',$utility->cleanIntArray($productfilter_ids, $db));

			//$model->setState('productfilter_id' ,implode(',',$vendor_ids));
		}else{
			$session->clear('productfilter_ids', 'j2store');
			$session->clear('list_product_filter_search_logic_rel', 'j2store');
			$states['productfilter_id'] ='';
		}

		$itemid = $app->input->get('id', 0, 'int') . ':' . $app->input->get('Itemid', 0, 'int');
		// Get the pagination request variables
		$limit		= $params->get('page_limit');
		$show_feature_only	= $params->get('show_feature_only',0);
		$model->setState('show_feature_only', $show_feature_only);
		$model->setState('list.limit', $limit);
		$limitstart = $app->input->get('limitstart', 0, 'int');

		// In case limit has been changed, adjust limitstart accordingly
		//		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		$model->setState('list.start', $limitstart);

		$orderCol = $app->getUserStateFromRequest('com_j2store.product.list.' . $itemid . '.filter_order', 'filter_order', '', 'string');
		if (!in_array($orderCol, $model->get_filter_fields()))
		{
			$orderCol = 'a.ordering';
		}
		$model->setState('list.ordering', $orderCol);

		$listOrder = $app->getUserStateFromRequest('com_j2store.product.list.' . $itemid . '.filter_order_Dir',
				'filter_order_Dir', '', 'cmd');
		if (!in_array(strtoupper($listOrder), array('ASC', 'DESC', '')))
		{
			$listOrder = 'ASC';
		}
		$model->setState('list.direction', $listOrder);

		foreach($states as $key => $value){
			$model->setState($key,$value);
		}

		/* $filter_catid = $app->input->getInt('filter_catid',0); */
		$filter_catid = $app->input->getInt('filter_catid',$session->get('filter_catid' ,'','j2store'));

		$catids = $app->input->get('catid',array(),'Array');
		if(!$catids){
			$catids = $params->get('category');
		}
		if(!empty($filter_catid)){
			$model->setState('catids', $filter_catid);
		}elseif(empty($filter_catid)){
			$model->setState('catids', $catids);
		}elseif($params->get('list_show_filter_category_all', 1) && empty($filter_catid)){
			$model->setState('catids', $catids[0]);
		}
		// set the depth of the category query based on parameter
		$showSubcategories = $params->get('show_subcategory_content', '1');

		if ($showSubcategories)
		{
			$model->setState('filter.max_category_levels', $params->get('show_subcategory_content', '1'));
			$model->setState('filter.subcategories', true);
		}

		$model->setState('filter.language', JLanguageMultilang::isEnabled());

		$model->setState('enabled', 1);
		$model->setState('visible', 1);
		$search = $app->input->getString('search', '');
		$model->setState('search', $search);
		$limit = $params->get('limit_product', 2);
		$model->setState('limit', $limit);
		//set product ids

		$items = $model->getProductList();
		// print_r($items);die;
		foreach ($items as $key => $item) {
			$model->getProduct($item);
		}

		return $items;

		// return $products;
		// $items  =F0FModel::getTmpInstance('products','J2StoreModel')->getItems();
		// print_r($items);die;
		// if (count($items) <= 0 ) {
		// 	return array();
		// }

		// $product_helper = J2Store::product();

		// $j2_pids = array();
		// $related_prods = array();
		// foreach ($items as $k => $item) {
		// 	$j2_prod_id = $item->j2store_product_id;
		// 	$j2_pids[] = $j2_prod_id;
		// 	$ptable = F0FTable::getAninstance('Product', 'J2StoreTable')->getClone();
		// 	$ptable->load($j2_prod_id);
		// 	$product = $product_helper->setId( $ptable->j2store_product_id)->getProduct();
		// 	F0FModel::getTmpInstance('Products', 'J2StoreModel')->runMyBehaviorFlag(true)->getProduct($product);
		// 	if( $product->product_source == 'com_content' ){
		// 		if(!isset($product->source->state) || !($product->source->state == 1) ){
		// 			continue;
		// 		}
		// 	}
		// 	$product->module_display_link = JRoute::_('index.php?option=com_j2store&view=products&task=view&id='.$product->j2store_product_id);
		// 	$product->module_introtext = self::truncate($product->product_short_desc, $params->get('introtext_limit',50)); // truncated intro text
		// 	if( isset($product) && $product->enabled && $product->visibility ){
		// 		$related_prods[$k]['j2_item'] = $product ;
		// 	}
		// 	if($limit > 0 && count($j2_pids) == $limit ){
		// 		break;
		// 	}
		// }
		// // print_r($related_prods);die;
		// return $related_prods;
	}

	/**
	 * Method to truncate introtext
	 *
	 * The goal is to get the proper length plain text string with as much of
	 * the html intact as possible with all tags properly closed.
	 *
	 * @param string   $html       The content of the introtext to be truncated
	 * @param integer  $maxLength  The maximum number of charactes to render
	 *
	 * @return  string  The truncated string
	 */
	public static function truncate($html, $maxLength = 0)
	{
		$baseLength = strlen($html);
		$diffLength = 0;

		// First get the plain text string. This is the rendered text we want to end up with.
		$ptString = JHtml::_('string.truncate', $html, $maxLength, $noSplit = true, $allowHtml = false);

		for ($maxLength; $maxLength < $baseLength;)
		{
			// Now get the string if we allow html.
			$htmlString = JHtml::_('string.truncate', $html, $maxLength, $noSplit = true, $allowHtml = true);

			// Now get the plain text from the html string.
			$htmlStringToPtString = JHtml::_('string.truncate', $htmlString, $maxLength, $noSplit = true, $allowHtml = false);

			// If the new plain text string matches the original plain text string we are done.
			if ($ptString == $htmlStringToPtString)
			{
				return $htmlString;
			}
			// Get the number of html tag characters in the first $maxlength characters
			$diffLength = strlen($ptString) - strlen($htmlStringToPtString);

			// Set new $maxlength that adjusts for the html tags
			$maxLength += $diffLength;
			if ($baseLength <= $maxLength || $diffLength <= 0)
			{
				return $htmlString;
			}
		}
		return $html;
	}

	public static function getFilterStates() {
		$app = JFactory::getApplication();
		$state = array();
		$state['search'] = $app->input->getString('search','');
		$state['product_type']= $app->input->getString('product_type','');
		$state['visible'] = $app->input->getString('visible',null);
		$state['vendor_id'] = $app->input->getInt('vendor_id',0);
		$state['manufacturer_id'] = $app->input->getString('manufacturer_id',0);
		$state['productid_from']= $app->input->getString('productid_from','');
		$state['productid_to']= $app->input->getString('productid_to','');
		$state['pricefrom']= $app->input->getString('pricefrom','');
		$state['priceto']= $app->input->getString('priceto','');
		$state['since']= $app->input->getString('since','');
		$state['until']= $app->input->getString('until','');
		$state['taxprofile_id']= $app->input->getString('taxprofile_id','');
		$state['shippingmethod']=$app->input->getString('shippingmethod','');
		$state['filter_order']= $app->input->getString('filter_order','j2store_product_id');
		$state['filter_order_Dir']= $app->input->getString('filter_order_Dir','ASC');
		$state['sku']= $app->input->getString('sku','');
		$state['sortby']= $app->input->getString('sortby','');
		$state['productfilter_id']= $app->input->getString('productfilter_id',0);
		return $state;
	}

	/**
	 * Method to get Filters and to assing in the browse view
	 */
	public static function getFilters($items, $elementparams){

		//filters
		$filters =array();
		$filter_categories =array();
		$params = F0FModel::getTmpInstance('Products', 'J2StoreModel')->getMergedParams();
        $params->merge($elementparams);
		//now set the categories
		$filters['filter_categories'] =array();
		if($params->get('list_filter_selected_categories', 1)){
			$filter_categories = $params->get('category');
			// list_filter_selected_categories
			if(!is_array($filter_categories)) $filter_categories = array($filter_categories);
			$filters['filter_categories'] = F0FModel::getTmpInstance('Products', 'J2StoreModel')->getCategories($filter_categories);
		}

		//to show the product filter for the existing products in the product layout view
		//should not fetch all product filters
		$product_ids = array();
		foreach($items as $item){
			$product_ids[] =$item->j2store_product_id;
		}
		$filters['sorting'] = F0FModel::getTmpInstance('Products', 'J2StoreModel')->getSortFields();
		//$filters['productfilters'] = F0FModel::getTmpInstance('Products', 'J2StoreModel')->getProductFilters($product_ids);

		$filters['productfilters'] = array();
		$product_model = F0FModel::getTmpInstance('Products', 'J2StoreModel');
		//fetch the pfilters when show product filter is enabled
		if($params->get('list_show_product_filter',1)){
			//this option will list all the productfilter added
			if($params->get('list_product_filter_list_type','selected') == 'all'){
				$filters['productfilters'] = F0FTable::getAnInstance('ProductFilter', 'J2StoreTable')->getFilters();
			}elseif($params->get('list_product_filter_list_type','selected') == 'selected'){
				// this option will list productfilter related to the products selected
				$filters['productfilters'] = $product_model->getProductFilters($product_ids);
			}
		}

		//fetch the Manufacturers when Show manufacturer filter is enabled
		if($params->get('list_show_manfacturer_filter',1)){
			if($params->get('list_manufacturer_filter_list_type','selected') == 'all'){
				$filters['manufacturers'] =$product_model->getManufacturers();
			}else{
				$filters['manufacturers'] = $product_model->getManfucaturersByProduct($product_ids);
			}
		}
		//fetch the Vendors when Show vendor filter is enabled
		if($params->get('list_show_vendor_filter',1)){
			if($params->get('list_vendor_filter_list_type','selected') == 'all'){
				$filters['vendors'] = $product_model->getVendors();
			}else{
				$filters['vendors'] =$product_model->getVendorsByProduct($product_ids);
			}
		}
		return $filters;
	}

	public static function getPriceRanges($items){

		//get the active menu details
		$menu = JFactory::getApplication()->getMenu()->getActive();
		$params = F0FModel::getTmpInstance('Products', 'J2StoreModel')->getMergedParams();
		$ranges =array();
		$currency = J2Store::currency();
		//price filters
		if(isset($items['0']->pricing->price )) {
			$priceHigh = abs( $items['0']->pricing->price );
		}else {
			$priceHigh = 0;
		}
		//create link to be concatinated
		//get the highest price
		$priceHigh = abs($params->get('list_price_filter_upper_limit', '1000'));
		$link = '';
		$priceLow =0;
		$range =0;
		if(count($items )) {
			foreach($items as $item){

				//$item->pricing->price
				//calculate the price low
				$priceLow = ( count($item) == 1 ) ?  0 : abs( $item[count( $item ) - 1]->pricing->price );
				//calculate the range price high - low price
				$range = ( abs( $priceHigh ) - abs( $priceLow ) )/4;
				//now round the price
				$roundRange = F0FModel::getTmpInstance('Products','J2StoreModel')->_priceRound($range, $params->get( 'list_price_round_digit', '100' ), true);
				//get the lowest price
				$roundPriceLow = F0FModel::getTmpInstance('Products','J2StoreModel')->_priceRound( $priceLow, $params->get( 'list_price_round_digit', '100' ) );
			}
		}
		$ranges['max_price'] = $priceHigh;
		$ranges['min_price'] = $priceLow;
		$ranges['range'] = $range;
		return $ranges;
	}

}
