<?php 
defined('_JEXEC') or die('Restricted access');
use Joomla\Registry\Registry;
class templateJ2StoreElement
{

    private $params;

    function __construct($params)
    {
      require_once (JPATH_ADMINISTRATOR.'/components/com_j2store/helpers/j2store.php');
      require_once JPATH_ADMINISTRATOR.'/components/com_j2store/library/popup.php';
      require_once JPATH_ADMINISTRATOR.'/components/com_j2store/helpers/select.php';
      require_once JPATH_ADMINISTRATOR.'/components/com_j2store/helpers/j2html.php';
      if(!class_exists('J2StoreStrapper')){
        require_once (JPATH_ADMINISTRATOR.'/components/com_j2store/helpers/strapper.php');
      }
      $session = JFactory::getSession();

      J2StoreStrapper::addJS();
      J2StoreStrapper::addCSS();

      // Include the helper functions only once
      require_once __DIR__ . '/helper.php';
      $this->params = $params;

      $menu = JMenu::getInstance('site');
      $app  = JFactory::getApplication();
      $menuItem = $menu->getActive();
      if(!$menuItem){
        $menuItem = $menu->getDefault();
      }

      /* $filter_catid = $this->input->getInt('filter_catid',0); */
      $this->filter_catid = $app->input->getInt('filter_catid',$session->get('filter_catid' ,'','j2store'));
            
      $this->active_menu = $menuItem;
      // $this->active_menu
      // print_r($this->active_menu);die;
      // $menu = JSite::getMenu();
      // $activeMenu = $menu->getActive();
      // if(!isset($activeMenu->id)){
        // $activeMenu = $menu->getDefault();
      // }
      // $this->active_menu = $activeMenu;

      $limit = $this->params->get('number_of_items',6);
      $this->products = ModJ2StoreRelatedProductsHelper::getAllProducts($limit, $this->params);
      // $j2params = J2Store::config ();

      $filters = array();
      $filters = ModJ2StoreRelatedProductsHelper::getFilters($this->products, $this->params);
      $filters['pricefilters'] = ModJ2StoreRelatedProductsHelper::getPriceRanges($this->products);
      $this->filters = $filters;

      $state = ModJ2StoreRelatedProductsHelper::getFilterStates();
      $this->state = (object) $state;
      $this->currency = J2store::currency();
      // // --------------------------------------

      // $total_cols = $this->params->get('number_of_cols', 3);
      // $total_count = count($list); $counter = 0;
      // $J2gridRow = ($j2params->get('bootstrap_version', 2) == 2) ? 'row-fluid' : 'row';
      // $J2gridCol = ($j2params->get('bootstrap_version', 2) == 2) ? 'span' : 'col-sm-';

      require_once __DIR__ . '/tmpl/default.php';
    }

    function loadTemplate($name)
    {
      Include 'tmpl/default_' . $name . '.php';
    }
}

$params = new Registry;
$params->loadArray($field);
// print_r($params);die;
?>
<div itemscope itemtype="http://schema.org/ItemList" class="j2store-product-element j2store-product-element-list">
<?php new templateJ2StoreElement($params); ?>
</div>